/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.Cipher;
import javax.crypto.NullCipher;

public class CipherOutputStream
extends FilterOutputStream {
    private Cipher cipher;

    public CipherOutputStream(OutputStream out, Cipher cipher) {
        super(out);
        this.cipher = cipher != null ? cipher : new NullCipher();
    }

    protected CipherOutputStream(OutputStream out) {
        super(out);
    }

    public void close() throws IOException {
        try {
            this.out.write(this.cipher.doFinal());
            this.out.flush();
            this.out.close();
        }
        catch (Exception cause) {
            IOException ioex = new IOException(String.valueOf(cause));
            ioex.initCause(cause);
            throw ioex;
        }
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        byte[] b = this.cipher.update(buf, off, len);
        if (b != null) {
            this.out.write(b);
        }
    }
}

