/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import gnu.classpath.ServiceFactory;
import gnu.java.util.prefs.NodeReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.NodeChangeListener;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.PreferencesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preferences {
    private static final String defaultFactoryClass = "gnu.java.util.prefs.FileBasedFactory";
    private static final Permission prefsPermission = new RuntimePermission("preferences");
    private static PreferencesFactory factory;
    public static final int MAX_NAME_LENGTH = 80;
    public static final int MAX_KEY_LENGTH = 80;
    public static final int MAX_VALUE_LENGTH = 8192;

    protected Preferences() {
    }

    public static Preferences systemRoot() throws SecurityException {
        PreferencesFactory factory = Preferences.getFactory();
        return factory.systemRoot();
    }

    public static Preferences userRoot() throws SecurityException {
        PreferencesFactory factory = Preferences.getFactory();
        return factory.userRoot();
    }

    private static PreferencesFactory getFactory() throws SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(prefsPermission);
        }
        if (factory == null) {
            Iterator iter;
            factory = AccessController.doPrivileged(new PrivilegedAction<PreferencesFactory>(){

                @Override
                public PreferencesFactory run() {
                    PreferencesFactory pf = null;
                    String className = System.getProperty("java.util.prefs.PreferencesFactory");
                    if (className != null) {
                        try {
                            Class<?> fc = Class.forName(className);
                            Object o = fc.newInstance();
                            pf = (PreferencesFactory)o;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                        catch (InstantiationException instantiationException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                        }
                        catch (ClassCastException classCastException) {}
                    }
                    return pf;
                }
            });
            if (factory == null && (iter = ServiceFactory.lookupProviders(PreferencesFactory.class, null)) != null && iter.hasNext()) {
                factory = (PreferencesFactory)iter.next();
            }
            if (factory == null) {
                try {
                    Class<?> cls = Class.forName(defaultFactoryClass);
                    factory = (PreferencesFactory)cls.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't load default factory 'gnu.java.util.prefs.FileBasedFactory'", e);
                }
            }
        }
        return factory;
    }

    public static Preferences systemNodeForPackage(Class<?> c) throws SecurityException {
        return Preferences.nodeForPackage(c, Preferences.systemRoot());
    }

    public static Preferences userNodeForPackage(Class<?> c) throws SecurityException {
        return Preferences.nodeForPackage(c, Preferences.userRoot());
    }

    private static Preferences nodeForPackage(Class c, Preferences root) {
        String className = c.getName();
        int index = className.lastIndexOf(46);
        String packagePath = index == -1 ? "<unnamed>" : className.substring(0, index).replace('.', '/');
        return root.node(packagePath);
    }

    public static void importPreferences(InputStream is) throws InvalidPreferencesFormatException, IOException {
        PreferencesFactory factory = Preferences.getFactory();
        NodeReader reader = new NodeReader(is, factory);
        reader.importPreferences();
    }

    public abstract String absolutePath();

    public abstract boolean isUserNode();

    public abstract String name();

    public abstract String toString();

    public abstract String[] childrenNames() throws BackingStoreException;

    public abstract Preferences node(String var1);

    public abstract boolean nodeExists(String var1) throws BackingStoreException;

    public abstract Preferences parent();

    public abstract void exportNode(OutputStream var1) throws BackingStoreException, IOException;

    public abstract void exportSubtree(OutputStream var1) throws BackingStoreException, IOException;

    public abstract String[] keys() throws BackingStoreException;

    public abstract String get(String var1, String var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract byte[] getByteArray(String var1, byte[] var2);

    public abstract double getDouble(String var1, double var2);

    public abstract float getFloat(String var1, float var2);

    public abstract int getInt(String var1, int var2);

    public abstract long getLong(String var1, long var2);

    public abstract void put(String var1, String var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract void putByteArray(String var1, byte[] var2);

    public abstract void putDouble(String var1, double var2);

    public abstract void putFloat(String var1, float var2);

    public abstract void putInt(String var1, int var2);

    public abstract void putLong(String var1, long var2);

    public abstract void remove(String var1);

    public abstract void clear() throws BackingStoreException;

    public abstract void flush() throws BackingStoreException;

    public abstract void sync() throws BackingStoreException;

    public abstract void removeNode() throws BackingStoreException;

    public abstract void addNodeChangeListener(NodeChangeListener var1);

    public abstract void addPreferenceChangeListener(PreferenceChangeListener var1);

    public abstract void removeNodeChangeListener(NodeChangeListener var1);

    public abstract void removePreferenceChangeListener(PreferenceChangeListener var1);
}

