/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.security.cert.Certificate;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarEntry
extends ZipEntry {
    Attributes attr;
    JarFile jarfile;

    public JarEntry(String name) throws NullPointerException, IllegalArgumentException {
        super(name);
        this.attr = null;
        this.jarfile = null;
    }

    public JarEntry(ZipEntry entry) {
        super(entry);
        this.attr = null;
        this.jarfile = null;
    }

    public JarEntry(JarEntry entry) {
        super(entry);
        try {
            this.attr = entry.getAttributes();
        }
        catch (IOException iOException) {}
        this.jarfile = entry.jarfile;
    }

    public Attributes getAttributes() throws IOException {
        if (this.attr != null) {
            return (Attributes)this.attr.clone();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Certificate[] getCertificates() {
        if (this.jarfile != null) {
            JarFile jarFile = this.jarfile;
            synchronized (jarFile) {
                Set certs;
                if (this.jarfile.entryCerts != null && (certs = (Set)this.jarfile.entryCerts.get(this.getName())) != null && this.jarfile.verified.get(this.getName()) == Boolean.TRUE) {
                    return certs.toArray(new Certificate[certs.size()]);
                }
            }
        }
        return null;
    }
}

