/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPoolExecutor
extends AbstractExecutorService {
    private static final Runnable[] EMPTY_RUNNABLE_ARRAY = new Runnable[0];
    private static final RuntimePermission shutdownPerm = new RuntimePermission("modifyThread");
    private final BlockingQueue<Runnable> workQueue;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final Condition termination = this.mainLock.newCondition();
    private final HashSet<Worker> workers = new HashSet();
    private volatile long keepAliveTime;
    private volatile boolean allowCoreThreadTimeOut;
    private volatile int corePoolSize;
    private volatile int maximumPoolSize;
    private volatile int poolSize;
    volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;
    private volatile RejectedExecutionHandler handler;
    private volatile ThreadFactory threadFactory;
    private int largestPoolSize;
    private long completedTaskCount;
    private static final RejectedExecutionHandler defaultHandler = new AbortPolicy();

    void reject(Runnable command) {
        this.handler.rejectedExecution(command, this);
    }

    private Thread addThread(Runnable firstTask) {
        if (this.runState == 3) {
            return null;
        }
        Worker w = new Worker(firstTask);
        Thread t = this.threadFactory.newThread(w);
        if (t != null) {
            w.thread = t;
            this.workers.add(w);
            int nt = ++this.poolSize;
            if (nt > this.largestPoolSize) {
                this.largestPoolSize = nt;
            }
        }
        return t;
    }

    private boolean addIfUnderCorePoolSize(Runnable firstTask) {
        Thread t = null;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.corePoolSize) {
                t = this.addThread(firstTask);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (t == null) {
            return false;
        }
        t.start();
        return true;
    }

    private int addIfUnderMaximumPoolSize(Runnable firstTask) {
        Thread t = null;
        int status = 0;
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            if (this.poolSize < this.maximumPoolSize) {
                Runnable next = (Runnable)this.workQueue.poll();
                if (next == null) {
                    next = firstTask;
                    status = 1;
                } else {
                    status = -1;
                }
                t = this.addThread(next);
            }
        }
        finally {
            mainLock.unlock();
        }
        if (t == null) {
            return 0;
        }
        t.start();
        return status;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Runnable getTask() {
        while (true) {
            try {
                block8: while (true) {
                    switch (this.runState) {
                        case 0: {
                            if (this.poolSize <= this.corePoolSize && !this.allowCoreThreadTimeOut) {
                                return this.workQueue.take();
                            }
                            long timeout = this.keepAliveTime;
                            if (timeout <= 0L) {
                                return null;
                            }
                            Runnable r = this.workQueue.poll(timeout, TimeUnit.NANOSECONDS);
                            if (r != null) {
                                return r;
                            }
                            if (this.poolSize <= this.corePoolSize && !this.allowCoreThreadTimeOut) continue block8;
                            return null;
                        }
                        case 1: {
                            Runnable r = (Runnable)this.workQueue.poll();
                            if (r != null) {
                                return r;
                            }
                            if (this.workQueue.isEmpty()) {
                                this.interruptIdleWorkers();
                                return null;
                            }
                            return this.workQueue.take();
                        }
                        case 2: {
                            return null;
                        }
                    }
                    if (!$assertionsDisabled) break;
                }
                throw new AssertionError();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    void interruptIdleWorkers() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            for (Worker w : this.workers) {
                w.interruptIfIdle();
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void workerDone(Worker w) {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            this.completedTaskCount += w.completedTasks;
            this.workers.remove(w);
            if (--this.poolSize > 0) {
                return;
            }
            int state = this.runState;
            assert (state != 3);
            if (state != 2) {
                if (!this.workQueue.isEmpty()) {
                    Thread t = this.addThread(null);
                    if (t == null) return;
                    t.start();
                    return;
                }
                if (state == 0) {
                    return;
                }
            }
            this.termination.signalAll();
            this.runState = 3;
        }
        finally {
            mainLock.unlock();
        }
        assert (this.runState == 3);
        this.terminated();
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, defaultHandler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        this(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, Executors.defaultThreadFactory(), handler);
    }

    public ThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        if (corePoolSize < 0 || maximumPoolSize <= 0 || maximumPoolSize < corePoolSize || keepAliveTime < 0L) {
            throw new IllegalArgumentException();
        }
        if (workQueue == null || threadFactory == null || handler == null) {
            throw new NullPointerException();
        }
        this.corePoolSize = corePoolSize;
        this.maximumPoolSize = maximumPoolSize;
        this.workQueue = workQueue;
        this.keepAliveTime = unit.toNanos(keepAliveTime);
        this.threadFactory = threadFactory;
        this.handler = handler;
    }

    @Override
    public void execute(Runnable command) {
        int status;
        if (command == null) {
            throw new NullPointerException();
        }
        do {
            if (this.runState != 0) {
                this.reject(command);
                return;
            }
            if (this.poolSize < this.corePoolSize && this.addIfUnderCorePoolSize(command)) {
                return;
            }
            if (this.workQueue.offer(command)) {
                return;
            }
            status = this.addIfUnderMaximumPoolSize(command);
            if (status <= 0) continue;
            return;
        } while (status != 0);
        this.reject(command);
    }

    @Override
    public void shutdown() {
        boolean fullyTerminated;
        block12: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(shutdownPerm);
            }
            fullyTerminated = false;
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.workers.size() > 0) {
                    int state;
                    if (security != null) {
                        for (Worker w : this.workers) {
                            security.checkAccess(w.thread);
                        }
                    }
                    if ((state = this.runState) == 0) {
                        this.runState = 1;
                    }
                    try {
                        for (Worker w : this.workers) {
                            w.interruptIfIdle();
                        }
                        break block12;
                    }
                    catch (SecurityException se) {
                        this.runState = state;
                        throw se;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                mainLock.unlock();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        boolean fullyTerminated;
        block12: {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(shutdownPerm);
            }
            fullyTerminated = false;
            ReentrantLock mainLock = this.mainLock;
            mainLock.lock();
            try {
                if (this.workers.size() > 0) {
                    int state;
                    if (security != null) {
                        for (Worker w : this.workers) {
                            security.checkAccess(w.thread);
                        }
                    }
                    if ((state = this.runState) != 3) {
                        this.runState = 2;
                    }
                    try {
                        for (Worker w : this.workers) {
                            w.interruptNow();
                        }
                        break block12;
                    }
                    catch (SecurityException se) {
                        this.runState = state;
                        throw se;
                    }
                }
                fullyTerminated = true;
                this.runState = 3;
                this.termination.signalAll();
            }
            finally {
                mainLock.unlock();
            }
        }
        if (fullyTerminated) {
            this.terminated();
        }
        return Arrays.asList(this.workQueue.toArray(EMPTY_RUNNABLE_ARRAY));
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    public boolean isTerminating() {
        return this.runState == 2;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            while (true) {
                if (this.runState == 3) {
                    return true;
                }
                if (nanos <= 0L) {
                    return false;
                }
                nanos = this.termination.awaitNanos(nanos);
            }
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void finalize() {
        this.shutdown();
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        if (threadFactory == null) {
            throw new NullPointerException();
        }
        this.threadFactory = threadFactory;
    }

    public ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        this.handler = handler;
    }

    public RejectedExecutionHandler getRejectedExecutionHandler() {
        return this.handler;
    }

    public BlockingQueue<Runnable> getQueue() {
        return this.workQueue;
    }

    public boolean remove(Runnable task) {
        return this.getQueue().remove(task);
    }

    public void purge() {
        try {
            Iterator it = this.getQueue().iterator();
            while (it.hasNext()) {
                Future c;
                Runnable r = (Runnable)it.next();
                if (!(r instanceof Future) || !(c = (Future)((Object)r)).isCancelled()) continue;
                it.remove();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            return;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCorePoolSize(int corePoolSize) {
        if (corePoolSize < 0) {
            throw new IllegalArgumentException();
        }
        mainLock = this.mainLock;
        mainLock.lock();
        try {
            block6: {
                extra = this.corePoolSize - corePoolSize;
                this.corePoolSize = corePoolSize;
                if (extra >= 0) break block6;
                n = this.workQueue.size();
                ** GOTO lbl13
                while ((t = this.addThread(null)) != null) {
                    t.start();
lbl13:
                    // 2 sources

                    if (extra++ >= 0 || n-- <= 0) return;
                    if (this.poolSize < corePoolSize) continue;
                    return;
                }
                return;
            }
            if (extra <= 0 || this.poolSize <= corePoolSize) return;
            it = this.workers.iterator();
            if (true) ** GOTO lbl23
            do {
                it.next().interruptIfIdle();
lbl23:
                // 2 sources

                if (!it.hasNext() || extra-- <= 0 || this.poolSize <= corePoolSize) return;
            } while (this.workQueue.remainingCapacity() == 0);
            return;
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public boolean prestartCoreThread() {
        return this.addIfUnderCorePoolSize(null);
    }

    public int prestartAllCoreThreads() {
        int n = 0;
        while (this.addIfUnderCorePoolSize(null)) {
            ++n;
        }
        return n;
    }

    public boolean allowsCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void allowCoreThreadTimeOut(boolean value) {
        if (value && this.keepAliveTime <= 0L) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.allowCoreThreadTimeOut = value;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMaximumPoolSize(int maximumPoolSize) {
        if (maximumPoolSize <= 0) throw new IllegalArgumentException();
        if (maximumPoolSize < this.corePoolSize) {
            throw new IllegalArgumentException();
        }
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            block7: {
                Iterator<Worker> it;
                int extra;
                block6: {
                    extra = this.maximumPoolSize - maximumPoolSize;
                    this.maximumPoolSize = maximumPoolSize;
                    if (extra <= 0) return;
                    if (this.poolSize <= maximumPoolSize) return;
                    it = this.workers.iterator();
                    if (!true) break block6;
                    if (!it.hasNext()) return;
                    if (extra <= 0) return;
                    if (this.poolSize <= maximumPoolSize) break block7;
                }
                do {
                    it.next().interruptIfIdle();
                    --extra;
                    if (!it.hasNext()) return;
                    if (extra <= 0) return;
                } while (this.poolSize > maximumPoolSize);
            }
            return;
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public void setKeepAliveTime(long time, TimeUnit unit) {
        if (time < 0L) {
            throw new IllegalArgumentException();
        }
        if (time == 0L && this.allowsCoreThreadTimeOut()) {
            throw new IllegalArgumentException("Core threads must have nonzero keep alive times");
        }
        this.keepAliveTime = unit.toNanos(time);
    }

    public long getKeepAliveTime(TimeUnit unit) {
        return unit.convert(this.keepAliveTime, TimeUnit.NANOSECONDS);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getActiveCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = 0;
            for (Worker w : this.workers) {
                if (!w.isActive()) continue;
                ++n;
            }
            int n2 = n;
            return n2;
        }
        finally {
            mainLock.unlock();
        }
    }

    public int getLargestPoolSize() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            int n = this.largestPoolSize;
            return n;
        }
        finally {
            mainLock.unlock();
        }
    }

    public long getTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
                if (!w.isActive()) continue;
                ++n;
            }
            long l = n + (long)this.workQueue.size();
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    public long getCompletedTaskCount() {
        ReentrantLock mainLock = this.mainLock;
        mainLock.lock();
        try {
            long n = this.completedTaskCount;
            for (Worker w : this.workers) {
                n += w.completedTasks;
            }
            long l = n;
            return l;
        }
        finally {
            mainLock.unlock();
        }
    }

    protected void beforeExecute(Thread t, Runnable r) {
    }

    protected void afterExecute(Runnable r, Throwable t) {
    }

    protected void terminated() {
    }

    public static class AbortPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            throw new RejectedExecutionException();
        }
    }

    public static class CallerRunsPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                r.run();
            }
        }
    }

    public static class DiscardOldestPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            if (!e.isShutdown()) {
                e.getQueue().poll();
                e.execute(r);
            }
        }
    }

    public static class DiscardPolicy
    implements RejectedExecutionHandler {
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        }
    }

    private class Worker
    implements Runnable {
        private final ReentrantLock runLock = new ReentrantLock();
        private Runnable firstTask;
        volatile long completedTasks;
        Thread thread;

        Worker(Runnable firstTask) {
            this.firstTask = firstTask;
        }

        boolean isActive() {
            return this.runLock.isLocked();
        }

        void interruptIfIdle() {
            ReentrantLock runLock = this.runLock;
            if (runLock.tryLock()) {
                try {
                    this.thread.interrupt();
                }
                finally {
                    runLock.unlock();
                }
            }
        }

        void interruptNow() {
            this.thread.interrupt();
        }

        private void runTask(Runnable task) {
            ReentrantLock runLock = this.runLock;
            runLock.lock();
            try {
                if (ThreadPoolExecutor.this.runState != 2 && Thread.interrupted() && ThreadPoolExecutor.this.runState == 2) {
                    this.thread.interrupt();
                }
                boolean ran = false;
                ThreadPoolExecutor.this.beforeExecute(this.thread, task);
                try {
                    task.run();
                    ran = true;
                    ThreadPoolExecutor.this.afterExecute(task, null);
                    ++this.completedTasks;
                }
                catch (RuntimeException ex) {
                    if (!ran) {
                        ThreadPoolExecutor.this.afterExecute(task, ex);
                    }
                    throw ex;
                }
            }
            finally {
                runLock.unlock();
            }
        }

        public void run() {
            try {
                Runnable task = this.firstTask;
                this.firstTask = null;
                while (task != null || (task = ThreadPoolExecutor.this.getTask()) != null) {
                    this.runTask(task);
                    task = null;
                }
            }
            finally {
                ThreadPoolExecutor.this.workerDone(this);
            }
        }
    }
}

