/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int NCPUS = Runtime.getRuntime().availableProcessors();
    static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    static final int maxUntimedSpins = maxTimedSpins * 16;
    static final long spinForTimeoutThreshold = 1000L;
    private volatile transient Transferer transferer;
    private ReentrantLock qlock;
    private WaitQueue waitingProducers;
    private WaitQueue waitingConsumers;

    public SynchronousQueue() {
        this(false);
    }

    public SynchronousQueue(boolean fair) {
        this.transferer = fair ? new TransferQueue() : new TransferStack();
    }

    @Override
    public void put(E o) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(o, false, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.transferer.transfer(o, true, unit.toNanos(timeout)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.transferer.transfer(e, true, 0L) != null;
    }

    @Override
    public E take() throws InterruptedException {
        Object e = this.transferer.transfer(null, false, 0L);
        if (e != null) {
            return (E)e;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object e = this.transferer.transfer(null, true, unit.toNanos(timeout));
        if (e != null || !Thread.interrupted()) {
            return (E)e;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return (E)this.transferer.transfer(null, true, 0L);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public int remainingCapacity() {
        return 0;
    }

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object o) {
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return false;
    }

    @Override
    public E peek() {
        return null;
    }

    @Override
    public Iterator<E> iterator() {
        return new EmptyIterator();
    }

    @Override
    public Object[] toArray() {
        return new Object[0];
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length > 0) {
            a[0] = null;
        }
        return a;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        E e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E e;
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < maxElements && (e = this.poll()) != null) {
            c.add(e);
            ++n;
        }
        return n;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        boolean fair = this.transferer instanceof TransferQueue;
        if (fair) {
            this.qlock = new ReentrantLock(true);
            this.waitingProducers = new FifoWaitQueue();
            this.waitingConsumers = new FifoWaitQueue();
        } else {
            this.qlock = new ReentrantLock();
            this.waitingProducers = new LifoWaitQueue();
            this.waitingConsumers = new LifoWaitQueue();
        }
        s.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.transferer = this.waitingProducers instanceof FifoWaitQueue ? new TransferQueue() : new TransferStack();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyIterator<E>
    implements Iterator<E> {
        EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3623113410248163686L;

        FifoWaitQueue() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LifoWaitQueue
    extends WaitQueue {
        private static final long serialVersionUID = -3633113410248163686L;

        LifoWaitQueue() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TransferQueue
    extends Transferer {
        volatile transient QNode head;
        volatile transient QNode tail;
        volatile transient QNode cleanMe;
        static final AtomicReferenceFieldUpdater<TransferQueue, java.util.concurrent.SynchronousQueue$TransferQueue.QNode> headUpdater = AtomicReferenceFieldUpdater.newUpdater(TransferQueue.class, QNode.class, "head");
        static final AtomicReferenceFieldUpdater<TransferQueue, java.util.concurrent.SynchronousQueue$TransferQueue.QNode> tailUpdater = AtomicReferenceFieldUpdater.newUpdater(TransferQueue.class, QNode.class, "tail");
        static final AtomicReferenceFieldUpdater<TransferQueue, java.util.concurrent.SynchronousQueue$TransferQueue.QNode> cleanMeUpdater = AtomicReferenceFieldUpdater.newUpdater(TransferQueue.class, QNode.class, "cleanMe");

        TransferQueue() {
            QNode h;
            this.head = h = new QNode(null, false);
            this.tail = h;
        }

        void advanceHead(QNode h, QNode nh) {
            if (h == this.head && headUpdater.compareAndSet(this, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)h, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)nh)) {
                h.next = h;
            }
        }

        void advanceTail(QNode t, QNode nt) {
            if (this.tail == t) {
                tailUpdater.compareAndSet(this, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)t, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)nt);
            }
        }

        boolean casCleanMe(QNode cmp, QNode val) {
            return this.cleanMe == cmp && cleanMeUpdater.compareAndSet(this, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)cmp, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)val);
        }

        @Override
        Object transfer(Object e, boolean timed, long nanos) {
            QNode m;
            Object x;
            QNode h;
            QNode s = null;
            boolean isData = e != null;
            while (true) {
                QNode t = this.tail;
                h = this.head;
                if (t == null || h == null) continue;
                if (h == t || t.isData == isData) {
                    QNode tn = t.next;
                    if (t != this.tail) continue;
                    if (tn != null) {
                        this.advanceTail(t, tn);
                        continue;
                    }
                    if (timed && nanos <= 0L) {
                        return null;
                    }
                    if (s == null) {
                        s = new QNode(e, isData);
                    }
                    if (!t.casNext(null, s)) continue;
                    this.advanceTail(t, s);
                    x = this.awaitFulfill(s, e, timed, nanos);
                    if (x == s) {
                        this.clean(t, s);
                        return null;
                    }
                    if (!s.isOffList()) {
                        this.advanceHead(t, s);
                        if (x != null) {
                            s.item = s;
                        }
                        s.waiter = null;
                    }
                    return x != null ? x : e;
                }
                m = h.next;
                if (t != this.tail || m == null || h != this.head) continue;
                x = m.item;
                if (isData != (x != null) && x != m && m.casItem(x, e)) break;
                this.advanceHead(h, m);
            }
            this.advanceHead(h, m);
            LockSupport.unpark(m.waiter);
            return x != null ? x : e;
        }

        Object awaitFulfill(QNode s, Object e, boolean timed, long nanos) {
            int spins;
            long lastTime = timed ? System.nanoTime() : 0L;
            Thread w = Thread.currentThread();
            int n = this.head.next == s ? (timed ? maxTimedSpins : maxUntimedSpins) : (spins = 0);
            while (true) {
                long now;
                Object x;
                if (w.isInterrupted()) {
                    s.tryCancel(e);
                }
                if ((x = s.item) != e) {
                    return x;
                }
                if (timed && (nanos -= (now = System.nanoTime()) - (lastTime = now)) <= 0L) {
                    s.tryCancel(e);
                    continue;
                }
                if (spins > 0) {
                    --spins;
                    continue;
                }
                if (s.waiter == null) {
                    s.waiter = w;
                    continue;
                }
                if (!timed) {
                    LockSupport.park(this);
                    continue;
                }
                if (nanos <= 1000L) continue;
                LockSupport.parkNanos(this, nanos);
            }
        }

        void clean(QNode pred, QNode s) {
            s.waiter = null;
            while (pred.next == s) {
                QNode sn;
                QNode h = this.head;
                QNode hn = h.next;
                if (hn != null && hn.isCancelled()) {
                    this.advanceHead(h, hn);
                    continue;
                }
                QNode t = this.tail;
                if (t == h) {
                    return;
                }
                QNode tn = t.next;
                if (t != this.tail) continue;
                if (tn != null) {
                    this.advanceTail(t, tn);
                    continue;
                }
                if (s != t && ((sn = s.next) == s || pred.casNext(s, sn))) {
                    return;
                }
                QNode dp = this.cleanMe;
                if (dp != null) {
                    QNode dn;
                    QNode d = dp.next;
                    if (d == null || d == dp || !d.isCancelled() || d != t && (dn = d.next) != null && dn != d && dp.casNext(d, dn)) {
                        this.casCleanMe(dp, null);
                    }
                    if (dp != pred) continue;
                    return;
                }
                if (!this.casCleanMe(null, pred)) continue;
                return;
            }
        }

        static final class QNode {
            volatile QNode next;
            volatile Object item;
            volatile Thread waiter;
            final boolean isData;
            static final AtomicReferenceFieldUpdater<java.util.concurrent.SynchronousQueue$TransferQueue.QNode, java.util.concurrent.SynchronousQueue$TransferQueue.QNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");
            static final AtomicReferenceFieldUpdater<java.util.concurrent.SynchronousQueue$TransferQueue.QNode, Object> itemUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, Object.class, "item");

            QNode(Object item, boolean isData) {
                this.item = item;
                this.isData = isData;
            }

            boolean casNext(QNode cmp, QNode val) {
                return this.next == cmp && nextUpdater.compareAndSet((java.util.concurrent.SynchronousQueue$TransferQueue.QNode)this, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)cmp, (java.util.concurrent.SynchronousQueue$TransferQueue.QNode)val);
            }

            boolean casItem(Object cmp, Object val) {
                return this.item == cmp && itemUpdater.compareAndSet((java.util.concurrent.SynchronousQueue$TransferQueue.QNode)this, cmp, val);
            }

            void tryCancel(Object cmp) {
                itemUpdater.compareAndSet((java.util.concurrent.SynchronousQueue$TransferQueue.QNode)this, cmp, this);
            }

            boolean isCancelled() {
                return this.item == this;
            }

            boolean isOffList() {
                return this.next == this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TransferStack
    extends Transferer {
        static final int REQUEST = 0;
        static final int DATA = 1;
        static final int FULFILLING = 2;
        volatile SNode head;
        static final AtomicReferenceFieldUpdater<TransferStack, java.util.concurrent.SynchronousQueue$TransferStack.SNode> headUpdater = AtomicReferenceFieldUpdater.newUpdater(TransferStack.class, SNode.class, "head");

        TransferStack() {
        }

        static boolean isFulfilling(int m) {
            return (m & 2) != 0;
        }

        boolean casHead(SNode h, SNode nh) {
            return h == this.head && headUpdater.compareAndSet(this, (java.util.concurrent.SynchronousQueue$TransferStack.SNode)h, (java.util.concurrent.SynchronousQueue$TransferStack.SNode)nh);
        }

        static SNode snode(SNode s, Object e, SNode next, int mode) {
            if (s == null) {
                s = new SNode(e);
            }
            s.mode = mode;
            s.next = next;
            return s;
        }

        @Override
        Object transfer(Object e, boolean timed, long nanos) {
            int mode;
            SNode s = null;
            int n = mode = e == null ? 0 : 1;
            block0: while (true) {
                SNode mn;
                SNode m;
                SNode h;
                if ((h = this.head) == null || h.mode == mode) {
                    if (timed && nanos <= 0L) {
                        if (h != null && h.isCancelled()) {
                            this.casHead(h, h.next);
                            continue;
                        }
                        return null;
                    }
                    if (!this.casHead(h, s = TransferStack.snode(s, e, h, mode))) continue;
                    m = this.awaitFulfill(s, timed, nanos);
                    if (m == s) {
                        this.clean(s);
                        return null;
                    }
                    h = this.head;
                    if (h != null && h.next == s) {
                        this.casHead(h, s.next);
                    }
                    return mode == 0 ? m.item : s.item;
                }
                if (!TransferStack.isFulfilling(h.mode)) {
                    if (h.isCancelled()) {
                        this.casHead(h, h.next);
                        continue;
                    }
                    if (!this.casHead(h, s = TransferStack.snode(s, e, h, 2 | mode))) continue;
                    while (true) {
                        if ((m = s.next) == null) {
                            this.casHead(s, null);
                            s = null;
                            continue block0;
                        }
                        mn = m.next;
                        if (m.tryMatch(s)) {
                            this.casHead(s, mn);
                            return mode == 0 ? m.item : s.item;
                        }
                        s.casNext(m, mn);
                    }
                }
                m = h.next;
                if (m == null) {
                    this.casHead(h, null);
                    continue;
                }
                mn = m.next;
                if (m.tryMatch(h)) {
                    this.casHead(h, mn);
                    continue;
                }
                h.casNext(m, mn);
            }
        }

        SNode awaitFulfill(SNode s, boolean timed, long nanos) {
            int spins;
            long lastTime = timed ? System.nanoTime() : 0L;
            Thread w = Thread.currentThread();
            int n = this.shouldSpin(s) ? (timed ? maxTimedSpins : maxUntimedSpins) : (spins = 0);
            while (true) {
                long now;
                SNode m;
                if (w.isInterrupted()) {
                    s.tryCancel();
                }
                if ((m = s.match) != null) {
                    return m;
                }
                if (timed && (nanos -= (now = System.nanoTime()) - (lastTime = now)) <= 0L) {
                    s.tryCancel();
                    continue;
                }
                if (spins > 0) {
                    spins = this.shouldSpin(s) ? spins - 1 : 0;
                    continue;
                }
                if (s.waiter == null) {
                    s.waiter = w;
                    continue;
                }
                if (!timed) {
                    LockSupport.park(this);
                    continue;
                }
                if (nanos <= 1000L) continue;
                LockSupport.parkNanos(this, nanos);
            }
        }

        boolean shouldSpin(SNode s) {
            SNode h = this.head;
            return h == s || h == null || TransferStack.isFulfilling(h.mode);
        }

        void clean(SNode s) {
            SNode p;
            s.item = null;
            s.waiter = null;
            SNode past = s.next;
            if (past != null && past.isCancelled()) {
                past = past.next;
            }
            while ((p = this.head) != null && p != past && p.isCancelled()) {
                this.casHead(p, p.next);
            }
            while (p != null && p != past) {
                SNode n = p.next;
                if (n != null && n.isCancelled()) {
                    p.casNext(n, n.next);
                    continue;
                }
                p = n;
            }
        }

        static final class SNode {
            volatile SNode next;
            volatile SNode match;
            volatile Thread waiter;
            Object item;
            int mode;
            static final AtomicReferenceFieldUpdater<java.util.concurrent.SynchronousQueue$TransferStack.SNode, java.util.concurrent.SynchronousQueue$TransferStack.SNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(SNode.class, SNode.class, "next");
            static final AtomicReferenceFieldUpdater<java.util.concurrent.SynchronousQueue$TransferStack.SNode, java.util.concurrent.SynchronousQueue$TransferStack.SNode> matchUpdater = AtomicReferenceFieldUpdater.newUpdater(SNode.class, SNode.class, "match");

            SNode(Object item) {
                this.item = item;
            }

            boolean casNext(SNode cmp, SNode val) {
                return cmp == this.next && nextUpdater.compareAndSet((java.util.concurrent.SynchronousQueue$TransferStack.SNode)this, (java.util.concurrent.SynchronousQueue$TransferStack.SNode)cmp, (java.util.concurrent.SynchronousQueue$TransferStack.SNode)val);
            }

            boolean tryMatch(SNode s) {
                if (this.match == null && matchUpdater.compareAndSet((java.util.concurrent.SynchronousQueue$TransferStack.SNode)this, null, (java.util.concurrent.SynchronousQueue$TransferStack.SNode)s)) {
                    Thread w = this.waiter;
                    if (w != null) {
                        this.waiter = null;
                        LockSupport.unpark(w);
                    }
                    return true;
                }
                return this.match == s;
            }

            void tryCancel() {
                matchUpdater.compareAndSet((java.util.concurrent.SynchronousQueue$TransferStack.SNode)this, null, (java.util.concurrent.SynchronousQueue$TransferStack.SNode)this);
            }

            boolean isCancelled() {
                return this.match == this;
            }
        }
    }

    static abstract class Transferer {
        Transferer() {
        }

        abstract Object transfer(Object var1, boolean var2, long var3);
    }

    static class WaitQueue
    implements Serializable {
        WaitQueue() {
        }
    }
}

