/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMap<K, V>
implements Map<K, V> {
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    Set<K> keys;
    Collection<V> values;

    protected AbstractMap() {
    }

    @Override
    public abstract Set<Map.Entry<K, V>> entrySet();

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap copy = (AbstractMap)super.clone();
        copy.keys = null;
        copy.values = null;
        return copy;
    }

    @Override
    public boolean containsKey(Object key) {
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(key, entries.next().getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            if (!AbstractMap.equals(value, entries.next().getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o == this || o instanceof Map && this.entrySet().equals(((Map)o).entrySet());
    }

    @Override
    public V get(Object key) {
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry<K, V> entry = entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet<K>(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object key) {
                    return AbstractMap.this.containsKey(key);
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(this){
                        private final Iterator<Map.Entry<K, V>> map_iterator;
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = var1_1;
                            this.map_iterator = 1.access$0(var1_1).entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public K next() {
                            return this.map_iterator.next().getKey();
                        }

                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }

                static /* synthetic */ AbstractMap access$0(1 var0) {
                    return var0.AbstractMap.this;
                }
            };
        }
        return this.keys;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Iterator<Map.Entry<K, V>> entries2;
        Iterator<Map.Entry<K, V>> entries = entries2 = m.entrySet().iterator();
        int pos = m.size();
        while (--pos >= 0) {
            Map.Entry<K, V> entry = entries.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        int pos = this.size();
        while (--pos >= 0) {
            Map.Entry<K, V> entry = entries.next();
            if (!AbstractMap.equals(key, entry.getKey())) continue;
            V r = entry.getValue();
            entries.remove();
            return r;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> entries = this.entrySet().iterator();
        StringBuffer r = new StringBuffer("{");
        int pos = this.size();
        while (pos > 0) {
            Map.Entry<K, V> entry = entries.next();
            r.append(entry.getKey());
            r.append('=');
            r.append(entry.getValue());
            if (pos > 1) {
                r.append(", ");
            }
            --pos;
        }
        r.append("}");
        return r.toString();
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean contains(Object value) {
                    return AbstractMap.this.containsValue(value);
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(this){
                        private final Iterator<Map.Entry<K, V>> map_iterator;
                        final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = var1_1;
                            this.map_iterator = 3.access$0(var1_1).entrySet().iterator();
                        }

                        public boolean hasNext() {
                            return this.map_iterator.hasNext();
                        }

                        public V next() {
                            return this.map_iterator.next().getValue();
                        }

                        public void remove() {
                            this.map_iterator.remove();
                        }
                    };
                }

                static /* synthetic */ AbstractMap access$0(3 var0) {
                    return var0.AbstractMap.this;
                }
            };
        }
        return this.values;
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    static final int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        K key;
        V value;

        public SimpleEntry(K newKey, V newValue) {
            this.key = newKey;
            this.value = newValue;
        }

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof SimpleEntry) {
                SimpleEntry e = (SimpleEntry)o;
                return AbstractMap.equals(this.key, e.key) && AbstractMap.equals(this.value, e.value);
            }
            Map.Entry e = (Map.Entry)o;
            return AbstractMap.equals(this.key, e.getKey()) && AbstractMap.equals(this.value, e.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return AbstractMap.hashCode(this.key) ^ AbstractMap.hashCode(this.value);
        }

        @Override
        public V setValue(V newVal) {
            V r = this.value;
            this.value = newVal;
            return r;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 7138329143949025153L;
        K key;
        V value;

        public SimpleImmutableEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public SimpleImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this(entry.getKey(), entry.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue not supported on immutable entry");
        }
    }
}

