/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.DummySignature;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;

public abstract class Signature
extends SignatureSpi {
    private static final String SIGNATURE = "Signature";
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state = 0;
    private String algorithm;
    Provider provider;

    protected Signature(String algorithm) {
        this.algorithm = algorithm;
        this.state = 0;
    }

    public static Signature getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return Signature.getInstance(algorithm, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static Signature getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        if ((provider = provider.trim()).length() == 0) {
            throw new IllegalArgumentException("provider MUST NOT be empty");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Signature.getInstance(algorithm, p);
    }

    public static Signature getInstance(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        Signature result;
        Object o;
        StringBuilder sb = new StringBuilder("Signature algorithm [").append(algorithm).append("] from provider[").append(provider).append("] ");
        try {
            o = Engine.getInstance(SIGNATURE, algorithm, provider);
        }
        catch (InvocationTargetException x) {
            Throwable cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
            sb.append("could not be created");
            NoSuchAlgorithmException y = new NoSuchAlgorithmException(sb.toString());
            y.initCause(cause);
            throw y;
        }
        if (o instanceof SignatureSpi) {
            result = new DummySignature((SignatureSpi)o, algorithm);
        } else if (o instanceof Signature) {
            result = (Signature)o;
            result.algorithm = algorithm;
        } else {
            sb.append("is of an unexpected Type: ").append(o.getClass().getName());
            throw new NoSuchAlgorithmException(sb.toString());
        }
        result.provider = provider;
        return result;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.state = 3;
        this.engineInitVerify(publicKey);
    }

    public final void initVerify(Certificate certificate) throws InvalidKeyException {
        X509Certificate cert;
        boolean[] array;
        this.state = 3;
        if (certificate.getType().equals("X509") && (array = (cert = (X509Certificate)certificate).getKeyUsage()) != null && !array[0]) {
            throw new InvalidKeyException("KeyUsage of this Certificate indicates it cannot be used for digital signing");
        }
        this.initVerify(certificate.getPublicKey());
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey);
    }

    public final void initSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.state = 2;
        this.engineInitSign(privateKey, random);
    }

    public final byte[] sign() throws SignatureException {
        if (this.state == 2) {
            return this.engineSign();
        }
        throw new SignatureException();
    }

    public final int sign(byte[] outbuf, int offset, int len) throws SignatureException {
        if (this.state == 2) {
            return this.engineSign(outbuf, offset, len);
        }
        throw new SignatureException();
    }

    public final boolean verify(byte[] signature) throws SignatureException {
        if (this.state == 3) {
            return this.engineVerify(signature);
        }
        throw new SignatureException();
    }

    public final boolean verify(byte[] signature, int offset, int length) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException("illegal state");
        }
        if (signature == null) {
            throw new IllegalArgumentException("signature is null");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset is less than 0");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length is less than 0");
        }
        if (offset + length < signature.length) {
            throw new IllegalArgumentException("range is out of bounds");
        }
        return this.engineVerify(signature, offset, length);
    }

    public final void update(byte b) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(b);
    }

    public final void update(byte[] data) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(data, 0, data.length);
    }

    public final void update(byte[] data, int off, int len) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException();
        }
        this.engineUpdate(data, off, len);
    }

    public final void update(ByteBuffer input) throws SignatureException {
        if (this.state == 0) {
            throw new SignatureException("not initialized");
        }
        this.engineUpdate(input);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return String.valueOf(this.algorithm) + " Signature";
    }

    public final void setParameter(String param, Object value) throws InvalidParameterException {
        this.engineSetParameter(param, value);
    }

    public final void setParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.engineSetParameter(params);
    }

    public final AlgorithmParameters getParameters() {
        return this.engineGetParameters();
    }

    public final Object getParameter(String param) throws InvalidParameterException {
        return this.engineGetParameter(param);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

