/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;
import java.util.WeakHashMap;

public abstract class RemoteObject
implements Remote,
Serializable {
    private static final long serialVersionUID = -3215090123894869218L;
    protected transient RemoteRef ref;
    private static final WeakHashMap stubs = new WeakHashMap();

    protected RemoteObject() {
        this(null);
    }

    protected RemoteObject(RemoteRef newref) {
        this.ref = newref;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    static synchronized void addStub(Remote obj, Remote stub) {
        stubs.put(obj, stub);
    }

    static synchronized void deleteStub(Remote obj) {
        stubs.remove(obj);
    }

    public static Remote toStub(Remote obj) throws NoSuchObjectException {
        Remote stub = (Remote)stubs.get(obj);
        if (stub == null) {
            throw new NoSuchObjectException(obj.getClass().getName());
        }
        return stub;
    }

    public int hashCode() {
        if (this.ref == null) {
            return 0;
        }
        return this.ref.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public String toString() {
        if (this.ref == null) {
            return this.getClass().toString();
        }
        return this.ref.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String cname = in.readUTF();
        if (!cname.equals("")) {
            if (cname.equals("UnicastRef2")) {
                cname = "UnicastRef";
                in.read();
            }
            cname = "gnu.java.rmi.server." + cname;
            try {
                Class<?> cls = Class.forName(cname);
                this.ref = (RemoteRef)cls.newInstance();
            }
            catch (InstantiationException e1) {
                throw new UnmarshalException("failed to create ref", e1);
            }
            catch (IllegalAccessException e2) {
                throw new UnmarshalException("failed to create ref", e2);
            }
            this.ref.readExternal(in);
        } else {
            this.ref = (RemoteRef)in.readObject();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new UnmarshalException("no ref to serialize");
        }
        String cname = this.ref.getRefClass(out);
        if (cname != null && cname.length() > 0) {
            out.writeUTF(cname);
            this.ref.writeExternal(out);
        } else {
            out.writeUTF("");
            out.writeObject(this.ref);
        }
    }
}

