/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import gnu.gcj.RawData;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;
import java.nio.ReadOnlyBufferException;

public abstract class Buffer {
    int cap = 0;
    int limit = 0;
    int pos = 0;
    int mark = -1;
    RawData address;

    Buffer(int capacity, int limit, int position, int mark) {
        if (capacity < 0) {
            throw new IllegalArgumentException();
        }
        this.cap = capacity;
        this.limit(limit);
        this.position(position);
        if (mark >= 0) {
            if (mark > this.pos) {
                throw new IllegalArgumentException();
            }
            this.mark = mark;
        }
    }

    public final int capacity() {
        return this.cap;
    }

    public final Buffer clear() {
        this.limit = this.cap;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.pos;
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    public final boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public abstract boolean isReadOnly();

    public final int limit() {
        return this.limit;
    }

    public final Buffer limit(int newLimit) {
        if (newLimit < 0 || newLimit > this.cap) {
            throw new IllegalArgumentException();
        }
        if (newLimit < this.mark) {
            this.mark = -1;
        }
        if (this.pos > newLimit) {
            this.pos = newLimit;
        }
        this.limit = newLimit;
        return this;
    }

    public final Buffer mark() {
        this.mark = this.pos;
        return this;
    }

    public final int position() {
        return this.pos;
    }

    public final Buffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit) {
            throw new IllegalArgumentException();
        }
        if (newPosition <= this.mark) {
            this.mark = -1;
        }
        this.pos = newPosition;
        return this;
    }

    public final int remaining() {
        return this.limit - this.pos;
    }

    public final Buffer reset() {
        if (this.mark == -1) {
            throw new InvalidMarkException();
        }
        this.pos = this.mark;
        return this;
    }

    public final Buffer rewind() {
        this.pos = 0;
        this.mark = -1;
        return this;
    }

    final void checkForUnderflow() {
        if (!this.hasRemaining()) {
            throw new BufferUnderflowException();
        }
    }

    final void checkForUnderflow(int length) {
        if (this.remaining() < length) {
            throw new BufferUnderflowException();
        }
    }

    final void checkForOverflow() {
        if (!this.hasRemaining()) {
            throw new BufferOverflowException();
        }
    }

    final void checkForOverflow(int length) {
        if (this.remaining() < length) {
            throw new BufferOverflowException();
        }
    }

    final void checkIndex(int index) {
        if (index < 0 || index >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
    }

    final void checkIfReadOnly() {
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
    }

    static final void checkArraySize(int arraylength, int offset, int length) {
        if (offset < 0 || length < 0 || arraylength < length + offset) {
            throw new IndexOutOfBoundsException();
        }
    }
}

