/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.gcj.RawDataManaged;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;

final class PosixProcess
extends Process {
    private String[] progarray;
    private String[] envp;
    private File dir;
    private boolean redirect;
    private Throwable exception;
    long pid;
    static final int STATE_WAITING_TO_START = 0;
    static final int STATE_RUNNING = 1;
    static final int STATE_TERMINATED = 2;
    int state;
    int status;
    private InputStream errorStream;
    private InputStream inputStream;
    private OutputStream outputStream;
    private InputStream returnedErrorStream;
    private InputStream returnedInputStream;
    private static Object queueLock = new Object();
    private static ProcessManager processManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = queueLock;
        synchronized (object) {
            PosixProcess posixProcess = this;
            synchronized (posixProcess) {
                if (this.state != 2) {
                    if (processManager == null) {
                        throw new InternalError();
                    }
                    this.nativeDestroy();
                }
            }
        }
    }

    private native void nativeDestroy();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exitValue() {
        PosixProcess posixProcess = this;
        synchronized (posixProcess) {
            if (this.state != 2) {
                throw new IllegalThreadStateException("Process has not exited");
            }
        }
        return this.status;
    }

    void processTerminationCleanup() {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {}
        try {
            if (this.returnedErrorStream == null && this.errorStream.available() == 0) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (IOException iOException) {}
        try {
            if (this.returnedInputStream == null && this.inputStream.available() == 0) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (IOException iOException) {}
    }

    public synchronized InputStream getErrorStream() {
        if (this.returnedErrorStream != null) {
            return this.returnedErrorStream;
        }
        this.returnedErrorStream = this.errorStream == null ? EOFInputStream.instance : this.errorStream;
        return this.returnedErrorStream;
    }

    public synchronized InputStream getInputStream() {
        if (this.returnedInputStream != null) {
            return this.returnedInputStream;
        }
        this.returnedInputStream = this.inputStream == null ? EOFInputStream.instance : this.inputStream;
        return this.returnedInputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        PosixProcess posixProcess = this;
        synchronized (posixProcess) {
            while (this.state != 2) {
                this.wait();
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void spawn(ProcessManager pm) {
        PosixProcess posixProcess = this;
        synchronized (posixProcess) {
            this.nativeSpawn();
            pm.addToLiveProcesses(this);
            this.state = 1;
            this.notifyAll();
        }
    }

    private native void nativeSpawn();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PosixProcess(String[] progarray, String[] envp, File dir, boolean redirect) throws IOException {
        if (progarray[0] == null) {
            throw new NullPointerException();
        }
        this.progarray = progarray;
        this.envp = envp;
        this.dir = dir;
        this.redirect = redirect;
        Object object = queueLock;
        synchronized (object) {
            if (processManager == null) {
                processManager = new ProcessManager();
                processManager.start();
                processManager.waitUntilReady();
            }
            processManager.startExecuting(this);
        }
        object = this;
        synchronized (object) {
            while (this.state == 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.exception == null) {
            return;
        }
        if (this.exception instanceof IOException) {
            IOException ioe = new IOException(this.exception.toString());
            ioe.initCause(this.exception);
            throw ioe;
        }
        InternalError ie = new InternalError(this.exception.toString());
        ie.initCause(this.exception);
        throw ie;
    }

    static class EOFInputStream
    extends InputStream {
        static EOFInputStream instance = new EOFInputStream();

        EOFInputStream() {
        }

        public int read() {
            return -1;
        }
    }

    static final class ProcessManager
    extends Thread {
        private LinkedList<PosixProcess> queue = new LinkedList();
        private LinkedList<PosixProcess> liveProcesses = new LinkedList();
        private boolean ready = false;
        static RawDataManaged nativeData;

        ProcessManager() {
            super("ProcessManager", true);
            this.setDaemon(true);
        }

        void addToLiveProcesses(PosixProcess p) {
            this.liveProcesses.add(p);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startExecuting(PosixProcess p) {
            Object object = queueLock;
            synchronized (object) {
                this.queue.add(p);
                this.signalReaper();
                queueLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitUntilReady() {
            ProcessManager processManager = this;
            synchronized (processManager) {
                try {
                    while (!this.ready) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            this.init();
            Object object = this;
            synchronized (object) {
                this.ready = true;
                this.notifyAll();
            }
            while (true) {
                try {
                    while (true) {
                        object = queueLock;
                        synchronized (object) {
                            Iterator processIterator = this.liveProcesses.iterator();
                            while (true) {
                                if (!processIterator.hasNext()) {
                                    if (this.liveProcesses.size() != 0 || this.queue.size() != 0) break;
                                    try {
                                        queueLock.wait(1000L);
                                        if (this.queue.size() == 0) {
                                            PosixProcess.processManager = null;
                                            return;
                                        }
                                        break;
                                    }
                                    catch (InterruptedException interruptedException) {
                                        return;
                                    }
                                }
                                boolean reaped = this.reap((PosixProcess)processIterator.next());
                                if (!reaped) continue;
                                processIterator.remove();
                            }
                            while (this.queue.size() > 0) {
                                PosixProcess p = this.queue.remove(0);
                                p.spawn(this);
                            }
                        }
                        this.waitForSignal();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }

        private native void init();

        private native void waitForSignal();

        private native boolean reap(PosixProcess var1);

        private native void signalReaper();
    }
}

