/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceDelegate {
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        if (type != Object.class) {
            type = type.getSuperclass();
            PersistenceDelegate pd = out.getPersistenceDelegate(type);
            pd.initialize(type, oldInstance, newInstance, out);
        }
    }

    public void writeObject(Object oldInstance, Encoder out) {
        Object streamCandidate = out.get(oldInstance);
        if (this.mutatesTo(oldInstance, streamCandidate)) {
            this.initialize(oldInstance.getClass(), oldInstance, streamCandidate, out);
        } else {
            out.remove(oldInstance);
            out.writeExpression(this.instantiate(oldInstance, out));
        }
    }

    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        return newInstance != null && oldInstance.getClass() == newInstance.getClass();
    }

    protected abstract Expression instantiate(Object var1, Encoder var2);
}

