/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import gnu.java.awt.BitMaskExtent;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int scanlineStride;
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] sampleSize;

    public SinglePixelPackedSampleModel(int dataType, int w, int h, int[] bitMasks) {
        this(dataType, w, h, w, bitMasks);
    }

    public SinglePixelPackedSampleModel(int dataType, int w, int h, int scanlineStride, int[] bitMasks) {
        super(dataType, w, h, bitMasks.length);
        switch (dataType) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("SinglePixelPackedSampleModel unsupported dataType");
            }
        }
        this.scanlineStride = scanlineStride;
        this.bitMasks = bitMasks;
        this.bitOffsets = new int[this.numBands];
        this.sampleSize = new int[this.numBands];
        BitMaskExtent extent = new BitMaskExtent();
        int b = 0;
        while (b < this.numBands) {
            long mask = (long)bitMasks[b] & 0xFFFFFFFFL;
            extent.setMask(mask);
            this.sampleSize[b] = extent.bitWidth;
            this.bitOffsets[b] = extent.leastSignificantBit;
            ++b;
        }
    }

    public int getNumDataElements() {
        return 1;
    }

    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(this.dataType, w, h, this.bitMasks);
    }

    public DataBuffer createDataBuffer() {
        int size = this.scanlineStride * (this.height - 1) + this.width;
        DataBuffer buffer = null;
        switch (this.getTransferType()) {
            case 0: {
                buffer = new DataBufferByte(size);
                break;
            }
            case 1: {
                buffer = new DataBufferUShort(size);
                break;
            }
            case 3: {
                buffer = new DataBufferInt(size);
            }
        }
        return buffer;
    }

    public int[] getSampleSize() {
        return (int[])this.sampleSize.clone();
    }

    public int getSampleSize(int band) {
        return this.sampleSize[band];
    }

    public int getOffset(int x, int y) {
        return this.scanlineStride * y + x;
    }

    public int[] getBitOffsets() {
        return this.bitOffsets;
    }

    public int[] getBitMasks() {
        return this.bitMasks;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.numBands) {
            throw new RasterFormatException("Too many bands.");
        }
        int numBands = bands.length;
        int[] bitMasks = new int[numBands];
        int b = 0;
        while (b < numBands) {
            bitMasks[b] = this.bitMasks[bands[b]];
            ++b;
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, bitMasks);
    }

    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        int type = this.getTransferType();
        Object[] ret = null;
        switch (type) {
            case 0: {
                byte[] in = (byte[])obj;
                if (in == null) {
                    in = new byte[]{(byte)data.getElem(x + y * this.scanlineStride)};
                }
                ret = in;
                break;
            }
            case 1: {
                short[] in = (short[])obj;
                if (in == null) {
                    in = new short[]{(short)data.getElem(x + y * this.scanlineStride)};
                }
                ret = in;
                break;
            }
            case 3: {
                int[] in = (int[])obj;
                if (in == null) {
                    in = new int[]{data.getElem(x + y * this.scanlineStride)};
                }
                ret = in;
            }
        }
        return ret;
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        int samples = data.getElem(offset);
        int b = 0;
        while (b < this.numBands) {
            iArray[b] = (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
            ++b;
        }
        return iArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        if (iArray == null) {
            iArray = new int[this.numBands * w * h];
        }
        int outOffset = 0;
        y = 0;
        while (y < h) {
            int lineOffset = offset;
            x = 0;
            while (x < w) {
                int samples = data.getElem(lineOffset++);
                int b = 0;
                while (b < this.numBands) {
                    iArray[outOffset++] = (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
                    ++b;
                }
                ++x;
            }
            offset += this.scanlineStride;
            ++y;
        }
        return iArray;
    }

    public int getSample(int x, int y, int b, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        int samples = data.getElem(offset);
        return (samples & this.bitMasks[b]) >>> this.bitOffsets[b];
    }

    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        int transferType = this.getTransferType();
        switch (transferType) {
            case 0: {
                byte[] in = (byte[])obj;
                data.setElem(y * this.scanlineStride + x, in[0] & 0xFF);
                break;
            }
            case 1: {
                short[] in = (short[])obj;
                data.setElem(y * this.scanlineStride + x, in[0] & 0xFFFF);
                break;
            }
            case 3: {
                int[] in = (int[])obj;
                data.setElem(y * this.scanlineStride + x, in[0]);
            }
        }
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        int samples = 0;
        int b = 0;
        while (b < this.numBands) {
            samples |= iArray[b] << this.bitOffsets[b] & this.bitMasks[b];
            ++b;
        }
        data.setElem(offset, samples);
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int inOffset = 0;
        int yy = y;
        while (yy < y + h) {
            int offset = this.scanlineStride * yy + x;
            int xx = x;
            while (xx < x + w) {
                int samples = 0;
                int b = 0;
                while (b < this.numBands) {
                    samples |= iArray[inOffset + b] << this.bitOffsets[b] & this.bitMasks[b];
                    ++b;
                }
                data.setElem(0, offset, samples);
                inOffset += this.numBands;
                ++offset;
                ++xx;
            }
            ++yy;
        }
    }

    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        int offset = this.scanlineStride * y + x;
        int samples = data.getElem(offset);
        int bitMask = this.bitMasks[b];
        samples &= ~bitMask;
        data.setElem(offset, samples |= s << this.bitOffsets[b] & bitMask);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel that = (SinglePixelPackedSampleModel)obj;
        if (this.dataType != that.dataType) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.height != that.height) {
            return false;
        }
        if (this.numBands != that.numBands) {
            return false;
        }
        if (this.scanlineStride != that.scanlineStride) {
            return false;
        }
        if (!Arrays.equals(this.bitMasks, that.bitMasks)) {
            return false;
        }
        return Arrays.equals(this.bitOffsets, that.bitOffsets);
    }

    public int hashCode() {
        int result = 193;
        result = 37 * result + this.dataType;
        result = 37 * result + this.width;
        result = 37 * result + this.height;
        result = 37 * result + this.numBands;
        result = 37 * result + this.scanlineStride;
        int i = 0;
        while (i < this.bitMasks.length) {
            result = 37 * result + this.bitMasks[i];
            ++i;
        }
        i = 0;
        while (i < this.bitOffsets.length) {
            result = 37 * result + this.bitOffsets[i];
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("[");
        result.append("scanlineStride=").append(this.scanlineStride);
        int i = 0;
        while (i < this.bitMasks.length) {
            result.append(", mask[").append(i).append("]=0x").append(Integer.toHexString(this.bitMasks[i]));
            ++i;
        }
        result.append("]");
        return result.toString();
    }
}

