/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ComponentReshapeEvent;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTException;
import java.awt.AWTKeyStroke;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.KeyboardFocusManager;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.im.InputContext;
import java.awt.im.InputMethodRequests;
import java.awt.image.BufferStrategy;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Component
implements ImageObserver,
MenuContainer,
Serializable {
    private static final long serialVersionUID = -7644114512714619750L;
    public static final float TOP_ALIGNMENT = 0.0f;
    public static final float CENTER_ALIGNMENT = 0.5f;
    public static final float BOTTOM_ALIGNMENT = 1.0f;
    public static final float RIGHT_ALIGNMENT = 1.0f;
    public static final float LEFT_ALIGNMENT = 0.0f;
    static final Object treeLock = new String("AWT_TREE_LOCK");
    private static final Dimension DEFAULT_MAX_SIZE = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    int x;
    int y;
    int width;
    int height;
    Color foreground;
    Color background;
    Font font;
    Font peerFont;
    Cursor cursor;
    Locale locale = Locale.getDefault();
    boolean ignoreRepaint;
    boolean visible = true;
    boolean enabled = true;
    boolean valid;
    DropTarget dropTarget;
    Vector popups;
    String name;
    boolean nameExplicitlySet;
    boolean focusable = true;
    int isFocusTraversableOverridden;
    Set[] focusTraversalKeys;
    boolean focusTraversalKeysEnabled = true;
    Dimension minSize;
    boolean minSizeSet;
    Dimension maxSize;
    boolean maxSizeSet;
    Dimension prefSize;
    boolean prefSizeSet;
    boolean newEventsOnly;
    long eventMask = 4096L;
    PropertyChangeSupport changeSupport;
    boolean isPacked;
    int componentSerializedDataVersion = 4;
    AccessibleContext accessibleContext;
    transient ComponentListener componentListener;
    transient FocusListener focusListener;
    transient KeyListener keyListener;
    transient MouseListener mouseListener;
    transient MouseMotionListener mouseMotionListener;
    transient MouseWheelListener mouseWheelListener;
    transient InputMethodListener inputMethodListener;
    transient HierarchyListener hierarchyListener;
    transient HierarchyBoundsListener hierarchyBoundsListener;
    transient Container parent;
    transient ComponentPeer peer;
    transient ComponentOrientation componentOrientation = ComponentOrientation.UNKNOWN;
    transient GraphicsConfiguration graphicsConfig;
    transient BufferStrategy bufferStrategy;
    int numHierarchyListeners;
    int numHierarchyBoundsListeners;
    private transient FocusEvent pendingFocusRequest = null;
    private static transient boolean incrementalDraw = Boolean.getBoolean("awt.image.incrementalDraw");
    private static transient Long redrawRate = Long.getLong("awt.image.redrawrate");

    protected Component() {
    }

    public String getName() {
        if (this.name == null && !this.nameExplicitlySet) {
            this.name = this.generateName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.nameExplicitlySet = true;
        String old = this.name;
        this.name = name;
        this.firePropertyChange("name", old, name);
    }

    public Container getParent() {
        return this.parent;
    }

    public ComponentPeer getPeer() {
        return this.peer;
    }

    public void setDropTarget(DropTarget dt) {
        this.dropTarget = dt;
        if (this.peer != null) {
            this.dropTarget.addNotify(this.peer);
        }
    }

    public DropTarget getDropTarget() {
        return this.dropTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration conf = null;
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.graphicsConfig != null) {
                conf = this.graphicsConfig;
            } else {
                Container par = this.getParent();
                if (par != null) {
                    conf = this.parent.getGraphicsConfiguration();
                }
            }
        }
        return conf;
    }

    public final Object getTreeLock() {
        return treeLock;
    }

    public Toolkit getToolkit() {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        Toolkit tk = null;
        if (p != null) {
            tk = this.peer.getToolkit();
        }
        if (tk == null) {
            tk = Toolkit.getDefaultToolkit();
        }
        return tk;
    }

    public boolean isValid() {
        return this.peer != null && this.valid;
    }

    public boolean isDisplayable() {
        return this.peer != null;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isShowing() {
        Container par = this.parent;
        return this.visible && this.peer != null && (par == null || par.isShowing());
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enable(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        if (!this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = true;
                ComponentPeer p = this.peer;
                if (p != null) {
                    p.enable();
                }
            }
        }
    }

    public void enable(boolean enabled) {
        if (enabled) {
            this.enable();
        } else {
            this.disable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        if (this.enabled) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.enabled = false;
                ComponentPeer p = this.peer;
                if (p != null) {
                    p.disable();
                }
            }
        }
    }

    public boolean isDoubleBuffered() {
        return false;
    }

    public void enableInputMethods(boolean enable) {
        this.eventMask = enable ? (this.eventMask |= 0x1000L) : (this.eventMask &= 0xFFFFFFFFFFFFEFFFL);
    }

    public void setVisible(boolean visible) {
        this.show(visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show() {
        if (!this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.visible = true;
                ComponentPeer currentPeer = this.peer;
                if (currentPeer != null) {
                    currentPeer.show();
                    this.fireHierarchyEvent(1400, this, this.parent, 4L);
                    if (this.peer instanceof LightweightPeer) {
                        this.repaint();
                    }
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    ComponentEvent ce = new ComponentEvent(this, 102);
                    this.getToolkit().getSystemEventQueue().postEvent(ce);
                }
            }
            Container currentParent = this.parent;
            if (currentParent != null) {
                currentParent.invalidate();
            }
        }
    }

    public void show(boolean visible) {
        if (visible) {
            this.show();
        } else {
            this.hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        if (this.visible) {
            Object object = this.getTreeLock();
            synchronized (object) {
                this.visible = false;
                ComponentPeer currentPeer = this.peer;
                if (currentPeer != null) {
                    currentPeer.hide();
                    this.fireHierarchyEvent(1400, this, this.parent, 4L);
                    if (this.peer instanceof LightweightPeer) {
                        this.repaint();
                    }
                }
                if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
                    ComponentEvent ce = new ComponentEvent(this, 103);
                    this.getToolkit().getSystemEventQueue().postEvent(ce);
                }
            }
            Container currentParent = this.parent;
            if (currentParent != null) {
                currentParent.invalidate();
            }
        }
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        return this.parent == null ? null : this.parent.getForeground();
    }

    public void setForeground(Color c) {
        if (this.peer != null) {
            this.peer.setForeground(c);
        }
        Color previous = this.foreground;
        this.foreground = c;
        this.firePropertyChange("foreground", previous, c);
    }

    public boolean isForegroundSet() {
        return this.foreground != null;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        return this.parent == null ? null : this.parent.getBackground();
    }

    public void setBackground(Color c) {
        if (c != null && c.equals(this.background)) {
            return;
        }
        Color previous = this.background;
        this.background = c;
        if (this.peer != null && c != null) {
            this.peer.setBackground(c);
        }
        this.firePropertyChange("background", previous, c);
    }

    public boolean isBackgroundSet() {
        return this.background != null;
    }

    @Override
    public Font getFont() {
        return this.getFontImpl();
    }

    private final Font getFontImpl() {
        Font f = this.font;
        if (f == null) {
            Container p = this.parent;
            f = p != null ? super.getFontImpl() : null;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font f) {
        Font newFont;
        Font oldFont;
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this;
            synchronized (component) {
                oldFont = this.font;
                this.font = f;
                newFont = f;
            }
            ComponentPeer p = this.peer;
            if (p != null && (f = this.getFont()) != null) {
                p.setFont(f);
                this.peerFont = f;
            }
        }
        this.firePropertyChange("font", oldFont, newFont);
        if (this.valid) {
            this.invalidate();
        }
    }

    public boolean isFontSet() {
        return this.font != null;
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.parent == null) {
            throw new IllegalComponentStateException("Component has no parent: can't determine Locale");
        }
        return this.parent.getLocale();
    }

    public void setLocale(Locale newLocale) {
        if (this.locale == newLocale) {
            return;
        }
        Locale oldLocale = this.locale;
        this.locale = newLocale;
        this.firePropertyChange("locale", oldLocale, newLocale);
        this.invalidate();
    }

    public ColorModel getColorModel() {
        GraphicsConfiguration config = this.getGraphicsConfiguration();
        return config != null ? config.getColorModel() : this.getToolkit().getColorModel();
    }

    public Point getLocation() {
        return this.location();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        if (!this.isShowing()) {
            throw new IllegalComponentStateException("component " + this.getClass().getName() + " not showing");
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int offsX = 0;
            int offsY = 0;
            ComponentPeer p = this.peer;
            Component comp = this;
            while (p instanceof LightweightPeer) {
                offsX += comp.x;
                offsY += comp.y;
                comp = comp.parent;
                ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
            }
            assert (!(p instanceof LightweightPeer));
            Point loc = p.getLocationOnScreen();
            loc.x += offsX;
            loc.y += offsY;
            return loc;
        }
    }

    public Point location() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int x, int y) {
        this.move(x, y);
    }

    public void move(int x, int y) {
        this.setBounds(x, y, this.width, this.height);
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Dimension getSize() {
        return this.size();
    }

    public Dimension size() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int width, int height) {
        this.resize(width, height);
    }

    public void resize(int width, int height) {
        this.setBounds(this.x, this.y, width, height);
    }

    public void setSize(Dimension d) {
        this.resize(d);
    }

    public void resize(Dimension d) {
        this.resize(d.width, d.height);
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int x, int y, int w, int h) {
        this.reshape(x, y, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reshape(int x, int y, int width, int height) {
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean moved;
            int oldx = this.x;
            int oldy = this.y;
            int oldwidth = this.width;
            int oldheight = this.height;
            boolean resized = oldwidth != width || oldheight != height;
            boolean bl = moved = oldx != x || oldy != y;
            if (resized || moved) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                if (this.peer != null) {
                    this.peer.setBounds(x, y, width, height);
                    if (resized) {
                        this.invalidate();
                    }
                    if (this.parent != null && this.parent.valid) {
                        this.parent.invalidate();
                    }
                }
                this.notifyReshape(resized, moved);
                if (this.parent != null && this.peer instanceof LightweightPeer && this.isShowing()) {
                    this.parent.repaint(oldx, oldy, oldwidth, oldheight);
                    this.repaint();
                }
            }
        }
    }

    void notifyReshape(boolean resized, boolean moved) {
        if (this.componentListener != null || (this.eventMask & 1L) != 0L) {
            ComponentEvent ce;
            if (moved) {
                ce = new ComponentEvent(this, 100);
                this.getToolkit().getSystemEventQueue().postEvent(ce);
            }
            if (resized) {
                ce = new ComponentEvent(this, 101);
                this.getToolkit().getSystemEventQueue().postEvent(ce);
            }
        }
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds(Rectangle r) {
        if (r == null) {
            r = new Rectangle();
        }
        r.x = this.x;
        r.y = this.y;
        r.width = this.width;
        r.height = this.height;
        return r;
    }

    public Dimension getSize(Dimension d) {
        if (d == null) {
            d = new Dimension();
        }
        d.width = this.width;
        d.height = this.height;
        return d;
    }

    public Point getLocation(Point p) {
        if (p == null) {
            p = new Point();
        }
        p.x = this.x;
        p.y = this.y;
        return p;
    }

    public boolean isOpaque() {
        return !this.isLightweight();
    }

    public boolean isLightweight() {
        return this.peer instanceof LightweightPeer;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public void setPreferredSize(Dimension size) {
        Dimension old = this.prefSizeSet ? this.prefSize : null;
        this.prefSize = size;
        this.prefSizeSet = size != null;
        this.firePropertyChange("preferredSize", old, size);
    }

    public boolean isPreferredSizeSet() {
        return this.prefSizeSet;
    }

    public Dimension preferredSize() {
        return new Dimension(this.preferredSizeImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dimension preferredSizeImpl() {
        Dimension size = this.prefSize;
        if (size == null || !this.valid && !this.prefSizeSet) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer p = this.peer;
                size = p != null ? this.peer.preferredSize() : this.minimumSizeImpl();
            }
        }
        return size;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public void setMinimumSize(Dimension size) {
        Dimension old = this.minSizeSet ? this.minSize : null;
        this.minSize = size;
        this.minSizeSet = size != null;
        this.firePropertyChange("minimumSize", old, size);
    }

    public boolean isMinimumSizeSet() {
        return this.minSizeSet;
    }

    public Dimension minimumSize() {
        return new Dimension(this.minimumSizeImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dimension minimumSizeImpl() {
        Dimension size = this.minSize;
        if (size == null || !this.valid && !this.minSizeSet) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer p = this.peer;
                size = p != null ? this.peer.minimumSize() : this.size();
            }
        }
        return size;
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.maximumSizeImpl());
    }

    Dimension maximumSizeImpl() {
        Dimension size = this.maxSizeSet ? this.maxSize : DEFAULT_MAX_SIZE;
        return size;
    }

    public void setMaximumSize(Dimension size) {
        Dimension old = this.maxSizeSet ? this.maxSize : null;
        this.maxSize = size;
        this.maxSizeSet = size != null;
        this.firePropertyChange("maximumSize", old, size);
    }

    public boolean isMaximumSizeSet() {
        return this.maxSizeSet;
    }

    public float getAlignmentX() {
        return 0.5f;
    }

    public float getAlignmentY() {
        return 0.5f;
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        if (!this.valid) {
            Object object = this.getTreeLock();
            synchronized (object) {
                ComponentPeer p = this.peer;
                if (p != null) {
                    Font oldFont;
                    Font newFont = this.getFont();
                    if (!(newFont == (oldFont = this.peerFont) || oldFont != null && oldFont.equals(newFont))) {
                        p.setFont(newFont);
                        this.peerFont = newFont;
                    }
                    p.layout();
                }
            }
            this.valid = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.valid = false;
            if (!this.minSizeSet) {
                this.minSize = null;
            }
            if (!this.prefSizeSet) {
                this.prefSize = null;
            }
            if (!this.maxSizeSet) {
                this.maxSize = null;
            }
            if (this.parent != null && this.parent.isValid()) {
                this.parent.invalidate();
            }
        }
    }

    public Graphics getGraphics() {
        ComponentPeer p = this.peer;
        Graphics g = null;
        if (p instanceof LightweightPeer) {
            if (this.parent != null && (g = this.parent.getGraphics()) != null) {
                g.translate(this.x, this.y);
                g.setClip(0, 0, this.width, this.height);
                g.setFont(this.getFont());
            }
        } else if (p != null) {
            g = p.getGraphics();
        }
        return g;
    }

    public FontMetrics getFontMetrics(Font font) {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        return p == null ? this.getToolkit().getFontMetrics(font) : p.getFontMetrics(font);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        if (p != null) {
            p.setCursor(cursor);
        }
    }

    public Cursor getCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent != null ? this.parent.getCursor() : Cursor.getDefaultCursor();
    }

    public boolean isCursorSet() {
        return this.cursor != null;
    }

    public void paint(Graphics g) {
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paintAll(Graphics g) {
        if (this.isShowing()) {
            this.validate();
            if (this.peer instanceof LightweightPeer) {
                this.paint(g);
            } else {
                this.peer.paint(g);
            }
        }
    }

    public void repaint() {
        this.repaint(0L, 0, 0, this.width, this.height);
    }

    public void repaint(long tm) {
        this.repaint(tm, 0, 0, this.width, this.height);
    }

    public void repaint(int x, int y, int w, int h) {
        this.repaint(0L, x, y, w, h);
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        ComponentPeer p = this.peer;
        if (p instanceof LightweightPeer) {
            if (this.parent != null) {
                int px = this.x + Math.max(0, x);
                int py = this.y + Math.max(0, y);
                int pw = Math.min(this.width, width);
                int ph = Math.min(this.height, height);
                this.parent.repaint(tm, px, py, pw, ph);
            }
        } else if (this.isVisible() && p != null && width > 0 && height > 0) {
            PaintEvent pe = new PaintEvent(this, 801, new Rectangle(x, y, width, height));
            this.getToolkit().getSystemEventQueue().postEvent(pe);
        }
    }

    public void print(Graphics g) {
        this.paint(g);
    }

    public void printAll(Graphics g) {
        if (this.peer != null) {
            this.peer.print(g);
        }
        this.paintAll(g);
    }

    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if ((flags & 0x30) != 0) {
            this.repaint();
        } else if ((flags & 8) != 0 && incrementalDraw) {
            if (redrawRate != null) {
                long tm = redrawRate;
                if (tm < 0L) {
                    tm = 0L;
                }
                this.repaint(tm);
            } else {
                this.repaint(100L);
            }
        }
        return (flags & 0xE0) == 0;
    }

    public Image createImage(ImageProducer producer) {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        Image im = p != null ? p.createImage(producer) : this.getToolkit().createImage(producer);
        return im;
    }

    public Image createImage(int width, int height) {
        Image returnValue = null;
        if (!GraphicsEnvironment.isHeadless()) {
            ComponentPeer p = this.peer;
            Component comp = this;
            while (p instanceof LightweightPeer) {
                comp = comp.parent;
                ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
            }
            if (p != null) {
                returnValue = p.createImage(width, height);
            }
        }
        return returnValue;
    }

    public VolatileImage createVolatileImage(int width, int height) {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        VolatileImage im = null;
        if (p != null) {
            im = p.createVolatileImage(width, height);
        }
        return im;
    }

    public VolatileImage createVolatileImage(int width, int height, ImageCapabilities caps) throws AWTException {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        VolatileImage im = null;
        if (p != null) {
            im = this.peer.createVolatileImage(width, height);
        }
        return im;
    }

    public boolean prepareImage(Image image, ImageObserver observer) {
        return this.prepareImage(image, image.getWidth(observer), image.getHeight(observer), observer);
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        boolean retval = p != null ? p.prepareImage(image, width, height, observer) : this.getToolkit().prepareImage(image, width, height, observer);
        return retval;
    }

    public int checkImage(Image image, ImageObserver observer) {
        return this.checkImage(image, -1, -1, observer);
    }

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        int retval = p != null ? p.checkImage(image, width, height, observer) : this.getToolkit().checkImage(image, width, height, observer);
        return retval;
    }

    public void setIgnoreRepaint(boolean ignoreRepaint) {
        this.ignoreRepaint = ignoreRepaint;
    }

    public boolean getIgnoreRepaint() {
        return this.ignoreRepaint;
    }

    public boolean contains(int x, int y) {
        return this.inside(x, y);
    }

    public boolean inside(int x, int y) {
        return x >= 0 && y >= 0 && x < this.width && y < this.height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public Component getComponentAt(int x, int y) {
        return this.locate(x, y);
    }

    public Component locate(int x, int y) {
        return this.contains(x, y) ? this : null;
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    public void deliverEvent(Event e) {
        this.postEvent(e);
    }

    public final void dispatchEvent(AWTEvent e) {
        this.dispatchEventImpl(e);
    }

    static boolean ignoreOldMouseEvents() {
        return false;
    }

    @Override
    public boolean postEvent(Event e) {
        boolean handled = this.handleEvent(e);
        if (!handled && this.getParent() != null) {
            handled = this.getParent().postEvent(e);
        }
        return handled;
    }

    public synchronized void addComponentListener(ComponentListener listener) {
        if (listener != null) {
            this.componentListener = AWTEventMulticaster.add(this.componentListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeComponentListener(ComponentListener listener) {
        this.componentListener = AWTEventMulticaster.remove(this.componentListener, listener);
    }

    public synchronized ComponentListener[] getComponentListeners() {
        return (ComponentListener[])AWTEventMulticaster.getListeners((EventListener)this.componentListener, ComponentListener.class);
    }

    public synchronized void addFocusListener(FocusListener listener) {
        if (listener != null) {
            this.focusListener = AWTEventMulticaster.add(this.focusListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeFocusListener(FocusListener listener) {
        this.focusListener = AWTEventMulticaster.remove(this.focusListener, listener);
    }

    public synchronized FocusListener[] getFocusListeners() {
        return (FocusListener[])AWTEventMulticaster.getListeners((EventListener)this.focusListener, FocusListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addHierarchyListener(HierarchyListener listener) {
        if (listener != null) {
            this.hierarchyListener = AWTEventMulticaster.add(this.hierarchyListener, listener);
            this.newEventsOnly = true;
            Object object = this.getTreeLock();
            synchronized (object) {
                ++this.numHierarchyListeners;
                if (this.parent != null) {
                    this.parent.updateHierarchyListenerCount(32768L, 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHierarchyListener(HierarchyListener listener) {
        this.hierarchyListener = AWTEventMulticaster.remove(this.hierarchyListener, listener);
        Object object = this.getTreeLock();
        synchronized (object) {
            --this.numHierarchyListeners;
            if (this.parent != null) {
                this.parent.updateHierarchyListenerCount(32768L, -1);
            }
        }
    }

    public synchronized HierarchyListener[] getHierarchyListeners() {
        return (HierarchyListener[])AWTEventMulticaster.getListeners((EventListener)this.hierarchyListener, HierarchyListener.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addHierarchyBoundsListener(HierarchyBoundsListener listener) {
        if (listener != null) {
            this.hierarchyBoundsListener = AWTEventMulticaster.add(this.hierarchyBoundsListener, listener);
            this.newEventsOnly = true;
            Object object = this.getTreeLock();
            synchronized (object) {
                ++this.numHierarchyBoundsListeners;
                if (this.parent != null) {
                    this.parent.updateHierarchyListenerCount(65536L, 1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHierarchyBoundsListener(HierarchyBoundsListener listener) {
        this.hierarchyBoundsListener = AWTEventMulticaster.remove(this.hierarchyBoundsListener, listener);
        Object object = this.getTreeLock();
        synchronized (object) {
            --this.numHierarchyBoundsListeners;
            if (this.parent != null) {
                this.parent.updateHierarchyListenerCount(65536L, -1);
            }
        }
    }

    public synchronized HierarchyBoundsListener[] getHierarchyBoundsListeners() {
        return (HierarchyBoundsListener[])AWTEventMulticaster.getListeners((EventListener)this.hierarchyBoundsListener, HierarchyBoundsListener.class);
    }

    void fireHierarchyEvent(int id, Component changed, Container parent, long flags) {
        boolean enabled = false;
        switch (id) {
            case 1400: {
                enabled = this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L;
                break;
            }
            case 1401: 
            case 1402: {
                enabled = this.hierarchyBoundsListener != null || (this.eventMask & 0x10000L) != 0L;
                break;
            }
            default: {
                assert (false) : "Should not reach here";
                break;
            }
        }
        if (enabled) {
            HierarchyEvent ev = new HierarchyEvent(this, id, changed, parent, flags);
            this.dispatchEvent(ev);
        }
    }

    public synchronized void addKeyListener(KeyListener listener) {
        if (listener != null) {
            this.keyListener = AWTEventMulticaster.add(this.keyListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeKeyListener(KeyListener listener) {
        this.keyListener = AWTEventMulticaster.remove(this.keyListener, listener);
    }

    public synchronized KeyListener[] getKeyListeners() {
        return (KeyListener[])AWTEventMulticaster.getListeners((EventListener)this.keyListener, KeyListener.class);
    }

    public synchronized void addMouseListener(MouseListener listener) {
        if (listener != null) {
            this.mouseListener = AWTEventMulticaster.add(this.mouseListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeMouseListener(MouseListener listener) {
        this.mouseListener = AWTEventMulticaster.remove(this.mouseListener, listener);
    }

    public synchronized MouseListener[] getMouseListeners() {
        return (MouseListener[])AWTEventMulticaster.getListeners((EventListener)this.mouseListener, MouseListener.class);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        if (listener != null) {
            this.mouseMotionListener = AWTEventMulticaster.add(this.mouseMotionListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        this.mouseMotionListener = AWTEventMulticaster.remove(this.mouseMotionListener, listener);
    }

    public synchronized MouseMotionListener[] getMouseMotionListeners() {
        return (MouseMotionListener[])AWTEventMulticaster.getListeners((EventListener)this.mouseMotionListener, MouseMotionListener.class);
    }

    public synchronized void addMouseWheelListener(MouseWheelListener listener) {
        if (listener != null) {
            this.mouseWheelListener = AWTEventMulticaster.add(this.mouseWheelListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeMouseWheelListener(MouseWheelListener listener) {
        this.mouseWheelListener = AWTEventMulticaster.remove(this.mouseWheelListener, listener);
    }

    public synchronized MouseWheelListener[] getMouseWheelListeners() {
        return (MouseWheelListener[])AWTEventMulticaster.getListeners((EventListener)this.mouseWheelListener, MouseWheelListener.class);
    }

    public synchronized void addInputMethodListener(InputMethodListener listener) {
        if (listener != null) {
            this.inputMethodListener = AWTEventMulticaster.add(this.inputMethodListener, listener);
            this.newEventsOnly = true;
        }
    }

    public synchronized void removeInputMethodListener(InputMethodListener listener) {
        this.inputMethodListener = AWTEventMulticaster.remove(this.inputMethodListener, listener);
    }

    public synchronized InputMethodListener[] getInputMethodListeners() {
        return (InputMethodListener[])AWTEventMulticaster.getListeners((EventListener)this.inputMethodListener, InputMethodListener.class);
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == ComponentListener.class) {
            return this.getComponentListeners();
        }
        if (listenerType == FocusListener.class) {
            return this.getFocusListeners();
        }
        if (listenerType == HierarchyListener.class) {
            return this.getHierarchyListeners();
        }
        if (listenerType == HierarchyBoundsListener.class) {
            return this.getHierarchyBoundsListeners();
        }
        if (listenerType == KeyListener.class) {
            return this.getKeyListeners();
        }
        if (listenerType == MouseListener.class) {
            return this.getMouseListeners();
        }
        if (listenerType == MouseMotionListener.class) {
            return this.getMouseMotionListeners();
        }
        if (listenerType == MouseWheelListener.class) {
            return this.getMouseWheelListeners();
        }
        if (listenerType == InputMethodListener.class) {
            return this.getInputMethodListeners();
        }
        if (listenerType == PropertyChangeListener.class) {
            return this.getPropertyChangeListeners();
        }
        return (EventListener[])Array.newInstance(listenerType, 0);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }

    public InputContext getInputContext() {
        return this.parent == null ? null : this.parent.getInputContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void enableEvents(long eventsToEnable) {
        Object object;
        if ((eventsToEnable & 0x8000L) != 0L && (this.eventMask & 0x8000L) == 0L) {
            object = this.getTreeLock();
            synchronized (object) {
                ++this.numHierarchyListeners;
                if (this.parent != null) {
                    this.parent.updateHierarchyListenerCount(32768L, 1);
                }
            }
        }
        if ((eventsToEnable & 0x10000L) != 0L && (this.eventMask & 0x10000L) == 0L) {
            object = this.getTreeLock();
            synchronized (object) {
                ++this.numHierarchyBoundsListeners;
                if (this.parent != null) {
                    this.parent.updateHierarchyListenerCount(65536L, 1);
                }
            }
        }
        this.eventMask |= eventsToEnable;
        this.newEventsOnly = true;
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        if (p != null) {
            p.setEventMask(this.eventMask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void disableEvents(long eventsToDisable) {
        Object object;
        if ((eventsToDisable & 0x8000L) != 0L && (this.eventMask & 0x8000L) != 0L) {
            object = this.getTreeLock();
            synchronized (object) {
                --this.numHierarchyListeners;
                if (this.parent != null) {
                    this.parent.updateHierarchyListenerCount(32768L, -1);
                }
            }
        }
        if ((eventsToDisable & 0x10000L) != 0L && (this.eventMask & 0x10000L) != 0L) {
            object = this.getTreeLock();
            synchronized (object) {
                --this.numHierarchyBoundsListeners;
                if (this.parent != null) {
                    this.parent.updateHierarchyListenerCount(65536L, -1);
                }
            }
        }
        this.eventMask &= eventsToDisable ^ 0xFFFFFFFFFFFFFFFFL;
        ComponentPeer p = this.peer;
        Component comp = this;
        while (p instanceof LightweightPeer) {
            comp = comp.parent;
            ComponentPeer componentPeer = p = comp == null ? null : comp.peer;
        }
        if (p != null) {
            p.setEventMask(this.eventMask);
        }
    }

    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        AWTEvent coalesced = null;
        switch (existingEvent.id) {
            case 503: 
            case 506: {
                MouseEvent me1 = (MouseEvent)existingEvent;
                MouseEvent me2 = (MouseEvent)newEvent;
                if (me1.getModifiers() != me2.getModifiers()) break;
                coalesced = newEvent;
                break;
            }
            case 800: 
            case 801: {
                if (this.peer == null || this.peer instanceof LightweightPeer) {
                    Rectangle r2;
                    PaintEvent pe1 = (PaintEvent)existingEvent;
                    PaintEvent pe2 = (PaintEvent)newEvent;
                    Rectangle r1 = pe1.getUpdateRect();
                    if (r1.contains(r2 = pe2.getUpdateRect())) {
                        coalesced = existingEvent;
                        break;
                    }
                    if (!r2.contains(r1)) break;
                    coalesced = newEvent;
                    break;
                }
                coalesced = newEvent;
                break;
            }
            default: {
                coalesced = null;
            }
        }
        return coalesced;
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof FocusEvent) {
            this.processFocusEvent((FocusEvent)e);
        } else if (e instanceof MouseWheelEvent) {
            this.processMouseWheelEvent((MouseWheelEvent)e);
        } else if (e instanceof MouseEvent) {
            if (e.id == 503 || e.id == 506) {
                this.processMouseMotionEvent((MouseEvent)e);
            } else {
                this.processMouseEvent((MouseEvent)e);
            }
        } else if (e instanceof KeyEvent) {
            this.processKeyEvent((KeyEvent)e);
        } else if (e instanceof InputMethodEvent) {
            this.processInputMethodEvent((InputMethodEvent)e);
        } else if (e instanceof ComponentEvent) {
            this.processComponentEvent((ComponentEvent)e);
        } else if (e instanceof HierarchyEvent) {
            if (e.id == 1400) {
                this.processHierarchyEvent((HierarchyEvent)e);
            } else {
                this.processHierarchyBoundsEvent((HierarchyEvent)e);
            }
        }
    }

    protected void processComponentEvent(ComponentEvent e) {
        if (this.componentListener == null) {
            return;
        }
        switch (e.id) {
            case 103: {
                this.componentListener.componentHidden(e);
                break;
            }
            case 100: {
                this.componentListener.componentMoved(e);
                break;
            }
            case 101: {
                this.componentListener.componentResized(e);
                break;
            }
            case 102: {
                this.componentListener.componentShown(e);
            }
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        if (this.focusListener == null) {
            return;
        }
        switch (e.id) {
            case 1004: {
                this.focusListener.focusGained(e);
                break;
            }
            case 1005: {
                this.focusListener.focusLost(e);
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (this.keyListener == null) {
            return;
        }
        switch (e.id) {
            case 401: {
                this.keyListener.keyPressed(e);
                break;
            }
            case 402: {
                this.keyListener.keyReleased(e);
                break;
            }
            case 400: {
                this.keyListener.keyTyped(e);
            }
        }
    }

    protected void processMouseEvent(MouseEvent e) {
        if (this.mouseListener == null) {
            return;
        }
        switch (e.id) {
            case 500: {
                this.mouseListener.mouseClicked(e);
                break;
            }
            case 504: {
                if (this.isLightweight()) {
                    this.setCursor(this.getCursor());
                }
                this.mouseListener.mouseEntered(e);
                break;
            }
            case 505: {
                this.mouseListener.mouseExited(e);
                break;
            }
            case 501: {
                this.mouseListener.mousePressed(e);
                break;
            }
            case 502: {
                this.mouseListener.mouseReleased(e);
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent e) {
        if (this.mouseMotionListener == null) {
            return;
        }
        switch (e.id) {
            case 506: {
                this.mouseMotionListener.mouseDragged(e);
                break;
            }
            case 503: {
                this.mouseMotionListener.mouseMoved(e);
            }
        }
        e.consume();
    }

    protected void processMouseWheelEvent(MouseWheelEvent e) {
        if (this.mouseWheelListener != null && e.id == 507) {
            this.mouseWheelListener.mouseWheelMoved(e);
            e.consume();
        }
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        if (this.inputMethodListener == null) {
            return;
        }
        switch (e.id) {
            case 1101: {
                this.inputMethodListener.caretPositionChanged(e);
                break;
            }
            case 1100: {
                this.inputMethodListener.inputMethodTextChanged(e);
            }
        }
    }

    protected void processHierarchyEvent(HierarchyEvent e) {
        if (this.hierarchyListener == null) {
            return;
        }
        if (e.id == 1400) {
            this.hierarchyListener.hierarchyChanged(e);
        }
    }

    protected void processHierarchyBoundsEvent(HierarchyEvent e) {
        if (this.hierarchyBoundsListener == null) {
            return;
        }
        switch (e.id) {
            case 1401: {
                this.hierarchyBoundsListener.ancestorMoved(e);
                break;
            }
            case 1402: {
                this.hierarchyBoundsListener.ancestorResized(e);
            }
        }
    }

    public boolean handleEvent(Event evt) {
        switch (evt.id) {
            case 401: 
            case 403: {
                return this.keyDown(evt, evt.key);
            }
            case 402: 
            case 404: {
                return this.keyUp(evt, evt.key);
            }
            case 501: {
                return this.mouseDown(evt, evt.x, evt.y);
            }
            case 502: {
                return this.mouseUp(evt, evt.x, evt.y);
            }
            case 503: {
                return this.mouseMove(evt, evt.x, evt.y);
            }
            case 506: {
                return this.mouseDrag(evt, evt.x, evt.y);
            }
            case 504: {
                return this.mouseEnter(evt, evt.x, evt.y);
            }
            case 505: {
                return this.mouseExit(evt, evt.x, evt.y);
            }
            case 1004: {
                return this.gotFocus(evt, evt.arg);
            }
            case 1005: {
                return this.lostFocus(evt, evt.arg);
            }
            case 1001: {
                return this.action(evt, evt.arg);
            }
        }
        return false;
    }

    public boolean mouseDown(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseUp(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseMove(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseEnter(Event evt, int x, int y) {
        return false;
    }

    public boolean mouseExit(Event evt, int x, int y) {
        return false;
    }

    public boolean keyDown(Event evt, int key) {
        return false;
    }

    public boolean keyUp(Event evt, int key) {
        return false;
    }

    public boolean action(Event evt, Object what) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createComponent(this);
            } else if (this.parent != null && this.parent.isLightweight()) {
                new HeavyweightInLightweightListener(this.parent);
            }
            this.peer.setEventMask(this.eventMask);
            this.invalidate();
            if (this.dropTarget != null) {
                this.dropTarget.addNotify(this.peer);
            }
            this.peerFont = this.getFont();
            long flags = 2L;
            if (this.isHierarchyVisible()) {
                flags |= 4L;
            }
            this.fireHierarchyEvent(1400, this, this.parent, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            ComponentPeer tmp = this.peer;
            this.peer = null;
            this.peerFont = null;
            if (tmp != null) {
                tmp.hide();
                tmp.dispose();
            }
            long flags = 2L;
            if (this.isHierarchyVisible()) {
                flags |= 4L;
            }
            this.fireHierarchyEvent(1400, this, this.parent, flags);
        }
    }

    public boolean gotFocus(Event evt, Object what) {
        return false;
    }

    public boolean lostFocus(Event evt, Object what) {
        return false;
    }

    public boolean isFocusTraversable() {
        return this.enabled && this.visible && (this.peer == null || this.isLightweight() || this.peer.isFocusTraversable());
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.firePropertyChange("focusable", this.focusable, focusable);
        this.focusable = focusable;
        this.isFocusTraversableOverridden = 1;
    }

    public void setFocusTraversalKeys(int id, Set<? extends AWTKeyStroke> keystrokes) {
        String name;
        Set<AWTKeyStroke> sb;
        Set<AWTKeyStroke> sa;
        if (keystrokes == null) {
            Container parent = this.getParent();
            while (parent != null) {
                if (parent.areFocusTraversalKeysSet(id)) {
                    keystrokes = parent.getFocusTraversalKeys(id);
                    break;
                }
                parent = parent.getParent();
            }
            if (keystrokes == null) {
                keystrokes = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
            }
        }
        switch (id) {
            case 0: {
                sa = this.getFocusTraversalKeys(1);
                sb = this.getFocusTraversalKeys(2);
                name = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(2);
                name = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                name = "upCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator<? extends AWTKeyStroke> iter = keystrokes.iterator();
        while (--i >= 0) {
            AWTKeyStroke o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && o.keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[3];
        }
        keystrokes = Collections.unmodifiableSet(new HashSet<AWTKeyStroke>(keystrokes));
        this.firePropertyChange(name, this.focusTraversalKeys[id], keystrokes);
        this.focusTraversalKeys[id] = keystrokes;
    }

    public Set<AWTKeyStroke> getFocusTraversalKeys(int id) {
        if (id != 0 && id != 1 && id != 2) {
            throw new IllegalArgumentException();
        }
        Set<AWTKeyStroke> s = null;
        if (this.focusTraversalKeys != null) {
            s = this.focusTraversalKeys[id];
        }
        if (s == null && this.parent != null) {
            s = this.parent.getFocusTraversalKeys(id);
        }
        return s == null ? KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id) : s;
    }

    public boolean areFocusTraversalKeysSet(int id) {
        if (id != 0 && id != 1 && id != 2) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[id] != null;
    }

    public void setFocusTraversalKeysEnabled(boolean focusTraversalKeysEnabled) {
        this.firePropertyChange("focusTraversalKeysEnabled", this.focusTraversalKeysEnabled, focusTraversalKeysEnabled);
        this.focusTraversalKeysEnabled = focusTraversalKeysEnabled;
    }

    public boolean getFocusTraversalKeysEnabled() {
        return this.focusTraversalKeysEnabled;
    }

    public void requestFocus() {
        this.requestFocusImpl(false, true);
    }

    protected boolean requestFocus(boolean temporary) {
        return this.requestFocusImpl(temporary, true);
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusImpl(false, false);
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        return this.requestFocusImpl(temporary, false);
    }

    private boolean requestFocusImpl(boolean temporary, boolean focusWindow) {
        boolean retval = false;
        if (this.isFocusable() && this.isVisible()) {
            ComponentPeer myPeer = this.peer;
            if (this.peer != null) {
                boolean showing = true;
                Component window = this;
                while (!(window instanceof Window)) {
                    if (!window.isVisible()) {
                        showing = false;
                    }
                    window = window.parent;
                }
                if (window != null && ((Window)window).isFocusableWindow() && showing) {
                    Component heavyweightParent = this;
                    while (heavyweightParent.peer instanceof LightweightPeer) {
                        heavyweightParent = heavyweightParent.parent;
                    }
                    if (heavyweightParent != null && heavyweightParent.isVisible() && (myPeer = heavyweightParent.peer) != null) {
                        long time;
                        boolean success;
                        if (heavyweightParent != this) {
                            KeyboardFocusManager.addLightweightFocusRequest(heavyweightParent, this);
                        }
                        if (!(success = myPeer.requestFocus(this, temporary, focusWindow, time = EventQueue.getMostRecentEventTime()))) {
                            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                            kfm.dequeueKeyEvents(time, this);
                        }
                        retval = success;
                    }
                }
            }
        }
        return retval;
    }

    public void transferFocus() {
        this.nextFocus();
    }

    public Container getFocusCycleRootAncestor() {
        Container parent = this.getParent();
        while (parent != null && !parent.isFocusCycleRoot()) {
            parent = parent.getParent();
        }
        return parent;
    }

    public boolean isFocusCycleRoot(Container c) {
        return c == this.getFocusCycleRootAncestor();
    }

    public void nextFocus() {
        Container focusRoot = this.getFocusCycleRootAncestor();
        Component focusComp = this;
        while (!(focusRoot == null || focusRoot.isShowing() && focusRoot.isFocusable() && focusRoot.isEnabled())) {
            focusComp = focusRoot;
            focusRoot = focusComp.getFocusCycleRootAncestor();
        }
        if (focusRoot != null) {
            FocusTraversalPolicy policy = focusRoot.getFocusTraversalPolicy();
            Component nextFocus = policy.getComponentAfter(focusRoot, focusComp);
            if (nextFocus == null) {
                nextFocus = policy.getDefaultComponent(focusRoot);
            }
            if (nextFocus != null) {
                nextFocus.requestFocus();
            }
        }
    }

    public void transferFocusBackward() {
        Container focusRoot = this.getFocusCycleRootAncestor();
        Component focusComp = this;
        while (!(focusRoot == null || focusRoot.isShowing() && focusRoot.isFocusable() && focusRoot.isEnabled())) {
            focusComp = focusRoot;
            focusRoot = focusComp.getFocusCycleRootAncestor();
        }
        if (focusRoot != null) {
            FocusTraversalPolicy policy = focusRoot.getFocusTraversalPolicy();
            Component nextFocus = policy.getComponentBefore(focusRoot, focusComp);
            if (nextFocus == null) {
                nextFocus = policy.getDefaultComponent(focusRoot);
            }
            if (nextFocus != null) {
                nextFocus.requestFocus();
            }
        }
    }

    public void transferFocusUpCycle() {
        Container focusCycleRoot = this.getFocusCycleRootAncestor();
        while (!(focusCycleRoot == null || focusCycleRoot.isShowing() && focusCycleRoot.isFocusable() && focusCycleRoot.isEnabled())) {
            focusCycleRoot = focusCycleRoot.getFocusCycleRootAncestor();
        }
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (focusCycleRoot != null) {
            Container focusCycleAncestor = focusCycleRoot.getFocusCycleRootAncestor();
            Container globalFocusCycleRoot = focusCycleAncestor == null ? focusCycleRoot : focusCycleAncestor;
            fm.setGlobalCurrentFocusCycleRoot(globalFocusCycleRoot);
            focusCycleRoot.requestFocus();
        } else {
            FocusTraversalPolicy policy;
            Component focusComp;
            Container cont = this instanceof Container ? (Container)this : this.getParent();
            while (cont != null && !(cont instanceof Window)) {
                cont = cont.getParent();
            }
            if (cont != null && (focusComp = (policy = cont.getFocusTraversalPolicy()).getDefaultComponent(cont)) != null) {
                fm.setGlobalCurrentFocusCycleRoot(cont);
                focusComp.requestFocus();
            }
        }
    }

    public boolean hasFocus() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = manager.getFocusOwner();
        return this == focusOwner;
    }

    public boolean isFocusOwner() {
        return this.hasFocus();
    }

    public synchronized void add(PopupMenu popup) {
        if (this.popups == null) {
            this.popups = new Vector();
        }
        this.popups.add(popup);
        if (popup.parent != null) {
            popup.parent.remove(popup);
        }
        popup.parent = this;
        if (this.peer != null) {
            popup.addNotify();
        }
    }

    @Override
    public synchronized void remove(MenuComponent popup) {
        if (this.popups != null) {
            this.popups.remove(popup);
        }
    }

    protected String paramString() {
        StringBuffer param = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            param.append(name).append(",");
        }
        param.append(this.x).append(",").append(this.y).append(",").append(this.width).append("x").append(this.height);
        if (!this.isValid()) {
            param.append(",invalid");
        }
        if (!this.isVisible()) {
            param.append(",invisible");
        }
        if (!this.isEnabled()) {
            param.append(",disabled");
        }
        if (!this.isOpaque()) {
            param.append(",translucent");
        }
        if (this.isDoubleBuffered()) {
            param.append(",doublebuffered");
        }
        if (this.parent == null) {
            param.append(",parent=null");
        } else {
            param.append(",parent=").append(this.parent.getName());
        }
        return param.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + '[' + this.paramString() + ']';
    }

    public void list() {
        this.list(System.out, 0);
    }

    public void list(PrintStream out) {
        this.list(out, 0);
    }

    public void list(PrintStream out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(' ');
            ++i;
        }
        out.println(this.toString());
    }

    public void list(PrintWriter out) {
        this.list(out, 0);
    }

    public void list(PrintWriter out, int indent) {
        int i = 0;
        while (i < indent) {
            out.print(' ');
            ++i;
        }
        out.println(this.toString());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        return this.changeSupport == null ? new PropertyChangeListener[]{} : this.changeSupport.getPropertyChangeListeners(property);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Byte(oldValue), new Byte(newValue));
        }
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
        }
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Short(oldValue), new Short(newValue));
        }
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
        }
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
        }
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
        }
    }

    public void setComponentOrientation(ComponentOrientation o) {
        ComponentOrientation oldOrientation = this.componentOrientation;
        this.componentOrientation = o;
        this.firePropertyChange("componentOrientation", oldOrientation, o);
    }

    public ComponentOrientation getComponentOrientation() {
        return this.componentOrientation;
    }

    public void applyComponentOrientation(ComponentOrientation o) {
        this.setComponentOrientation(o);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    String generateName() {
        return null;
    }

    final void setPeer(ComponentPeer peer) {
        this.peer = peer;
    }

    static Event translateEvent(AWTEvent e) {
        Object target = e.getSource();
        Event translated = null;
        if (e instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)e;
            int id = we.id;
            int newId = 0;
            switch (id) {
                case 204: {
                    newId = 204;
                    break;
                }
                case 201: 
                case 202: {
                    newId = 201;
                    break;
                }
                case 203: {
                    newId = 203;
                    break;
                }
                case 207: {
                    newId = 1004;
                    break;
                }
                case 208: {
                    newId = 1005;
                    break;
                }
                default: {
                    return null;
                }
            }
            translated = new Event(target, 0L, newId, 0, 0, 0, 0);
        } else if (e instanceof InputEvent) {
            InputEvent ie = (InputEvent)e;
            long when = ie.getWhen();
            int oldID = 0;
            int id = e.getID();
            int oldMods = 0;
            int mods = ie.getModifiersEx();
            if ((mods & 0x800) != 0) {
                oldMods |= 4;
            } else if ((mods & 0x1000) != 0) {
                oldMods |= 8;
            }
            if ((mods & 0x40) != 0) {
                oldMods |= 1;
            }
            if ((mods & 0x80) != 0) {
                oldMods |= 2;
            }
            if ((mods & 0x100) != 0) {
                oldMods |= 4;
            }
            if ((mods & 0x200) != 0) {
                oldMods |= 8;
            }
            if (e instanceof MouseEvent && !Component.ignoreOldMouseEvents()) {
                if (id == 501) {
                    oldID = 501;
                } else if (id == 502) {
                    oldID = 502;
                } else if (id == 503) {
                    oldID = 503;
                } else if (id == 506) {
                    oldID = 506;
                } else if (id == 504) {
                    oldID = 504;
                } else if (id == 505) {
                    oldID = 505;
                } else {
                    return null;
                }
                MouseEvent me = (MouseEvent)e;
                translated = new Event(target, when, oldID, me.getX(), me.getY(), 0, oldMods);
            } else if (e instanceof KeyEvent) {
                if (id == 401) {
                    oldID = 401;
                } else if (e.getID() == 402) {
                    oldID = 402;
                } else {
                    return null;
                }
                int oldKey = 0;
                int newKey = ((KeyEvent)e).getKeyCode();
                switch (newKey) {
                    case 8: {
                        oldKey = 8;
                        break;
                    }
                    case 20: {
                        oldKey = 1022;
                        break;
                    }
                    case 127: {
                        oldKey = 127;
                        break;
                    }
                    case 40: 
                    case 225: {
                        oldKey = 1005;
                        break;
                    }
                    case 35: {
                        oldKey = 1001;
                        break;
                    }
                    case 10: {
                        oldKey = 10;
                        break;
                    }
                    case 27: {
                        oldKey = 27;
                        break;
                    }
                    case 112: {
                        oldKey = 1008;
                        break;
                    }
                    case 121: {
                        oldKey = 1017;
                        break;
                    }
                    case 122: {
                        oldKey = 1018;
                        break;
                    }
                    case 123: {
                        oldKey = 1019;
                        break;
                    }
                    case 113: {
                        oldKey = 1009;
                        break;
                    }
                    case 114: {
                        oldKey = 1010;
                        break;
                    }
                    case 115: {
                        oldKey = 1011;
                        break;
                    }
                    case 116: {
                        oldKey = 1012;
                        break;
                    }
                    case 117: {
                        oldKey = 1013;
                        break;
                    }
                    case 118: {
                        oldKey = 1014;
                        break;
                    }
                    case 119: {
                        oldKey = 1015;
                        break;
                    }
                    case 120: {
                        oldKey = 1016;
                        break;
                    }
                    case 36: {
                        oldKey = 1000;
                        break;
                    }
                    case 155: {
                        oldKey = 1025;
                        break;
                    }
                    case 37: 
                    case 226: {
                        oldKey = 1006;
                        break;
                    }
                    case 144: {
                        oldKey = 1023;
                        break;
                    }
                    case 19: {
                        oldKey = 1024;
                        break;
                    }
                    case 34: {
                        oldKey = 1003;
                        break;
                    }
                    case 33: {
                        oldKey = 1002;
                        break;
                    }
                    case 154: {
                        oldKey = 1020;
                        break;
                    }
                    case 39: 
                    case 227: {
                        oldKey = 1007;
                        break;
                    }
                    case 145: {
                        oldKey = 1021;
                        break;
                    }
                    case 9: {
                        oldKey = 9;
                        break;
                    }
                    case 38: 
                    case 224: {
                        oldKey = 1004;
                        break;
                    }
                    default: {
                        oldKey = ((KeyEvent)e).getKeyChar();
                    }
                }
                translated = new Event(target, when, oldID, 0, 0, oldKey, oldMods);
            }
        } else if (e instanceof AdjustmentEvent) {
            AdjustmentEvent ae = (AdjustmentEvent)e;
            int type = ae.getAdjustmentType();
            int oldType = type == 3 ? 603 : (type == 4 ? 604 : (type == 5 ? 605 : (type == 2 ? 601 : (type == 1 ? 602 : type))));
            translated = new Event(target, oldType, new Integer(ae.getValue()));
        } else if (e instanceof ActionEvent) {
            translated = new Event(target, 1001, ((ActionEvent)e).getActionCommand());
        }
        return translated;
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e instanceof ComponentReshapeEvent) {
            ComponentReshapeEvent reshape = (ComponentReshapeEvent)e;
            this.x = reshape.x;
            this.y = reshape.y;
            this.width = reshape.width;
            this.height = reshape.height;
            return;
        }
        boolean dispatched = false;
        if (!e.isFocusManagerEvent) {
            e = KeyboardFocusManager.retargetFocusEvent(e);
            dispatched = KeyboardFocusManager.getCurrentKeyboardFocusManager().dispatchEvent(e);
        }
        if (!dispatched) {
            Toolkit.getDefaultToolkit().globalDispatchEvent(e);
            if (this.newEventsOnly) {
                if (this.eventTypeEnabled(e.id)) {
                    this.processEvent(e);
                }
            } else {
                Event oldEvent = Component.translateEvent(e);
                if (oldEvent != null) {
                    this.postEvent(oldEvent);
                }
            }
            if (this.peer != null) {
                this.peer.handleEvent(e);
            }
        }
    }

    boolean eventTypeEnabled(int type) {
        if (type > 1999) {
            return true;
        }
        switch (type) {
            case 1400: {
                return this.hierarchyListener != null || (this.eventMask & 0x8000L) != 0L;
            }
            case 1401: 
            case 1402: {
                return this.hierarchyBoundsListener != null || (this.eventMask & 0x10000L) != 0L;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return this.componentListener != null || (this.eventMask & 1L) != 0L;
            }
            case 400: 
            case 401: 
            case 402: {
                return this.keyListener != null || (this.eventMask & 8L) != 0L;
            }
            case 500: 
            case 501: 
            case 502: 
            case 504: 
            case 505: {
                return this.mouseListener != null || (this.eventMask & 0x10L) != 0L;
            }
            case 503: 
            case 506: {
                return this.mouseMotionListener != null || (this.eventMask & 0x20L) != 0L;
            }
            case 507: {
                return this.mouseWheelListener != null || (this.eventMask & 0x20000L) != 0L;
            }
            case 1004: 
            case 1005: {
                return this.focusListener != null || (this.eventMask & 4L) != 0L;
            }
            case 1100: 
            case 1101: {
                return this.inputMethodListener != null || (this.eventMask & 0x800L) != 0L;
            }
            case 800: 
            case 801: {
                return (this.eventMask & 0x2000L) != 0L;
            }
        }
        return false;
    }

    boolean isHierarchyVisible() {
        boolean visible = this.isVisible();
        Container comp = this.parent;
        while (comp != null && visible) {
            comp = comp.parent;
            if (comp == null) continue;
            boolean bl = visible = visible && comp.isVisible();
        }
        return visible;
    }

    public Point getMousePosition() throws HeadlessException {
        return this.getMousePositionHelper(true);
    }

    Point getMousePositionHelper(boolean allowChildren) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("can't get mouse position in headless environment");
        }
        if (!this.isShowing()) {
            return null;
        }
        Component parent = this;
        int windowRelativeXOffset = 0;
        int windowRelativeYOffset = 0;
        while (parent != null && !(parent instanceof Window)) {
            windowRelativeXOffset += parent.getX();
            windowRelativeYOffset += parent.getY();
            parent = parent.getParent();
        }
        if (parent == null) {
            return null;
        }
        Window window = (Window)parent;
        if (!Toolkit.getDefaultToolkit().getMouseInfoPeer().isWindowUnderMouse(window)) {
            return null;
        }
        PointerInfo info = MouseInfo.getPointerInfo();
        Point mouseLocation = info.getLocation();
        Point windowLocation = window.getLocationOnScreen();
        int x = mouseLocation.x - windowLocation.x;
        int y = mouseLocation.y - windowLocation.y;
        if (!this.mouseOverComponent(window.getComponentAt(x, y), allowChildren)) {
            return null;
        }
        return new Point(x - windowRelativeXOffset, y - windowRelativeYOffset);
    }

    boolean mouseOverComponent(Component component, boolean allowChildren) {
        return component == this;
    }

    Component findNextFocusComponent(Component child) {
        return null;
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        String key = (String)s.readObject();
        while (key != null) {
            Object listener = s.readObject();
            if ("componentL".equals(key)) {
                this.addComponentListener((ComponentListener)listener);
            } else if ("focusL".equals(key)) {
                this.addFocusListener((FocusListener)listener);
            } else if ("keyL".equals(key)) {
                this.addKeyListener((KeyListener)listener);
            } else if ("mouseL".equals(key)) {
                this.addMouseListener((MouseListener)listener);
            } else if ("mouseMotionL".equals(key)) {
                this.addMouseMotionListener((MouseMotionListener)listener);
            } else if ("inputMethodL".equals(key)) {
                this.addInputMethodListener((InputMethodListener)listener);
            } else if ("hierarchyL".equals(key)) {
                this.addHierarchyListener((HierarchyListener)listener);
            } else if ("hierarchyBoundsL".equals(key)) {
                this.addHierarchyBoundsListener((HierarchyBoundsListener)listener);
            } else if ("mouseWheelL".equals(key)) {
                this.addMouseWheelListener((MouseWheelListener)listener);
            }
            key = (String)s.readObject();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "componentL", this.componentListener);
        AWTEventMulticaster.save(s, "focusL", this.focusListener);
        AWTEventMulticaster.save(s, "keyL", this.keyListener);
        AWTEventMulticaster.save(s, "mouseL", this.mouseListener);
        AWTEventMulticaster.save(s, "mouseMotionL", this.mouseMotionListener);
        AWTEventMulticaster.save(s, "inputMethodL", this.inputMethodListener);
        AWTEventMulticaster.save(s, "hierarchyL", this.hierarchyListener);
        AWTEventMulticaster.save(s, "hierarchyBoundsL", this.hierarchyBoundsListener);
        AWTEventMulticaster.save(s, "mouseWheelL", this.mouseWheelListener);
        s.writeObject(null);
    }

    protected abstract class AccessibleAWTComponent
    extends AccessibleContext
    implements Serializable,
    AccessibleComponent {
        private static final long serialVersionUID = 642321655757800191L;
        protected ComponentListener accessibleAWTComponentHandler = new AccessibleAWTComponentHandler();
        protected FocusListener accessibleAWTFocusHandler = new AccessibleAWTFocusHandler();

        protected AccessibleAWTComponent() {
            Component.this.addComponentListener(this.accessibleAWTComponentHandler);
            Component.this.addFocusListener(this.accessibleAWTFocusHandler);
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            Component.this.addPropertyChangeListener(l);
            super.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            Component.this.removePropertyChangeListener(l);
            super.removePropertyChangeListener(l);
        }

        public String getAccessibleName() {
            return this.accessibleName;
        }

        public String getAccessibleDescription() {
            return this.accessibleDescription;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.AWT_COMPONENT;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet s = new AccessibleStateSet();
            if (Component.this.isEnabled()) {
                s.add(AccessibleState.ENABLED);
            }
            if (Component.this.isFocusable()) {
                s.add(AccessibleState.FOCUSABLE);
            }
            if (Component.this.isFocusOwner()) {
                s.add(AccessibleState.FOCUSED);
            }
            if (Component.this.isShowing()) {
                s.add(AccessibleState.SHOWING);
            }
            if (Component.this.isVisible()) {
                s.add(AccessibleState.VISIBLE);
            }
            return s;
        }

        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null) {
                Container parent = Component.this.getParent();
                this.accessibleParent = parent instanceof Accessible ? (Accessible)((Object)parent) : null;
            }
            return this.accessibleParent;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() == null) {
                return -1;
            }
            AccessibleContext context = ((Component)((Object)this.accessibleParent)).getAccessibleContext();
            if (context == null) {
                return -1;
            }
            int i = context.getAccessibleChildrenCount();
            while (--i >= 0) {
                if (context.getAccessibleChild(i) != Component.this) continue;
                return i;
            }
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() {
            return Component.this.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return Component.this.getBackground();
        }

        public void setBackground(Color c) {
            Component.this.setBackground(c);
        }

        public Color getForeground() {
            return Component.this.getForeground();
        }

        public void setForeground(Color c) {
            Component.this.setForeground(c);
        }

        public Cursor getCursor() {
            return Component.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            Component.this.setCursor(cursor);
        }

        public Font getFont() {
            return Component.this.getFont();
        }

        public void setFont(Font f) {
            Component.this.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return Component.this.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean b) {
            Component.this.setEnabled(b);
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean b) {
            Component.this.setVisible(b);
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(Point p) {
            return Component.this.contains(p.x, p.y);
        }

        public Point getLocationOnScreen() {
            return Component.this.isShowing() ? Component.this.getLocationOnScreen() : null;
        }

        public Point getLocation() {
            return Component.this.getLocation();
        }

        public void setLocation(Point p) {
            Component.this.setLocation(p.x, p.y);
        }

        public Rectangle getBounds() {
            return Component.this.getBounds();
        }

        public void setBounds(Rectangle r) {
            Component.this.setBounds(r.x, r.y, r.width, r.height);
        }

        public Dimension getSize() {
            return Component.this.getSize();
        }

        public void setSize(Dimension d) {
            Component.this.setSize(d.width, d.height);
        }

        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusTraversable();
        }

        public void requestFocus() {
            Component.this.requestFocus();
        }

        public void addFocusListener(FocusListener l) {
            Component.this.addFocusListener(l);
        }

        public void removeFocusListener(FocusListener l) {
            Component.this.removeFocusListener(l);
        }

        protected class AccessibleAWTComponentHandler
        implements ComponentListener {
            protected AccessibleAWTComponentHandler() {
            }

            public void componentHidden(ComponentEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }

        protected class AccessibleAWTFocusHandler
        implements FocusListener {
            protected AccessibleAWTFocusHandler() {
            }

            public void focusGained(FocusEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            public void focusLost(FocusEvent e) {
                AccessibleAWTComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }
    }

    protected class BltBufferStrategy
    extends BufferStrategy {
        protected BufferCapabilities caps;
        protected VolatileImage[] backBuffers;
        protected boolean validatedContents;
        protected int width;
        protected int height;
        private VolatileImage frontBuffer;

        protected BltBufferStrategy(int numBuffers, BufferCapabilities caps) {
            this.caps = caps;
            this.createBackBuffers(numBuffers - 1);
            this.width = Component.this.getWidth();
            this.height = Component.this.getHeight();
        }

        protected void createBackBuffers(int numBuffers) {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            this.backBuffers = new VolatileImage[numBuffers];
            int i = 0;
            while (i < numBuffers) {
                this.backBuffers[i] = c.createCompatibleVolatileImage(this.width, this.height);
                ++i;
            }
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.backBuffers[0].getGraphics();
        }

        public void show() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Component.this.getGraphics().drawImage(this.backBuffers[this.backBuffers.length - 1], this.width, this.height, null);
            BufferCapabilities.FlipContents f = this.getCapabilities().getFlipContents();
            int i = this.backBuffers.length - 1;
            while (i > 0) {
                this.backBuffers[i] = this.backBuffers[i - 1];
                --i;
            }
            if (f == BufferCapabilities.FlipContents.UNDEFINED) {
                this.backBuffers[0] = c.createCompatibleVolatileImage(this.width, this.height);
            }
            if (f == BufferCapabilities.FlipContents.BACKGROUND) {
                this.backBuffers[0] = c.createCompatibleVolatileImage(this.width, this.height);
                this.backBuffers[0].getGraphics().clearRect(0, 0, this.width, this.height);
            }
            if (f == BufferCapabilities.FlipContents.COPIED) {
                this.backBuffers[0] = this.backBuffers[this.backBuffers.length - 1];
            }
        }

        protected void revalidate() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int i = 0;
            while (i < this.backBuffers.length) {
                int result = this.backBuffers[i].validate(c);
                if (result == 2) {
                    this.backBuffers[i] = c.createCompatibleVolatileImage(this.width, this.height);
                }
                ++i;
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            int i = 0;
            while (i < this.backBuffers.length) {
                if (this.backBuffers[i].contentsLost()) {
                    this.validatedContents = false;
                    return true;
                }
                ++i;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            boolean imageRestored = false;
            int i = 0;
            while (i < this.backBuffers.length) {
                int result = this.backBuffers[i].validate(c);
                if (result == 1) {
                    imageRestored = true;
                } else if (result == 2) {
                    return false;
                }
                ++i;
            }
            this.validatedContents = true;
            return imageRestored;
        }
    }

    protected class FlipBufferStrategy
    extends BufferStrategy {
        protected int numBuffers;
        protected BufferCapabilities caps;
        protected Image drawBuffer;
        protected VolatileImage drawVBuffer;
        protected boolean validatedContents;
        private int width;
        private int height;

        protected FlipBufferStrategy(int numBuffers, BufferCapabilities caps) throws AWTException {
            this.caps = caps;
            this.width = Component.this.getWidth();
            this.height = Component.this.getHeight();
            if (numBuffers > 1) {
                this.createBuffers(numBuffers, caps);
            } else {
                this.drawVBuffer = Component.this.peer.createVolatileImage(this.width, this.height);
                this.drawBuffer = this.drawVBuffer;
            }
        }

        protected void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
            if (numBuffers <= 1) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: numBuffers must be greater than one.");
            }
            if (!caps.isPageFlipping()) {
                throw new IllegalArgumentException("FlipBufferStrategy.createBuffers: flipping must be a specified capability.");
            }
            Component.this.peer.createBuffers(numBuffers, caps);
        }

        protected Image getBackBuffer() {
            return Component.this.peer.getBackBuffer();
        }

        protected void flip(BufferCapabilities.FlipContents flipAction) {
            Component.this.peer.flip(flipAction);
        }

        protected void destroyBuffers() {
            Component.this.peer.destroyBuffers();
        }

        public BufferCapabilities getCapabilities() {
            return this.caps;
        }

        public Graphics getDrawGraphics() {
            return this.drawVBuffer.getGraphics();
        }

        protected void revalidate() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            if (this.drawVBuffer.validate(c) == 2) {
                this.drawVBuffer = Component.this.peer.createVolatileImage(this.width, this.height);
            }
            this.validatedContents = true;
        }

        public boolean contentsLost() {
            if (this.drawVBuffer.contentsLost()) {
                this.validatedContents = false;
                return true;
            }
            this.validatedContents = true;
            return false;
        }

        public boolean contentsRestored() {
            GraphicsConfiguration c = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            int result = this.drawVBuffer.validate(c);
            boolean imageRestored = false;
            if (result == 1) {
                imageRestored = true;
            } else if (result == 2) {
                return false;
            }
            this.validatedContents = true;
            return imageRestored;
        }

        public void show() {
            this.flip(this.caps.getFlipContents());
        }
    }

    class HeavyweightInLightweightListener
    implements ComponentListener {
        public HeavyweightInLightweightListener(Container parent) {
            parent.addComponentListener(this);
        }

        public void componentResized(ComponentEvent event) {
        }

        public void componentMoved(ComponentEvent event) {
            if (Component.this.peer != null) {
                Component.this.peer.setBounds(Component.this.x, Component.this.y, Component.this.width, Component.this.height);
            }
        }

        public void componentShown(ComponentEvent event) {
            if (Component.this.isShowing()) {
                Component.this.peer.show();
            }
        }

        public void componentHidden(ComponentEvent event) {
            if (Component.this.isShowing()) {
                Component.this.peer.hide();
            }
        }
    }
}

