/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class UnsignedShortType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{11, 12, 4, 6, 5, 7, 8, 10, 9};
    static final String MAX_VALUE = "65535";
    static final int LENGTH = "65535".length();

    UnsignedShortType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort"), TypeLibrary.UNSIGNED_INT);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        if (len == 0) {
            throw new DatatypeException(0, "invalid unsigned short value");
        }
        boolean compare = false;
        int i = 0;
        while (i < len) {
            char c;
            if (len - i > LENGTH) {
                throw new DatatypeException(i, "invalid unsigned short value");
            }
            if (len - i == LENGTH) {
                compare = true;
            }
            if ((c = value.charAt(i)) >= '0' && c <= '9') {
                if (compare) {
                    char d = MAX_VALUE.charAt(i);
                    if (Character.digit(c, 10) > Character.digit(d, 10)) {
                        throw new DatatypeException(i, "invalid unsigned short value");
                    }
                }
            } else {
                throw new DatatypeException(i, "invalid unsigned short value");
            }
            ++i;
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            return new Short(literal);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }
}

