/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.Key;
import gnu.xml.transform.SortKey;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.Template;
import gnu.xml.transform.TemplateNode;
import gnu.xml.transform.XSLComparator;
import gnu.xml.xpath.Expr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

final class ForEachNode
extends TemplateNode {
    final Expr select;
    final List sortKeys;

    ForEachNode(Expr select, List sortKeys) {
        this.select = select;
        this.sortKeys = sortKeys;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        int len = this.sortKeys != null ? this.sortKeys.size() : 0;
        ArrayList<Key> sortKeys2 = new ArrayList<Key>(len);
        int i = 0;
        while (i < len) {
            sortKeys2.add(((Key)this.sortKeys.get(i)).clone(stylesheet));
            ++i;
        }
        ForEachNode ret = new ForEachNode(this.select.clone(stylesheet), sortKeys2);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        if (this.children != null) {
            Template saved = stylesheet.currentTemplate;
            stylesheet.currentTemplate = null;
            Object ret = this.select.evaluate(context, pos, len);
            if (ret instanceof Collection) {
                Collection ns = (Collection)ret;
                ArrayList list2 = new ArrayList(ns);
                if (this.sortKeys != null) {
                    for (SortKey sortKey : this.sortKeys) {
                        sortKey.init(stylesheet, mode, context, pos, len, parent, nextSibling);
                    }
                    Collections.sort(list2, new XSLComparator(this.sortKeys));
                } else {
                    Collections.sort(list2, documentOrderComparator);
                }
                int l = list2.size();
                int p = 1;
                Iterator i = list2.iterator();
                while (i.hasNext()) {
                    Node node2;
                    stylesheet.current = node2 = (Node)i.next();
                    this.children.apply(stylesheet, mode, node2, p++, l, parent, nextSibling);
                }
            }
            stylesheet.currentTemplate = saved;
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public boolean references(QName var) {
        if (this.select != null && this.select.references(var)) {
            return true;
        }
        if (this.sortKeys != null) {
            Iterator i = this.sortKeys.iterator();
            while (i.hasNext()) {
                if (!((SortKey)i.next()).references(var)) continue;
                return true;
            }
        }
        return super.references(var);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("for-each");
        buf.append('[');
        buf.append("select=");
        buf.append(this.select);
        buf.append(']');
        return buf.toString();
    }
}

