/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.classpath.debug.TeeInputStream;
import gnu.classpath.debug.TeeReader;
import gnu.java.net.CRLFInputStream;
import gnu.xml.stream.BufferedReader;
import gnu.xml.stream.CRLFReader;
import gnu.xml.stream.UnicodeReader;
import gnu.xml.stream.XIncludeFilter;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class XMLParser
implements XMLStreamReader,
NamespaceContext {
    private static final int INIT = 0;
    private static final int PROLOG = 1;
    private static final int CONTENT = 2;
    private static final int EMPTY_ELEMENT = 3;
    private static final int MISC = 4;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_PUBID = 256;
    static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    static final int START_ENTITY = 50;
    static final int END_ENTITY = 51;
    private Input input;
    private LinkedList inputStack = new LinkedList();
    private LinkedList startEntityStack = new LinkedList();
    private LinkedList endEntityStack = new LinkedList();
    private int state = 0;
    private int event;
    private boolean lookahead;
    private LinkedList stack = new LinkedList();
    private LinkedList namespaces = new LinkedList();
    private LinkedList bases = new LinkedList();
    private ArrayList attrs = new ArrayList();
    private StringBuffer buf = new StringBuffer();
    private StringBuffer nmtokenBuf = new StringBuffer();
    private StringBuffer literalBuf = new StringBuffer();
    private int[] tmpBuf = new int[1024];
    private ContentModel currentContentModel;
    private LinkedList validationStack;
    private HashSet ids;
    private HashSet idrefs;
    private String piTarget;
    private String piData;
    private String xmlVersion;
    private String xmlEncoding;
    private Boolean xmlStandalone;
    Doctype doctype;
    private boolean expandPE;
    private boolean peIsError;
    private final boolean validating;
    private final boolean stringInterning;
    private final boolean coalescing;
    private final boolean replaceERefs;
    private final boolean externalEntities;
    private final boolean supportDTD;
    private final boolean namespaceAware;
    private final boolean baseAware;
    private final boolean extendedEventTypes;
    final XMLReporter reporter;
    final XMLResolver resolver;
    private static final String TEST_START_ELEMENT = "<";
    private static final String TEST_END_ELEMENT = "</";
    private static final String TEST_COMMENT = "<!--";
    private static final String TEST_PI = "<?";
    private static final String TEST_CDATA = "<![CDATA[";
    private static final String TEST_XML_DECL = "<?xml";
    private static final String TEST_DOCTYPE_DECL = "<!DOCTYPE";
    private static final String TEST_ELEMENT_DECL = "<!ELEMENT";
    private static final String TEST_ATTLIST_DECL = "<!ATTLIST";
    private static final String TEST_ENTITY_DECL = "<!ENTITY";
    private static final String TEST_NOTATION_DECL = "<!NOTATION";
    private static final String TEST_KET = ">";
    private static final String TEST_END_COMMENT = "--";
    private static final String TEST_END_PI = "?>";
    private static final String TEST_END_CDATA = "]]>";
    private static final LinkedHashMap PREDEFINED_ENTITIES = new LinkedHashMap();

    static {
        PREDEFINED_ENTITIES.put("amp", "&");
        PREDEFINED_ENTITIES.put("lt", TEST_START_ELEMENT);
        PREDEFINED_ENTITIES.put("gt", TEST_KET);
        PREDEFINED_ENTITIES.put("apos", "'");
        PREDEFINED_ENTITIES.put("quot", "\"");
    }

    public XMLParser(InputStream in, String systemId, boolean validating, boolean namespaceAware, boolean coalescing, boolean replaceERefs, boolean externalEntities, boolean supportDTD, boolean baseAware, boolean stringInterning, boolean extendedEventTypes, XMLReporter reporter, XMLResolver resolver) {
        String debug;
        this.validating = validating;
        this.namespaceAware = namespaceAware;
        this.coalescing = coalescing;
        this.replaceERefs = replaceERefs;
        this.externalEntities = externalEntities;
        this.supportDTD = supportDTD;
        this.baseAware = baseAware;
        this.stringInterning = stringInterning;
        this.extendedEventTypes = extendedEventTypes;
        this.reporter = reporter;
        this.resolver = resolver;
        if (validating) {
            this.validationStack = new LinkedList();
            this.ids = new HashSet();
            this.idrefs = new HashSet();
        }
        if ((debug = System.getProperty("gnu.xml.debug.input")) != null) {
            try {
                File file = File.createTempFile(debug, ".xml");
                in = new TeeInputStream(in, new FileOutputStream(file));
            }
            catch (IOException e) {
                RuntimeException e2 = new RuntimeException();
                e2.initCause(e);
                throw e2;
            }
        }
        systemId = XMLParser.canonicalize(systemId);
        this.pushInput(new Input(in, null, null, systemId, null, null, false, true));
    }

    public XMLParser(Reader reader, String systemId, boolean validating, boolean namespaceAware, boolean coalescing, boolean replaceERefs, boolean externalEntities, boolean supportDTD, boolean baseAware, boolean stringInterning, boolean extendedEventTypes, XMLReporter reporter, XMLResolver resolver) {
        String debug;
        this.validating = validating;
        this.namespaceAware = namespaceAware;
        this.coalescing = coalescing;
        this.replaceERefs = replaceERefs;
        this.externalEntities = externalEntities;
        this.supportDTD = supportDTD;
        this.baseAware = baseAware;
        this.stringInterning = stringInterning;
        this.extendedEventTypes = extendedEventTypes;
        this.reporter = reporter;
        this.resolver = resolver;
        if (validating) {
            this.validationStack = new LinkedList();
            this.ids = new HashSet();
            this.idrefs = new HashSet();
        }
        if ((debug = System.getProperty("gnu.xml.debug.input")) != null) {
            try {
                File file = File.createTempFile(debug, ".xml");
                reader = new TeeReader(reader, new FileWriter(file));
            }
            catch (IOException e) {
                RuntimeException e2 = new RuntimeException();
                e2.initCause(e);
                throw e2;
            }
        }
        systemId = XMLParser.canonicalize(systemId);
        this.pushInput(new Input(null, reader, null, systemId, null, null, false, true));
    }

    public String getNamespaceURI(String prefix) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(prefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        for (LinkedHashMap ctx : this.namespaces) {
            String namespaceURI = (String)ctx.get(prefix);
            if (namespaceURI == null) continue;
            return namespaceURI;
        }
        return null;
    }

    public String getPrefix(String namespaceURI) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return "xmlns";
        }
        Iterator i = this.namespaces.iterator();
        while (i.hasNext()) {
            LinkedHashMap ctx = (LinkedHashMap)i.next();
            if (!ctx.containsValue(namespaceURI)) continue;
            Iterator j = ctx.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String uri = (String)entry.getValue();
                if (!uri.equals(namespaceURI)) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return Collections.singleton("xml").iterator();
        }
        if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
            return Collections.singleton("xmlns").iterator();
        }
        LinkedList acc = new LinkedList();
        Iterator i = this.namespaces.iterator();
        while (i.hasNext()) {
            LinkedHashMap ctx = (LinkedHashMap)i.next();
            if (!ctx.containsValue(namespaceURI)) continue;
            Iterator j = ctx.entrySet().iterator();
            while (j.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                String uri = (String)entry.getValue();
                if (!uri.equals(namespaceURI)) continue;
                acc.add(entry.getKey());
            }
        }
        return acc.iterator();
    }

    public void close() throws XMLStreamException {
        this.stack = null;
        this.namespaces = null;
        this.bases = null;
        this.buf = null;
        this.attrs = null;
        this.doctype = null;
        this.inputStack = null;
        this.validationStack = null;
        this.ids = null;
        this.idrefs = null;
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getAttributeCount() {
        return this.attrs.size();
    }

    public String getAttributeLocalName(int index) {
        Attribute a = (Attribute)this.attrs.get(index);
        return a.localName;
    }

    public String getAttributeNamespace(int index) {
        String prefix = this.getAttributePrefix(index);
        return this.getNamespaceURI(prefix);
    }

    public String getAttributePrefix(int index) {
        Attribute a = (Attribute)this.attrs.get(index);
        return a.prefix;
    }

    public QName getAttributeName(int index) {
        Attribute a = (Attribute)this.attrs.get(index);
        String namespaceURI = this.getNamespaceURI(a.prefix);
        return new QName(namespaceURI, a.localName, a.prefix);
    }

    public String getAttributeType(int index) {
        Attribute a = (Attribute)this.attrs.get(index);
        return a.type;
    }

    private String getAttributeType(String elementName, String attName) {
        AttributeDecl att;
        if (this.doctype != null && (att = this.doctype.getAttributeDecl(elementName, attName)) != null) {
            return att.type;
        }
        return "CDATA";
    }

    public String getAttributeValue(int index) {
        Attribute a = (Attribute)this.attrs.get(index);
        return a.value;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        for (Attribute a : this.attrs) {
            String uri;
            if (!a.localName.equals(localName) || ((uri = this.getNamespaceURI(a.prefix)) != null || namespaceURI != null) && (uri == null || !uri.equals(namespaceURI))) continue;
            return a.value;
        }
        return null;
    }

    boolean isAttributeDeclared(int index) {
        if (this.doctype == null) {
            return false;
        }
        Attribute a = (Attribute)this.attrs.get(index);
        String qn = "".equals(a.prefix) ? a.localName : String.valueOf(a.prefix) + ":" + a.localName;
        String elementName = this.buf.toString();
        return this.doctype.isAttributeDeclared(elementName, qn);
    }

    public String getCharacterEncodingScheme() {
        return this.xmlEncoding;
    }

    public String getElementText() throws XMLStreamException {
        if (this.event != 1) {
            throw new XMLStreamException("current event must be START_ELEMENT");
        }
        StringBuffer elementText = new StringBuffer();
        int depth = this.stack.size();
        while (this.event != 2 || this.stack.size() > depth) {
            switch (this.next()) {
                case 4: 
                case 6: {
                    elementText.append(this.buf.toString());
                }
            }
        }
        return elementText.toString();
    }

    public String getEncoding() {
        return this.input.inputEncoding == null ? "UTF-8" : this.input.inputEncoding;
    }

    public int getEventType() {
        return this.event;
    }

    public String getLocalName() {
        switch (this.event) {
            case 1: 
            case 2: {
                String qName = this.buf.toString();
                int ci = qName.indexOf(58);
                return ci == -1 ? qName : qName.substring(ci + 1);
            }
        }
        return null;
    }

    public Location getLocation() {
        return this.input;
    }

    public QName getName() {
        switch (this.event) {
            case 1: 
            case 2: {
                String localName;
                String qName = this.buf.toString();
                int ci = qName.indexOf(58);
                String string = localName = ci == -1 ? qName : qName.substring(ci + 1);
                String prefix = ci == -1 ? (this.namespaceAware ? "" : null) : qName.substring(0, ci);
                String namespaceURI = this.getNamespaceURI(prefix);
                return new QName(namespaceURI, localName, prefix);
            }
        }
        return null;
    }

    public int getNamespaceCount() {
        if (!this.namespaceAware || this.namespaces.isEmpty()) {
            return 0;
        }
        switch (this.event) {
            case 1: 
            case 2: {
                LinkedHashMap ctx = (LinkedHashMap)this.namespaces.getFirst();
                return ctx.size();
            }
        }
        return 0;
    }

    public String getNamespacePrefix(int index) {
        LinkedHashMap ctx = (LinkedHashMap)this.namespaces.getFirst();
        int count = 0;
        for (String prefix : ctx.keySet()) {
            if (count++ != index) continue;
            return prefix;
        }
        return null;
    }

    public String getNamespaceURI() {
        switch (this.event) {
            case 1: 
            case 2: {
                String qName = this.buf.toString();
                int ci = qName.indexOf(58);
                if (ci == -1) {
                    return null;
                }
                String prefix = qName.substring(0, ci);
                return this.getNamespaceURI(prefix);
            }
        }
        return null;
    }

    public String getNamespaceURI(int index) {
        LinkedHashMap ctx = (LinkedHashMap)this.namespaces.getFirst();
        int count = 0;
        for (String uri : ctx.values()) {
            if (count++ != index) continue;
            return uri;
        }
        return null;
    }

    public String getPIData() {
        return this.piData;
    }

    public String getPITarget() {
        return this.piTarget;
    }

    public String getPrefix() {
        switch (this.event) {
            case 1: 
            case 2: {
                String qName = this.buf.toString();
                int ci = qName.indexOf(58);
                return ci == -1 ? (this.namespaceAware ? "" : null) : qName.substring(0, ci);
            }
        }
        return null;
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if ("javax.xml.stream.allocator".equals(name)) {
            return null;
        }
        if ("javax.xml.stream.isCoalescing".equals(name)) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isNamespaceAware".equals(name)) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isReplacingEntityReferences".equals(name)) {
            return this.replaceERefs ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isSupportingExternalEntities".equals(name)) {
            return this.externalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("javax.xml.stream.isValidating".equals(name)) {
            return Boolean.FALSE;
        }
        if ("javax.xml.stream.reporter".equals(name)) {
            return this.reporter;
        }
        if ("javax.xml.stream.resolver".equals(name)) {
            return this.resolver;
        }
        if ("javax.xml.stream.supportDTD".equals(name)) {
            return this.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("gnu.xml.stream.stringInterning".equals(name)) {
            return this.stringInterning ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("gnu.xml.stream.xmlBase".equals(name)) {
            return this.baseAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if ("gnu.xml.stream.baseURI".equals(name)) {
            return this.getXMLBase();
        }
        return null;
    }

    public String getText() {
        return this.buf.toString();
    }

    public char[] getTextCharacters() {
        return this.buf.toString().toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        length = Math.min(sourceStart + this.buf.length(), length);
        int sourceEnd = sourceStart + length;
        this.buf.getChars(sourceStart, sourceEnd, target, targetStart);
        return length;
    }

    public int getTextLength() {
        return this.buf.length();
    }

    public int getTextStart() {
        return 0;
    }

    public String getVersion() {
        return this.xmlVersion == null ? "1.0" : this.xmlVersion;
    }

    public boolean hasName() {
        switch (this.event) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public boolean hasText() {
        switch (this.event) {
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public boolean isAttributeSpecified(int index) {
        Attribute a = (Attribute)this.attrs.get(index);
        return a.specified;
    }

    public boolean isCharacters() {
        return this.event == 4;
    }

    public boolean isEndElement() {
        return this.event == 2;
    }

    public boolean isStandalone() {
        return Boolean.TRUE.equals(this.xmlStandalone);
    }

    public boolean isStartElement() {
        return this.event == 1;
    }

    public boolean isWhiteSpace() {
        return this.event == 6;
    }

    public int nextTag() throws XMLStreamException {
        do {
            switch (this.next()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected event type: " + this.event);
                }
            }
        } while (this.event != 1 && this.event != 2);
        return this.event;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        if (this.event != type) {
            throw new XMLStreamException("Current event type is " + this.event);
        }
        if (this.event == 1 || this.event == 2) {
            String ln = this.getLocalName();
            if (!ln.equals(localName)) {
                throw new XMLStreamException("Current local-name is " + ln);
            }
            String uri = this.getNamespaceURI();
            if (uri == null && namespaceURI != null || uri != null && !uri.equals(namespaceURI)) {
                throw new XMLStreamException("Current namespace URI is " + uri);
            }
        }
    }

    public boolean standaloneSet() {
        return this.xmlStandalone != null;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.event == 8) {
            return false;
        }
        if (!this.lookahead) {
            this.next();
            this.lookahead = true;
        }
        return this.event != -1;
    }

    public int next() throws XMLStreamException {
        if (this.lookahead) {
            this.lookahead = false;
            return this.event;
        }
        if (this.event == 2) {
            if (this.namespaceAware && !this.namespaces.isEmpty()) {
                this.namespaces.removeFirst();
            }
            if (this.baseAware && !this.bases.isEmpty()) {
                this.bases.removeFirst();
            }
        }
        if (!this.startEntityStack.isEmpty()) {
            String entityName = (String)this.startEntityStack.removeFirst();
            this.buf.setLength(0);
            this.buf.append(entityName);
            this.event = 50;
            return this.extendedEventTypes ? this.event : this.next();
        }
        if (!this.endEntityStack.isEmpty()) {
            String entityName = (String)this.endEntityStack.removeFirst();
            this.buf.setLength(0);
            this.buf.append(entityName);
            this.event = 51;
            return this.extendedEventTypes ? this.event : this.next();
        }
        try {
            if (!this.input.initialized) {
                this.input.init();
            }
            switch (this.state) {
                case 2: {
                    if (this.tryRead(TEST_END_ELEMENT)) {
                        this.readEndElement();
                        if (this.stack.isEmpty()) {
                            this.state = 4;
                        }
                        this.event = 2;
                        break;
                    }
                    if (this.tryRead(TEST_COMMENT)) {
                        this.readComment(false);
                        this.event = 5;
                        break;
                    }
                    if (this.tryRead(TEST_PI)) {
                        this.readPI(false);
                        this.event = 3;
                        break;
                    }
                    if (this.tryRead(TEST_CDATA)) {
                        this.readCDSect();
                        this.event = 12;
                        break;
                    }
                    if (this.tryRead(TEST_START_ELEMENT)) {
                        this.state = this.readStartElement();
                        this.event = 1;
                        break;
                    }
                    this.mark(8);
                    int c = this.readCh();
                    if (c == 38) {
                        c = this.readCh();
                        if (c == 35) {
                            this.reset();
                            this.event = this.readCharData(null);
                            break;
                        }
                        this.reset();
                        this.readCh();
                        this.readReference();
                        String ref = this.buf.toString();
                        String text = (String)PREDEFINED_ENTITIES.get(ref);
                        if (text != null) {
                            this.event = this.readCharData(text);
                            break;
                        }
                        if (this.replaceERefs && !this.isUnparsedEntity(ref)) {
                            Object entity;
                            boolean external = false;
                            if (this.doctype != null && (entity = this.doctype.getEntity(ref)) instanceof ExternalIds) {
                                external = true;
                            }
                            this.expandEntity(ref, false, external);
                            this.event = this.next();
                            break;
                        }
                        this.event = 9;
                        break;
                    }
                    this.reset();
                    this.event = this.readCharData(null);
                    if (!this.validating || this.doctype == null) break;
                    this.validatePCData(this.buf.toString());
                    break;
                }
                case 3: {
                    String elementName = (String)this.stack.removeLast();
                    this.buf.setLength(0);
                    this.buf.append(elementName);
                    this.state = this.stack.isEmpty() ? 4 : 2;
                    this.event = 2;
                    if (!this.validating || this.doctype == null) break;
                    this.endElementValidationHook();
                    break;
                }
                case 0: {
                    if (this.tryRead(TEST_XML_DECL)) {
                        this.readXMLDecl();
                    }
                    this.input.finalizeEncoding();
                    this.event = 7;
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.skipWhitespace();
                    if (this.doctype == null && this.tryRead(TEST_DOCTYPE_DECL)) {
                        this.readDoctypeDecl();
                        this.event = 11;
                        break;
                    }
                    if (this.tryRead(TEST_COMMENT)) {
                        this.readComment(false);
                        this.event = 5;
                        break;
                    }
                    if (this.tryRead(TEST_PI)) {
                        this.readPI(false);
                        this.event = 3;
                        break;
                    }
                    if (this.tryRead(TEST_START_ELEMENT)) {
                        this.state = this.readStartElement();
                        this.event = 1;
                        break;
                    }
                    int c = this.readCh();
                    this.error("no root element: U+" + Integer.toHexString(c));
                    break;
                }
                case 4: {
                    this.skipWhitespace();
                    if (this.tryRead(TEST_COMMENT)) {
                        this.readComment(false);
                        this.event = 5;
                        break;
                    }
                    if (this.tryRead(TEST_PI)) {
                        this.readPI(false);
                        this.event = 3;
                        break;
                    }
                    if (this.event == 8) {
                        throw new NoSuchElementException();
                    }
                    int c = this.readCh();
                    if (c != -1) {
                        this.error("Only comments and PIs may appear after the root element");
                    }
                    this.event = 8;
                    break;
                }
                default: {
                    this.event = -1;
                }
            }
            return this.event;
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException();
            e2.initCause(e);
            throw e2;
        }
    }

    String getCurrentElement() {
        return (String)this.stack.getLast();
    }

    private void mark(int limit) throws IOException {
        this.input.mark(limit);
    }

    private void reset() throws IOException {
        this.input.reset();
    }

    private int read() throws IOException {
        return this.input.read();
    }

    private int read(int[] b, int off, int len) throws IOException {
        return this.input.read(b, off, len);
    }

    private int readCh() throws IOException, XMLStreamException {
        int c = this.read();
        if (this.expandPE && c == 37) {
            if (this.peIsError) {
                this.error("PE reference within decl in internal subset.");
            }
            this.expandPEReference();
            return this.readCh();
        }
        return c;
    }

    private void require(char delim) throws IOException, XMLStreamException {
        this.mark(1);
        int c = this.readCh();
        if (delim != c) {
            this.reset();
            this.error("required character (got U+" + Integer.toHexString(c) + ")", new Character(delim));
        }
    }

    private void require(String delim) throws IOException, XMLStreamException {
        int l2;
        char[] chars = delim.toCharArray();
        int len = chars.length;
        this.mark(len);
        int off = 0;
        do {
            if ((l2 = this.read(this.tmpBuf, off, len - off)) != -1) continue;
            this.reset();
            this.error("EOF before required string", delim);
        } while ((off += l2) < len);
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != this.tmpBuf[i]) {
                this.reset();
                this.error("required string", delim);
            }
            ++i;
        }
    }

    private boolean tryRead(char delim) throws IOException, XMLStreamException {
        this.mark(1);
        int c = this.readCh();
        if (delim != c) {
            this.reset();
            return false;
        }
        return true;
    }

    private boolean tryRead(String test) throws IOException {
        char[] chars = test.toCharArray();
        int len = chars.length;
        this.mark(len);
        int count = 0;
        int l2 = this.read(this.tmpBuf, 0, len);
        if (l2 == -1) {
            this.reset();
            return false;
        }
        count += l2;
        int i = 0;
        while (i < count) {
            if (chars[i] != this.tmpBuf[i]) {
                this.reset();
                return false;
            }
            ++i;
        }
        while (count < len) {
            int c = this.read();
            if (c == -1) {
                this.reset();
                return false;
            }
            this.tmpBuf[count] = (char)c;
            if (chars[count] != this.tmpBuf[count]) {
                this.reset();
                return false;
            }
            ++count;
        }
        return true;
    }

    private void readUntil(String delim) throws IOException, XMLStreamException {
        int startLine = this.input.line;
        try {
            while (!this.tryRead(delim)) {
                int c = this.readCh();
                if (c == -1) {
                    throw new EOFException();
                }
                if (this.input.xml11) {
                    if (!XMLParser.isXML11Char(c) || XMLParser.isXML11RestrictedChar(c)) {
                        this.error("illegal XML 1.1 character", "U+" + Integer.toHexString(c));
                    }
                } else if (!XMLParser.isChar(c)) {
                    this.error("illegal XML character", "U+" + Integer.toHexString(c));
                }
                this.buf.append(Character.toChars(c));
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', delim);
        }
    }

    private boolean tryWhitespace() throws IOException, XMLStreamException {
        boolean white;
        boolean ret = false;
        do {
            this.mark(1);
            int c = this.readCh();
            while (c == -1 && this.inputStack.size() > 1) {
                this.popInput();
                c = this.readCh();
            }
            boolean bl = white = c == 32 || c == 9 || c == 10 || c == 13;
            if (!white) continue;
            ret = true;
        } while (white);
        this.reset();
        return ret;
    }

    private void skipWhitespace() throws IOException, XMLStreamException {
        int c;
        boolean white;
        do {
            this.mark(1);
            c = this.readCh();
            while (c == -1 && this.inputStack.size() > 1) {
                this.popInput();
                c = this.readCh();
            }
        } while (white = c == 32 || c == 9 || c == 10 || c == 13);
        this.reset();
    }

    private void requireWhitespace() throws IOException, XMLStreamException {
        if (!this.tryWhitespace()) {
            this.error("whitespace required");
        }
    }

    String getXMLBase() {
        if (this.baseAware) {
            for (String base : this.bases) {
                if (base == null) continue;
                return base;
            }
        }
        return this.input.systemId;
    }

    private void pushInput(String name, String text, boolean report, boolean normalize) throws IOException, XMLStreamException {
        if (name != null && !"".equals(name)) {
            for (Input ctx : this.inputStack) {
                if (!name.equals(ctx.name)) continue;
                this.error("entities may not be self-recursive", name);
            }
        } else {
            report = false;
        }
        this.pushInput(new Input(null, new StringReader(text), this.input.publicId, this.input.systemId, name, this.input.inputEncoding, report, normalize));
    }

    private void pushInput(String name, ExternalIds ids, boolean report, boolean normalize) throws IOException, XMLStreamException {
        Object obj;
        if (!this.externalEntities) {
            return;
        }
        String url = XMLParser.canonicalize(XMLParser.absolutize(this.input.systemId, ids.systemId));
        for (Input ctx : this.inputStack) {
            if (url.equals(ctx.systemId)) {
                this.error("entities may not be self-recursive", url);
            }
            if (name == null || "".equals(name) || !name.equals(ctx.name)) continue;
            this.error("entities may not be self-recursive", name);
        }
        if (name == null || "".equals(name)) {
            report = false;
        }
        InputStream in = null;
        if (this.resolver != null && (obj = this.resolver.resolveEntity(ids.publicId, url, this.getXMLBase(), null)) instanceof InputStream) {
            in = (InputStream)obj;
        }
        if (in == null) {
            in = XMLParser.resolve(url);
        }
        if (in == null) {
            this.error("unable to resolve external entity", ids.systemId != null ? ids.systemId : ids.publicId);
        }
        this.pushInput(new Input(in, null, ids.publicId, url, name, null, report, normalize));
        this.input.init();
        if (this.tryRead(TEST_XML_DECL)) {
            this.readTextDecl();
        }
        this.input.finalizeEncoding();
    }

    private void pushInput(Input input) {
        if (input.report) {
            this.startEntityStack.addFirst(input.name);
        }
        this.inputStack.addLast(input);
        if (this.input != null) {
            input.xml11 = this.input.xml11;
        }
        this.input = input;
    }

    static String canonicalize(String url) {
        if (url == null) {
            return null;
        }
        if (url.startsWith("file:") && !url.startsWith("file://")) {
            url = "file://" + url.substring(5);
        }
        return url;
    }

    public static String absolutize(String base, String href) {
        int lsi;
        int i;
        if (href == null) {
            return null;
        }
        int ci = href.indexOf(58);
        if (ci > 1 && XMLParser.isURLScheme(href.substring(0, ci))) {
            return href;
        }
        if ("".equals(base = base == null ? "" : ((i = base.lastIndexOf(47)) != -1 ? base.substring(0, i + 1) : ""))) {
            base = System.getProperty("user.dir");
            if (base.charAt(0) == '/') {
                base = base.substring(1);
            }
            if (!(base = "file:///" + base.replace(File.separatorChar, '/')).endsWith("/")) {
                base = String.valueOf(base) + "/";
            }
        }
        String basePrefix = null;
        ci = base.indexOf(58);
        if (ci > 1 && XMLParser.isURLScheme(base.substring(0, ci))) {
            if (base.length() > ci + 3 && base.charAt(ci + 1) == '/' && base.charAt(ci + 2) == '/') {
                int si = base.indexOf(47, ci + 3);
                if (si == -1) {
                    base = null;
                } else {
                    basePrefix = base.substring(0, si);
                    base = base.substring(si);
                }
            } else {
                base = null;
            }
        }
        if (base == null) {
            return href;
        }
        if (href.startsWith("/")) {
            return basePrefix == null ? href : String.valueOf(basePrefix) + href;
        }
        if (!base.endsWith("/")) {
            lsi = base.lastIndexOf(47);
            base = lsi == -1 ? "/" : base.substring(0, lsi + 1);
        }
        while (href.startsWith("../") || href.startsWith("./")) {
            if (href.startsWith("../")) {
                lsi = base.lastIndexOf(47, base.length() - 2);
                if (lsi > -1) {
                    base = base.substring(0, lsi + 1);
                }
                href = href.substring(3);
                continue;
            }
            href = href.substring(2);
        }
        return basePrefix == null ? String.valueOf(base) + href : String.valueOf(basePrefix) + base + href;
    }

    private static boolean isURLScheme(String text) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            if (c != '+' && c != '.' && c != '-' && (c < 'A' || c > 'Z' && c < 'a' || c > 'z')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static InputStream resolve(String url) throws IOException {
        try {
            return new URL(url).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        catch (IOException e) {
            IOException e2 = new IOException("error resolving " + url);
            e2.initCause(e);
            throw e2;
        }
    }

    private void popInput() {
        Input old = (Input)this.inputStack.removeLast();
        if (old.report) {
            this.endEntityStack.addFirst(old.name);
        }
        this.input = (Input)this.inputStack.getLast();
    }

    private void readTextDecl() throws IOException, XMLStreamException {
        this.requireWhitespace();
        if (this.tryRead("version")) {
            this.readEq();
            String v = this.readLiteral(112, false);
            if ("1.0".equals(v)) {
                this.input.xml11 = false;
            } else if ("1.1".equals(v)) {
                Input i1 = (Input)this.inputStack.getFirst();
                if (!i1.xml11) {
                    this.error("external entity specifies later version number");
                }
                this.input.xml11 = true;
            } else {
                throw new XMLStreamException("illegal XML version: " + v);
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.readEq();
        String enc = this.readLiteral(112, false);
        this.skipWhitespace();
        this.require(TEST_END_PI);
        this.input.setInputEncoding(enc);
    }

    private void readXMLDecl() throws IOException, XMLStreamException {
        this.requireWhitespace();
        this.require("version");
        this.readEq();
        this.xmlVersion = this.readLiteral(112, false);
        if ("1.0".equals(this.xmlVersion)) {
            this.input.xml11 = false;
        } else if ("1.1".equals(this.xmlVersion)) {
            this.input.xml11 = true;
        } else {
            throw new XMLStreamException("illegal XML version: " + this.xmlVersion);
        }
        boolean white = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!white) {
                this.error("whitespace required before 'encoding='");
            }
            this.readEq();
            this.xmlEncoding = this.readLiteral(112, false);
            white = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!white) {
                this.error("whitespace required before 'standalone='");
            }
            this.readEq();
            String standalone = this.readLiteral(112, false);
            if ("yes".equals(standalone)) {
                this.xmlStandalone = Boolean.TRUE;
            } else if ("no".equals(standalone)) {
                this.xmlStandalone = Boolean.FALSE;
            } else {
                this.error("standalone flag must be 'yes' or 'no'", standalone);
            }
        }
        this.skipWhitespace();
        this.require(TEST_END_PI);
        if (this.xmlEncoding != null) {
            this.input.setInputEncoding(this.xmlEncoding);
        }
    }

    private void readDoctypeDecl() throws IOException, XMLStreamException {
        if (!this.supportDTD) {
            this.error("parser was configured not to support DTDs");
        }
        this.requireWhitespace();
        String rootName = this.readNmtoken(true);
        this.skipWhitespace();
        ExternalIds ids = this.readExternalIds(false, true);
        XMLParser xMLParser = this;
        xMLParser.getClass();
        this.doctype = xMLParser.new Doctype(rootName, ids.publicId, ids.systemId);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                if (this.tryRead(']')) break;
                this.readMarkupdecl(false);
            }
        }
        this.skipWhitespace();
        this.require('>');
        if (ids.systemId != null && this.externalEntities) {
            this.pushInput("", TEST_KET, false, false);
            this.pushInput("[dtd]", ids, true, true);
            while (true) {
                this.expandPE = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.mark(1);
                int c = this.readCh();
                if (c == 62) break;
                if (c == -1) {
                    this.popInput();
                    continue;
                }
                this.reset();
                this.expandPE = true;
                this.readMarkupdecl(true);
                this.expandPE = true;
            }
            if (this.inputStack.size() != 2) {
                this.error("external subset has unmatched '>'");
            }
            this.popInput();
        }
        this.checkDoctype();
        if (this.validating) {
            this.validateDoctype();
        }
        this.buf.setLength(0);
        this.buf.append(rootName);
    }

    private void checkDoctype() throws XMLStreamException {
    }

    private void readMarkupdecl(boolean inExternalSubset) throws IOException, XMLStreamException {
        boolean saved = this.expandPE;
        this.mark(1);
        this.require('<');
        this.reset();
        this.expandPE = false;
        if (this.tryRead(TEST_ELEMENT_DECL)) {
            this.expandPE = saved;
            this.readElementDecl();
        } else if (this.tryRead(TEST_ATTLIST_DECL)) {
            this.expandPE = saved;
            this.readAttlistDecl();
        } else if (this.tryRead(TEST_ENTITY_DECL)) {
            this.expandPE = saved;
            this.readEntityDecl(inExternalSubset);
        } else if (this.tryRead(TEST_NOTATION_DECL)) {
            this.expandPE = saved;
            this.readNotationDecl(inExternalSubset);
        } else if (this.tryRead(TEST_PI)) {
            this.readPI(true);
            this.expandPE = saved;
        } else if (this.tryRead(TEST_COMMENT)) {
            this.readComment(true);
            this.expandPE = saved;
        } else if (this.tryRead("<![")) {
            this.expandPE = saved;
            if (this.inputStack.size() < 2) {
                this.error("conditional sections illegal in internal subset");
            }
            this.skipWhitespace();
            if (this.tryRead("INCLUDE")) {
                this.skipWhitespace();
                this.require('[');
                this.skipWhitespace();
                while (!this.tryRead(TEST_END_CDATA)) {
                    this.readMarkupdecl(inExternalSubset);
                    this.skipWhitespace();
                }
            } else if (this.tryRead("IGNORE")) {
                this.skipWhitespace();
                this.require('[');
                this.expandPE = false;
                int nesting = 1;
                while (nesting > 0) {
                    int c = this.readCh();
                    switch (c) {
                        case 60: {
                            if (!this.tryRead("![")) break;
                            ++nesting;
                            break;
                        }
                        case 93: {
                            if (!this.tryRead("]>")) break;
                            --nesting;
                            break;
                        }
                        case -1: {
                            throw new EOFException();
                        }
                    }
                }
                this.expandPE = saved;
            } else {
                this.error("conditional section must begin with INCLUDE or IGNORE");
            }
        } else {
            this.error("expected markup declaration");
        }
    }

    private void readElementDecl() throws IOException, XMLStreamException {
        this.requireWhitespace();
        boolean saved = this.expandPE;
        this.expandPE = this.inputStack.size() > 1;
        String name = this.readNmtoken(true);
        this.expandPE = saved;
        this.requireWhitespace();
        this.readContentspec(name);
        this.skipWhitespace();
        this.require('>');
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void readContentspec(String elementName) throws IOException, XMLStreamException {
        block2: {
            block5: {
                block4: {
                    block3: {
                        block1: {
                            if (!this.tryRead("EMPTY")) break block1;
                            this.doctype.addElementDecl(elementName, "EMPTY", new EmptyContentModel());
                            break block2;
                        }
                        if (!this.tryRead("ANY")) break block3;
                        this.doctype.addElementDecl(elementName, "ANY", new AnyContentModel());
                        break block2;
                    }
                    acc = new StringBuffer();
                    this.require('(');
                    acc.append('(');
                    this.skipWhitespace();
                    if (!this.tryRead("#PCDATA")) break block4;
                    acc.append("#PCDATA");
                    mm = new MixedContentModel();
                    model /* !! */  = mm;
                    this.skipWhitespace();
                    if (!this.tryRead(')')) ** GOTO lbl36
                    acc.append(")");
                    if (!this.tryRead('*')) break block5;
                    mm.min = 0;
                    mm.max = -1;
                    break block5;
lbl-1000:
                    // 1 sources

                    {
                        this.require('|');
                        acc.append('|');
                        this.skipWhitespace();
                        name = this.readNmtoken(true);
                        acc.append(name);
                        mm.addName(name);
                        this.skipWhitespace();
lbl36:
                        // 2 sources

                        ** while (!this.tryRead((String)")"))
                    }
lbl37:
                    // 1 sources

                    this.require('*');
                    acc.append(")*");
                    mm.min = 0;
                    mm.max = -1;
                    break block5;
                }
                model /* !! */  = this.readElements(acc);
            }
            this.doctype.addElementDecl(elementName, acc.toString(), model /* !! */ );
        }
    }

    private ElementContentModel readElements(StringBuffer acc) throws IOException, XMLStreamException {
        int separator;
        ElementContentModel model = new ElementContentModel();
        this.skipWhitespace();
        model.addContentParticle(this.readContentParticle(acc));
        this.skipWhitespace();
        int c = this.readCh();
        switch (c) {
            case 41: {
                acc.append(')');
                this.mark(1);
                c = this.readCh();
                switch (c) {
                    case 63: {
                        acc.append('?');
                        model.min = 0;
                        model.max = 1;
                        break;
                    }
                    case 42: {
                        acc.append('*');
                        model.min = 0;
                        model.max = -1;
                        break;
                    }
                    case 43: {
                        acc.append('+');
                        model.min = 1;
                        model.max = -1;
                        break;
                    }
                    default: {
                        this.reset();
                    }
                }
                return model;
            }
            case 124: {
                model.or = true;
            }
            case 44: {
                separator = c;
                acc.append(Character.toChars(c));
                break;
            }
            default: {
                this.error("bad separator in content model", "U+" + Integer.toHexString(c));
                return model;
            }
        }
        while (true) {
            this.skipWhitespace();
            model.addContentParticle(this.readContentParticle(acc));
            this.skipWhitespace();
            c = this.readCh();
            if (c == 41) break;
            if (c != separator) {
                this.error("bad separator in content model", "U+" + Integer.toHexString(c));
                return model;
            }
            acc.append(c);
        }
        acc.append(')');
        this.mark(1);
        c = this.readCh();
        switch (c) {
            case 63: {
                acc.append('?');
                model.min = 0;
                model.max = 1;
                break;
            }
            case 42: {
                acc.append('*');
                model.min = 0;
                model.max = -1;
                break;
            }
            case 43: {
                acc.append('+');
                model.min = 1;
                model.max = -1;
                break;
            }
            default: {
                this.reset();
            }
        }
        return model;
    }

    private ContentParticle readContentParticle(StringBuffer acc) throws IOException, XMLStreamException {
        ContentParticle cp = new ContentParticle();
        if (this.tryRead('(')) {
            acc.append('(');
            cp.content = this.readElements(acc);
        } else {
            String name = this.readNmtoken(true);
            acc.append(name);
            cp.content = name;
            this.mark(1);
            int c = this.readCh();
            switch (c) {
                case 63: {
                    acc.append('?');
                    cp.min = 0;
                    cp.max = 1;
                    break;
                }
                case 42: {
                    acc.append('*');
                    cp.min = 0;
                    cp.max = -1;
                    break;
                }
                case 43: {
                    acc.append('+');
                    cp.min = 1;
                    cp.max = -1;
                    break;
                }
                default: {
                    this.reset();
                }
            }
        }
        return cp;
    }

    private void readAttlistDecl() throws IOException, XMLStreamException {
        this.requireWhitespace();
        boolean saved = this.expandPE;
        this.expandPE = this.inputStack.size() > 1;
        String elementName = this.readNmtoken(true);
        this.expandPE = saved;
        boolean white = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!white) {
                this.error("whitespace required before attribute definition");
            }
            this.readAttDef(elementName);
            white = this.tryWhitespace();
        }
    }

    private void readAttDef(String elementName) throws IOException, XMLStreamException {
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        StringBuffer acc = new StringBuffer();
        HashSet values = new HashSet();
        String type = this.readAttType(acc, values);
        if (this.validating) {
            Iterator i;
            if ("ID".equals(type)) {
                i = this.doctype.attlistIterator(elementName);
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    AttributeDecl decl = (AttributeDecl)entry.getValue();
                    if (!"ID".equals(decl.type)) continue;
                    this.error("element types must not have more than one ID attribute");
                }
            } else if ("NOTATION".equals(type)) {
                i = this.doctype.attlistIterator(elementName);
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    AttributeDecl decl = (AttributeDecl)entry.getValue();
                    if (!"NOTATION".equals(decl.type)) continue;
                    this.error("element types must not have more than one NOTATION attribute");
                }
                ContentModel model = this.doctype.getElementModel(elementName);
                if (model != null && model.type == 0) {
                    this.error("attributes of type NOTATION must not be declared on an element declared EMPTY");
                }
            }
        }
        String enumer = null;
        if ("ENUMERATION".equals(type) || "NOTATION".equals(type)) {
            enumer = acc.toString();
        } else {
            values = null;
        }
        this.requireWhitespace();
        this.readDefault(elementName, name, type, enumer, values);
    }

    private String readAttType(StringBuffer acc, HashSet values) throws IOException, XMLStreamException {
        if (this.tryRead('(')) {
            this.readEnumeration(false, acc, values);
            return "ENUMERATION";
        }
        String typeString = this.readNmtoken(true);
        if ("NOTATION".equals(typeString)) {
            this.readNotationType(acc, values);
            return typeString;
        }
        if ("CDATA".equals(typeString) || "ID".equals(typeString) || "IDREF".equals(typeString) || "IDREFS".equals(typeString) || "ENTITY".equals(typeString) || "ENTITIES".equals(typeString) || "NMTOKEN".equals(typeString) || "NMTOKENS".equals(typeString)) {
            return typeString;
        }
        this.error("illegal attribute type", typeString);
        return null;
    }

    private void readEnumeration(boolean isNames, StringBuffer acc, HashSet values) throws IOException, XMLStreamException {
        acc.append('(');
        this.skipWhitespace();
        String token = this.readNmtoken(isNames);
        acc.append(token);
        values.add(token);
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            acc.append('|');
            this.skipWhitespace();
            token = this.readNmtoken(isNames);
            if (this.validating && values.contains(token)) {
                this.error("duplicate token", token);
            }
            acc.append(token);
            values.add(token);
            this.skipWhitespace();
        }
        acc.append(')');
    }

    private void readNotationType(StringBuffer acc, HashSet values) throws IOException, XMLStreamException {
        this.requireWhitespace();
        this.require('(');
        this.readEnumeration(true, acc, values);
    }

    private void readDefault(String elementName, String name, String type, String enumeration, HashSet values) throws IOException, XMLStreamException {
        int valueType = 31;
        int flags = 8;
        String value = null;
        boolean saved = this.expandPE;
        if (!"CDATA".equals(type)) {
            flags |= 4;
        }
        this.expandPE = false;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                valueType = 34;
                this.requireWhitespace();
                value = this.readLiteral(flags, false);
            } else if (this.tryRead("REQUIRED")) {
                valueType = 33;
            } else if (this.tryRead("IMPLIED")) {
                valueType = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            value = this.readLiteral(flags, false);
        }
        this.expandPE = saved;
        if (this.validating) {
            if ("ID".equals(type)) {
                if (value != null && !this.isNmtoken(value, true)) {
                    this.error("default value must match Name production", value);
                }
                if (valueType != 33 && valueType != 32) {
                    this.error("ID attributes must have a declared default of #IMPLIED or #REQUIRED");
                }
            } else if (value != null) {
                StringTokenizer st;
                if ("IDREF".equals(type) || "ENTITY".equals(type)) {
                    if (!this.isNmtoken(value, true)) {
                        this.error("default value must match Name production", value);
                    }
                } else if ("IDREFS".equals(type) || "ENTITIES".equals(type)) {
                    st = new StringTokenizer(value);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (this.isNmtoken(token, true)) continue;
                        this.error("default value must match Name production", token);
                    }
                } else if ("NMTOKEN".equals(type) || "ENUMERATION".equals(type)) {
                    if (!this.isNmtoken(value, false)) {
                        this.error("default value must match Nmtoken production", value);
                    }
                } else if ("NMTOKENS".equals(type)) {
                    st = new StringTokenizer(value);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        if (this.isNmtoken(token, false)) continue;
                        this.error("default value must match Nmtoken production", token);
                    }
                }
            }
        }
        AttributeDecl attribute = new AttributeDecl(type, value, valueType, enumeration, values, this.inputStack.size() != 1);
        this.doctype.addAttributeDecl(elementName, name, attribute);
    }

    private void readEntityDecl(boolean inExternalSubset) throws IOException, XMLStreamException {
        int flags = 0;
        boolean peFlag = false;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            peFlag = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String name = this.readNmtoken(true);
        if (name.indexOf(58) != -1) {
            this.error("illegal character ':' in entity name", name);
        }
        if (peFlag) {
            name = "%" + name;
        }
        this.requireWhitespace();
        this.mark(1);
        int c = this.readCh();
        this.reset();
        if (c == 34 || c == 39) {
            String value = this.readLiteral(flags | 0x40, true);
            int ai = value.indexOf(38);
            while (ai != -1) {
                int i;
                String ref;
                int[] cp;
                int sci = value.indexOf(59, ai);
                if (sci == -1) {
                    this.error("malformed reference in entity value", value);
                }
                if ((cp = UnicodeReader.toCodePointArray(ref = value.substring(ai + 1, sci))).length == 0) {
                    this.error("malformed reference in entity value", value);
                }
                if (cp[0] == 35) {
                    int x;
                    if (cp.length == 1) {
                        this.error("malformed reference in entity value", value);
                    }
                    if (cp[1] == 120) {
                        if (cp.length == 2) {
                            this.error("malformed reference in entity value", value);
                        }
                        i = 2;
                        while (i < cp.length) {
                            x = cp[i];
                            if (x < 48 || x > 57 && x < 65 || x > 70 && x < 97 || x > 102) {
                                this.error("malformed character reference in entity value", value);
                            }
                            ++i;
                        }
                    } else {
                        i = 1;
                        while (i < cp.length) {
                            x = cp[i];
                            if (x < 48 || x > 57) {
                                this.error("malformed character reference in entity value", value);
                            }
                            ++i;
                        }
                    }
                } else {
                    if (!XMLParser.isNameStartCharacter(cp[0], this.input.xml11)) {
                        this.error("malformed reference in entity value", value);
                    }
                    i = 1;
                    while (i < cp.length) {
                        if (!XMLParser.isNameCharacter(cp[i], this.input.xml11)) {
                            this.error("malformed reference in entity value", value);
                        }
                        ++i;
                    }
                }
                ai = value.indexOf(38, sci);
            }
            this.doctype.addEntityDecl(name, value, inExternalSubset);
        } else {
            ExternalIds ids = this.readExternalIds(false, false);
            boolean white = this.tryWhitespace();
            if (!peFlag && this.tryRead("NDATA")) {
                if (!white) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                ids.notationName = this.readNmtoken(true);
            }
            this.doctype.addEntityDecl(name, ids, inExternalSubset);
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void readNotationDecl(boolean inExternalSubset) throws IOException, XMLStreamException {
        ExternalIds notation;
        this.requireWhitespace();
        String notationName = this.readNmtoken(true);
        if (notationName.indexOf(58) != -1) {
            this.error("illegal character ':' in notation name", notationName);
        }
        if (this.validating && (notation = this.doctype.getNotation(notationName)) != null) {
            this.error("duplicate notation name", notationName);
        }
        this.requireWhitespace();
        ExternalIds ids = this.readExternalIds(true, false);
        ids.notationName = notationName;
        this.doctype.addNotationDecl(notationName, ids, inExternalSubset);
        this.skipWhitespace();
        this.require('>');
    }

    private ExternalIds readExternalIds(boolean inNotation, boolean isSubset) throws IOException, XMLStreamException {
        int flags = 112;
        ExternalIds ids = new ExternalIds();
        if (this.tryRead("PUBLIC")) {
            String href;
            this.requireWhitespace();
            ids.publicId = this.readLiteral(0x104 | flags, false);
            if (inNotation) {
                this.skipWhitespace();
                this.mark(1);
                int c = this.readCh();
                this.reset();
                if (c == 34 || c == 39) {
                    href = this.readLiteral(flags, false);
                    ids.systemId = XMLParser.absolutize(this.input.systemId, href);
                }
            } else {
                this.requireWhitespace();
                href = this.readLiteral(flags, false);
                ids.systemId = XMLParser.absolutize(this.input.systemId, href);
            }
            int i = 0;
            while (i < ids.publicId.length()) {
                char d = ids.publicId.charAt(i);
                if (!(d >= 'a' && d <= 'z' || d >= 'A' && d <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(d) != -1)) {
                    this.error("illegal PUBLIC id character", "U+" + Integer.toHexString(d));
                }
                ++i;
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            String href = this.readLiteral(flags, false);
            ids.systemId = XMLParser.absolutize(this.input.systemId, href);
        } else if (!isSubset) {
            this.error("missing SYSTEM or PUBLIC keyword");
        }
        if (ids.systemId != null && !inNotation && ids.systemId.indexOf(35) != -1) {
            this.error("SYSTEM id has a URI fragment", ids.systemId);
        }
        return ids;
    }

    private int readStartElement() throws IOException, XMLStreamException {
        String elementName = this.readNmtoken(true);
        this.attrs.clear();
        if (this.namespaceAware) {
            if (elementName.charAt(0) == ':' || elementName.charAt(elementName.length() - 1) == ':') {
                this.error("not a QName", elementName);
            }
            this.namespaces.addFirst(new LinkedHashMap());
        }
        boolean white = this.tryWhitespace();
        this.mark(1);
        int c = this.readCh();
        while (c != 47 && c != 62) {
            this.reset();
            if (!white) {
                this.error("need whitespace between attributes");
            }
            this.readAttribute(elementName);
            white = this.tryWhitespace();
            this.mark(1);
            c = this.readCh();
        }
        if (this.doctype != null) {
            Iterator i = this.doctype.attlistIterator(elementName);
            while (i.hasNext()) {
                LinkedHashMap ctx;
                Map.Entry entry = (Map.Entry)i.next();
                String attName = (String)entry.getKey();
                AttributeDecl decl = (AttributeDecl)entry.getValue();
                if (this.validating) {
                    switch (decl.valueType) {
                        case 33: {
                            if (decl.value != null || this.attributeSpecified(attName)) break;
                            this.error("value for " + attName + " attribute is required");
                            break;
                        }
                        case 34: {
                            for (Attribute a : this.attrs) {
                                if (!attName.equals(a.name) || decl.value.equals(a.value)) continue;
                                this.error("value for " + attName + " attribute must be " + decl.value);
                            }
                            break;
                        }
                    }
                }
                if ((!this.namespaceAware || !attName.equals("xmlns") ? (!this.namespaceAware || !attName.startsWith("xmlns:") ? this.attributeSpecified(attName) : (ctx = (LinkedHashMap)this.namespaces.getFirst()).containsKey(attName.substring(6))) : (ctx = (LinkedHashMap)this.namespaces.getFirst()).containsKey("")) || decl.value == null) continue;
                if (this.validating && decl.external && this.xmlStandalone == Boolean.TRUE) {
                    this.error("standalone must be 'no' if attributes inherit values from externally declared markup declarations");
                }
                Attribute attr = new Attribute(attName, decl.type, false, decl.value);
                if (this.namespaceAware) {
                    if (this.addNamespace(attr)) continue;
                    this.attrs.add(attr);
                    continue;
                }
                this.attrs.add(attr);
            }
        }
        if (this.baseAware) {
            String uri = this.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
            String base = this.getXMLBase();
            this.bases.addFirst(XMLParser.absolutize(base, uri));
        }
        if (this.namespaceAware) {
            int ci = elementName.indexOf(58);
            if (ci != -1) {
                String prefix = elementName.substring(0, ci);
                String uri = this.getNamespaceURI(prefix);
                if (uri == null) {
                    this.error("unbound element prefix", prefix);
                } else if (this.input.xml11 && "".equals(uri)) {
                    this.error("XML 1.1 unbound element prefix", prefix);
                }
            }
            for (Attribute attr : this.attrs) {
                if (attr.prefix == null || "xmlns".equals(attr.prefix)) continue;
                String uri = this.getNamespaceURI(attr.prefix);
                if (uri == null) {
                    this.error("unbound attribute prefix", attr.prefix);
                    continue;
                }
                if (!this.input.xml11 || !"".equals(uri)) continue;
                this.error("XML 1.1 unbound attribute prefix", attr.prefix);
            }
        }
        if (this.validating && this.doctype != null) {
            this.validateStartElement(elementName);
            this.currentContentModel = this.doctype.getElementModel(elementName);
            if (this.currentContentModel == null) {
                this.error("no element declaration", elementName);
            }
            this.validationStack.add(new LinkedList());
        }
        this.buf.setLength(0);
        this.buf.append(elementName);
        this.stack.addLast(elementName);
        switch (c) {
            case 62: {
                return 2;
            }
            case 47: {
                this.require('>');
                return 3;
            }
        }
        return -1;
    }

    private boolean attributeSpecified(String attName) {
        for (Attribute a : this.attrs) {
            if (!attName.equals(a.name)) continue;
            return true;
        }
        return false;
    }

    private void readAttribute(String elementName) throws IOException, XMLStreamException {
        String attributeName = this.readNmtoken(true);
        String type = this.getAttributeType(elementName, attributeName);
        this.readEq();
        String value = type == null || "CDATA".equals(type) ? this.readLiteral(10, false) : this.readLiteral(14, false);
        XMLParser xMLParser = this;
        xMLParser.getClass();
        Attribute attr = xMLParser.new Attribute(attributeName, type, true, value);
        if (this.namespaceAware) {
            LinkedHashMap ctx;
            if (attributeName.charAt(0) == ':' || attributeName.charAt(attributeName.length() - 1) == ':') {
                this.error("not a QName", attributeName);
            } else if (attributeName.equals("xmlns")) {
                ctx = (LinkedHashMap)this.namespaces.getFirst();
                if (ctx.containsKey("")) {
                    this.error("duplicate default namespace");
                }
            } else if (attributeName.startsWith("xmlns:")) {
                ctx = (LinkedHashMap)this.namespaces.getFirst();
                if (ctx.containsKey(attributeName.substring(6))) {
                    this.error("duplicate namespace", attributeName.substring(6));
                }
            } else if (this.attrs.contains(attr)) {
                this.error("duplicate attribute", attributeName);
            }
        } else if (this.attrs.contains(attr)) {
            this.error("duplicate attribute", attributeName);
        }
        if (this.validating && this.doctype != null) {
            AttributeDecl decl = this.doctype.getAttributeDecl(elementName, attributeName);
            if (decl == null) {
                this.error("attribute must be declared", attributeName);
            }
            if ("ENUMERATION".equals(decl.type)) {
                if (!decl.values.contains(value)) {
                    this.error("value does not match enumeration " + decl.enumeration, value);
                }
            } else if ("ID".equals(decl.type)) {
                if (!this.isNmtoken(value, true)) {
                    this.error("ID values must match the Name production");
                }
                if (this.ids.contains(value)) {
                    this.error("Duplicate ID", value);
                }
                this.ids.add(value);
            } else if ("IDREF".equals(decl.type) || "IDREFS".equals(decl.type)) {
                StringTokenizer st = new StringTokenizer(value);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (!this.isNmtoken(token, true)) {
                        this.error("IDREF values must match the Name production");
                    }
                    this.idrefs.add(token);
                }
            } else if ("NMTOKEN".equals(decl.type) || "NMTOKENS".equals(decl.type)) {
                StringTokenizer st = new StringTokenizer(value);
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (this.isNmtoken(token, false)) continue;
                    this.error("NMTOKEN values must match the Nmtoken production");
                }
            } else if ("ENTITY".equals(decl.type)) {
                Object entity;
                if (!this.isNmtoken(value, true)) {
                    this.error("ENTITY values must match the Name production");
                }
                if ((entity = this.doctype.getEntity(value)) == null || !(entity instanceof ExternalIds) || ((ExternalIds)entity).notationName == null) {
                    this.error("ENTITY values must match the name of an unparsed entity declared in the DTD");
                }
            } else if ("NOTATION".equals(decl.type)) {
                ExternalIds notation;
                if (!decl.values.contains(value)) {
                    this.error("NOTATION values must match a declared notation name", value);
                }
                if ((notation = this.doctype.getNotation(value)) == null) {
                    this.error("NOTATION values must match the name of a notation declared in the DTD", value);
                }
            }
        }
        if (this.namespaceAware) {
            if (!this.addNamespace(attr)) {
                this.attrs.add(attr);
            }
        } else {
            this.attrs.add(attr);
        }
    }

    private boolean addNamespace(Attribute attr) throws XMLStreamException {
        if ("xmlns".equals(attr.name)) {
            LinkedHashMap ctx = (LinkedHashMap)this.namespaces.getFirst();
            if (ctx.get("") != null) {
                this.error("Duplicate default namespace declaration");
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(attr.value)) {
                this.error("can't bind XML namespace");
            }
            ctx.put("", attr.value);
            return true;
        }
        if ("xmlns".equals(attr.prefix)) {
            LinkedHashMap ctx = (LinkedHashMap)this.namespaces.getFirst();
            if (ctx.get(attr.localName) != null) {
                this.error("Duplicate namespace declaration for prefix", attr.localName);
            }
            if ("xml".equals(attr.localName)) {
                if (!"http://www.w3.org/XML/1998/namespace".equals(attr.value)) {
                    this.error("can't redeclare xml prefix");
                } else {
                    return false;
                }
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(attr.value)) {
                this.error("can't bind non-xml prefix to XML namespace");
            }
            if ("xmlns".equals(attr.localName)) {
                this.error("can't redeclare xmlns prefix");
            }
            if ("http://www.w3.org/2000/xmlns/".equals(attr.value)) {
                this.error("can't bind non-xmlns prefix to XML Namespace namespace");
            }
            if ("".equals(attr.value) && !this.input.xml11) {
                this.error("illegal use of 1.1-style prefix unbinding in 1.0 document");
            }
            ctx.put(attr.localName, attr.value);
            return true;
        }
        return false;
    }

    private void readEndElement() throws IOException, XMLStreamException {
        String expected = (String)this.stack.removeLast();
        this.require(expected);
        this.skipWhitespace();
        this.require('>');
        this.buf.setLength(0);
        this.buf.append(expected);
        if (this.validating && this.doctype != null) {
            this.endElementValidationHook();
        }
    }

    private void endElementValidationHook() throws XMLStreamException {
        this.validateEndElement();
        this.validationStack.removeLast();
        if (this.stack.isEmpty()) {
            this.currentContentModel = null;
        } else {
            String parent = (String)this.stack.getLast();
            this.currentContentModel = this.doctype.getElementModel(parent);
        }
    }

    private void readComment(boolean inDTD) throws IOException, XMLStreamException {
        boolean saved = this.expandPE;
        this.expandPE = false;
        this.buf.setLength(0);
        this.readUntil(TEST_END_COMMENT);
        this.require('>');
        this.expandPE = saved;
        if (inDTD) {
            this.doctype.addComment(this.buf.toString());
        }
    }

    private void readPI(boolean inDTD) throws IOException, XMLStreamException {
        boolean saved = this.expandPE;
        this.expandPE = false;
        this.piTarget = this.readNmtoken(true);
        if (this.piTarget.indexOf(58) != -1) {
            this.error("illegal character in PI target", new Character(':'));
        }
        if ("xml".equalsIgnoreCase(this.piTarget)) {
            this.error("illegal PI target", this.piTarget);
        }
        if (this.tryRead(TEST_END_PI)) {
            this.piData = null;
        } else {
            if (!this.tryWhitespace()) {
                this.error("whitespace required between PI target and data");
            }
            this.buf.setLength(0);
            this.readUntil(TEST_END_PI);
            this.piData = this.buf.toString();
        }
        this.expandPE = saved;
        if (inDTD) {
            this.doctype.addPI(this.piTarget, this.piData);
        }
    }

    private void readReference() throws IOException, XMLStreamException {
        this.buf.setLength(0);
        String entityName = this.readNmtoken(true);
        this.require(';');
        this.buf.setLength(0);
        this.buf.append(entityName);
    }

    private void readCDSect() throws IOException, XMLStreamException {
        this.buf.setLength(0);
        this.readUntil(TEST_END_CDATA);
    }

    private int readCharData(String prefix) throws IOException, XMLStreamException {
        boolean white = true;
        this.buf.setLength(0);
        if (prefix != null) {
            this.buf.append(prefix);
        }
        boolean done = false;
        boolean entities = false;
        while (!done) {
            this.mark(this.tmpBuf.length);
            int len = this.read(this.tmpBuf, 0, this.tmpBuf.length);
            if (len == -1) {
                if (this.inputStack.size() > 1) {
                    this.popInput();
                    done = true;
                } else {
                    throw new EOFException();
                }
            }
            int i = 0;
            while (i < len && !done) {
                int c = this.tmpBuf[i];
                switch (c) {
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.buf.append(Character.toChars(c));
                        break;
                    }
                    case 38: {
                        this.reset();
                        this.read(this.tmpBuf, 0, i);
                        this.mark(3);
                        c = this.readCh();
                        c = this.readCh();
                        if (c == 35) {
                            boolean hex;
                            this.mark(1);
                            c = this.readCh();
                            boolean bl = hex = c == 120;
                            if (!hex) {
                                this.reset();
                            }
                            char[] ch = this.readCharacterRef(hex ? 16 : 10);
                            this.buf.append(ch, 0, ch.length);
                            int j = 0;
                            while (j < ch.length) {
                                switch (ch[j]) {
                                    case '\t': 
                                    case '\n': 
                                    case '\r': 
                                    case ' ': {
                                        break;
                                    }
                                    default: {
                                        white = false;
                                    }
                                }
                                ++j;
                            }
                        } else {
                            this.reset();
                            c = this.readCh();
                            String entityName = this.readNmtoken(true);
                            this.require(';');
                            String text = (String)PREDEFINED_ENTITIES.get(entityName);
                            if (text != null) {
                                this.buf.append(text);
                            } else {
                                this.pushInput("", "&" + entityName + ";", false, false);
                                done = true;
                                break;
                            }
                        }
                        i = -1;
                        this.mark(this.tmpBuf.length);
                        len = this.read(this.tmpBuf, 0, this.tmpBuf.length);
                        if (len == -1) {
                            if (this.inputStack.size() > 1) {
                                this.popInput();
                                done = true;
                            } else {
                                throw new EOFException();
                            }
                        }
                        entities = true;
                        break;
                    }
                    case 62: {
                        int l = this.buf.length();
                        if (l > 1 && this.buf.charAt(l - 1) == ']' && this.buf.charAt(l - 2) == ']') {
                            this.error("Character data may not contain unescaped ']]>'");
                        }
                        this.buf.append(Character.toChars(c));
                        break;
                    }
                    case 60: {
                        int r;
                        this.reset();
                        int count = 0;
                        int remaining = i;
                        do {
                            r = this.read(this.tmpBuf, 0, remaining);
                            remaining -= r;
                        } while ((count += r) < i);
                        i = len;
                        if (this.coalescing && this.tryRead(TEST_CDATA)) {
                            this.readUntil(TEST_END_CDATA);
                            break;
                        }
                        done = true;
                        break;
                    }
                    default: {
                        if (this.input.xml11) {
                            if (!XMLParser.isXML11Char(c) || XMLParser.isXML11RestrictedChar(c)) {
                                this.error("illegal XML 1.1 character", "U+" + Integer.toHexString(c));
                            }
                        } else if (!XMLParser.isChar(c)) {
                            this.error("illegal XML character", "U+" + Integer.toHexString(c));
                        }
                        white = false;
                        this.buf.append(Character.toChars(c));
                    }
                }
                ++i;
            }
            if (this.buf.length() < 0x200000) continue;
            done = true;
        }
        if (entities) {
            this.normalizeCRLF(this.buf);
        }
        return white ? 6 : 4;
    }

    private void expandEntity(String name, boolean inAttr, boolean normalize) throws IOException, XMLStreamException {
        Object value;
        if (this.doctype != null && (value = this.doctype.getEntity(name)) != null) {
            if (this.xmlStandalone == Boolean.TRUE) {
                if (this.doctype.isEntityExternal(name)) {
                    this.error("reference to external entity in standalone document");
                } else if (value instanceof ExternalIds) {
                    ExternalIds ids = (ExternalIds)value;
                    if (ids.notationName != null && this.doctype.isNotationExternal(ids.notationName)) {
                        this.error("reference to external notation in standalone document");
                    }
                }
            }
            if (value instanceof String) {
                String text = (String)value;
                if (inAttr && text.indexOf(60) != -1) {
                    this.error("< in attribute value");
                }
                this.pushInput(name, text, !inAttr, normalize);
            } else if (inAttr) {
                this.error("reference to external entity in attribute value", name);
            } else {
                this.pushInput(name, (ExternalIds)value, !inAttr, normalize);
            }
            return;
        }
        this.error("reference to undeclared entity", name);
    }

    private boolean isUnparsedEntity(String name) {
        Object value;
        if (this.doctype != null && (value = this.doctype.getEntity(name)) != null && value instanceof ExternalIds) {
            return ((ExternalIds)value).notationName != null;
        }
        return false;
    }

    private void readEq() throws IOException, XMLStreamException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private int literalReadCh(boolean recognizePEs) throws IOException, XMLStreamException {
        int c = recognizePEs ? this.readCh() : this.read();
        while (c == -1) {
            if (this.inputStack.size() > 1) {
                this.inputStack.removeLast();
                this.input = (Input)this.inputStack.getLast();
                c = recognizePEs ? this.readCh() : this.read();
                continue;
            }
            throw new EOFException();
        }
        return c;
    }

    private String readLiteral(int flags, boolean recognizePEs) throws IOException, XMLStreamException {
        int c;
        boolean saved = this.expandPE;
        int delim = this.readCh();
        if (delim != 39 && delim != 34) {
            this.error("expected '\"' or \"'\"", "U+" + Integer.toHexString(delim));
        }
        this.literalBuf.setLength(0);
        if ((flags & 0x10) != 0) {
            this.expandPE = false;
        }
        boolean entities = false;
        int inputStackSize = this.inputStack.size();
        block7: while ((c = this.literalReadCh(recognizePEs)) != delim || inputStackSize != this.inputStack.size()) {
            switch (c) {
                case 10: 
                case 13: {
                    if ((flags & 0x108) == 0) break;
                    c = 32;
                    break;
                }
                case 9: {
                    if ((flags & 8) == 0) break;
                    c = 32;
                    break;
                }
                case 38: {
                    this.mark(2);
                    c = this.readCh();
                    if (c == 35) {
                        boolean hex;
                        if ((flags & 0x20) != 0) {
                            this.reset();
                            c = 38;
                            break;
                        }
                        this.mark(1);
                        c = this.readCh();
                        boolean bl = hex = c == 120;
                        if (!hex) {
                            this.reset();
                        }
                        char[] ref = this.readCharacterRef(hex ? 16 : 10);
                        int i = 0;
                        while (i < ref.length) {
                            this.literalBuf.append(ref[i]);
                            ++i;
                        }
                        entities = true;
                        continue block7;
                    }
                    if ((flags & 0x40) != 0) {
                        this.reset();
                        c = 38;
                        break;
                    }
                    this.reset();
                    String entityName = this.readNmtoken(true);
                    this.require(';');
                    String text = (String)PREDEFINED_ENTITIES.get(entityName);
                    if (text != null) {
                        this.literalBuf.append(text);
                    } else {
                        this.expandEntity(entityName, (flags & 8) != 0, true);
                    }
                    entities = true;
                    continue block7;
                }
                case 60: {
                    if ((flags & 8) == 0) break;
                    this.error("attribute values may not contain '<'");
                    break;
                }
                case -1: {
                    if (this.inputStack.size() > 1) {
                        this.popInput();
                        continue block7;
                    }
                    throw new EOFException();
                }
                default: {
                    if (c >= 32 && c <= 65533 && (c < 55296 || c >= 56320) && (!this.input.xml11 || c < 127 || c > 159 || c == 133)) break;
                    this.error("illegal character", "U+" + Integer.toHexString(c));
                }
            }
            this.literalBuf.append(Character.toChars(c));
        }
        this.expandPE = saved;
        if (entities) {
            this.normalizeCRLF(this.literalBuf);
        }
        if ((flags & 4) > 0) {
            this.literalBuf = this.normalize(this.literalBuf);
        }
        return this.literalBuf.toString();
    }

    private StringBuffer normalize(StringBuffer buf) {
        StringBuffer acc = new StringBuffer();
        int len = buf.length();
        int avState = 0;
        int i = 0;
        while (i < len) {
            char c = buf.charAt(i);
            if (c == ' ') {
                avState = avState == 0 ? 0 : 1;
            } else {
                if (avState == 1) {
                    acc.append(' ');
                }
                acc.append(c);
                avState = 2;
            }
            ++i;
        }
        return acc;
    }

    private void normalizeCRLF(StringBuffer buf) {
        int len = buf.length() - 1;
        int i = 0;
        while (i < len) {
            char c = buf.charAt(i);
            if (c == '\r' && buf.charAt(i + 1) == '\n') {
                buf.deleteCharAt(i--);
                --len;
            }
            ++i;
        }
    }

    private void expandPEReference() throws IOException, XMLStreamException {
        String name = this.readNmtoken(true, new StringBuffer());
        this.require(';');
        this.mark(1);
        if (this.doctype != null) {
            String entityName = "%" + name;
            Object entity = this.doctype.getEntity(entityName);
            if (entity != null) {
                if (this.xmlStandalone == Boolean.TRUE && this.doctype.isEntityExternal(entityName)) {
                    this.error("reference to external parameter entity in standalone document");
                }
                if (entity instanceof String) {
                    this.pushInput(name, (String)entity, false, this.input.normalize);
                } else {
                    this.pushInput(name, (ExternalIds)entity, false, this.input.normalize);
                }
            } else {
                this.error("reference to undeclared parameter entity", name);
            }
        } else {
            this.error("reference to parameter entity without doctype", name);
        }
    }

    private char[] readCharacterRef(int base) throws IOException, XMLStreamException {
        StringBuffer b = new StringBuffer();
        int c = this.readCh();
        while (c != 59 && c != -1) {
            b.append(Character.toChars(c));
            c = this.readCh();
        }
        try {
            int ord = Integer.parseInt(b.toString(), base);
            if (this.input.xml11) {
                if (!XMLParser.isXML11Char(ord)) {
                    this.error("illegal XML 1.1 character reference U+" + Integer.toHexString(ord));
                }
            } else if (ord < 32 && ord != 10 && ord != 9 && ord != 13 || ord >= 55296 && ord <= 57343 || ord == 65534 || ord == 65535 || ord > 0x10FFFF) {
                this.error("illegal XML character reference U+" + Integer.toHexString(ord));
            }
            return Character.toChars(ord);
        }
        catch (NumberFormatException numberFormatException) {
            this.error("illegal characters in character reference", b.toString());
            return null;
        }
    }

    private String readNmtoken(boolean isName) throws IOException, XMLStreamException {
        return this.readNmtoken(isName, this.nmtokenBuf);
    }

    private String readNmtoken(boolean isName, StringBuffer buf) throws IOException, XMLStreamException {
        buf.setLength(0);
        int c = this.readCh();
        if (isName) {
            if (!XMLParser.isNameStartCharacter(c, this.input.xml11)) {
                this.error("not a name start character", "U+" + Integer.toHexString(c));
            }
        } else if (!XMLParser.isNameCharacter(c, this.input.xml11)) {
            this.error("not a name character", "U+" + Integer.toHexString(c));
        }
        buf.append(Character.toChars(c));
        while (true) {
            this.mark(1);
            c = this.readCh();
            switch (c) {
                case -1: 
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 34: 
                case 37: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 47: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 91: 
                case 124: {
                    this.reset();
                    return this.intern(buf.toString());
                }
            }
            if (!XMLParser.isNameCharacter(c, this.input.xml11)) {
                this.error("not a name character", "U+" + Integer.toHexString(c));
                continue;
            }
            buf.append(Character.toChars(c));
        }
    }

    public static boolean isXML11Char(int c) {
        return c >= 1 && c <= 55295 || c >= 57344 && c < 65534 || c >= 65536 && c <= 0x10FFFF;
    }

    public static boolean isXML11RestrictedChar(int c) {
        return c >= 1 && c <= 8 || c >= 11 && c <= 12 || c >= 14 && c <= 31 || c >= 127 && c <= 132 || c >= 134 && c <= 159;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isNmtoken(String text, boolean isName) {
        try {
            int[] cp = UnicodeReader.toCodePointArray(text);
            if (cp.length == 0) {
                return false;
            }
            if (isName ? !XMLParser.isNameStartCharacter(cp[0], this.input.xml11) : !XMLParser.isNameCharacter(cp[0], this.input.xml11)) {
                return false;
            }
            int i = 1;
            while (true) {
                if (i >= cp.length) {
                    return true;
                }
                if (!XMLParser.isNameCharacter(cp[i], this.input.xml11)) {
                    return false;
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isNameStartCharacter(int c, boolean xml11) {
        if (xml11) {
            return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c == 58 | c == 95 | (c >= 192 && c <= 214) || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
        }
        return c == 95 || c == 58 || XMLParser.isLetter(c);
    }

    public static boolean isNameCharacter(int c, boolean xml11) {
        if (xml11) {
            return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 58 | c == 95 | c == 45 | c == 46 | c == 183 | (c >= 192 && c <= 214) || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 768 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8255 && c <= 8256 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
        }
        return c == 46 || c == 45 || c == 95 || c == 58 || XMLParser.isLetter(c) || XMLParser.isDigit(c) || XMLParser.isCombiningChar(c) || XMLParser.isExtender(c);
    }

    public static boolean isLetter(int c) {
        if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 255 || c >= 256 && c <= 305 || c >= 308 && c <= 318 || c >= 321 && c <= 328 || c >= 330 && c <= 382 || c >= 384 && c <= 451 || c >= 461 && c <= 496 || c >= 500 && c <= 501 || c >= 506 && c <= 535 || c >= 592 && c <= 680 || c >= 699 && c <= 705 || c == 902 || c >= 904 && c <= 906 || c == 908 || c >= 910 && c <= 929 || c >= 931 && c <= 974 || c >= 976 && c <= 982 || c == 986 || c == 988 || c == 990 || c == 992 || c >= 994 && c <= 1011 || c >= 1025 && c <= 1036 || c >= 1038 && c <= 1103 || c >= 1105 && c <= 1116 || c >= 1118 && c <= 1153 || c >= 1168 && c <= 1220 || c >= 1223 && c <= 1224 || c >= 1227 && c <= 1228 || c >= 1232 && c <= 1259 || c >= 1262 && c <= 1269 || c >= 1272 && c <= 1273 || c >= 1329 && c <= 1366 || c == 1369 || c >= 1377 && c <= 1414 || c >= 1488 && c <= 1514 || c >= 1520 && c <= 1522 || c >= 1569 && c <= 1594 || c >= 1601 && c <= 1610 || c >= 1649 && c <= 1719 || c >= 1722 && c <= 1726 || c >= 1728 && c <= 1742 || c >= 1744 && c <= 1747 || c == 1749 || c >= 1765 && c <= 1766 || c >= 2309 && c <= 2361 || c == 2365 || c >= 2392 && c <= 2401 || c >= 2437 && c <= 2444 || c >= 2447 && c <= 2448 || c >= 2451 && c <= 2472 || c >= 2474 && c <= 2480 || c == 2482 || c >= 2486 && c <= 2489 || c >= 2524 && c <= 2525 || c >= 2527 && c <= 2529 || c >= 2544 && c <= 2545 || c >= 2565 && c <= 2570 || c >= 2575 && c <= 2576 || c >= 2579 && c <= 2600 || c >= 2602 && c <= 2608 || c >= 2610 && c <= 2611 || c >= 2613 && c <= 2614 || c >= 2616 && c <= 2617 || c >= 2649 && c <= 2652 || c == 2654 || c >= 2674 && c <= 2676 || c >= 2693 && c <= 2699 || c == 2701 || c >= 2703 && c <= 2705 || c >= 2707 && c <= 2728 || c >= 2730 && c <= 2736 || c >= 2738 && c <= 2739 || c >= 2741 && c <= 2745 || c == 2749 || c == 2784 || c >= 2821 && c <= 2828 || c >= 2831 && c <= 2832 || c >= 2835 && c <= 2856 || c >= 2858 && c <= 2864 || c >= 2866 && c <= 2867 || c >= 2870 && c <= 2873 || c == 2877 || c >= 2908 && c <= 2909 || c >= 2911 && c <= 2913 || c >= 2949 && c <= 2954 || c >= 2958 && c <= 2960 || c >= 2962 && c <= 2965 || c >= 2969 && c <= 2970 || c == 2972 || c >= 2974 && c <= 2975 || c >= 2979 && c <= 2980 || c >= 2984 && c <= 2986 || c >= 2990 && c <= 2997 || c >= 2999 && c <= 3001 || c >= 3077 && c <= 3084 || c >= 3086 && c <= 3088 || c >= 3090 && c <= 3112 || c >= 3114 && c <= 3123 || c >= 3125 && c <= 3129 || c >= 3168 && c <= 3169 || c >= 3205 && c <= 3212 || c >= 3214 && c <= 3216 || c >= 3218 && c <= 3240 || c >= 3242 && c <= 3251 || c >= 3253 && c <= 3257 || c == 3294 || c >= 3296 && c <= 3297 || c >= 3333 && c <= 3340 || c >= 3342 && c <= 3344 || c >= 3346 && c <= 3368 || c >= 3370 && c <= 3385 || c >= 3424 && c <= 3425 || c >= 3585 && c <= 3630 || c == 3632 || c >= 3634 && c <= 3635 || c >= 3648 && c <= 3653 || c >= 3713 && c <= 3714 || c == 3716 || c >= 3719 && c <= 3720 || c == 3722 || c == 3725 || c >= 3732 && c <= 3735 || c >= 3737 && c <= 3743 || c >= 3745 && c <= 3747 || c == 3749 || c == 3751 || c >= 3754 && c <= 3755 || c >= 3757 && c <= 3758 || c == 3760 || c >= 3762 && c <= 3763 || c == 3773 || c >= 3776 && c <= 3780 || c >= 3904 && c <= 3911 || c >= 3913 && c <= 3945 || c >= 4256 && c <= 4293 || c >= 4304 && c <= 4342 || c == 4352 || c >= 4354 && c <= 4355 || c >= 4357 && c <= 4359 || c == 4361 || c >= 4363 && c <= 4364 || c >= 4366 && c <= 4370 || c == 4412 || c == 4414 || c == 4416 || c == 4428 || c == 4430 || c == 4432 || c >= 4436 && c <= 4437 || c == 4441 || c >= 4447 && c <= 4449 || c == 4451 || c == 4453 || c == 4455 || c == 4457 || c >= 4461 && c <= 4462 || c >= 4466 && c <= 4467 || c == 4469 || c == 4510 || c == 4520 || c == 4523 || c >= 4526 && c <= 4527 || c >= 4535 && c <= 4536 || c == 4538 || c >= 4540 && c <= 4546 || c == 4587 || c == 4592 || c == 4601 || c >= 7680 && c <= 7835 || c >= 7840 && c <= 7929 || c >= 7936 && c <= 7957 || c >= 7960 && c <= 7965 || c >= 7968 && c <= 8005 || c >= 8008 && c <= 8013 || c >= 8016 && c <= 8023 || c == 8025 || c == 8027 || c == 8029 || c >= 8031 && c <= 8061 || c >= 8064 && c <= 8116 || c >= 8118 && c <= 8124 || c == 8126 || c >= 8130 && c <= 8132 || c >= 8134 && c <= 8140 || c >= 8144 && c <= 8147 || c >= 8150 && c <= 8155 || c >= 8160 && c <= 8172 || c >= 8178 && c <= 8180 || c >= 8182 && c <= 8188 || c == 8486 || c >= 8490 && c <= 8491 || c == 8494 || c >= 8576 && c <= 8578 || c >= 12353 && c <= 12436 || c >= 12449 && c <= 12538 || c >= 12549 && c <= 12588 || c >= 44032 && c <= 55203) {
            return true;
        }
        return c >= 19968 && c <= 40869 || c == 12295 || c >= 12321 && c <= 12329;
    }

    public static boolean isDigit(int c) {
        return c >= 48 && c <= 57 || c >= 1632 && c <= 1641 || c >= 1776 && c <= 1785 || c >= 2406 && c <= 2415 || c >= 2534 && c <= 2543 || c >= 2662 && c <= 2671 || c >= 2790 && c <= 2799 || c >= 2918 && c <= 2927 || c >= 3047 && c <= 3055 || c >= 3174 && c <= 3183 || c >= 3302 && c <= 3311 || c >= 3430 && c <= 3439 || c >= 3664 && c <= 3673 || c >= 3792 && c <= 3801 || c >= 3872 && c <= 3881;
    }

    public static boolean isCombiningChar(int c) {
        return c >= 768 && c <= 837 || c >= 864 && c <= 865 || c >= 1155 && c <= 1158 || c >= 1425 && c <= 1441 || c >= 1443 && c <= 1465 || c >= 1467 && c <= 1469 || c == 1471 || c >= 1473 && c <= 1474 || c == 1476 || c >= 1611 && c <= 1618 || c == 1648 || c >= 1750 && c <= 1756 || c >= 1757 && c <= 1759 || c >= 1760 && c <= 1764 || c >= 1767 && c <= 1768 || c >= 1770 && c <= 1773 || c >= 2305 && c <= 2307 || c == 2364 || c >= 2366 && c <= 2380 || c == 2381 || c >= 2385 && c <= 2388 || c >= 2402 && c <= 2403 || c >= 2433 && c <= 2435 || c == 2492 || c == 2494 || c == 2495 || c >= 2496 && c <= 2500 || c >= 2503 && c <= 2504 || c >= 2507 && c <= 2509 || c == 2519 || c >= 2530 && c <= 2531 || c == 2562 || c == 2620 || c == 2622 || c == 2623 || c >= 2624 && c <= 2626 || c >= 2631 && c <= 2632 || c >= 2635 && c <= 2637 || c >= 2672 && c <= 2673 || c >= 2689 && c <= 2691 || c == 2748 || c >= 2750 && c <= 2757 || c >= 2759 && c <= 2761 || c >= 2763 && c <= 2765 || c >= 2817 && c <= 2819 || c == 2876 || c >= 2878 && c <= 2883 || c >= 2887 && c <= 2888 || c >= 2891 && c <= 2893 || c >= 2902 && c <= 2903 || c >= 2946 && c <= 2947 || c >= 3006 && c <= 3010 || c >= 3014 && c <= 3016 || c >= 3018 && c <= 3021 || c == 3031 || c >= 3073 && c <= 3075 || c >= 3134 && c <= 3140 || c >= 3142 && c <= 3144 || c >= 3146 && c <= 3149 || c >= 3157 && c <= 3158 || c >= 3202 && c <= 3203 || c >= 3262 && c <= 3268 || c >= 3270 && c <= 3272 || c >= 3274 && c <= 3277 || c >= 3285 && c <= 3286 || c >= 3330 && c <= 3331 || c >= 3390 && c <= 3395 || c >= 3398 && c <= 3400 || c >= 3402 && c <= 3405 || c == 3415 || c == 3633 || c >= 3636 && c <= 3642 || c >= 3655 && c <= 3662 || c == 3761 || c >= 3764 && c <= 3769 || c >= 3771 && c <= 3772 || c >= 3784 && c <= 3789 || c >= 3864 && c <= 3865 || c == 3893 || c == 3895 || c == 3897 || c == 3902 || c == 3903 || c >= 3953 && c <= 3972 || c >= 3974 && c <= 3979 || c >= 3984 && c <= 3989 || c == 3991 || c >= 3993 && c <= 4013 || c >= 4017 && c <= 4023 || c == 4025 || c >= 8400 && c <= 8412 || c == 8417 || c >= 12330 && c <= 12335 || c == 12441 || c == 12442;
    }

    public static boolean isExtender(int c) {
        return c == 183 || c == 720 || c == 721 || c == 903 || c == 1600 || c == 3654 || c == 3782 || c == 12293 || c >= 12337 && c <= 12341 || c >= 12445 && c <= 12446 || c >= 12540 && c <= 12542;
    }

    public static boolean isChar(int c) {
        return c >= 32 && c < 55296 || c >= 3584 && c < 65534 || c >= 65536 && c < 0x110000 || c == 10 || c == 9 || c == 13;
    }

    private String intern(String text) {
        return this.stringInterning ? text.intern() : text;
    }

    private void error(String message) throws XMLStreamException {
        this.error(message, null);
    }

    private void error(String message, Object info) throws XMLStreamException {
        if (info != null) {
            if (info instanceof String) {
                message = String.valueOf(message) + ": \"" + (String)info + "\"";
            } else if (info instanceof Character) {
                message = String.valueOf(message) + ": '" + (Character)info + "'";
            }
        }
        throw new XMLStreamException(message);
    }

    private void validateStartElement(String elementName) throws XMLStreamException {
        if (this.currentContentModel == null) {
            if (!elementName.equals(this.doctype.rootName)) {
                this.error("root element name must match name in DTD");
            }
            return;
        }
        switch (this.currentContentModel.type) {
            case 0: {
                this.error("child element found in empty element", elementName);
                break;
            }
            case 2: {
                LinkedList ctx = (LinkedList)this.validationStack.getLast();
                ctx.add(elementName);
                break;
            }
            case 3: {
                MixedContentModel mm = (MixedContentModel)this.currentContentModel;
                if (mm.containsName(elementName)) break;
                this.error("illegal element for content model", elementName);
            }
        }
    }

    private void validateEndElement() throws XMLStreamException {
        if (this.currentContentModel == null) {
            if (!this.idrefs.containsAll(this.ids)) {
                this.error("IDREF values must match the value of some ID attribute");
            }
            return;
        }
        switch (this.currentContentModel.type) {
            case 2: {
                LinkedList ctx = (LinkedList)this.validationStack.getLast();
                ElementContentModel ecm = (ElementContentModel)this.currentContentModel;
                this.validateElementContent(ecm, ctx);
            }
        }
    }

    private void validatePCData(String text) throws XMLStreamException {
        switch (this.currentContentModel.type) {
            case 0: {
                this.error("character data found in empty element", text);
                break;
            }
            case 2: {
                boolean white = true;
                int len = text.length();
                int i = 0;
                while (i < len) {
                    char c = text.charAt(i);
                    if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                        white = false;
                        break;
                    }
                    ++i;
                }
                if (!white) {
                    this.error("character data found in element with element content", text);
                    break;
                }
                if (this.xmlStandalone != Boolean.TRUE || !this.currentContentModel.external) break;
                this.error("whitespace in element content of externally declared element in standalone document");
            }
        }
    }

    private void validateElementContent(ElementContentModel model, LinkedList children) throws XMLStreamException {
        String regex;
        StringBuffer buf = new StringBuffer();
        Iterator i = children.iterator();
        while (i.hasNext()) {
            buf.append((String)i.next());
            buf.append(' ');
        }
        String c = buf.toString();
        if (!c.matches(regex = this.createRegularExpression(model))) {
            this.error("element content " + model.text + " does not match expression " + regex, c);
        }
    }

    private String createRegularExpression(ElementContentModel model) {
        if (model.regex == null) {
            StringBuffer buf = new StringBuffer();
            buf.append('(');
            Iterator i = model.contentParticles.iterator();
            while (i.hasNext()) {
                ContentParticle cp = (ContentParticle)i.next();
                if (cp.content instanceof String) {
                    buf.append('(');
                    buf.append((String)cp.content);
                    buf.append(' ');
                    buf.append(')');
                    if (cp.max == -1) {
                        if (cp.min == 0) {
                            buf.append('*');
                        } else {
                            buf.append('+');
                        }
                    } else if (cp.min == 0) {
                        buf.append('?');
                    }
                } else {
                    ElementContentModel ecm = (ElementContentModel)cp.content;
                    buf.append(this.createRegularExpression(ecm));
                }
                if (!model.or || !i.hasNext()) continue;
                buf.append('|');
            }
            buf.append(')');
            if (model.max == -1) {
                if (model.min == 0) {
                    buf.append('*');
                } else {
                    buf.append('+');
                }
            } else if (model.min == 0) {
                buf.append('?');
            }
            model.regex = buf.toString();
        }
        return model.regex;
    }

    void validateDoctype() throws XMLStreamException {
        Iterator i = this.doctype.entityIterator();
        while (i.hasNext()) {
            ExternalIds notation;
            Map.Entry entry = (Map.Entry)i.next();
            Object entity = entry.getValue();
            if (!(entity instanceof ExternalIds)) continue;
            ExternalIds ids = (ExternalIds)entity;
            if (ids.notationName == null || (notation = this.doctype.getNotation(ids.notationName)) != null) continue;
            this.error("Notation name must match the declared name of a notation", ids.notationName);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws Exception {
        validating = false;
        namespaceAware = false;
        xIncludeAware = false;
        pos = 0;
        while (pos < args.length && args[pos].startsWith("-")) {
            if ("-x".equals(args[pos])) {
                xIncludeAware = true;
            } else if ("-v".equals(args[pos])) {
                validating = true;
            } else if ("-n".equals(args[pos])) {
                namespaceAware = true;
            }
            ++pos;
        }
        if (pos >= args.length) {
            System.out.println("Syntax: XMLParser [-n] [-v] [-x] <file> [<file2> [...]]");
            System.out.println("\t-n: use namespace aware mode");
            System.out.println("\t-v: use validating parser");
            System.out.println("\t-x: use XInclude aware mode");
            System.exit(2);
        }
        while (pos < args.length) {
            p = new XMLParser(new FileInputStream(args[pos]), XMLParser.absolutize(null, args[pos]), validating, namespaceAware, true, true, true, true, true, true, true, null, null);
            reader = p;
            if (!xIncludeAware) ** GOTO lbl-1000
            reader = new XIncludeFilter(p, args[pos], true, true, true);
            try lbl-1000:
            // 3 sources

            {
                while (true) {
                    if (!reader.hasNext()) break;
                    event = reader.next();
                    loc = reader.getLocation();
                    System.out.print(String.valueOf(loc.getLineNumber()) + ":" + loc.getColumnNumber() + " ");
                    switch (event) {
                        case 7: {
                            System.out.println("START_DOCUMENT version=" + reader.getVersion() + " encoding=" + reader.getEncoding());
                            break;
                        }
                        case 8: {
                            System.out.println("END_DOCUMENT");
                            break;
                        }
                        case 1: {
                            System.out.println("START_ELEMENT " + reader.getName());
                            l = reader.getNamespaceCount();
                            i = 0;
                            while (true) {
                                if (i < l) ** GOTO lbl49
                                l = reader.getAttributeCount();
                                i = 0;
                                if (true) ** GOTO lbl97
lbl49:
                                // 1 sources

                                System.out.println("\tnamespace " + reader.getNamespacePrefix(i) + "='" + reader.getNamespaceURI(i) + "'");
                                ++i;
                            }
                        }
                        case 2: {
                            System.out.println("END_ELEMENT " + reader.getName());
                            break;
                        }
                        case 4: {
                            System.out.println("CHARACTERS '" + XMLParser.encodeText(reader.getText()) + "'");
                            break;
                        }
                        case 12: {
                            System.out.println("CDATA '" + XMLParser.encodeText(reader.getText()) + "'");
                            break;
                        }
                        case 6: {
                            System.out.println("SPACE '" + XMLParser.encodeText(reader.getText()) + "'");
                            break;
                        }
                        case 11: {
                            System.out.println("DTD " + reader.getText());
                            break;
                        }
                        case 9: {
                            System.out.println("ENTITY_REFERENCE " + reader.getText());
                            break;
                        }
                        case 5: {
                            System.out.println("COMMENT '" + XMLParser.encodeText(reader.getText()) + "'");
                            break;
                        }
                        case 3: {
                            System.out.println("PROCESSING_INSTRUCTION " + reader.getPITarget() + " " + reader.getPIData());
                            break;
                        }
                        case 50: {
                            System.out.println("START_ENTITY " + reader.getText());
                            break;
                        }
                        case 51: {
                            System.out.println("END_ENTITY " + reader.getText());
                            break;
                        }
                        default: {
                            System.out.println("Unknown event: " + event);
                            break;
                        }
                    }
                    continue;
                    break;
                }
            }
            catch (XMLStreamException e) {
                l = reader.getLocation();
                System.out.println("At line " + l.getLineNumber() + ", column " + l.getColumnNumber() + " of " + l.getSystemId());
                throw e;
            }
            ++pos;
        }
        return;
        do {
            System.out.println("\tattribute " + reader.getAttributeName(i) + "='" + reader.getAttributeValue(i) + "'");
            ++i;
lbl97:
            // 2 sources

        } while (i < l);
        ** while (true)
    }

    private static String encodeText(String text) {
        StringBuffer b = new StringBuffer();
        int len = text.length();
        int i = 0;
        while (i < len) {
            char c = text.charAt(i);
            switch (c) {
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                default: {
                    b.append(c);
                }
            }
            ++i;
        }
        return b.toString();
    }

    class AnyContentModel
    extends ContentModel {
        AnyContentModel() {
            super(1);
            this.min = 0;
            this.max = -1;
        }
    }

    class Attribute {
        final String name;
        final String type;
        final boolean specified;
        final String value;
        final String prefix;
        final String localName;

        Attribute(String name, String type, boolean specified, String value) {
            this.name = name;
            this.type = type;
            this.specified = specified;
            this.value = value;
            int ci = name.indexOf(58);
            if (ci == -1) {
                this.prefix = null;
                this.localName = XMLParser.this.intern(name);
            } else {
                this.prefix = XMLParser.this.intern(name.substring(0, ci));
                this.localName = XMLParser.this.intern(name.substring(ci + 1));
            }
        }

        public boolean equals(Object other) {
            if (other instanceof Attribute) {
                Attribute a = (Attribute)other;
                if (XMLParser.this.namespaceAware) {
                    if (!a.localName.equals(this.localName)) {
                        return false;
                    }
                    String auri = XMLParser.this.getNamespaceURI(a.prefix);
                    String uri = XMLParser.this.getNamespaceURI(this.prefix);
                    if (uri == null && (auri == null || ((XMLParser)XMLParser.this).input.xml11 && "".equals(auri))) {
                        return true;
                    }
                    if (uri != null) {
                        if ("".equals(uri) && ((XMLParser)XMLParser.this).input.xml11 && "".equals(auri)) {
                            return true;
                        }
                        return uri.equals(auri);
                    }
                    return false;
                }
                return a.name.equals(this.name);
            }
            return false;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.getClass().getName());
            buf.append('[');
            buf.append("name=");
            buf.append(this.name);
            if (this.value != null) {
                buf.append(",value=");
                buf.append(this.value);
            }
            if (this.type != null) {
                buf.append(",type=");
                buf.append(this.type);
            }
            if (this.specified) {
                buf.append(",specified");
            }
            buf.append(']');
            return buf.toString();
        }
    }

    class AttributeDecl {
        final String type;
        final String value;
        final int valueType;
        final String enumeration;
        final HashSet values;
        final boolean external;

        AttributeDecl(String type, String value, int valueType, String enumeration, HashSet values, boolean external) {
            this.type = type;
            this.value = value;
            this.valueType = valueType;
            this.enumeration = enumeration;
            this.values = values;
            this.external = external;
        }
    }

    abstract class ContentModel {
        static final int EMPTY = 0;
        static final int ANY = 1;
        static final int ELEMENT = 2;
        static final int MIXED = 3;
        int min;
        int max;
        final int type;
        String text;
        boolean external;

        ContentModel(int type) {
            this.type = type;
            this.min = 1;
            this.max = 1;
        }
    }

    class ContentParticle {
        int min = 1;
        int max = 1;
        Object content;

        ContentParticle() {
        }
    }

    class Doctype {
        final String rootName;
        final String publicId;
        final String systemId;
        private final LinkedHashMap elements = new LinkedHashMap();
        private final LinkedHashMap attlists = new LinkedHashMap();
        private final LinkedHashMap entities = new LinkedHashMap();
        private final LinkedHashMap notations = new LinkedHashMap();
        private final LinkedHashMap comments = new LinkedHashMap();
        private final LinkedHashMap pis = new LinkedHashMap();
        private final LinkedList entries = new LinkedList();
        private final HashSet externalEntities = new HashSet();
        private final HashSet externalNotations = new HashSet();
        private int anon = 1;

        Doctype(String rootName, String publicId, String systemId) {
            this.rootName = rootName;
            this.publicId = publicId;
            this.systemId = systemId;
        }

        void addElementDecl(String name, String text, ContentModel model) {
            if (this.elements.containsKey(name)) {
                return;
            }
            model.text = text;
            model.external = XMLParser.this.inputStack.size() != 1;
            this.elements.put(name, model);
            this.entries.add("E" + name);
        }

        void addAttributeDecl(String ename, String aname, AttributeDecl decl) {
            LinkedHashMap<String, AttributeDecl> attlist = (LinkedHashMap<String, AttributeDecl>)this.attlists.get(ename);
            if (attlist == null) {
                attlist = new LinkedHashMap<String, AttributeDecl>();
                this.attlists.put(ename, attlist);
            } else if (attlist.containsKey(aname)) {
                return;
            }
            attlist.put(aname, decl);
            String key = "A" + ename;
            if (!this.entries.contains(key)) {
                this.entries.add(key);
            }
        }

        void addEntityDecl(String name, String text, boolean inExternalSubset) {
            if (this.entities.containsKey(name)) {
                return;
            }
            this.entities.put(name, text);
            this.entries.add("e" + name);
            if (inExternalSubset) {
                this.externalEntities.add(name);
            }
        }

        void addEntityDecl(String name, ExternalIds ids, boolean inExternalSubset) {
            if (this.entities.containsKey(name)) {
                return;
            }
            this.entities.put(name, ids);
            this.entries.add("e" + name);
            if (inExternalSubset) {
                this.externalEntities.add(name);
            }
        }

        void addNotationDecl(String name, ExternalIds ids, boolean inExternalSubset) {
            if (this.notations.containsKey(name)) {
                return;
            }
            this.notations.put(name, ids);
            this.entries.add("n" + name);
            if (inExternalSubset) {
                this.externalNotations.add(name);
            }
        }

        void addComment(String text) {
            String key = Integer.toString(this.anon++);
            this.comments.put(key, text);
            this.entries.add("c" + key);
        }

        void addPI(String target, String data) {
            String key = Integer.toString(this.anon++);
            this.pis.put(key, new String[]{target, data});
            this.entries.add("p" + key);
        }

        ContentModel getElementModel(String name) {
            return (ContentModel)this.elements.get(name);
        }

        AttributeDecl getAttributeDecl(String ename, String aname) {
            LinkedHashMap attlist = (LinkedHashMap)this.attlists.get(ename);
            return attlist == null ? null : (AttributeDecl)attlist.get(aname);
        }

        boolean isAttributeDeclared(String ename, String aname) {
            LinkedHashMap attlist = (LinkedHashMap)this.attlists.get(ename);
            return attlist == null ? false : attlist.containsKey(aname);
        }

        Iterator attlistIterator(String ename) {
            LinkedHashMap attlist = (LinkedHashMap)this.attlists.get(ename);
            return attlist == null ? Collections.EMPTY_LIST.iterator() : attlist.entrySet().iterator();
        }

        Object getEntity(String name) {
            return this.entities.get(name);
        }

        boolean isEntityExternal(String name) {
            return this.externalEntities.contains(name);
        }

        Iterator entityIterator() {
            return this.entities.entrySet().iterator();
        }

        ExternalIds getNotation(String name) {
            return (ExternalIds)this.notations.get(name);
        }

        boolean isNotationExternal(String name) {
            return this.externalNotations.contains(name);
        }

        String getComment(String key) {
            return (String)this.comments.get(key);
        }

        String[] getPI(String key) {
            return (String[])this.pis.get(key);
        }

        Iterator entryIterator() {
            return this.entries.iterator();
        }
    }

    class ElementContentModel
    extends ContentModel {
        LinkedList contentParticles;
        boolean or;
        String regex;

        ElementContentModel() {
            super(2);
            this.contentParticles = new LinkedList();
        }

        void addContentParticle(ContentParticle cp) {
            this.contentParticles.add(cp);
        }
    }

    class EmptyContentModel
    extends ContentModel {
        EmptyContentModel() {
            super(0);
            this.min = 0;
            this.max = 0;
        }
    }

    class ExternalIds {
        String publicId;
        String systemId;
        String notationName;

        ExternalIds() {
        }
    }

    static class Input
    implements Location {
        int line = 1;
        int markLine;
        int column;
        int markColumn;
        int offset;
        int markOffset;
        final String publicId;
        final String systemId;
        final String name;
        final boolean report;
        final boolean normalize;
        InputStream in;
        Reader reader;
        UnicodeReader unicodeReader;
        boolean initialized;
        boolean encodingDetected;
        String inputEncoding;
        boolean xml11;
        private static final int[] SIGNATURE_UCS_4_1234;
        private static final int[] SIGNATURE_UCS_4_4321;
        private static final int[] SIGNATURE_UCS_4_2143;
        private static final int[] SIGNATURE_UCS_4_3412;
        private static final int[] SIGNATURE_UCS_2_12;
        private static final int[] SIGNATURE_UCS_2_21;
        private static final int[] SIGNATURE_UCS_2_12_NOBOM;
        private static final int[] SIGNATURE_UCS_2_21_NOBOM;
        private static final int[] SIGNATURE_UTF_8;
        private static final int[] SIGNATURE_UTF_8_BOM;

        static {
            int[] nArray = new int[4];
            nArray[3] = 60;
            SIGNATURE_UCS_4_1234 = nArray;
            int[] nArray2 = new int[4];
            nArray2[0] = 60;
            SIGNATURE_UCS_4_4321 = nArray2;
            int[] nArray3 = new int[4];
            nArray3[2] = 60;
            SIGNATURE_UCS_4_2143 = nArray3;
            int[] nArray4 = new int[4];
            nArray4[1] = 60;
            SIGNATURE_UCS_4_3412 = nArray4;
            SIGNATURE_UCS_2_12 = new int[]{254, 255};
            SIGNATURE_UCS_2_21 = new int[]{255, 254};
            int[] nArray5 = new int[4];
            nArray5[1] = 60;
            nArray5[3] = 63;
            SIGNATURE_UCS_2_12_NOBOM = nArray5;
            int[] nArray6 = new int[4];
            nArray6[0] = 60;
            nArray6[2] = 63;
            SIGNATURE_UCS_2_21_NOBOM = nArray6;
            SIGNATURE_UTF_8 = new int[]{60, 63, 120, 109};
            SIGNATURE_UTF_8_BOM = new int[]{239, 187, 191};
        }

        Input(InputStream in, Reader reader, String publicId, String systemId, String name, String inputEncoding, boolean report, boolean normalize) {
            if (inputEncoding == null) {
                inputEncoding = "UTF-8";
            }
            this.inputEncoding = inputEncoding;
            this.publicId = publicId;
            this.systemId = systemId;
            this.name = name;
            this.report = report;
            this.normalize = normalize;
            if (in != null) {
                if (reader != null) {
                    throw new IllegalStateException("both byte and char streams specified");
                }
                if (normalize) {
                    in = new CRLFInputStream(in);
                }
                this.in = in = new BufferedInputStream(in);
            } else {
                this.reader = normalize ? new CRLFReader(reader) : reader;
                this.unicodeReader = new UnicodeReader(this.reader);
            }
            this.initialized = false;
        }

        public int getCharacterOffset() {
            return this.offset;
        }

        public int getColumnNumber() {
            return this.column;
        }

        public int getLineNumber() {
            return this.line;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        void init() throws IOException {
            if (this.initialized) {
                return;
            }
            if (this.in != null) {
                this.detectEncoding();
            }
            this.initialized = true;
        }

        void mark(int len) throws IOException {
            this.markOffset = this.offset;
            this.markLine = this.line;
            this.markColumn = this.column;
            if (this.unicodeReader != null) {
                this.unicodeReader.mark(len);
            } else {
                this.in.mark(len);
            }
        }

        int read() throws IOException {
            int ret;
            ++this.offset;
            int n = ret = this.unicodeReader != null ? this.unicodeReader.read() : this.in.read();
            if (this.normalize && (ret == 13 || this.xml11 && (ret == 133 || ret == 8232))) {
                ret = 10;
            }
            if (ret == 10) {
                ++this.line;
                this.column = 0;
            } else {
                ++this.column;
            }
            return ret;
        }

        int read(int[] b, int off, int len) throws IOException {
            int ret;
            if (this.unicodeReader != null) {
                ret = this.unicodeReader.read(b, off, len);
            } else {
                byte[] b2 = new byte[len];
                ret = this.in.read(b2, 0, len);
                if (ret != -1) {
                    String s = new String(b2, 0, ret, this.inputEncoding);
                    int[] c = UnicodeReader.toCodePointArray(s);
                    ret = c.length;
                    System.arraycopy(c, 0, b, off, ret);
                }
            }
            if (ret != -1) {
                int i = 0;
                while (i < ret) {
                    int c = b[off + i];
                    if (this.normalize && (c == 13 || this.xml11 && (c == 133 || c == 8232))) {
                        b[off + i] = c = 10;
                    }
                    if (c == 10) {
                        ++this.line;
                        this.column = 0;
                    } else {
                        ++this.column;
                    }
                    ++i;
                }
            }
            return ret;
        }

        void reset() throws IOException {
            if (this.unicodeReader != null) {
                this.unicodeReader.reset();
            } else {
                this.in.reset();
            }
            this.offset = this.markOffset;
            this.line = this.markLine;
            this.column = this.markColumn;
        }

        private void detectEncoding() throws IOException {
            int[] signature = new int[4];
            this.in.mark(4);
            int i = 0;
            while (i < 4) {
                signature[i] = this.in.read();
                ++i;
            }
            this.in.reset();
            if (Input.equals(SIGNATURE_UCS_4_1234, signature)) {
                this.in.read();
                this.in.read();
                this.in.read();
                this.in.read();
                this.setInputEncoding("UTF-32BE");
                this.encodingDetected = true;
            } else if (Input.equals(SIGNATURE_UCS_4_4321, signature)) {
                this.in.read();
                this.in.read();
                this.in.read();
                this.in.read();
                this.setInputEncoding("UTF-32LE");
                this.encodingDetected = true;
            } else {
                if (Input.equals(SIGNATURE_UCS_4_2143, signature) || Input.equals(SIGNATURE_UCS_4_3412, signature)) {
                    throw new UnsupportedEncodingException("unsupported UCS-4 byte ordering");
                }
                if (Input.equals(SIGNATURE_UCS_2_12, signature)) {
                    this.in.read();
                    this.in.read();
                    this.setInputEncoding("UTF-16BE");
                    this.encodingDetected = true;
                } else if (Input.equals(SIGNATURE_UCS_2_21, signature)) {
                    this.in.read();
                    this.in.read();
                    this.setInputEncoding("UTF-16LE");
                    this.encodingDetected = true;
                } else {
                    if (Input.equals(SIGNATURE_UCS_2_12_NOBOM, signature)) {
                        throw new UnsupportedEncodingException("no byte-order mark for UCS-2 entity");
                    }
                    if (Input.equals(SIGNATURE_UCS_2_21_NOBOM, signature)) {
                        throw new UnsupportedEncodingException("no byte-order mark for UCS-2 entity");
                    }
                    if (!Input.equals(SIGNATURE_UTF_8, signature) && Input.equals(SIGNATURE_UTF_8_BOM, signature)) {
                        this.in.read();
                        this.in.read();
                        this.in.read();
                        this.setInputEncoding("UTF-8");
                        this.encodingDetected = true;
                    }
                }
            }
        }

        private static boolean equals(int[] b1, int[] b2) {
            int i = 0;
            while (i < b1.length) {
                if (b1[i] != b2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        void setInputEncoding(String encoding) throws IOException {
            if (encoding.equals(this.inputEncoding)) {
                return;
            }
            if ("UTF-16".equalsIgnoreCase(encoding) && this.inputEncoding.startsWith("UTF-16")) {
                return;
            }
            if (this.encodingDetected) {
                throw new UnsupportedEncodingException("document is not in its declared encoding " + this.inputEncoding + ": " + encoding);
            }
            this.inputEncoding = encoding;
            this.finalizeEncoding();
        }

        void finalizeEncoding() throws IOException {
            if (this.reader != null) {
                return;
            }
            this.reader = new BufferedReader(new InputStreamReader(this.in, this.inputEncoding));
            this.unicodeReader = new UnicodeReader(this.reader);
            this.mark(1);
        }
    }

    class MixedContentModel
    extends ContentModel {
        private HashSet names;

        MixedContentModel() {
            super(3);
            this.names = new HashSet();
        }

        void addName(String name) {
            this.names.add(name);
        }

        boolean containsName(String name) {
            return this.names.contains(name);
        }
    }
}

