/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.sax;

import gnu.xml.libxmlj.sax.GnomeLocator;
import gnu.xml.libxmlj.sax.Namespaces;
import gnu.xml.libxmlj.sax.StringArrayAttributes;
import gnu.xml.libxmlj.sax.XMLName;
import gnu.xml.libxmlj.util.NamedInputStream;
import gnu.xml.libxmlj.util.StandaloneLocator;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;

public class GnomeXMLReader
implements XMLReader {
    private static final String FEATURES_PREFIX = "http://xml.org/sax/features/";
    private static final List RECOGNIZED_FEATURES;
    private static final String PROPERTIES_PREFIX = "http://xml.org/sax/properties/";
    private static final List RECOGNIZED_PROPERTIES;
    private transient boolean standalone;
    private boolean namespaces;
    private boolean namespacePrefixes;
    private boolean validation;
    private ContentHandler contentHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private DeclHandler declarationHandler;
    private LexicalHandler lexicalHandler;
    private GnomeLocator locator;
    private transient Namespaces ns;
    private transient boolean seenFatalError;
    private transient boolean seenStartDocument;
    private transient String base;

    static {
        XMLJ.init();
        RECOGNIZED_FEATURES = Arrays.asList("external-general-entities", "external-parameter-entities", "is-standalone", "lexical-handler/parameter-entities", "namespaces", "namespace-prefixes", "resolve-dtd-uris", "string-interning", "use-attributes2", "use-locator2", "use-entity-resolver2", "validation");
        RECOGNIZED_PROPERTIES = Arrays.asList("declaration-handler", "dom-node", "lexical-handler", "xml-string");
    }

    public GnomeXMLReader() {
        this(true, true);
    }

    public GnomeXMLReader(boolean namespaces, boolean validation) {
        this.namespaces = namespaces;
        this.validation = validation;
        this.ns = new Namespaces();
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkFeatureName(name);
        String key = name.substring(FEATURES_PREFIX.length());
        if ("external-general-entities".equals(key)) {
            return this.validation;
        }
        if ("external-parameter-entities".equals(key)) {
            return this.validation;
        }
        if ("is-standalone".equals(key)) {
            return this.standalone;
        }
        if ("namespaces".equals(key)) {
            return this.namespaces;
        }
        if ("namespace-prefixes".equals(key)) {
            return this.namespacePrefixes;
        }
        if ("resolve-dtd-uris".equals(key)) {
            return true;
        }
        if ("validation".equals(key)) {
            return this.validation;
        }
        return false;
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkFeatureName(name);
        String key = name.substring(FEATURES_PREFIX.length());
        if ("namespaces".equals(key)) {
            this.namespaces = value;
        } else if ("namespace-prefixes".equals(key)) {
            this.namespacePrefixes = value;
        } else if ("validation".equals(key)) {
            this.validation = value;
        }
    }

    static void checkFeatureName(String name) throws SAXNotRecognizedException {
        if (name == null || !name.startsWith(FEATURES_PREFIX)) {
            throw new SAXNotRecognizedException(name);
        }
        String key = name.substring(FEATURES_PREFIX.length());
        if (!RECOGNIZED_FEATURES.contains(key)) {
            throw new SAXNotRecognizedException(name);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkPropertyName(name);
        String key = name.substring(PROPERTIES_PREFIX.length());
        if ("declaration-handler".equals(key)) {
            return this.getDeclarationHandler();
        }
        if ("lexical-handler".equals(key)) {
            return this.getLexicalHandler();
        }
        throw new SAXNotSupportedException(name);
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        GnomeXMLReader.checkPropertyName(name);
        String key = name.substring(PROPERTIES_PREFIX.length());
        if ("declaration-handler".equals(key)) {
            this.setDeclarationHandler((DeclHandler)value);
        } else if ("lexical-handler".equals(key)) {
            this.setLexicalHandler((LexicalHandler)value);
        }
    }

    public DeclHandler getDeclarationHandler() {
        return this.declarationHandler;
    }

    public void setDeclarationHandler(DeclHandler declarationHandler) {
        this.declarationHandler = declarationHandler;
    }

    public LexicalHandler getLexicalHandler() {
        return this.lexicalHandler;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    static void checkPropertyName(String name) throws SAXNotRecognizedException {
        if (!name.startsWith(PROPERTIES_PREFIX)) {
            throw new SAXNotRecognizedException(name);
        }
        String key = name.substring(PROPERTIES_PREFIX.length());
        if (!RECOGNIZED_PROPERTIES.contains(key)) {
            throw new SAXNotRecognizedException(name);
        }
    }

    public void parse(String systemId) throws IOException, SAXException {
        URL url = null;
        try {
            url = new URL(systemId);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(systemId);
            if (!file.exists()) {
                throw new FileNotFoundException(systemId);
            }
            String path = file.getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (!path.endsWith("/") && file.isDirectory()) {
                path = String.valueOf(path) + "/";
            }
            url = new URL("file:" + path);
        }
        InputSource source = new InputSource(url.toString());
        source.setByteStream(url.openStream());
        this.parse(source);
    }

    public synchronized void parse(InputSource input) throws IOException, SAXException {
        int lsi;
        NamedInputStream in = XMLJ.getInputStream(input);
        byte[] detectBuffer = in.getDetectBuffer();
        String publicId = input.getPublicId();
        String systemId = input.getSystemId();
        this.base = XMLJ.getBaseURI(systemId);
        this.standalone = false;
        this.seenFatalError = false;
        this.seenStartDocument = false;
        if (systemId != null && (lsi = systemId.lastIndexOf(47)) != -1) {
            this.base = systemId.substring(0, lsi + 1);
        }
        if (detectBuffer == null) {
            this.startDocument(true);
            this.fatalError("No document element", 0, 0, publicId, systemId);
            this.endDocument();
            return;
        }
        this.parseStream(in, detectBuffer, publicId, systemId, this.base, this.validation, this.contentHandler != null, this.dtdHandler != null, this.entityResolver != null, this.errorHandler != null, this.declarationHandler != null, this.lexicalHandler != null);
        in.close();
    }

    native void parseStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12) throws IOException, SAXException;

    String getURI(String prefix) {
        if (!this.namespaces) {
            return null;
        }
        return this.ns.getURI(prefix);
    }

    private void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.seenFatalError || this.lexicalHandler == null) {
            return;
        }
        try {
            systemId = XMLJ.getAbsoluteURI(this.base, systemId);
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            systemId = XMLJ.getAbsoluteURI(this.base, systemId);
            this.declarationHandler.externalEntityDecl(name, publicId, systemId);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void internalEntityDecl(String name, String value) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            this.declarationHandler.internalEntityDecl(name, value);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private InputStream resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (this.entityResolver == null) {
            return null;
        }
        try {
            systemId = XMLJ.getAbsoluteURI(this.base, systemId);
            InputSource source = this.entityResolver.resolveEntity(publicId, systemId);
            return source == null ? null : XMLJ.getInputStream(source);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.seenFatalError || this.dtdHandler == null) {
            return;
        }
        try {
            systemId = XMLJ.getAbsoluteURI(this.base, systemId);
            this.dtdHandler.notationDecl(name, publicId, systemId);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            this.declarationHandler.attributeDecl(eName, aName, type, mode, value);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void elementDecl(String name, String model) throws SAXException {
        if (this.seenFatalError || this.declarationHandler == null) {
            return;
        }
        try {
            this.declarationHandler.elementDecl(name, model);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.seenFatalError || this.dtdHandler == null) {
            return;
        }
        try {
            systemId = XMLJ.getAbsoluteURI(this.base, systemId);
            this.dtdHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void setDocumentLocator(Object ctx, Object loc) {
        this.locator = new GnomeLocator(ctx, loc);
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            this.contentHandler.setDocumentLocator(this.locator);
        }
        catch (Exception exception) {}
    }

    private void startDocument(boolean standalone) throws SAXException {
        this.standalone = standalone;
        this.seenStartDocument = true;
        if (this.contentHandler == null) {
            return;
        }
        try {
            this.contentHandler.startDocument();
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        try {
            this.contentHandler.endDocument();
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void startElement(String name, String[] attrs) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            XMLName xName = new XMLName(this, name);
            if (this.namespaces) {
                int len;
                this.ns.push();
                int n = len = attrs == null ? 0 : attrs.length;
                if (len > 0) {
                    ArrayList<String> filtered = new ArrayList<String>(len);
                    int i = 0;
                    while (i < len) {
                        String attName = attrs[i];
                        String attValue = attrs[i + 1];
                        if (attName.equals("xmlns")) {
                            this.startPrefixMapping("", attValue);
                        } else if (attName.startsWith("xmlns:")) {
                            this.startPrefixMapping(attName.substring(6), attValue);
                        } else {
                            filtered.add(attName);
                            filtered.add(attValue);
                        }
                        i += 2;
                    }
                    attrs = new String[filtered.size()];
                    filtered.toArray(attrs);
                }
            }
            StringArrayAttributes atts = new StringArrayAttributes(this, attrs);
            this.contentHandler.startElement(xName.uri, xName.localName, xName.qName, atts);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void endElement(String name) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            XMLName xName = new XMLName(this, name);
            String uri = xName.uri == null ? "" : xName.uri;
            this.contentHandler.endElement(uri, xName.localName, xName.qName);
            if (this.namespaces) {
                Iterator i = this.ns.currentPrefixes();
                while (i.hasNext()) {
                    this.endPrefixMapping((String)i.next());
                }
                this.ns.pop();
            }
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        this.ns.define(prefix, uri);
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    private void endPrefixMapping(String prefix) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        this.contentHandler.endPrefixMapping(prefix);
    }

    private void characters(String text) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null || text == null) {
            return;
        }
        try {
            char[] ch = text.toCharArray();
            this.contentHandler.characters(ch, 0, ch.length);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void ignorableWhitespace(String text) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null || text == null) {
            return;
        }
        try {
            char[] ch = text.toCharArray();
            this.contentHandler.ignorableWhitespace(ch, 0, ch.length);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void processingInstruction(String target, String data) throws SAXException {
        if (this.seenFatalError || this.contentHandler == null) {
            return;
        }
        try {
            if (data == null) {
                data = "";
            }
            this.contentHandler.processingInstruction(target, data);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void comment(String text) throws SAXException {
        if (this.seenFatalError || this.lexicalHandler == null || text == null) {
            return;
        }
        try {
            char[] ch = text.toCharArray();
            this.lexicalHandler.comment(ch, 0, ch.length);
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void cdataBlock(String text) throws SAXException {
        if (this.seenFatalError || text == null) {
            return;
        }
        try {
            if (this.lexicalHandler == null) {
                this.characters(text);
            } else {
                this.lexicalHandler.startCDATA();
                this.characters(text);
                this.lexicalHandler.endCDATA();
            }
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void warning(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws SAXException {
        if (this.seenFatalError || this.errorHandler == null) {
            return;
        }
        try {
            StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
            this.errorHandler.warning(new SAXParseException(message, l));
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void error(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws SAXException {
        if (this.seenFatalError || this.errorHandler == null) {
            return;
        }
        try {
            StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
            this.errorHandler.error(new SAXParseException(message, l));
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }

    private void fatalError(String message, int lineNumber, int columnNumber, String publicId, String systemId) throws SAXException {
        if (this.seenFatalError || this.errorHandler == null) {
            return;
        }
        try {
            if (!this.seenStartDocument) {
                this.startDocument(false);
            }
            this.seenFatalError = true;
            StandaloneLocator l = new StandaloneLocator(lineNumber, columnNumber, publicId, systemId);
            this.errorHandler.fatalError(new SAXParseException(message, l));
        }
        catch (Exception e) {
            if (e instanceof SAXException) {
                throw (SAXException)e;
            }
            throw new SAXException(e);
        }
    }
}

