/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.aelfred2;

import gnu.java.security.action.GetPropertyAction;
import gnu.xml.aelfred2.SAXDriver;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class XmlParser {
    private static final boolean USE_CHEATS = true;
    public static final int CONTENT_UNDECLARED = 0;
    public static final int CONTENT_ANY = 1;
    public static final int CONTENT_EMPTY = 2;
    public static final int CONTENT_MIXED = 3;
    public static final int CONTENT_ELEMENTS = 4;
    public static final int ENTITY_UNDECLARED = 0;
    public static final int ENTITY_INTERNAL = 1;
    public static final int ENTITY_NDATA = 2;
    public static final int ENTITY_TEXT = 3;
    private static final int ENCODING_EXTERNAL = 0;
    private static final int ENCODING_UTF_8 = 1;
    private static final int ENCODING_ISO_8859_1 = 2;
    private static final int ENCODING_UCS_2_12 = 3;
    private static final int ENCODING_UCS_2_21 = 4;
    private static final int ENCODING_UCS_4_1234 = 5;
    private static final int ENCODING_UCS_4_4321 = 6;
    private static final int ENCODING_UCS_4_2143 = 7;
    private static final int ENCODING_UCS_4_3412 = 8;
    private static final int ENCODING_ASCII = 9;
    public static final int ATTRIBUTE_DEFAULT_UNDECLARED = 30;
    public static final int ATTRIBUTE_DEFAULT_SPECIFIED = 31;
    public static final int ATTRIBUTE_DEFAULT_IMPLIED = 32;
    public static final int ATTRIBUTE_DEFAULT_REQUIRED = 33;
    public static final int ATTRIBUTE_DEFAULT_FIXED = 34;
    private static final int INPUT_NONE = 0;
    private static final int INPUT_INTERNAL = 1;
    private static final int INPUT_STREAM = 3;
    private static final int INPUT_READER = 5;
    private static final int LIT_ENTITY_REF = 2;
    private static final int LIT_NORMALIZE = 4;
    private static final int LIT_ATTRIBUTE = 8;
    private static final int LIT_DISABLE_PE = 16;
    private static final int LIT_DISABLE_CREF = 32;
    private static final int LIT_DISABLE_EREF = 64;
    private static final int LIT_PUBID = 256;
    private static final int CONTEXT_NORMAL = 0;
    private static final int CONTEXT_LITERAL = 1;
    static boolean uriWarnings;
    private SAXDriver handler;
    private Reader reader;
    private InputStream is;
    private int line;
    private int column;
    private int sourceType;
    private LinkedList inputStack;
    private URLConnection externalEntity;
    private int encoding;
    private int currentByteCount;
    private InputSource scratch;
    private char[] readBuffer;
    private int readBufferPos;
    private int readBufferLength;
    private int readBufferOverflow;
    private static final int READ_BUFFER_MAX = 16384;
    private byte[] rawReadBuffer;
    private static int DATA_BUFFER_INITIAL;
    private char[] dataBuffer;
    private int dataBufferPos;
    private static int NAME_BUFFER_INITIAL;
    private char[] nameBuffer;
    private int nameBufferPos;
    private boolean docIsStandalone;
    private HashMap elementInfo;
    private HashMap entityInfo;
    private HashMap notationInfo;
    private boolean skippedPE;
    private String currentElement;
    private int currentElementContent;
    private LinkedList entityStack;
    private boolean inLiteral;
    private boolean expandPE;
    private boolean peIsError;
    private boolean doReport;
    private static final int SYMBOL_TABLE_LENGTH = 2039;
    private Object[][] symbolTable;
    private String[] tagAttributes;
    private int tagAttributePos;
    private boolean sawCR;
    private boolean inCDATA;
    private static final int XML_10 = 0;
    private static final int XML_11 = 1;
    private int xmlVersion = 0;
    static final char[] startDelimComment;
    static final char[] endDelimComment;
    static final char[] startDelimPI;
    static final char[] endDelimPI;
    static final char[] endDelimCDATA;
    private boolean isDirtyCurrentElement;

    static {
        String key = "gnu.xml.aelfred2.XmlParser.uriWarnings";
        GetPropertyAction a = new GetPropertyAction(key);
        uriWarnings = "true".equals(AccessController.doPrivileged(a));
        DATA_BUFFER_INITIAL = 4096;
        NAME_BUFFER_INITIAL = 1024;
        startDelimComment = new char[]{'<', '!', '-', '-'};
        endDelimComment = new char[]{'-', '-'};
        startDelimPI = new char[]{'<', '?'};
        endDelimPI = new char[]{'?', '>'};
        endDelimCDATA = new char[]{']', ']', '>'};
    }

    XmlParser() {
    }

    void setHandler(SAXDriver handler) {
        this.handler = handler;
    }

    void doParse(String systemId, String publicId, Reader reader, InputStream stream, String encoding) throws Exception {
        block33: {
            if (this.handler == null) {
                throw new IllegalStateException("no callback handler");
            }
            this.initializeVariables();
            this.setInternalEntity("amp", "&#38;");
            this.setInternalEntity("lt", "&#60;");
            this.setInternalEntity("gt", "&#62;");
            this.setInternalEntity("apos", "&#39;");
            this.setInternalEntity("quot", "&#34;");
            try {
                try {
                    this.handler.startDocument();
                    this.pushURL(false, "[document]", new ExternalIdentifiers(publicId, systemId, null), reader, stream, encoding, false);
                    this.parseDocument();
                }
                catch (EOFException eOFException) {
                    this.error("empty document, with no root element.");
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (this.is != null) {
                        try {
                            this.is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    this.scratch = null;
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.is != null) {
                    try {
                        this.is.close();
                    }
                    catch (IOException iOException) {}
                }
                this.scratch = null;
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
            if (this.is != null) {
                try {
                    this.is.close();
                }
                catch (IOException iOException) {}
            }
            this.scratch = null;
        }
    }

    private void error(String message, String textFound, String textExpected) throws SAXException {
        if (textFound != null) {
            message = String.valueOf(message) + " (found \"" + textFound + "\")";
        }
        if (textExpected != null) {
            message = String.valueOf(message) + " (expected \"" + textExpected + "\")";
        }
        this.handler.fatal(message);
        throw new SAXException(message);
    }

    private void error(String message, char textFound, String textExpected) throws SAXException {
        this.error(message, new Character(textFound).toString(), textExpected);
    }

    private void error(String message) throws SAXException {
        this.handler.fatal(message);
    }

    private void parseDocument() throws Exception {
        try {
            boolean sawDTD = this.parseProlog();
            this.require('<');
            this.parseElement(!sawDTD);
        }
        catch (EOFException eOFException) {
            this.error("premature end of file", "[EOF]", null);
        }
        try {
            this.parseMisc();
            char c = this.readCh();
            this.error("unexpected characters after document end", c, null);
        }
        catch (EOFException eOFException) {
            return;
        }
    }

    private void parseComment() throws Exception {
        boolean saved = this.expandPE;
        this.expandPE = false;
        this.parseUntil(endDelimComment);
        this.require('>');
        this.expandPE = saved;
        this.handler.comment(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
    }

    private void parsePI() throws SAXException, IOException {
        boolean saved = this.expandPE;
        this.expandPE = false;
        String name = this.readNmtoken(true);
        if (name.indexOf(58) >= 0) {
            this.error("Illegal character(':') in processing instruction name ", name, null);
        }
        if ("xml".equalsIgnoreCase(name)) {
            this.error("Illegal processing instruction target", name, null);
        }
        if (!this.tryRead(endDelimPI)) {
            this.requireWhitespace();
            this.parseUntil(endDelimPI);
        }
        this.expandPE = saved;
        this.handler.processingInstruction(name, this.dataBufferToString());
    }

    private void parseCDSect() throws Exception {
        this.parseUntil(endDelimCDATA);
        this.dataBufferFlush();
    }

    private boolean parseProlog() throws Exception {
        this.parseMisc();
        if (this.tryRead("<!DOCTYPE")) {
            this.parseDoctypedecl();
            this.parseMisc();
            return true;
        }
        return false;
    }

    private void checkLegalVersion(String version) throws SAXException {
        int len = version.length();
        int i = 0;
        while (i < len) {
            char c = version.charAt(i);
            if (!('0' <= c && c <= '9' || c == '_' || c == '.' || c == ':' || c == '-' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z')) {
                this.error("illegal character in version", version, "1.0");
            }
            ++i;
        }
    }

    private String parseXMLDecl(boolean ignoreEncoding) throws SAXException, IOException {
        String encodingName = null;
        String standalone = null;
        int flags = 112;
        String inputEncoding = null;
        switch (this.encoding) {
            case 0: 
            case 1: {
                inputEncoding = "UTF-8";
                break;
            }
            case 2: {
                inputEncoding = "ISO-8859-1";
                break;
            }
            case 3: {
                inputEncoding = "UTF-16BE";
                break;
            }
            case 4: {
                inputEncoding = "UTF-16LE";
            }
        }
        this.require("version");
        this.parseEq();
        String version = this.readLiteral(flags);
        this.checkLegalVersion(version);
        if (!version.equals("1.0")) {
            if (version.equals("1.1")) {
                this.handler.warn("expected XML version 1.0, not: " + version);
                this.xmlVersion = 1;
            } else {
                this.error("illegal XML version", version, "1.0 or 1.1");
            }
        } else {
            this.xmlVersion = 0;
        }
        boolean white = this.tryWhitespace();
        if (this.tryRead("encoding")) {
            if (!white) {
                this.error("whitespace required before 'encoding='");
            }
            this.parseEq();
            encodingName = this.readLiteral(flags);
            if (!ignoreEncoding) {
                this.setupDecoding(encodingName);
            }
        }
        if (encodingName != null) {
            white = this.tryWhitespace();
        }
        if (this.tryRead("standalone")) {
            if (!white) {
                this.error("whitespace required before 'standalone='");
            }
            this.parseEq();
            standalone = this.readLiteral(flags);
            if ("yes".equals(standalone)) {
                this.docIsStandalone = true;
            } else if (!"no".equals(standalone)) {
                this.error("standalone flag must be 'yes' or 'no'");
            }
        }
        this.skipWhitespace();
        this.require("?>");
        if (inputEncoding == null) {
            inputEncoding = encodingName;
        }
        return encodingName;
    }

    private String parseTextDecl(boolean ignoreEncoding) throws SAXException, IOException {
        String encodingName = null;
        int flags = 112;
        if (this.tryRead("version")) {
            this.parseEq();
            String version = this.readLiteral(flags);
            this.checkLegalVersion(version);
            if (version.equals("1.1")) {
                if (this.xmlVersion == 0) {
                    this.error("external subset has later version number.", "1.0", version);
                }
                this.handler.warn("expected XML version 1.0, not: " + version);
                this.xmlVersion = 1;
            } else if (!version.equals("1.0")) {
                this.error("illegal XML version", version, "1.0 or 1.1");
            }
            this.requireWhitespace();
        }
        this.require("encoding");
        this.parseEq();
        encodingName = this.readLiteral(flags);
        if (!ignoreEncoding) {
            this.setupDecoding(encodingName);
        }
        this.skipWhitespace();
        this.require("?>");
        return encodingName;
    }

    private void setupDecoding(String encodingName) throws SAXException, IOException {
        encodingName = encodingName.toUpperCase();
        if (this.encoding == 1 || this.encoding == 0) {
            if (encodingName.equals("ISO-8859-1") || encodingName.equals("8859_1") || encodingName.equals("ISO8859_1")) {
                this.encoding = 2;
                return;
            }
            if (encodingName.equals("US-ASCII") || encodingName.equals("ASCII")) {
                this.encoding = 9;
                return;
            }
            if (encodingName.equals("UTF-8") || encodingName.equals("UTF8")) {
                this.encoding = 1;
                return;
            }
            if (this.encoding != 0) {
                throw new UnsupportedEncodingException(encodingName);
            }
        }
        if (this.encoding == 3 || this.encoding == 4) {
            if (!(encodingName.equals("ISO-10646-UCS-2") || encodingName.equals("UTF-16") || encodingName.equals("UTF-16BE") || encodingName.equals("UTF-16LE"))) {
                this.error("unsupported Unicode encoding", encodingName, "UTF-16");
            }
            return;
        }
        if (this.encoding == 5 || this.encoding == 6 || this.encoding == 7 || this.encoding == 8) {
            if (!encodingName.equals("ISO-10646-UCS-4")) {
                this.error("unsupported 32-bit encoding", encodingName, "ISO-10646-UCS-4");
            }
            return;
        }
        if (encodingName.equals("UTF-16BE")) {
            this.encoding = 3;
            return;
        }
        if (encodingName.equals("UTF-16LE")) {
            this.encoding = 4;
            return;
        }
        if (encodingName.equals("UTF-16") || encodingName.equals("ISO-10646-UCS-2")) {
            encodingName = "Unicode";
        }
        this.reader = new InputStreamReader(this.is, encodingName);
        this.sourceType = 5;
    }

    private void parseMisc() throws Exception {
        while (true) {
            this.skipWhitespace();
            if (this.tryRead(startDelimPI)) {
                this.parsePI();
                continue;
            }
            if (!this.tryRead(startDelimComment)) break;
            this.parseComment();
        }
    }

    private void parseDoctypedecl() throws Exception {
        this.requireWhitespace();
        String rootName = this.readNmtoken(true);
        this.skipWhitespace();
        ExternalIdentifiers ids = this.readExternalIds(false, true);
        this.handler.doctypeDecl(rootName, ids.publicId, ids.systemId);
        this.skipWhitespace();
        if (this.tryRead('[')) {
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead(']')) break;
                this.expandPE = true;
                this.peIsError = true;
                this.parseMarkupdecl();
                this.expandPE = false;
                this.peIsError = false;
            }
        }
        this.skipWhitespace();
        this.require('>');
        InputSource subset = ids.systemId == null ? this.handler.getExternalSubset(rootName, this.handler.getSystemId()) : null;
        if (ids.systemId != null || subset != null) {
            this.pushString(null, ">");
            if (ids.systemId != null) {
                this.pushURL(true, "[dtd]", ids, null, null, null, true);
            } else {
                this.handler.warn("modifying document by adding external subset");
                this.pushURL(true, "[dtd]", new ExternalIdentifiers(subset.getPublicId(), subset.getSystemId(), null), subset.getCharacterStream(), subset.getByteStream(), subset.getEncoding(), false);
            }
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.error("external subset has unmatched '>'");
            }
        }
        this.handler.endDoctype();
        this.expandPE = false;
        this.doReport = true;
    }

    private void parseMarkupdecl() throws Exception {
        char[] saved = null;
        boolean savedPE = this.expandPE;
        this.require('<');
        this.unread('<');
        this.expandPE = false;
        if (this.tryRead("<!ELEMENT")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseElementDecl();
        } else if (this.tryRead("<!ATTLIST")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseAttlistDecl();
        } else if (this.tryRead("<!ENTITY")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseEntityDecl();
        } else if (this.tryRead("<!NOTATION")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseNotationDecl();
        } else if (this.tryRead(startDelimPI)) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parsePI();
        } else if (this.tryRead(startDelimComment)) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            this.parseComment();
        } else if (this.tryRead("<![")) {
            saved = this.readBuffer;
            this.expandPE = savedPE;
            if (this.inputStack.size() > 0) {
                this.parseConditionalSect(saved);
            } else {
                this.error("conditional sections illegal in internal subset");
            }
        } else {
            this.error("expected markup declaration");
        }
        if (this.readBuffer != saved) {
            this.handler.verror("Illegal Declaration/PE nesting");
        }
    }

    private void parseElement(boolean maybeGetSubset) throws Exception {
        InputSource subset;
        int oldElementContent = this.currentElementContent;
        String oldElement = this.currentElement;
        this.tagAttributePos = 0;
        String gi = this.readNmtoken(true);
        if (maybeGetSubset && (subset = this.handler.getExternalSubset(gi, this.handler.getSystemId())) != null) {
            String publicId = subset.getPublicId();
            String systemId = subset.getSystemId();
            this.handler.warn("modifying document by adding DTD");
            this.handler.doctypeDecl(gi, publicId, systemId);
            this.pushString(null, ">");
            this.pushURL(true, "[dtd]", new ExternalIdentifiers(publicId, systemId, null), subset.getCharacterStream(), subset.getByteStream(), subset.getEncoding(), false);
            while (true) {
                this.expandPE = true;
                this.doReport = true;
                this.skipWhitespace();
                this.expandPE = false;
                this.doReport = false;
                if (this.tryRead('>')) break;
                this.expandPE = true;
                this.parseMarkupdecl();
                this.expandPE = false;
            }
            if (this.inputStack.size() != 1) {
                this.error("external subset has unmatched '>'");
            }
            this.handler.endDoctype();
        }
        this.currentElement = gi;
        ElementDecl element = (ElementDecl)this.elementInfo.get(gi);
        this.currentElementContent = this.getContentType(element, 1);
        boolean white = this.tryWhitespace();
        char c = this.readCh();
        while (c != '/' && c != '>') {
            this.unread(c);
            if (!white) {
                this.error("need whitespace between attributes");
            }
            this.parseAttribute(gi);
            white = this.tryWhitespace();
            c = this.readCh();
        }
        Iterator atts = this.declaredAttributes(element);
        if (atts != null) {
            block6: while (atts.hasNext()) {
                String aname = (String)atts.next();
                int i = 0;
                while (i < this.tagAttributePos) {
                    if (this.tagAttributes[i] == aname) continue block6;
                    ++i;
                }
                String value = this.getAttributeDefaultValue(gi, aname);
                if (value == null) continue;
                this.handler.attribute(aname, value, false);
            }
        }
        switch (c) {
            case '>': {
                this.handler.startElement(gi);
                this.parseContent();
                break;
            }
            case '/': {
                this.require('>');
                this.handler.startElement(gi);
                this.handler.endElement(gi);
            }
        }
        this.currentElement = oldElement;
        this.currentElementContent = oldElementContent;
    }

    private void parseAttribute(String name) throws Exception {
        int flags = 10;
        String aname = this.readNmtoken(true);
        String type = this.getAttributeType(name, aname);
        this.parseEq();
        String value = this.handler.stringInterning ? (type == "CDATA" || type == null ? this.readLiteral(flags) : this.readLiteral(flags | 4)) : (type == null || type.equals("CDATA") ? this.readLiteral(flags) : this.readLiteral(flags | 4));
        int i = 0;
        while (i < this.tagAttributePos) {
            if (aname.equals(this.tagAttributes[i])) {
                this.error("duplicate attribute", aname, null);
            }
            ++i;
        }
        this.handler.attribute(aname, value, true);
        this.dataBufferPos = 0;
        if (this.tagAttributePos == this.tagAttributes.length) {
            String[] newAttrib = new String[this.tagAttributes.length * 2];
            System.arraycopy(this.tagAttributes, 0, newAttrib, 0, this.tagAttributePos);
            this.tagAttributes = newAttrib;
        }
        this.tagAttributes[this.tagAttributePos++] = aname;
    }

    private void parseEq() throws SAXException, IOException {
        this.skipWhitespace();
        this.require('=');
        this.skipWhitespace();
    }

    private void parseETag() throws Exception {
        this.require(this.currentElement);
        this.skipWhitespace();
        this.require('>');
        this.handler.endElement(this.currentElement);
    }

    private void parseContent() throws Exception {
        while (true) {
            this.parseCharData();
            char c = this.readCh();
            block0 : switch (c) {
                case '&': {
                    c = this.readCh();
                    if (c == '#') {
                        this.parseCharRef();
                    } else {
                        this.unread(c);
                        this.parseEntityRef(true);
                    }
                    this.isDirtyCurrentElement = true;
                    break;
                }
                case '<': {
                    this.dataBufferFlush();
                    c = this.readCh();
                    switch (c) {
                        case '!': {
                            c = this.readCh();
                            switch (c) {
                                case '-': {
                                    this.require('-');
                                    this.isDirtyCurrentElement = false;
                                    this.parseComment();
                                    break;
                                }
                                case '[': {
                                    this.isDirtyCurrentElement = false;
                                    this.require("CDATA[");
                                    this.handler.startCDATA();
                                    this.inCDATA = true;
                                    this.parseCDSect();
                                    this.inCDATA = false;
                                    this.handler.endCDATA();
                                    break;
                                }
                                default: {
                                    this.error("expected comment or CDATA section", c, null);
                                    break;
                                }
                            }
                            break block0;
                        }
                        case '?': {
                            this.isDirtyCurrentElement = false;
                            this.parsePI();
                            break block0;
                        }
                        case '/': {
                            this.isDirtyCurrentElement = false;
                            this.parseETag();
                            return;
                        }
                        default: {
                            this.isDirtyCurrentElement = false;
                            this.unread(c);
                            this.parseElement(false);
                        }
                    }
                }
            }
        }
    }

    private void parseElementDecl() throws Exception {
        this.requireWhitespace();
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        this.parseContentspec(name);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseContentspec(String name) throws Exception {
        String model;
        if (this.tryRead("EMPTY")) {
            this.setElement(name, 2, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(name, "EMPTY");
            }
            return;
        }
        if (this.tryRead("ANY")) {
            this.setElement(name, 1, null, null);
            if (!this.skippedPE) {
                this.handler.getDeclHandler().elementDecl(name, "ANY");
            }
            return;
        }
        this.require('(');
        char[] saved = this.readBuffer;
        this.dataBufferAppend('(');
        this.skipWhitespace();
        if (this.tryRead("#PCDATA")) {
            this.dataBufferAppend("#PCDATA");
            this.parseMixed(saved);
            model = this.dataBufferToString();
            this.setElement(name, 3, model, null);
        } else {
            this.parseElements(saved);
            model = this.dataBufferToString();
            this.setElement(name, 4, model, null);
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().elementDecl(name, model);
        }
    }

    private void parseElements(char[] saved) throws Exception {
        char sep;
        this.skipWhitespace();
        this.parseCp();
        this.skipWhitespace();
        char c = this.readCh();
        switch (c) {
            case ')': {
                if (this.readBuffer != saved) {
                    this.handler.verror("Illegal Group/PE nesting");
                }
                this.dataBufferAppend(')');
                c = this.readCh();
                switch (c) {
                    case '*': 
                    case '+': 
                    case '?': {
                        this.dataBufferAppend(c);
                        break;
                    }
                    default: {
                        this.unread(c);
                    }
                }
                return;
            }
            case ',': 
            case '|': {
                sep = c;
                this.dataBufferAppend(c);
                break;
            }
            default: {
                this.error("bad separator in content model", c, null);
                return;
            }
        }
        while (true) {
            this.skipWhitespace();
            this.parseCp();
            this.skipWhitespace();
            c = this.readCh();
            if (c == ')') {
                if (this.readBuffer != saved) {
                    this.handler.verror("Illegal Group/PE nesting");
                }
                break;
            }
            if (c != sep) {
                this.error("bad separator in content model", c, null);
                return;
            }
            this.dataBufferAppend(c);
        }
        this.dataBufferAppend(')');
        c = this.readCh();
        switch (c) {
            case '*': 
            case '+': 
            case '?': {
                this.dataBufferAppend(c);
                return;
            }
        }
        this.unread(c);
    }

    private void parseCp() throws Exception {
        if (this.tryRead('(')) {
            this.dataBufferAppend('(');
            this.parseElements(this.readBuffer);
        } else {
            this.dataBufferAppend(this.readNmtoken(true));
            char c = this.readCh();
            switch (c) {
                case '*': 
                case '+': 
                case '?': {
                    this.dataBufferAppend(c);
                    break;
                }
                default: {
                    this.unread(c);
                }
            }
        }
    }

    private void parseMixed(char[] saved) throws Exception {
        this.skipWhitespace();
        if (this.tryRead(')')) {
            if (this.readBuffer != saved) {
                this.handler.verror("Illegal Group/PE nesting");
            }
            this.dataBufferAppend(")*");
            this.tryRead('*');
            return;
        }
        this.skipWhitespace();
        while (!this.tryRead(")")) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(true));
            this.skipWhitespace();
        }
        if (this.readBuffer != saved) {
            this.handler.verror("Illegal Group/PE nesting");
        }
        this.require('*');
        this.dataBufferAppend(")*");
    }

    private void parseAttlistDecl() throws Exception {
        this.requireWhitespace();
        String elementName = this.readNmtoken(true);
        boolean white = this.tryWhitespace();
        while (!this.tryRead('>')) {
            if (!white) {
                this.error("whitespace required before attribute definition");
            }
            this.parseAttDef(elementName);
            white = this.tryWhitespace();
        }
    }

    private void parseAttDef(String elementName) throws Exception {
        String enumer = null;
        String name = this.readNmtoken(true);
        this.requireWhitespace();
        String type = this.readAttType();
        if (this.handler.stringInterning) {
            if ("ENUMERATION" == type || "NOTATION" == type) {
                enumer = this.dataBufferToString();
            }
        } else if ("ENUMERATION".equals(type) || "NOTATION".equals(type)) {
            enumer = this.dataBufferToString();
        }
        this.requireWhitespace();
        this.parseDefault(elementName, name, type, enumer);
    }

    private String readAttType() throws Exception {
        if (this.tryRead('(')) {
            this.parseEnumeration(false);
            return "ENUMERATION";
        }
        String typeString = this.readNmtoken(true);
        if (this.handler.stringInterning) {
            if ("NOTATION" == typeString) {
                this.parseNotationType();
                return typeString;
            }
            if ("CDATA" == typeString || "ID" == typeString || "IDREF" == typeString || "IDREFS" == typeString || "ENTITY" == typeString || "ENTITIES" == typeString || "NMTOKEN" == typeString || "NMTOKENS" == typeString) {
                return typeString;
            }
        } else {
            if ("NOTATION".equals(typeString)) {
                this.parseNotationType();
                return typeString;
            }
            if ("CDATA".equals(typeString) || "ID".equals(typeString) || "IDREF".equals(typeString) || "IDREFS".equals(typeString) || "ENTITY".equals(typeString) || "ENTITIES".equals(typeString) || "NMTOKEN".equals(typeString) || "NMTOKENS".equals(typeString)) {
                return typeString;
            }
        }
        this.error("illegal attribute type", typeString, null);
        return null;
    }

    private void parseEnumeration(boolean isNames) throws Exception {
        this.dataBufferAppend('(');
        this.skipWhitespace();
        this.dataBufferAppend(this.readNmtoken(isNames));
        this.skipWhitespace();
        while (!this.tryRead(')')) {
            this.require('|');
            this.dataBufferAppend('|');
            this.skipWhitespace();
            this.dataBufferAppend(this.readNmtoken(isNames));
            this.skipWhitespace();
        }
        this.dataBufferAppend(')');
    }

    private void parseNotationType() throws Exception {
        this.requireWhitespace();
        this.require('(');
        this.parseEnumeration(true);
    }

    private void parseDefault(String elementName, String name, String type, String enumer) throws Exception {
        int valueType = 31;
        String value = null;
        int flags = 8;
        boolean saved = this.expandPE;
        String defaultType = null;
        if (!this.skippedPE) {
            flags |= 2;
            if (this.handler.stringInterning) {
                if ("CDATA" != type) {
                    flags |= 4;
                }
            } else if (!"CDATA".equals(type)) {
                flags |= 4;
            }
        }
        this.expandPE = false;
        if (this.tryRead('#')) {
            if (this.tryRead("FIXED")) {
                defaultType = "#FIXED";
                valueType = 34;
                this.requireWhitespace();
                value = this.readLiteral(flags);
            } else if (this.tryRead("REQUIRED")) {
                defaultType = "#REQUIRED";
                valueType = 33;
            } else if (this.tryRead("IMPLIED")) {
                defaultType = "#IMPLIED";
                valueType = 32;
            } else {
                this.error("illegal keyword for attribute default value");
            }
        } else {
            value = this.readLiteral(flags);
        }
        this.expandPE = saved;
        this.setAttribute(elementName, name, type, enumer, value, valueType);
        if (this.handler.stringInterning) {
            if ("ENUMERATION" == type) {
                type = enumer;
            } else if ("NOTATION" == type) {
                type = "NOTATION " + enumer;
            }
        } else if ("ENUMERATION".equals(type)) {
            type = enumer;
        } else if ("NOTATION".equals(type)) {
            type = "NOTATION " + enumer;
        }
        if (!this.skippedPE) {
            this.handler.getDeclHandler().attributeDecl(elementName, name, type, defaultType, value);
        }
    }

    private void parseConditionalSect(char[] saved) throws Exception {
        this.skipWhitespace();
        if (this.tryRead("INCLUDE")) {
            this.skipWhitespace();
            this.require('[');
            if (this.readBuffer != saved) {
                this.handler.verror("Illegal Conditional Section/PE nesting");
            }
            this.skipWhitespace();
            while (!this.tryRead("]]>")) {
                this.parseMarkupdecl();
                this.skipWhitespace();
            }
        } else if (this.tryRead("IGNORE")) {
            this.skipWhitespace();
            this.require('[');
            if (this.readBuffer != saved) {
                this.handler.verror("Illegal Conditional Section/PE nesting");
            }
            this.expandPE = false;
            int nest = 1;
            while (nest > 0) {
                char c = this.readCh();
                switch (c) {
                    case '<': {
                        if (!this.tryRead("![")) break;
                        ++nest;
                        break;
                    }
                    case ']': {
                        if (!this.tryRead("]>")) break;
                        --nest;
                    }
                }
            }
            this.expandPE = true;
        } else {
            this.error("conditional section must begin with INCLUDE or IGNORE");
        }
    }

    private void parseCharRef() throws SAXException, IOException {
        this.parseCharRef(true);
    }

    private void tryReadCharRef() throws SAXException, IOException {
        int value = 0;
        if (this.tryRead('x')) {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 16);
                if (n == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                value *= 16;
                value += n;
            }
        } else {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 10);
                if (n == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                value *= 10;
                value += n;
            }
        }
        if (value < 32 && value != 10 && value != 9 && value != 13 || value >= 55296 && value <= 57343 || value == 65534 || value == 65535 || value > 0x10FFFF) {
            this.error("illegal XML character reference U+" + Integer.toHexString(value));
        }
        if (value > 0x10FFFF) {
            this.error("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
    }

    private void parseCharRef(boolean doFlush) throws SAXException, IOException {
        int value = 0;
        if (this.tryRead('x')) {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 16);
                if (n == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                value *= 16;
                value += n;
            }
        } else {
            char c;
            while ((c = this.readCh()) != ';') {
                int n = Character.digit(c, 10);
                if (n == -1) {
                    this.error("illegal character in character reference", c, null);
                    break;
                }
                value *= 10;
                value += c - 48;
            }
        }
        if (value < 32 && value != 10 && value != 9 && value != 13 || value >= 55296 && value <= 57343 || value == 65534 || value == 65535 || value > 0x10FFFF) {
            this.error("illegal XML character reference U+" + Integer.toHexString(value));
        }
        if (value <= 65535) {
            this.dataBufferAppend((char)value);
        } else if (value <= 0x10FFFF) {
            this.dataBufferAppend((char)(0xD800 | (value -= 65536) >> 10));
            this.dataBufferAppend((char)(0xDC00 | value & 0x3FF));
        } else {
            this.error("character reference " + value + " is too large for UTF-16", new Integer(value).toString(), null);
        }
        if (doFlush) {
            this.dataBufferFlush();
        }
    }

    private void parseEntityRef(boolean externalAllowed) throws SAXException, IOException {
        String name = this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                String message = "reference to undeclared general entity " + name;
                if (this.skippedPE && !this.docIsStandalone) {
                    this.handler.verror(message);
                    if (!externalAllowed) break;
                    this.handler.skippedEntity(name);
                    break;
                }
                this.error(message);
                break;
            }
            case 1: {
                this.pushString(name, this.getEntityValue(name));
                char t = this.readCh();
                this.unread(t);
                int bufferPosMark = this.readBufferPos;
                int end = this.readBufferPos + this.getEntityValue(name).length();
                int k = this.readBufferPos;
                while (k < end) {
                    t = this.readCh();
                    if (t == '&') {
                        t = this.readCh();
                        if (t == '#') {
                            this.tryReadCharRef();
                            if (this.readBufferPos >= end) break;
                            k = this.readBufferPos;
                        } else if (Character.isLetter(t)) {
                            this.unread(t);
                            this.readNmtoken(true);
                            this.require(';');
                            if (this.readBufferPos >= end) break;
                            k = this.readBufferPos;
                        } else {
                            this.error(" malformed entity reference");
                        }
                    }
                    ++k;
                }
                this.readBufferPos = bufferPosMark;
                break;
            }
            case 3: {
                if (externalAllowed) {
                    this.pushURL(false, name, this.getEntityIds(name), null, null, null, true);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
                break;
            }
            case 2: {
                if (externalAllowed) {
                    this.error("unparsed entity reference in content", name, null);
                    break;
                }
                this.error("reference to external entity in attribute value.", name, null);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    private void parsePEReference() throws SAXException, IOException {
        String name = "%" + this.readNmtoken(true);
        this.require(';');
        switch (this.getEntityType(name)) {
            case 0: {
                this.handler.verror("reference to undeclared parameter entity " + name);
                break;
            }
            case 1: {
                if (this.inLiteral) {
                    this.pushString(name, this.getEntityValue(name));
                    break;
                }
                this.pushString(name, String.valueOf(' ') + this.getEntityValue(name) + ' ');
                break;
            }
            case 3: {
                if (!this.inLiteral) {
                    this.pushString(null, " ");
                }
                this.pushURL(true, name, this.getEntityIds(name), null, null, null, true);
                if (this.inLiteral) break;
                this.pushString(null, " ");
            }
        }
    }

    private void parseEntityDecl() throws Exception {
        boolean peFlag = false;
        int flags = 0;
        this.expandPE = false;
        this.requireWhitespace();
        if (this.tryRead('%')) {
            peFlag = true;
            this.requireWhitespace();
        }
        this.expandPE = true;
        String name = this.readNmtoken(true);
        if (name.indexOf(58) >= 0) {
            this.error("Illegal character(':') in entity name ", name, null);
        }
        if (peFlag) {
            name = "%" + name;
        }
        this.requireWhitespace();
        char c = this.readCh();
        this.unread(c);
        if (c == '\"' || c == '\'') {
            String value = this.readLiteral(flags);
            this.setInternalEntity(name, value);
        } else {
            ExternalIdentifiers ids = this.readExternalIds(false, false);
            boolean white = this.tryWhitespace();
            if (!peFlag && this.tryRead("NDATA")) {
                if (!white) {
                    this.error("whitespace required before NDATA");
                }
                this.requireWhitespace();
                String notationName = this.readNmtoken(true);
                if (!this.skippedPE) {
                    this.setExternalEntity(name, 2, ids, notationName);
                    this.handler.unparsedEntityDecl(name, ids.publicId, ids.systemId, ids.baseUri, notationName);
                }
            } else if (!this.skippedPE) {
                this.setExternalEntity(name, 3, ids, null);
                this.handler.getDeclHandler().externalEntityDecl(name, ids.publicId, this.handler.resolveURIs() ? this.handler.absolutize(ids.baseUri, ids.systemId, false) : ids.systemId);
            }
        }
        this.skipWhitespace();
        this.require('>');
    }

    private void parseNotationDecl() throws Exception {
        this.requireWhitespace();
        String nname = this.readNmtoken(true);
        if (nname.indexOf(58) >= 0) {
            this.error("Illegal character(':') in notation name ", nname, null);
        }
        this.requireWhitespace();
        ExternalIdentifiers ids = this.readExternalIds(true, false);
        this.setNotation(nname, ids);
        this.skipWhitespace();
        this.require('>');
    }

    private void parseCharData() throws Exception {
        int state = 0;
        boolean pureWhite = false;
        if (this.currentElementContent == 4 && !this.isDirtyCurrentElement) {
            pureWhite = true;
        }
        while (true) {
            int lineAugment = 0;
            int columnAugment = 0;
            int i = this.readBufferPos;
            block7: while (i < this.readBufferLength) {
                char c = this.readBuffer[i];
                switch (c) {
                    case '\n': {
                        ++lineAugment;
                        columnAugment = 0;
                        break;
                    }
                    case '\t': 
                    case '\r': 
                    case ' ': {
                        ++columnAugment;
                        break;
                    }
                    case '&': 
                    case '<': {
                        ++columnAugment;
                        state = 1;
                        break block7;
                    }
                    case ']': {
                        pureWhite = false;
                        if (i + 2 < this.readBufferLength && this.readBuffer[i + 1] == ']' && this.readBuffer[i + 2] == '>') {
                            state = 2;
                            break block7;
                        }
                        ++columnAugment;
                        break;
                    }
                    default: {
                        if (c < ' ' || c > '\ufffd' || c >= '\u007f' && c <= '\u009f' && c != '\u0085' && this.xmlVersion == 1) {
                            this.error("illegal XML character U+" + Integer.toHexString(c));
                        }
                        pureWhite = false;
                        ++columnAugment;
                    }
                }
                ++i;
            }
            if (lineAugment > 0) {
                this.line += lineAugment;
                this.column = columnAugment;
            } else {
                this.column += columnAugment;
            }
            int length = i - this.readBufferPos;
            if (length != 0) {
                if (pureWhite) {
                    this.handler.ignorableWhitespace(this.readBuffer, this.readBufferPos, length);
                } else {
                    this.handler.charData(this.readBuffer, this.readBufferPos, length);
                }
                this.readBufferPos = i;
            }
            if (state != 0) break;
            this.unread(this.readCh());
        }
        if (!pureWhite) {
            this.isDirtyCurrentElement = true;
        }
        if (state != 1) {
            this.error("character data may not contain ']]>'");
        }
    }

    private void requireWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
        } else {
            this.error("whitespace required", c, null);
        }
    }

    private void skipWhitespace() throws SAXException, IOException {
        int lineAugment = 0;
        int columnAugment = 0;
        int i = this.readBufferPos;
        block5: while (i < this.readBufferLength) {
            switch (this.readBuffer[i]) {
                case '\t': 
                case '\r': 
                case ' ': {
                    ++columnAugment;
                    break;
                }
                case '\n': {
                    ++lineAugment;
                    columnAugment = 0;
                    break;
                }
                case '%': {
                    if (this.expandPE) break block5;
                }
                default: {
                    this.readBufferPos = i;
                    if (lineAugment > 0) {
                        this.line += lineAugment;
                        this.column = columnAugment;
                    } else {
                        this.column += columnAugment;
                    }
                    return;
                }
            }
            ++i;
        }
        char c = this.readCh();
        while (this.isWhitespace(c)) {
            c = this.readCh();
        }
        this.unread(c);
    }

    private String readNmtoken(boolean isName) throws SAXException, IOException {
        char c;
        int i = this.readBufferPos;
        block26: while (i < this.readBufferLength) {
            c = this.readBuffer[i];
            switch (c) {
                case '%': {
                    if (this.expandPE) break block26;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    int start = this.readBufferPos;
                    if (i == start) {
                        this.error("name expected", this.readBuffer[i], null);
                    }
                    this.readBufferPos = i;
                    return this.intern(this.readBuffer, start, i - start);
                }
                default: {
                    if (isName && i == this.readBufferPos) {
                        char c2 = (char)(c & 0xF0);
                        block4 : switch (c & 0xFF00) {
                            case 256: {
                                switch (c2) {
                                    case '0': {
                                        if (c != '\u0132' && c != '\u0133' && c != '\u013f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '@': {
                                        if (c != '\u0140' && c != '\u0149') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '\u00c0': {
                                        if (c != '\u01c4' && c != '\u01cc') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '\u00f0': {
                                        if (c != '\u01f1' && c != '\u01f3') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '\u00b0': {
                                        if (c != '\u01f1' && c != '\u01f3') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    default: {
                                        if (c != '\u017f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                }
                                break;
                            }
                            case 4352: {
                                switch (c2) {
                                    case '\u0000': {
                                        if (c != '\u1104' && c != '\u1108' && c != '\u110a' && c != '\u110d') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '0': {
                                        if (c != '\u113b' && c != '\u113f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '@': {
                                        if (c != '\u1141' && c != '\u114d' && c != '\u114f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case 'P': {
                                        if (c != '\u1151' && c != '\u1156') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '`': {
                                        if (c != '\u1162' && c != '\u1164' && c != '\u1166' && c != '\u116b' && c != '\u116f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    case '\u00b0': {
                                        if (c != '\u11b6' && c != '\u11b9' && c != '\u11bb' && c != '\u116f') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                    default: {
                                        if (c != '\u1174' && c != '\u119f' && c != '\u11ac' && c != '\u11c3' && c != '\u11f1') break block4;
                                        this.error("Not a name start character, U+" + Integer.toHexString(c));
                                        break;
                                    }
                                }
                                break;
                            }
                            default: {
                                if (c != '\u0e46' && c != '\u1011' && c != '\u212f' && c != '\u0587' && c != '\u0230') break;
                                this.error("Not a name start character, U+" + Integer.toHexString(c));
                            }
                        }
                    }
                    if (i == this.readBufferPos && isName) {
                        if (!Character.isUnicodeIdentifierStart(c) && c != ':' && c != '_') {
                            this.error("Not a name start character, U+" + Integer.toHexString(c));
                        }
                    } else if (!Character.isUnicodeIdentifierPart(c) && c != '-' && c != ':' && c != '_' && c != '.' && !XmlParser.isExtender(c)) {
                        this.error("Not a name character, U+" + Integer.toHexString(c));
                    }
                    ++i;
                }
            }
        }
        this.nameBufferPos = 0;
        while (true) {
            c = this.readCh();
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '\"': 
                case '%': 
                case '&': 
                case '\'': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case '|': {
                    this.unread(c);
                    if (this.nameBufferPos == 0) {
                        this.error("name expected");
                    }
                    if (isName && !Character.isUnicodeIdentifierStart(this.nameBuffer[0]) && ":_".indexOf(this.nameBuffer[0]) == -1) {
                        this.error("Not a name start character, U+" + Integer.toHexString(this.nameBuffer[0]));
                    }
                    String s = this.intern(this.nameBuffer, 0, this.nameBufferPos);
                    this.nameBufferPos = 0;
                    return s;
                }
            }
            if (!(this.nameBufferPos == 0 && isName || Character.isUnicodeIdentifierPart(c) || ":-_.".indexOf(c) != -1 || XmlParser.isExtender(c))) {
                this.error("Not a name character, U+" + Integer.toHexString(c));
            }
            if (this.nameBufferPos >= this.nameBuffer.length) {
                this.nameBuffer = (char[])this.extendArray(this.nameBuffer, this.nameBuffer.length, this.nameBufferPos);
            }
            this.nameBuffer[this.nameBufferPos++] = c;
        }
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readLiteral(int flags) throws SAXException, IOException {
        int startLine = this.line;
        boolean saved = this.expandPE;
        boolean savedReport = this.doReport;
        char delim = this.readCh();
        if (delim != '\"' && delim != '\'') {
            this.error("expected '\"' or \"'\"", delim, null);
            return null;
        }
        this.inLiteral = true;
        if ((flags & 0x10) != 0) {
            this.expandPE = false;
        }
        this.doReport = false;
        char[] ourBuf = this.readBuffer;
        try {
            char c = this.readCh();
            block8: while (c != delim || this.readBuffer != ourBuf) {
                switch (c) {
                    case '\n': 
                    case '\r': {
                        if ((flags & 0x108) == 0) break;
                        c = ' ';
                        break;
                    }
                    case '\t': {
                        if ((flags & 8) == 0) break;
                        c = ' ';
                        break;
                    }
                    case '&': {
                        c = this.readCh();
                        if (c == '#') {
                            if ((flags & 0x20) != 0) {
                                this.dataBufferAppend('&');
                                break;
                            }
                            this.parseCharRef(false);
                        } else {
                            this.unread(c);
                            if ((flags & 2) > 0) {
                                this.parseEntityRef(false);
                                if (String.valueOf(this.readBuffer).equals("&#38;")) {
                                    // empty if block
                                }
                            } else if ((flags & 0x40) != 0) {
                                this.dataBufferAppend('&');
                            } else {
                                String name = this.readNmtoken(true);
                                this.require(';');
                                this.dataBufferAppend('&');
                                this.dataBufferAppend(name);
                                this.dataBufferAppend(';');
                            }
                        }
                        c = this.readCh();
                        continue block8;
                    }
                    case '<': {
                        if ((flags & 8) == 0) break;
                        this.error("attribute values may not contain '<'");
                    }
                }
                this.dataBufferAppend(c);
                c = this.readCh();
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, new Character(delim).toString());
        }
        this.inLiteral = false;
        this.expandPE = saved;
        this.doReport = savedReport;
        if ((flags & 4) > 0) {
            this.dataBufferNormalize();
        }
        return this.dataBufferToString();
    }

    private ExternalIdentifiers readExternalIds(boolean inNotation, boolean isSubset) throws Exception {
        ExternalIdentifiers ids = new ExternalIdentifiers();
        int flags = 112;
        if (this.tryRead("PUBLIC")) {
            char c;
            this.requireWhitespace();
            ids.publicId = this.readLiteral(0x104 | flags);
            if (inNotation) {
                this.skipWhitespace();
                c = this.readCh();
                this.unread(c);
                if (c == '\"' || c == '\'') {
                    ids.systemId = this.readLiteral(flags);
                }
            } else {
                this.requireWhitespace();
                ids.systemId = this.readLiteral(flags);
            }
            int i = 0;
            while (i < ids.publicId.length()) {
                c = ids.publicId.charAt(i);
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || " \r\n0123456789-' ()+,./:=?;!*#@$_%".indexOf(c) != -1)) {
                    this.error("illegal PUBLIC id character U+" + Integer.toHexString(c));
                }
                ++i;
            }
        } else if (this.tryRead("SYSTEM")) {
            this.requireWhitespace();
            ids.systemId = this.readLiteral(flags);
        } else if (!isSubset) {
            this.error("missing SYSTEM or PUBLIC keyword");
        }
        if (ids.systemId != null) {
            if (ids.systemId.indexOf(35) != -1) {
                this.handler.verror("SYSTEM id has a URI fragment: " + ids.systemId);
            }
            ids.baseUri = this.handler.getSystemId();
            if (ids.baseUri == null && uriWarnings) {
                this.handler.warn("No base URI; hope URI is absolute: " + ids.systemId);
            }
        }
        return ids;
    }

    private final boolean isWhitespace(char c) {
        if (c > ' ') {
            return false;
        }
        return c == ' ' || c == '\n' || c == '\t' || c == '\r';
    }

    private void dataBufferAppend(char c) {
        if (this.dataBufferPos >= this.dataBuffer.length) {
            this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos);
        }
        this.dataBuffer[this.dataBufferPos++] = c;
    }

    private void dataBufferAppend(String s) {
        this.dataBufferAppend(s.toCharArray(), 0, s.length());
    }

    private void dataBufferAppend(char[] ch, int start, int length) {
        this.dataBuffer = (char[])this.extendArray(this.dataBuffer, this.dataBuffer.length, this.dataBufferPos + length);
        System.arraycopy(ch, start, this.dataBuffer, this.dataBufferPos, length);
        this.dataBufferPos += length;
    }

    private void dataBufferNormalize() {
        int i = 0;
        int j = 0;
        int end = this.dataBufferPos;
        while (j < end && this.dataBuffer[j] == ' ') {
            ++j;
        }
        while (end > j && this.dataBuffer[end - 1] == ' ') {
            --end;
        }
        while (j < end) {
            char c;
            if ((c = this.dataBuffer[j++]) == ' ') {
                while (j < end && this.dataBuffer[j++] == ' ') {
                }
                this.dataBuffer[i++] = 32;
                this.dataBuffer[i++] = this.dataBuffer[j - 1];
                continue;
            }
            this.dataBuffer[i++] = c;
        }
        this.dataBufferPos = i;
    }

    private String dataBufferToString() {
        String s = new String(this.dataBuffer, 0, this.dataBufferPos);
        this.dataBufferPos = 0;
        return s;
    }

    private void dataBufferFlush() throws SAXException {
        if (this.currentElementContent == 4 && this.dataBufferPos > 0 && !this.inCDATA) {
            int i = 0;
            while (i < this.dataBufferPos) {
                if (!this.isWhitespace(this.dataBuffer[i])) {
                    this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
                    this.dataBufferPos = 0;
                }
                ++i;
            }
            if (this.dataBufferPos > 0) {
                this.handler.ignorableWhitespace(this.dataBuffer, 0, this.dataBufferPos);
                this.dataBufferPos = 0;
            }
        } else if (this.dataBufferPos > 0) {
            this.handler.charData(this.dataBuffer, 0, this.dataBufferPos);
            this.dataBufferPos = 0;
        }
    }

    private void require(String delim) throws SAXException, IOException {
        char[] ch;
        int length = delim.length();
        if (length < this.dataBuffer.length) {
            ch = this.dataBuffer;
            delim.getChars(0, length, ch, 0);
        } else {
            ch = delim.toCharArray();
        }
        if (length <= this.readBufferLength - this.readBufferPos) {
            int offset = this.readBufferPos;
            int i = 0;
            while (i < length) {
                if (ch[i] != this.readBuffer[offset]) {
                    this.error("required string", null, delim);
                }
                ++i;
                ++offset;
            }
            this.readBufferPos = offset;
        } else {
            int i = 0;
            while (i < length) {
                this.require(ch[i]);
                ++i;
            }
        }
    }

    private void require(char delim) throws SAXException, IOException {
        char c = this.readCh();
        if (c != delim) {
            this.error("required character", c, new Character(delim).toString());
        }
    }

    /*
     * Unable to fully structure code
     */
    public String intern(char[] ch, int start, int length) {
        block5: {
            index = 0;
            hash = 0;
            i = start;
            while (i < start + length) {
                hash = 31 * hash + ch[i];
                ++i;
            }
            bucket = this.symbolTable[hash = (hash & 0x7FFFFFFF) % 2039];
            if (bucket != null) ** GOTO lbl22
            bucket = new Object[8];
            break block5;
            while ((chFound = (char[])bucket[index]) != null) {
                if (chFound.length == length) {
                    i = 0;
                    while (i < chFound.length) {
                        if (ch[start + i] != chFound[i]) break;
                        if (i == length - 1) {
                            return (String)bucket[index + 1];
                        }
                        ++i;
                    }
                }
                index += 2;
lbl22:
                // 2 sources

                if (index < bucket.length) continue;
            }
            bucket = (Object[])this.extendArray(bucket, bucket.length, index);
        }
        this.symbolTable[hash] = bucket;
        s = new String(ch, start, length).intern();
        bucket[index] = s.toCharArray();
        bucket[index + 1] = s;
        return s;
    }

    private Object extendArray(Object array, int currentSize, int requiredSize) {
        if (requiredSize < currentSize) {
            return array;
        }
        Object[] newArray = null;
        int newSize = currentSize * 2;
        if (newSize <= requiredSize) {
            newSize = requiredSize + 1;
        }
        if (array instanceof char[]) {
            newArray = new char[newSize];
        } else if (array instanceof Object[]) {
            newArray = new Object[newSize];
        } else {
            throw new RuntimeException();
        }
        System.arraycopy(array, 0, newArray, 0, currentSize);
        return newArray;
    }

    boolean isStandalone() {
        return this.docIsStandalone;
    }

    private int getContentType(ElementDecl element, int defaultType) {
        if (element == null) {
            return defaultType;
        }
        int retval = element.contentType;
        if (retval == 0) {
            retval = defaultType;
        }
        return retval;
    }

    public int getElementContentType(String name) {
        ElementDecl element = (ElementDecl)this.elementInfo.get(name);
        return this.getContentType(element, 0);
    }

    private void setElement(String name, int contentType, String contentModel, HashMap attributes) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        ElementDecl element = (ElementDecl)this.elementInfo.get(name);
        if (element == null) {
            element = new ElementDecl();
            element.contentType = contentType;
            element.contentModel = contentModel;
            element.attributes = attributes;
            this.elementInfo.put(name, element);
            return;
        }
        if (contentType != 0) {
            if (element.contentType == 0) {
                element.contentType = contentType;
                element.contentModel = contentModel;
            } else {
                this.handler.verror("multiple declarations for element type: " + name);
            }
        } else if (attributes != null) {
            element.attributes = attributes;
        }
    }

    private HashMap getElementAttributes(String name) {
        ElementDecl element = (ElementDecl)this.elementInfo.get(name);
        return element == null ? null : element.attributes;
    }

    private Iterator declaredAttributes(ElementDecl element) {
        if (element == null) {
            return null;
        }
        HashMap attlist = element.attributes;
        if (attlist == null) {
            return null;
        }
        return attlist.keySet().iterator();
    }

    public Iterator declaredAttributes(String elname) {
        return this.declaredAttributes((ElementDecl)this.elementInfo.get(elname));
    }

    public String getAttributeType(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? null : attribute.type;
    }

    public String getAttributeEnumeration(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? null : attribute.enumeration;
    }

    public String getAttributeDefaultValue(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? null : attribute.value;
    }

    public int getAttributeDefaultValueType(String name, String aname) {
        AttributeDecl attribute = this.getAttribute(name, aname);
        return attribute == null ? 30 : attribute.valueType;
    }

    private void setAttribute(String elName, String name, String type, String enumeration, String value, int valueType) throws Exception {
        if (this.skippedPE) {
            return;
        }
        HashMap<String, AttributeDecl> attlist = this.getElementAttributes(elName);
        if (attlist == null) {
            attlist = new HashMap<String, AttributeDecl>();
        }
        if (attlist.get(name) != null) {
            return;
        }
        AttributeDecl attribute = new AttributeDecl();
        attribute.type = type;
        attribute.value = value;
        attribute.valueType = valueType;
        attribute.enumeration = enumeration;
        attlist.put(name, attribute);
        this.setElement(elName, 0, null, attlist);
    }

    private AttributeDecl getAttribute(String elName, String name) {
        HashMap attlist = this.getElementAttributes(elName);
        return attlist == null ? null : (AttributeDecl)attlist.get(name);
    }

    public int getEntityType(String ename) {
        EntityInfo entity = (EntityInfo)this.entityInfo.get(ename);
        return entity == null ? 0 : entity.type;
    }

    public ExternalIdentifiers getEntityIds(String ename) {
        EntityInfo entity = (EntityInfo)this.entityInfo.get(ename);
        return entity == null ? null : entity.ids;
    }

    public String getEntityValue(String ename) {
        EntityInfo entity = (EntityInfo)this.entityInfo.get(ename);
        return entity == null ? null : entity.value;
    }

    private void setInternalEntity(String eName, String value) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        if (this.entityInfo.get(eName) == null) {
            EntityInfo entity = new EntityInfo();
            entity.type = 1;
            entity.value = value;
            this.entityInfo.put(eName, entity);
        }
        if (this.handler.stringInterning ? "lt" == eName || "gt" == eName || "quot" == eName || "apos" == eName || "amp" == eName : "lt".equals(eName) || "gt".equals(eName) || "quot".equals(eName) || "apos".equals(eName) || "amp".equals(eName)) {
            return;
        }
        this.handler.getDeclHandler().internalEntityDecl(eName, value);
    }

    private void setExternalEntity(String eName, int eClass, ExternalIdentifiers ids, String nName) {
        if (this.entityInfo.get(eName) == null) {
            EntityInfo entity = new EntityInfo();
            entity.type = eClass;
            entity.ids = ids;
            entity.notationName = nName;
            this.entityInfo.put(eName, entity);
        }
    }

    private void setNotation(String nname, ExternalIdentifiers ids) throws SAXException {
        if (this.skippedPE) {
            return;
        }
        this.handler.notationDecl(nname, ids.publicId, ids.systemId, ids.baseUri);
        if (this.notationInfo.get(nname) == null) {
            this.notationInfo.put(nname, nname);
        } else {
            this.handler.verror("Duplicate notation name decl: " + nname);
        }
    }

    public int getLineNumber() {
        return this.line;
    }

    public int getColumnNumber() {
        return this.column;
    }

    private char readCh() throws SAXException, IOException {
        char c;
        block3: while (this.readBufferPos >= this.readBufferLength) {
            switch (this.sourceType) {
                case 3: 
                case 5: {
                    this.readDataChunk();
                    while (this.readBufferLength < 1) {
                        this.popInput();
                        if (this.readBufferLength >= 1) continue;
                        this.readDataChunk();
                    }
                    continue block3;
                }
                default: {
                    this.popInput();
                }
            }
        }
        if ((c = this.readBuffer[this.readBufferPos++]) == '\n') {
            ++this.line;
            this.column = 0;
        } else {
            if (c != '<') {
                if (c < ' ' && c != '\t' && c != '\r' || c > '\ufffd' || c >= '\u007f' && c <= '\u009f' && c != '\u0085' && this.xmlVersion == 1) {
                    this.error("illegal XML character U+" + Integer.toHexString(c));
                } else if (c == '%' && this.expandPE) {
                    if (this.peIsError) {
                        this.error("PE reference within decl in internal subset.");
                    }
                    this.parsePEReference();
                    return this.readCh();
                }
            }
            ++this.column;
        }
        return c;
    }

    private void unread(char c) throws SAXException {
        if (c == '\n') {
            --this.line;
            this.column = -1;
        }
        if (this.readBufferPos > 0) {
            this.readBuffer[--this.readBufferPos] = c;
        } else {
            this.pushString(null, new Character(c).toString());
        }
    }

    private void unread(char[] ch, int length) throws SAXException {
        int i = 0;
        while (i < length) {
            if (ch[i] == '\n') {
                --this.line;
                this.column = -1;
            }
            ++i;
        }
        if (length < this.readBufferPos) {
            this.readBufferPos -= length;
        } else {
            this.pushCharArray(null, ch, 0, length);
        }
    }

    private void pushURL(boolean isPE, String ename, ExternalIdentifiers ids, Reader reader, InputStream stream, String encoding, boolean doResolve) throws SAXException, IOException {
        boolean ignoreEncoding;
        String systemId;
        InputSource source;
        if (!isPE) {
            this.dataBufferFlush();
        }
        this.scratch.setPublicId(ids.publicId);
        this.scratch.setSystemId(ids.systemId);
        if (doResolve) {
            source = this.handler.resolveEntity(isPE, ename, this.scratch, ids.baseUri);
            if (source == null) {
                this.handler.warn("skipping entity: " + ename);
                this.handler.skippedEntity(ename);
                if (isPE) {
                    this.skippedPE = true;
                }
                return;
            }
            systemId = source.getSystemId();
        } else {
            this.scratch.setCharacterStream(reader);
            this.scratch.setByteStream(stream);
            this.scratch.setEncoding(encoding);
            source = this.scratch;
            systemId = ids.systemId;
            if (this.handler.stringInterning) {
                this.handler.startExternalEntity(ename, systemId, "[document]" == ename);
            } else {
                this.handler.startExternalEntity(ename, systemId, "[document]".equals(ename));
            }
        }
        if (source.getCharacterStream() != null) {
            if (source.getByteStream() != null) {
                this.error("InputSource has two streams!");
            }
            reader = source.getCharacterStream();
        } else if (source.getByteStream() != null) {
            encoding = source.getEncoding();
            if (encoding == null) {
                stream = source.getByteStream();
            } else {
                try {
                    reader = new InputStreamReader(source.getByteStream(), encoding);
                }
                catch (IOException iOException) {
                    stream = source.getByteStream();
                }
            }
        } else if (systemId == null) {
            this.error("InputSource has no URI!");
        }
        this.scratch.setCharacterStream(null);
        this.scratch.setByteStream(null);
        this.scratch.setEncoding(null);
        this.pushInput(ename);
        this.readBuffer = new char[16388];
        this.readBufferPos = 0;
        this.readBufferLength = 0;
        this.readBufferOverflow = -1;
        this.is = null;
        this.line = 1;
        this.column = 0;
        this.currentByteCount = 0;
        if (reader != null) {
            this.sourceType = 5;
            this.reader = reader;
            this.tryEncodingDecl(true);
            return;
        }
        this.sourceType = 3;
        if (stream != null) {
            this.is = stream;
        } else {
            URL url = new URL(systemId);
            this.externalEntity = url.openConnection();
            this.externalEntity.connect();
            this.is = this.externalEntity.getInputStream();
        }
        if (!this.is.markSupported()) {
            this.is = new BufferedInputStream(this.is);
        }
        if (encoding == null && this.externalEntity != null && !"file".equals(this.externalEntity.getURL().getProtocol())) {
            encoding = this.externalEntity.getContentType();
            int temp = encoding == null ? -1 : encoding.indexOf("charset");
            if (temp < 0) {
                encoding = null;
            } else {
                temp = encoding.indexOf(59);
                if (temp > 0) {
                    encoding = encoding.substring(0, temp);
                }
                if ((temp = encoding.indexOf(61, temp + 7)) > 0) {
                    if ((temp = (encoding = encoding.substring(temp + 1)).indexOf(40)) > 0) {
                        encoding = encoding.substring(0, temp);
                    }
                    if ((temp = encoding.indexOf(34)) > 0) {
                        encoding = encoding.substring(temp + 1, encoding.indexOf(34, temp + 2));
                    }
                    encoding = encoding.trim();
                } else {
                    this.handler.warn("ignoring illegal MIME attribute: " + encoding);
                    encoding = null;
                }
            }
        }
        if (encoding != null) {
            this.encoding = 0;
            this.setupDecoding(encoding);
            ignoreEncoding = true;
        } else {
            this.detectEncoding();
            ignoreEncoding = false;
        }
        try {
            this.tryEncodingDecl(ignoreEncoding);
        }
        catch (UnsupportedEncodingException x) {
            encoding = x.getMessage();
            try {
                if (this.sourceType != 3) {
                    throw x;
                }
                this.is.reset();
                this.readBufferPos = 0;
                this.readBufferLength = 0;
                this.readBufferOverflow = -1;
                this.line = 1;
                this.column = 0;
                this.currentByteCount = 0;
                this.sourceType = 5;
                this.reader = new InputStreamReader(this.is, encoding);
                this.is = null;
                this.tryEncodingDecl(true);
            }
            catch (IOException iOException) {
                this.error("unsupported text encoding", encoding, null);
            }
        }
    }

    private String tryEncodingDecl(boolean ignoreEncoding) throws SAXException, IOException {
        if (this.tryRead("<?xml")) {
            if (this.tryWhitespace()) {
                if (this.inputStack.size() > 0) {
                    return this.parseTextDecl(ignoreEncoding);
                }
                return this.parseXMLDecl(ignoreEncoding);
            }
            this.unread('l');
            this.unread('m');
            this.unread('x');
            this.unread('?');
            this.unread('<');
        }
        return null;
    }

    private void detectEncoding() throws SAXException, IOException {
        byte[] signature = new byte[4];
        this.is.mark(4);
        this.is.read(signature);
        this.is.reset();
        if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)0, (byte)60)) {
            this.encoding = 5;
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)0, (byte)0, (byte)0)) {
            this.encoding = 6;
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)0, (byte)60, (byte)0)) {
            this.encoding = 7;
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)0)) {
            this.encoding = 8;
        } else if (XmlParser.tryEncoding(signature, (byte)-2, (byte)-1)) {
            this.encoding = 3;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(signature, (byte)-1, (byte)-2)) {
            this.encoding = 4;
            this.is.read();
            this.is.read();
        } else if (XmlParser.tryEncoding(signature, (byte)0, (byte)60, (byte)0, (byte)63)) {
            this.encoding = 3;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)0, (byte)63, (byte)0)) {
            this.encoding = 4;
            this.error("no byte-order mark for UCS-2 entity");
        } else if (XmlParser.tryEncoding(signature, (byte)60, (byte)63, (byte)120, (byte)109)) {
            this.encoding = 1;
            this.prefetchASCIIEncodingDecl();
        } else if (signature[0] == -17 && signature[1] == -69 && signature[2] == -65) {
            this.encoding = 1;
            this.is.read();
            this.is.read();
            this.is.read();
        } else {
            this.encoding = 1;
        }
    }

    private static boolean tryEncoding(byte[] sig, byte b1, byte b2, byte b3, byte b4) {
        return sig[0] == b1 && sig[1] == b2 && sig[2] == b3 && sig[3] == b4;
    }

    private static boolean tryEncoding(byte[] sig, byte b1, byte b2) {
        return sig[0] == b1 && sig[1] == b2;
    }

    private void pushString(String ename, String s) throws SAXException {
        char[] ch = s.toCharArray();
        this.pushCharArray(ename, ch, 0, ch.length);
    }

    private void pushCharArray(String ename, char[] ch, int start, int length) throws SAXException {
        this.pushInput(ename);
        if (ename != null && this.doReport) {
            this.dataBufferFlush();
            this.handler.startInternalEntity(ename);
        }
        this.sourceType = 1;
        this.readBuffer = ch;
        this.readBufferPos = start;
        this.readBufferLength = length;
        this.readBufferOverflow = -1;
    }

    private void pushInput(String ename) throws SAXException {
        if (ename != null) {
            for (String e : this.entityStack) {
                if (e == null || e != ename) continue;
                this.error("recursive reference to entity", ename, null);
            }
        }
        this.entityStack.addLast(ename);
        if (this.sourceType == 0) {
            return;
        }
        Input input = new Input();
        input.sourceType = this.sourceType;
        input.externalEntity = this.externalEntity;
        input.readBuffer = this.readBuffer;
        input.readBufferPos = this.readBufferPos;
        input.readBufferLength = this.readBufferLength;
        input.line = this.line;
        input.encoding = this.encoding;
        input.readBufferOverflow = this.readBufferOverflow;
        input.is = this.is;
        input.currentByteCount = this.currentByteCount;
        input.column = this.column;
        input.reader = this.reader;
        this.inputStack.addLast(input);
    }

    private void popInput() throws SAXException, IOException {
        String ename = (String)this.entityStack.removeLast();
        if (ename != null && this.doReport) {
            this.dataBufferFlush();
        }
        switch (this.sourceType) {
            case 3: {
                this.handler.endExternalEntity(ename);
                this.is.close();
                break;
            }
            case 5: {
                this.handler.endExternalEntity(ename);
                this.reader.close();
                break;
            }
            case 1: {
                if (ename == null || !this.doReport) break;
                this.handler.endInternalEntity(ename);
            }
        }
        if (this.inputStack.isEmpty()) {
            throw new EOFException("no more input");
        }
        Input input = (Input)this.inputStack.removeLast();
        this.sourceType = input.sourceType;
        this.externalEntity = input.externalEntity;
        this.readBuffer = input.readBuffer;
        this.readBufferPos = input.readBufferPos;
        this.readBufferLength = input.readBufferLength;
        this.line = input.line;
        this.encoding = input.encoding;
        this.readBufferOverflow = input.readBufferOverflow;
        this.is = input.is;
        this.currentByteCount = input.currentByteCount;
        this.column = input.column;
        this.reader = input.reader;
    }

    private boolean tryRead(char delim) throws SAXException, IOException {
        char c = this.readCh();
        if (c == delim) {
            return true;
        }
        this.unread(c);
        return false;
    }

    private boolean tryRead(String delim) throws SAXException, IOException {
        return this.tryRead(delim.toCharArray());
    }

    private boolean tryRead(char[] ch) throws SAXException, IOException {
        int i = 0;
        while (i < ch.length) {
            char c = this.readCh();
            if (c != ch[i]) {
                this.unread(c);
                if (i != 0) {
                    this.unread(ch, i);
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean tryWhitespace() throws SAXException, IOException {
        char c = this.readCh();
        if (this.isWhitespace(c)) {
            this.skipWhitespace();
            return true;
        }
        this.unread(c);
        return false;
    }

    private void parseUntil(String delim) throws SAXException, IOException {
        this.parseUntil(delim.toCharArray());
    }

    private void parseUntil(char[] delim) throws SAXException, IOException {
        int startLine = this.line;
        try {
            while (!this.tryRead(delim)) {
                char c = this.readCh();
                this.dataBufferAppend(c);
            }
        }
        catch (EOFException eOFException) {
            this.error("end of input while looking for delimiter (started on line " + startLine + ')', null, new String(delim));
        }
    }

    private void prefetchASCIIEncodingDecl() throws SAXException, IOException {
        this.readBufferLength = 0;
        this.readBufferPos = 0;
        this.is.mark(this.readBuffer.length);
        while (true) {
            int ch = this.is.read();
            this.readBuffer[this.readBufferLength++] = (char)ch;
            switch (ch) {
                case 62: {
                    return;
                }
                case -1: {
                    this.error("file ends before end of XML or encoding declaration.", null, "?>");
                }
            }
            if (this.readBuffer.length != this.readBufferLength) continue;
            this.error("unfinished XML or encoding declaration");
        }
    }

    private void readDataChunk() throws SAXException, IOException {
        if (this.readBufferOverflow > -1) {
            this.readBuffer[0] = (char)this.readBufferOverflow;
            this.readBufferOverflow = -1;
            this.readBufferPos = 1;
            this.sawCR = true;
        } else {
            this.readBufferPos = 0;
            this.sawCR = false;
        }
        if (this.sourceType == 5) {
            int count = this.reader.read(this.readBuffer, this.readBufferPos, 16384 - this.readBufferPos);
            this.readBufferLength = count < 0 ? this.readBufferPos : this.readBufferPos + count;
            if (this.readBufferLength > 0) {
                this.filterCR(count >= 0);
            }
            this.sawCR = false;
            return;
        }
        int count = this.is.read(this.rawReadBuffer, 0, 16384);
        if (count > 0) {
            switch (this.encoding) {
                case 9: {
                    this.copyIso8859_1ReadBuffer(count, '\u0080');
                    break;
                }
                case 1: {
                    this.copyUtf8ReadBuffer(count);
                    break;
                }
                case 2: {
                    this.copyIso8859_1ReadBuffer(count, '\u0000');
                    break;
                }
                case 3: {
                    this.copyUcs2ReadBuffer(count, 8, 0);
                    break;
                }
                case 4: {
                    this.copyUcs2ReadBuffer(count, 0, 8);
                    break;
                }
                case 5: {
                    this.copyUcs4ReadBuffer(count, 24, 16, 8, 0);
                    break;
                }
                case 6: {
                    this.copyUcs4ReadBuffer(count, 0, 8, 16, 24);
                    break;
                }
                case 7: {
                    this.copyUcs4ReadBuffer(count, 16, 24, 0, 8);
                    break;
                }
                case 8: {
                    this.copyUcs4ReadBuffer(count, 8, 0, 24, 16);
                }
            }
        } else {
            this.readBufferLength = this.readBufferPos;
        }
        this.readBufferPos = 0;
        if (this.sawCR) {
            this.filterCR(count >= 0);
            this.sawCR = false;
            if (this.readBufferLength == 0 && count >= 0) {
                this.readDataChunk();
            }
        }
        if (count > 0) {
            this.currentByteCount += count;
        }
    }

    private void filterCR(boolean moreData) {
        int j;
        this.readBufferOverflow = -1;
        int i = j = this.readBufferPos;
        block3: while (j < this.readBufferLength) {
            switch (this.readBuffer[j]) {
                case '\r': {
                    if (j == this.readBufferLength - 1) {
                        if (moreData) {
                            this.readBufferOverflow = 13;
                            --this.readBufferLength;
                            break block3;
                        }
                        this.readBuffer[i++] = 10;
                        break block3;
                    }
                    if (this.readBuffer[j + 1] == '\n') {
                        ++j;
                    }
                    this.readBuffer[i] = 10;
                    break;
                }
                default: {
                    this.readBuffer[i] = this.readBuffer[j];
                }
            }
            ++i;
            ++j;
        }
        this.readBufferLength = i;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void copyUtf8ReadBuffer(int count) throws SAXException, IOException {
        int i = 0;
        int j = this.readBufferPos;
        char c = '\u0000';
        while (i < count) {
            block11: {
                byte b1;
                block12: {
                    block13: {
                        if ((b1 = this.rawReadBuffer[i++]) >= 0) break block12;
                        if ((b1 & 0xE0) != 192) break block13;
                        if ((c = (char)((b1 & 0x1F) << 6 | this.getNextUtf8Byte(i++, count))) < '\u0080') {
                            this.encodingError("Illegal two byte UTF-8 sequence", c, 0);
                        }
                        if ((c == '\u0085' || c == '\n') && this.sawCR) continue;
                        if (c == '\u0085' && this.xmlVersion == 1) {
                            this.readBuffer[j++] = 13;
                        }
                        break block11;
                    }
                    if ((b1 & 0xF0) == 224) {
                        if ((c = (char)((b1 & 0xF) << 12 | this.getNextUtf8Byte(i++, count) << 6 | this.getNextUtf8Byte(i++, count))) == '\u2028' && this.xmlVersion == 1) {
                            this.readBuffer[j++] = 13;
                            this.sawCR = true;
                            continue;
                        }
                        if (c < '\u0800' || c >= '\ud800' && c <= '\udfff') {
                            this.encodingError("Illegal three byte UTF-8 sequence", c, 0);
                        }
                        break block11;
                    } else {
                        if ((b1 & 0xF8) == 240) {
                            int iso646 = b1 & 7;
                            iso646 = (iso646 << 6) + this.getNextUtf8Byte(i++, count);
                            iso646 = (iso646 << 6) + this.getNextUtf8Byte(i++, count);
                            if ((iso646 = (iso646 << 6) + this.getNextUtf8Byte(i++, count)) <= 65535) {
                                this.encodingError("Illegal four byte UTF-8 sequence", iso646, 0);
                                break block11;
                            } else {
                                if (iso646 > 0x10FFFF) {
                                    this.encodingError("UTF-8 value out of range for Unicode", iso646, 0);
                                }
                                this.readBuffer[j++] = (char)(0xD800 | (iso646 -= 65536) >> 10);
                                this.readBuffer[j++] = (char)(0xDC00 | iso646 & 0x3FF);
                                continue;
                            }
                        }
                        this.encodingError("unsupported five or six byte UTF-8 sequence", 0xFF & b1, i);
                        c = '\u0000';
                    }
                    break block11;
                }
                c = (char)b1;
            }
            this.readBuffer[j++] = c;
            if (c != '\r') continue;
            this.sawCR = true;
        }
        this.readBufferLength = j;
    }

    private int getNextUtf8Byte(int pos, int count) throws SAXException, IOException {
        int val;
        if (pos < count) {
            val = this.rawReadBuffer[pos];
        } else {
            val = this.is.read();
            if (val == -1) {
                this.encodingError("unfinished multi-byte UTF-8 sequence at EOF", -1, pos);
            }
        }
        if ((val & 0xC0) != 128) {
            this.encodingError("bad continuation of multi-byte UTF-8 sequence", val, pos + 1);
        }
        return val & 0x3F;
    }

    private void copyIso8859_1ReadBuffer(int count, char mask) throws IOException {
        int i = 0;
        int j = this.readBufferPos;
        while (i < count) {
            int c = this.rawReadBuffer[i] & 0xFF;
            if ((c & mask) != 0) {
                throw new CharConversionException("non-ASCII character U+" + Integer.toHexString(c));
            }
            if (c == 133 && this.xmlVersion == 1) {
                c = 13;
            }
            this.readBuffer[j] = c;
            if (c == 13) {
                this.sawCR = true;
            }
            ++i;
            ++j;
        }
        this.readBufferLength = j;
    }

    private void copyUcs2ReadBuffer(int count, int shift1, int shift2) throws SAXException {
        int j = this.readBufferPos;
        if (count > 0 && count % 2 != 0) {
            this.encodingError("odd number of bytes in UCS-2 encoding", -1, count);
        }
        if (shift1 == 0) {
            int i = 0;
            while (i < count) {
                char c = (char)(this.rawReadBuffer[i + 1] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i]);
                this.readBuffer[j++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                i += 2;
            }
        } else {
            int i = 0;
            while (i < count) {
                char c = (char)(this.rawReadBuffer[i] << 8);
                c = (char)(c | 0xFF & this.rawReadBuffer[i + 1]);
                this.readBuffer[j++] = c;
                if (c == '\r') {
                    this.sawCR = true;
                }
                i += 2;
            }
        }
        this.readBufferLength = j;
    }

    private void copyUcs4ReadBuffer(int count, int shift1, int shift2, int shift3, int shift4) throws SAXException {
        int j = this.readBufferPos;
        if (count > 0 && count % 4 != 0) {
            this.encodingError("number of bytes in UCS-4 encoding not divisible by 4", -1, count);
        }
        int i = 0;
        while (i < count) {
            int value = (this.rawReadBuffer[i] & 0xFF) << shift1 | (this.rawReadBuffer[i + 1] & 0xFF) << shift2 | (this.rawReadBuffer[i + 2] & 0xFF) << shift3 | (this.rawReadBuffer[i + 3] & 0xFF) << shift4;
            if (value < 65535) {
                this.readBuffer[j++] = (char)value;
                if (value == 13) {
                    this.sawCR = true;
                }
            } else if (value < 0x10FFFF) {
                this.readBuffer[j++] = (char)(0xD8 | (value -= 65536) >> 10 & 0x3FF);
                this.readBuffer[j++] = (char)(0xDC | value & 0x3FF);
            } else {
                this.encodingError("UCS-4 value out of range for Unicode", value, i);
            }
            i += 4;
        }
        this.readBufferLength = j;
    }

    private void encodingError(String message, int value, int offset) throws SAXException {
        if (value != -1) {
            message = String.valueOf(message) + " (character code: 0x" + Integer.toHexString(value) + ')';
            this.error(message);
        }
    }

    private void initializeVariables() {
        this.line = 1;
        this.column = 0;
        this.dataBufferPos = 0;
        this.dataBuffer = new char[DATA_BUFFER_INITIAL];
        this.nameBufferPos = 0;
        this.nameBuffer = new char[NAME_BUFFER_INITIAL];
        this.elementInfo = new HashMap();
        this.entityInfo = new HashMap();
        this.notationInfo = new HashMap();
        this.skippedPE = false;
        this.currentElement = null;
        this.currentElementContent = 0;
        this.sourceType = 0;
        this.inputStack = new LinkedList();
        this.entityStack = new LinkedList();
        this.externalEntity = null;
        this.tagAttributePos = 0;
        this.tagAttributes = new String[100];
        this.rawReadBuffer = new byte[16384];
        this.readBufferOverflow = -1;
        this.scratch = new InputSource();
        this.inLiteral = false;
        this.expandPE = false;
        this.peIsError = false;
        this.doReport = false;
        this.inCDATA = false;
        this.symbolTable = new Object[2039][];
    }

    static class AttributeDecl {
        String type;
        String value;
        int valueType;
        String enumeration;
        String defaultValue;

        AttributeDecl() {
        }
    }

    static class ElementDecl {
        int contentType;
        String contentModel;
        HashMap attributes;

        ElementDecl() {
        }
    }

    static class EntityInfo {
        int type;
        ExternalIdentifiers ids;
        String value;
        String notationName;

        EntityInfo() {
        }
    }

    static class ExternalIdentifiers {
        String publicId;
        String systemId;
        String baseUri;

        ExternalIdentifiers() {
        }

        ExternalIdentifiers(String publicId, String systemId, String baseUri) {
            this.publicId = publicId;
            this.systemId = systemId;
            this.baseUri = baseUri;
        }
    }

    static class Input {
        int sourceType;
        URLConnection externalEntity;
        char[] readBuffer;
        int readBufferPos;
        int readBufferLength;
        int line;
        int encoding;
        int readBufferOverflow;
        InputStream is;
        int currentByteCount;
        int column;
        Reader reader;

        Input() {
        }
    }
}

