/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.java.security.util.ByteArray;
import gnu.java.security.util.ByteBufferOutputStream;
import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.MacException;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Record;
import gnu.javax.net.ssl.provider.SessionImpl;
import gnu.javax.net.ssl.provider.Util;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.net.ssl.SSLException;

public class InputSecurityParameters {
    private static final SystemLogger logger = SystemLogger.SYSTEM;
    private final Cipher cipher;
    private final Mac mac;
    private final Inflater inflater;
    private SessionImpl session;
    private final CipherSuite suite;
    private long sequence;

    public InputSecurityParameters(Cipher cipher, Mac mac, Inflater inflater, SessionImpl session, CipherSuite suite) {
        this.cipher = cipher;
        this.mac = mac;
        this.inflater = inflater;
        this.session = session;
        this.suite = suite;
        this.sequence = 0L;
    }

    public int decrypt(Record record, ByteBuffer[] output, int offset, int length) throws DataFormatException, IllegalBlockSizeException, MacException, SSLException, ShortBufferException {
        return this.decrypt(record, output, offset, length, null);
    }

    public int decrypt(Record record, ByteBufferOutputStream outputStream) throws DataFormatException, IllegalBlockSizeException, MacException, SSLException, ShortBufferException {
        return this.decrypt(record, null, 0, 0, outputStream);
    }

    private int decrypt(Record record, ByteBuffer[] output, int offset, int length, ByteBufferOutputStream outputStream) throws DataFormatException, IllegalBlockSizeException, MacException, SSLException, ShortBufferException {
        ByteBuffer fragment;
        boolean badPadding = false;
        if (this.cipher != null) {
            ByteBuffer input = record.fragment();
            fragment = ByteBuffer.allocate(input.remaining());
            this.cipher.update(input, fragment);
        } else {
            fragment = record.fragment();
        }
        int fragmentLength = record.length();
        int maclen = 0;
        if (this.mac != null) {
            maclen = this.mac.getMacLength();
        }
        fragmentLength -= maclen;
        int padlen = 0;
        int padRemoveLen = 0;
        if (!this.suite.isStreamCipher()) {
            padlen = fragment.get(record.length() - 1) & 0xFF;
            padRemoveLen = padlen + 1;
            logger.logv(Component.SSL_RECORD_LAYER, "padlen:{0}", padlen);
            if (record.version() == ProtocolVersion.SSL_3) {
                if (padlen > this.cipher.getBlockSize()) {
                    badPadding = true;
                }
            } else if (record.version().compareTo(ProtocolVersion.TLS_1) >= 0) {
                byte[] pad = new byte[padlen];
                ((ByteBuffer)fragment.duplicate().position(record.length() - padlen - 1)).get(pad);
                int i = 0;
                while (i < pad.length) {
                    if ((pad[i] & 0xFF) != padlen) {
                        badPadding = true;
                    }
                    ++i;
                }
                logger.logv(Component.SSL_RECORD_LAYER, "TLSv1.x padding\n{0}", new ByteArray(pad));
            }
            logger.logv(Component.SSL_RECORD_LAYER, "padding bad? {0}", badPadding);
            if (!badPadding) {
                fragmentLength -= padRemoveLen;
            }
        }
        int ivlen = 0;
        if (this.session.version.compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
            ivlen = this.cipher.getBlockSize();
        }
        if (this.mac != null) {
            this.mac.update((byte)(this.sequence >>> 56));
            this.mac.update((byte)(this.sequence >>> 48));
            this.mac.update((byte)(this.sequence >>> 40));
            this.mac.update((byte)(this.sequence >>> 32));
            this.mac.update((byte)(this.sequence >>> 24));
            this.mac.update((byte)(this.sequence >>> 16));
            this.mac.update((byte)(this.sequence >>> 8));
            this.mac.update((byte)this.sequence);
            this.mac.update((byte)record.getContentType().getValue());
            ProtocolVersion version = record.version();
            if (version != ProtocolVersion.SSL_3) {
                this.mac.update((byte)version.major());
                this.mac.update((byte)version.minor());
            }
            this.mac.update((byte)(fragmentLength - ivlen >>> 8));
            this.mac.update((byte)(fragmentLength - ivlen));
            ByteBuffer content = (ByteBuffer)fragment.duplicate().position(ivlen).limit(fragmentLength);
            this.mac.update(content);
            byte[] mac1 = this.mac.doFinal();
            byte[] mac2 = new byte[maclen];
            this.mac.reset();
            ((ByteBuffer)fragment.duplicate().position(fragmentLength)).get(mac2);
            logger.logv(Component.SSL_RECORD_LAYER, "mac1:{0} mac2:{1}", Util.toHexString(mac1, ':'), Util.toHexString(mac2, ':'));
            if (!Arrays.equals(mac1, mac2)) {
                badPadding = true;
            }
        }
        if (badPadding) {
            throw new MacException();
        }
        int produced = 0;
        if (this.inflater != null) {
            ByteBufferOutputStream out = new ByteBufferOutputStream(fragmentLength);
            byte[] inbuffer = new byte[1024];
            byte[] outbuffer = new byte[1024];
            boolean done = false;
            if (record.version().compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
                fragment.position(this.cipher.getBlockSize());
            } else {
                fragment.position(0);
            }
            fragment.limit(fragmentLength);
            while (!done) {
                int l;
                if (this.inflater.needsInput()) {
                    l = Math.min(inbuffer.length, fragment.remaining());
                    fragment.get(inbuffer, 0, l);
                    this.inflater.setInput(inbuffer);
                }
                l = this.inflater.inflate(outbuffer);
                out.write(outbuffer, 0, l);
                boolean bl = done = !fragment.hasRemaining() && this.inflater.finished();
            }
            ByteBuffer outbuf = out.buffer();
            if (outputStream != null) {
                byte[] buf = new byte[1024];
                while (outbuf.hasRemaining()) {
                    int l = Math.min(outbuf.remaining(), buf.length);
                    outbuf.get(buf, 0, l);
                    outputStream.write(buf, 0, l);
                    produced += l;
                }
            } else {
                int i = offset;
                while (outbuf.hasRemaining() && i < offset + length) {
                    int l = Math.min(output[i].remaining(), outbuf.remaining());
                    ByteBuffer b = (ByteBuffer)outbuf.duplicate().limit(outbuf.position() + l);
                    output[i++].put(b);
                    outbuf.position(outbuf.position() + l);
                    produced += l;
                }
                if (outbuf.hasRemaining()) {
                    throw new BufferOverflowException();
                }
            }
        } else {
            ByteBuffer outbuf = (ByteBuffer)fragment.duplicate().position(0).limit(record.length() - maclen - padRemoveLen);
            if (record.version().compareTo(ProtocolVersion.TLS_1_1) >= 0 && !this.suite.isStreamCipher()) {
                outbuf.position(this.cipher.getBlockSize());
            }
            if (outputStream != null) {
                byte[] buf = new byte[1024];
                while (outbuf.hasRemaining()) {
                    int l = Math.min(outbuf.remaining(), buf.length);
                    outbuf.get(buf, 0, l);
                    outputStream.write(buf, 0, l);
                    produced += l;
                }
            } else {
                int i = offset;
                while (outbuf.hasRemaining() && i < offset + length) {
                    int l = Math.min(output[i].remaining(), outbuf.remaining());
                    ByteBuffer b = (ByteBuffer)outbuf.duplicate().limit(outbuf.position() + l);
                    output[i++].put(b);
                    outbuf.position(outbuf.position() + l);
                    produced += l;
                }
                if (outbuf.hasRemaining()) {
                    throw new BufferOverflowException();
                }
            }
        }
        ++this.sequence;
        return produced;
    }

    CipherSuite cipherSuite() {
        return this.suite;
    }
}

