/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.naming.giop;

import gnu.CORBA.NamingService.Ext;
import gnu.CORBA.NamingService.NameTransformer;
import gnu.javax.naming.giop.ContextContinuation;
import gnu.javax.naming.giop.CorbalocParser;
import gnu.javax.naming.giop.GiopNamingServiceFactory;
import gnu.javax.naming.giop.ListBindingsEnumeration;
import gnu.javax.naming.giop.ListEnumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming._NamingContextExtStub;
import org.omg.CosNaming._NamingContextStub;

public class GiopNamingServiceURLContext
extends CorbalocParser
implements Context {
    public int DEFAULT_BATCH_SIZE = 20;
    ORB orb;
    Hashtable properties;
    GiopNamingServiceFactory factory;
    static NameTransformer transformer = new NameTransformer();
    public final int howMany;

    public GiopNamingServiceURLContext(Hashtable props, GiopNamingServiceFactory aFactory, ORB anOrb) {
        this.factory = aFactory;
        this.orb = anOrb;
        this.properties = props;
        this.howMany = this.getBatchSize();
    }

    public NamingContextExt getService(String address) {
        Object nsObject = this.orb.string_to_object(address);
        Delegate delegate = ((ObjectImpl)nsObject)._get_delegate();
        if (!nsObject._is_a(NamingContextExtHelper.id()) && nsObject._is_a(NamingContextHelper.id())) {
            _NamingContextStub stub = new _NamingContextStub();
            stub._set_delegate(delegate);
            return new Ext(stub);
        }
        _NamingContextExtStub stub = new _NamingContextExtStub();
        stub._set_delegate(delegate);
        return stub;
    }

    public String[] split(String corbaloc) throws InvalidNameException {
        if (corbaloc.endsWith("#")) {
            corbaloc = corbaloc.substring(0, corbaloc.length() - 1);
        }
        if (corbaloc.indexOf(35) < 0) {
            if (!corbaloc.regionMatches(true, 0, "corbaname", 0, "corbaname".length())) {
                throw new InvalidNameException(String.valueOf(corbaloc) + " must start with " + "corbaname");
            }
            corbaloc = "corbaloc" + corbaloc.substring("corbaname".length());
            return new String[]{corbaloc, ""};
        }
        return this.corbaloc(corbaloc, this.orb);
    }

    public void bind(Name name, java.lang.Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, java.lang.Object obj) throws NamingException {
        try {
            String[] n = this.split(name);
            Object object = (Object)obj;
            this.getService(n[0]).bind(transformer.toName(n[1]), object);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException(Object.class + " required ");
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (AlreadyBound alreadyBound) {
            throw new NameAlreadyBoundException();
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public void close() throws NamingException {
        if (this.orb != null && this.factory != null) {
            this.factory.checkIfReferenced(this.orb);
        }
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String composeName(String name1, String name2) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context createSubcontext(Name subContext) throws NamingException {
        return this.createSubcontext(subContext.toString());
    }

    public Context createSubcontext(String subContext) throws NamingException {
        try {
            String[] n = this.split(subContext);
            NamingContext subcontext = this.getService(n[0]).bind_new_context(transformer.toName(n[1]));
            Hashtable clonedProps = new Hashtable();
            clonedProps.putAll(this.properties);
            return new ContextContinuation(subcontext, clonedProps, null, null);
        }
        catch (AlreadyBound alreadyBound) {
            throw new NameAlreadyBoundException(subContext);
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException(subContext);
        }
        catch (Exception ex) {
            throw new NamingException(ex.toString());
        }
    }

    public void destroySubcontext(Name subContext) throws NamingException {
        this.unbind(subContext);
    }

    public void destroySubcontext(String subContext) throws NamingException {
        this.unbind(subContext);
    }

    public String getNameInNamespace() throws NamingException {
        return "";
    }

    public NameParser getNameParser(Name name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NameParser getNameParser(String name) throws NamingException {
        throw new UnsupportedOperationException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        NamingContext subcontext;
        BindingIteratorHolder bi = new BindingIteratorHolder();
        BindingListHolder bl = new BindingListHolder();
        String[] n = this.split(name);
        NamingContextExt service = this.getService(n[0]);
        if (n[1].length() == 0) {
            subcontext = service;
        } else {
            try {
                subcontext = NamingContextHelper.narrow(service.resolve_str(n[1]));
            }
            catch (Exception e) {
                throw new NamingException(e.toString());
            }
        }
        subcontext.list(this.howMany, bl, bi);
        return new ListEnumeration(bl, bi, this.howMany);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        NamingContext subcontext;
        BindingIteratorHolder bi = new BindingIteratorHolder();
        BindingListHolder bl = new BindingListHolder();
        String[] n = this.split(name);
        NamingContextExt service = this.getService(n[0]);
        if (n[1].length() == 0) {
            subcontext = service;
        } else {
            try {
                subcontext = NamingContextHelper.narrow(service.resolve_str(n[1]));
            }
            catch (Exception e) {
                throw new NamingException(e.toString());
            }
        }
        subcontext.list(this.howMany, bl, bi);
        return new ListBindingsEnumeration(bl, bi, this.howMany, subcontext);
    }

    public java.lang.Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public java.lang.Object lookup(String name) throws NamingException {
        try {
            String[] n = this.split(name);
            NamingContextExt service = this.getService(n[0]);
            return service.resolve_str(n[1]);
        }
        catch (NotFound notFound) {
            throw new NameNotFoundException();
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public java.lang.Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public java.lang.Object lookupLink(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public void rebind(Name name, java.lang.Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, java.lang.Object obj) throws NamingException {
        try {
            String[] n = this.split(name);
            NamingContextExt service = this.getService(n[0]);
            Object object = (Object)obj;
            service.rebind(transformer.toName(n[1]), object);
        }
        catch (ClassCastException classCastException) {
            throw new NamingException(Object.class + " required ");
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException();
        }
        catch (Exception e) {
            throw new NamingException(e.toString());
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        java.lang.Object object = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, object);
    }

    public void rename(String oldName, String newName) throws NamingException {
        java.lang.Object object = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, object);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        try {
            String[] n = this.split(name);
            NamingContextExt service = this.getService(n[0]);
            service.unbind(transformer.toName(n[1]));
        }
        catch (NotFound notFound) {
            throw new NameNotFoundException(name);
        }
        catch (CannotProceed cannotProceed) {
            throw new ContextNotEmptyException(name);
        }
        catch (InvalidName invalidName) {
            throw new InvalidNameException(name);
        }
    }

    public java.lang.Object addToEnvironment(String key, java.lang.Object value) throws NamingException {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        return this.properties.put(key, value);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.properties;
    }

    public java.lang.Object removeFromEnvironment(String propName) throws NamingException {
        return this.properties.remove(propName);
    }

    public NameComponent[] toGiop(Name name) throws InvalidName {
        return transformer.toName(name.toString());
    }

    public int getBatchSize() {
        int batchSize = this.DEFAULT_BATCH_SIZE;
        java.lang.Object bs = this.properties.get("java.naming.batchsize");
        if (bs != null) {
            try {
                int b = Integer.parseInt(bs.toString());
                if (b >= 0) {
                    batchSize = b;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return batchSize;
    }
}

