/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPEncoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import javax.imageio.IIOImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;

public class EncodeRLE8
extends BMPEncoder {
    protected BMPInfoHeader infoHeader;
    protected BMPFileHeader fileHeader;
    protected long offset;
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public EncodeRLE8(BMPFileHeader fh, BMPInfoHeader ih) {
        this.fileHeader = fh;
        this.infoHeader = ih;
        this.offset = 54L;
    }

    public void encode(ImageOutputStream o, IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        int rowIndex;
        int size = this.infoHeader.biWidth * this.infoHeader.biHeight - 1;
        int rowCount = 1;
        int lastRowIndex = rowIndex = size - this.infoHeader.biWidth;
        ByteBuffer buf = ByteBuffer.allocate(size);
        try {
            int[] bitmap = new int[this.infoHeader.biWidth * this.infoHeader.biHeight];
            PixelGrabber pg = new PixelGrabber((BufferedImage)image.getRenderedImage(), 0, 0, this.infoHeader.biWidth, this.infoHeader.biHeight, bitmap, 0, this.infoHeader.biWidth);
            pg.grabPixels();
            int j = 0;
            while (j < size) {
                int value = bitmap[rowIndex];
                buf.put((byte)(value & 0xFF));
                if (rowCount == this.infoHeader.biWidth) {
                    rowCount = 1;
                    lastRowIndex = rowIndex = lastRowIndex - this.infoHeader.biWidth;
                } else {
                    ++rowCount;
                }
                ++rowIndex;
                ++j;
            }
            buf.flip();
            o.write(this.uncompress(this.infoHeader.biWidth, this.infoHeader.biHeight, buf));
        }
        catch (Exception wb) {
            wb.printStackTrace();
        }
    }

    private byte[] uncompress(int w, int h, ByteBuffer buf) throws IOException {
        byte[] cmd = new byte[2];
        byte[] data = new byte[w * h];
        int x = 0;
        int y = 0;
        try {
            while (x + y * w < w * h) {
                try {
                    buf.get(cmd);
                }
                catch (BufferUnderflowException bufferUnderflowException) {
                    throw new IOException("Error reading compressed data.");
                }
                if (cmd[0] == 0) {
                    switch (cmd[1]) {
                        case 1: {
                            return data;
                        }
                        case 0: {
                            x = 0;
                            ++y;
                            break;
                        }
                        case 2: {
                            try {
                                buf.get(cmd);
                            }
                            catch (BufferUnderflowException bufferUnderflowException) {
                                throw new IOException("Error reading compressed data.");
                            }
                            int dx = cmd[0] & 0xFF;
                            int dy = cmd[1] & 0xFF;
                            x += dx;
                            y += dy;
                            break;
                        }
                        default: {
                            int length;
                            int copylength = length = cmd[1] & 0xFF;
                            length += length & 1;
                            byte[] run = new byte[length];
                            try {
                                buf.get(run);
                            }
                            catch (BufferUnderflowException bufferUnderflowException) {
                                throw new IOException("Error reading compressed data.");
                            }
                            System.arraycopy(run, 0, data, x + w * (h - y - 1), copylength);
                            x += copylength;
                            break;
                        }
                    }
                    continue;
                }
                int length = cmd[0] & 0xFF;
                int i = 0;
                while (i < length) {
                    data[(h - y - 1) * w + x++] = cmd[1];
                    ++i;
                }
            }
            return data;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BMPException("Invalid RLE data.");
        }
    }
}

