/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRGB8
extends BMPDecoder {
    public DecodeRGB8(BMPFileHeader fh, BMPInfoHeader ih) {
        super(fh, ih);
    }

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        IndexColorModel palette = this.readPalette(in);
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        int scansize = (w & 3) != 0 ? w + 4 - (w & 3) : w;
        byte[] data = new byte[w * h];
        int y = h - 1;
        while (y >= 0) {
            byte[] scanline = new byte[scansize];
            if (in.read(scanline) != scansize) {
                throw new IOException("Couldn't read image data.");
            }
            int x = 0;
            while (x < w) {
                data[x + y * w] = scanline[x];
                ++x;
            }
            --y;
        }
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(0, w, h, new int[]{255});
        DataBufferByte db = new DataBufferByte(data, w * h, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(palette, raster, false, null);
    }
}

