/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.hash.IMessageDigest;
import gnu.javax.crypto.mac.IMac;
import java.security.InvalidKeyException;
import java.util.Map;

public abstract class BaseMac
implements IMac {
    protected String name;
    protected IMessageDigest underlyingHash;
    protected int truncatedSize;

    protected BaseMac(String name) {
        this.name = name;
    }

    protected BaseMac(String name, IMessageDigest underlyingHash) {
        this(name);
        if (underlyingHash != null) {
            this.truncatedSize = underlyingHash.hashSize();
        }
        this.underlyingHash = underlyingHash;
    }

    public String name() {
        return this.name;
    }

    public int macSize() {
        return this.truncatedSize;
    }

    public void update(byte b) {
        this.underlyingHash.update(b);
    }

    public void update(byte[] b, int offset, int len) {
        this.underlyingHash.update(b, offset, len);
    }

    public void reset() {
        this.underlyingHash.reset();
    }

    public Object clone() throws CloneNotSupportedException {
        BaseMac result = (BaseMac)super.clone();
        if (this.underlyingHash != null) {
            result.underlyingHash = (IMessageDigest)this.underlyingHash.clone();
        }
        return result;
    }

    public abstract void init(Map var1) throws InvalidKeyException, IllegalStateException;

    public abstract byte[] digest();

    public abstract boolean selfTest();
}

