/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.key.dh;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.util.DerUtil;
import gnu.java.security.util.Util;
import gnu.javax.crypto.key.dh.GnuDHPrivateKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DHKeyPairPKCS8Codec
implements IKeyPairCodec {
    private static final OID DH_ALG_OID = new OID("1.2.840.10046.2.1");

    public int getFormatID() {
        return 3;
    }

    public byte[] encodePublicKey(PublicKey key) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        byte[] result;
        if (!(key instanceof GnuDHPrivateKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        DERValue derVersion = new DERValue(2, BigInteger.ZERO);
        DERValue derOID = new DERValue(6, DH_ALG_OID);
        GnuDHPrivateKey pk = (GnuDHPrivateKey)key;
        BigInteger p = pk.getParams().getP();
        BigInteger g = pk.getParams().getG();
        BigInteger q = pk.getQ();
        if (q == null) {
            q = BigInteger.ZERO;
        }
        BigInteger x = pk.getX();
        ArrayList<DERValue> params = new ArrayList<DERValue>(3);
        params.add(new DERValue(2, p));
        params.add(new DERValue(2, g));
        params.add(new DERValue(2, q));
        DERValue derParams = new DERValue(48, params);
        ArrayList<DERValue> algorithmID = new ArrayList<DERValue>(2);
        algorithmID.add(derOID);
        algorithmID.add(derParams);
        DERValue derAlgorithmID = new DERValue(48, algorithmID);
        DERValue derPrivateKey = new DERValue(4, Util.trim(x));
        ArrayList<DERValue> pki = new ArrayList<DERValue>(3);
        pki.add(derVersion);
        pki.add(derAlgorithmID);
        pki.add(derPrivateKey);
        DERValue derPKI = new DERValue(48, pki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derPKI);
            result = baos.toByteArray();
        }
        catch (IOException e) {
            InvalidParameterException y = new InvalidParameterException();
            y.initCause(e);
            throw y;
        }
        return result;
    }

    public PublicKey decodePublicKey(byte[] input) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public PrivateKey decodePrivateKey(byte[] input) {
        BigInteger x;
        BigInteger q;
        BigInteger g;
        BigInteger p;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader der = new DERReader(input);
        try {
            DERValue derPKI = der.read();
            DerUtil.checkIsConstructed(derPKI, "Wrong PrivateKeyInfo field");
            DERValue derVersion = der.read();
            if (!(derVersion.getValue() instanceof BigInteger)) {
                throw new InvalidParameterException("Wrong Version field");
            }
            BigInteger version = (BigInteger)derVersion.getValue();
            if (version.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected Version: " + version);
            }
            DERValue derAlgoritmID = der.read();
            DerUtil.checkIsConstructed(derAlgoritmID, "Wrong AlgorithmIdentifier field");
            DERValue derOID = der.read();
            OID algOID = (OID)derOID.getValue();
            if (!algOID.equals(DH_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + algOID);
            }
            DERValue derParams = der.read();
            DerUtil.checkIsConstructed(derParams, "Wrong DSS Parameters field");
            DERValue val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong P field");
            p = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong G field");
            g = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong Q field");
            q = (BigInteger)val.getValue();
            if (q.compareTo(BigInteger.ZERO) == 0) {
                q = null;
            }
            val = der.read();
            byte[] xBytes = (byte[])val.getValue();
            x = new BigInteger(1, xBytes);
        }
        catch (IOException e) {
            InvalidParameterException y = new InvalidParameterException();
            y.initCause(e);
            throw y;
        }
        return new GnuDHPrivateKey(3, q, p, g, x);
    }
}

