/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import gnu.javax.crypto.kwa.IKeyWrappingAlgorithm;
import gnu.javax.crypto.kwa.KeyUnwrappingException;
import gnu.javax.crypto.kwa.KeyWrappingAlgorithmFactory;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

abstract class KeyWrappingAlgorithmAdapter
extends CipherSpi {
    private static final Logger log = Logger.getLogger(KeyWrappingAlgorithmAdapter.class.getName());
    private static final String NO_PADDING = "nopadding";
    protected IKeyWrappingAlgorithm kwAlgorithm;
    protected int kwaBlockSize;
    protected int kwaKeySize;
    protected String supportedMode;
    protected int opmode = -1;
    byte[] iv;

    protected KeyWrappingAlgorithmAdapter(String name, int blockSize, int keySize, String supportedMode) {
        this.kwAlgorithm = KeyWrappingAlgorithmFactory.getInstance(name);
        this.kwaBlockSize = blockSize;
        this.kwaKeySize = keySize;
        this.supportedMode = supportedMode;
    }

    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] keyMaterial = key.getEncoded();
        byte[] result = this.kwAlgorithm.wrap(keyMaterial, 0, keyMaterial.length);
        return result;
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key result;
        byte[] keyBytes;
        try {
            keyBytes = this.kwAlgorithm.unwrap(wrappedKey, 0, wrappedKey.length);
        }
        catch (KeyUnwrappingException x) {
            InvalidKeyException y = new InvalidKeyException("engineUnwrap()");
            y.initCause(x);
            throw y;
        }
        switch (wrappedKeyType) {
            case 3: {
                result = new SecretKeySpec(keyBytes, wrappedKeyAlgorithm);
                break;
            }
            case 1: 
            case 2: {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(wrappedKeyAlgorithm);
                try {
                    if (wrappedKeyType == 2) {
                        result = keyFactory.generatePrivate(keySpec);
                        break;
                    }
                    result = keyFactory.generatePublic(keySpec);
                    break;
                }
                catch (InvalidKeySpecException x) {
                    InvalidKeyException y = new InvalidKeyException("engineUnwrap()");
                    y.initCause(x);
                    throw y;
                }
            }
            default: {
                IllegalArgumentException x = new IllegalArgumentException("Invalid 'wrappedKeyType': " + wrappedKeyType);
                InvalidKeyException y = new InvalidKeyException("engineUnwrap()");
                y.initCause(x);
                throw y;
            }
        }
        return result;
    }

    protected int engineGetBlockSize() {
        return this.kwaBlockSize;
    }

    protected byte[] engineGetIV() {
        return this.iv == null ? null : (byte[])this.iv.clone();
    }

    protected int engineGetOutputSize(int inputLength) {
        switch (this.opmode) {
            case 3: {
                return this.getOutputSizeForWrap(inputLength);
            }
            case 4: {
                return this.getOutputSizeForUnwrap(inputLength);
            }
        }
        throw new IllegalStateException();
    }

    protected AlgorithmParameters engineGetParameters() {
        BlockCipherParameterSpec spec = new BlockCipherParameterSpec(this.iv, this.kwaBlockSize, this.kwaKeySize);
        AlgorithmParameters result = null;
        try {
            result = AlgorithmParameters.getInstance("BlockCipherParameters");
            result.init(spec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        return result;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.checkOpMode(opmode);
        byte[] kekBytes = this.checkAndGetKekBytes(key);
        this.initAlgorithm(opmode, kekBytes, null, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        BlockCipherParameterSpec spec = null;
        try {
            if (params != null) {
                spec = params.getParameterSpec(BlockCipherParameterSpec.class);
            }
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {}
        this.engineInit(opmode, key, spec, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidKeyException {
        this.checkOpMode(opmode);
        byte[] kekBytes = this.checkAndGetKekBytes(key);
        byte[] ivBytes = null;
        if (params instanceof BlockCipherParameterSpec) {
            ivBytes = ((BlockCipherParameterSpec)params).getIV();
        } else if (params instanceof IvParameterSpec) {
            ivBytes = ((IvParameterSpec)params).getIV();
        }
        this.initAlgorithm(opmode, kekBytes, ivBytes, random);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        if (!this.supportedMode.equalsIgnoreCase(mode)) {
            throw new UnsupportedOperationException("Only " + this.supportedMode + " is supported");
        }
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        if (!NO_PADDING.equalsIgnoreCase(padding)) {
            throw new UnsupportedOperationException("Only NoPadding is supported");
        }
    }

    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLength) {
        throw new UnsupportedOperationException();
    }

    protected int engineUpdate(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws ShortBufferException {
        throw new UnsupportedOperationException();
    }

    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLength) throws IllegalBlockSizeException, BadPaddingException {
        throw new UnsupportedOperationException();
    }

    protected int engineDoFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        throw new UnsupportedOperationException();
    }

    protected int getOutputSizeForWrap(int inputLength) {
        return this.kwaBlockSize * (inputLength + this.kwaBlockSize - 1) / this.kwaBlockSize;
    }

    protected int getOutputSizeForUnwrap(int inputLength) {
        return this.kwaBlockSize * (inputLength + this.kwaBlockSize - 1) / this.kwaBlockSize;
    }

    private void checkOpMode(int opmode) {
        switch (opmode) {
            case 3: 
            case 4: {
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported operational mode: " + opmode);
    }

    private byte[] checkAndGetKekBytes(Key key) throws InvalidKeyException {
        if (!"RAW".equalsIgnoreCase(key.getFormat())) {
            throw new InvalidKeyException("Only RAW key format is supported");
        }
        byte[] result = key.getEncoded();
        int kekSize = result.length;
        if (kekSize != this.kwaKeySize) {
            throw new InvalidKeyException("Invalid key material size. Expected " + this.kwaKeySize + " but found " + kekSize);
        }
        return result;
    }

    private void initAlgorithm(int opmode, byte[] kek, byte[] ivBytes, SecureRandom rnd) throws InvalidKeyException {
        this.opmode = opmode;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.kwa.kek", kek);
        if (ivBytes != null) {
            this.iv = (byte[])ivBytes.clone();
            attributes.put("gnu.crypto.kwa.iv", this.iv);
        } else {
            this.iv = null;
        }
        if (rnd != null) {
            attributes.put("gnu.crypto.kwa.prng", rnd);
        }
        this.kwAlgorithm.init(attributes);
    }
}

