/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CharIndexedInputStream
implements CharIndexed {
    private static final int BUFFER_INCREMENT = 1024;
    private static final int UNKNOWN = Integer.MAX_VALUE;
    private BufferedInputStream br;
    private int index = -1;
    private int bufsize = 1024;
    private int end = Integer.MAX_VALUE;
    private char cached = (char)65535;
    private char[] lookBehind = new char[]{'\uffff', '\uffff'};

    CharIndexedInputStream(InputStream str, int index) {
        this.br = str instanceof BufferedInputStream ? (BufferedInputStream)str : new BufferedInputStream(str, 1024);
        this.next();
        if (index > 0) {
            this.move(index);
        }
    }

    private boolean next() {
        int i;
        block5: {
            if (this.end == 1) {
                return false;
            }
            --this.end;
            try {
                if (this.index != -1) {
                    this.br.reset();
                }
                i = this.br.read();
                this.br.mark(this.bufsize);
                if (i != -1) break block5;
                this.end = 1;
                this.cached = (char)65535;
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.cached = (char)65535;
                return false;
            }
        }
        this.cached = (char)i;
        this.index = 1;
        return true;
    }

    public char charAt(int index) {
        if (index == 0) {
            return this.cached;
        }
        if (index >= this.end) {
            return '\uffff';
        }
        if (index == -1) {
            return this.lookBehind[0];
        }
        if (index == -2) {
            return this.lookBehind[1];
        }
        if (index < -2) {
            return '\uffff';
        }
        if (index >= this.bufsize) {
            try {
                while (this.bufsize <= index) {
                    this.bufsize += 1024;
                }
                this.br.reset();
                this.br.mark(this.bufsize);
                this.br.skip(index - 1);
            }
            catch (IOException iOException) {}
        } else if (this.index != index) {
            try {
                this.br.reset();
                this.br.skip(index - 1);
            }
            catch (IOException iOException) {}
        }
        char ch = '\uffff';
        try {
            int i = this.br.read();
            this.index = index + 1;
            if (i == -1) {
                this.end = index;
                return ch;
            }
            ch = (char)i;
        }
        catch (IOException iOException) {}
        return ch;
    }

    public boolean move(int index) {
        boolean retval = true;
        while (retval && index-- > 0) {
            retval = this.next();
        }
        return retval;
    }

    public boolean isValid() {
        return this.cached != '\uffff';
    }

    public CharIndexed lookBehind(int index, int length) {
        throw new UnsupportedOperationException("difficult to look behind for an input stream");
    }

    public int length() {
        throw new UnsupportedOperationException("difficult to tell the length for an input stream");
    }

    public void setLastMatch(REMatch match) {
        throw new UnsupportedOperationException("difficult to support setLastMatch for an input stream");
    }

    public REMatch getLastMatch() {
        throw new UnsupportedOperationException("difficult to support getLastMatch for an input stream");
    }

    public void setHitEnd(REMatch match) {
        throw new UnsupportedOperationException("difficult to support setHitEnd for an input stream");
    }

    public boolean hitEnd() {
        throw new UnsupportedOperationException("difficult to support hitEnd for an input stream");
    }

    public int getAnchor() {
        throw new UnsupportedOperationException("difficult to support getAnchor for an input stream");
    }

    public void setAnchor(int anchor) {
        throw new UnsupportedOperationException("difficult to support setAnchor for an input stream");
    }

    public boolean move1(int index) {
        throw new UnsupportedOperationException("difficult to support move1 for an input stream");
    }
}

