/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.prefs;

import gnu.java.util.prefs.gconf.GConfNativePeer;
import java.security.Permission;
import java.util.List;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;

public class GConfBasedPreferences
extends AbstractPreferences {
    private static final Permission PERMISSION = new RuntimePermission("preferences");
    private static GConfNativePeer backend = new GConfNativePeer();
    private static final String DEFAULT_USER_ROOT = "/apps/classpath";
    private static final String DEFAULT_SYSTEM_ROOT = "/system";
    private String node = "";
    private final boolean isUser;

    public GConfBasedPreferences() {
        this(true);
    }

    public GConfBasedPreferences(boolean isUser) {
        this(null, "", isUser);
    }

    public GConfBasedPreferences(AbstractPreferences parent, String name, boolean isUser) {
        super(parent, name);
        int index;
        this.isUser = isUser;
        String absolutePath = this.absolutePath();
        if (absolutePath != null && absolutePath.endsWith("/")) {
            absolutePath = absolutePath.substring(0, absolutePath.length() - 1);
        }
        if ((index = absolutePath.lastIndexOf(47)) > -1) {
            absolutePath = absolutePath.substring(0, index + 1);
            absolutePath = String.valueOf(absolutePath) + GConfNativePeer.escapeString(name);
        }
        this.node = String.valueOf(this.getRealRoot(isUser)) + absolutePath;
        boolean nodeExist = backend.nodeExist(this.node);
        this.newNode = !nodeExist;
    }

    protected AbstractPreferences childSpi(String name) {
        GConfBasedPreferences preferenceNode = new GConfBasedPreferences(this, name, this.isUser);
        backend.startWatchingNode(this.node);
        return preferenceNode;
    }

    protected String[] childrenNamesSpi() throws BackingStoreException {
        List<String> nodeList = backend.getChildrenNodes(this.node);
        String[] nodes = new String[nodeList.size()];
        nodeList.toArray(nodes);
        return nodes;
    }

    public void flush() throws BackingStoreException {
        backend.suggestSync();
    }

    protected void flushSpi() throws BackingStoreException {
        this.flush();
    }

    protected String[] keysSpi() throws BackingStoreException {
        List<String> keyList = backend.getKeys(this.node);
        String[] keys = new String[keyList.size()];
        keyList.toArray(keys);
        return keys;
    }

    private void postorderRemove(String directory) {
        try {
            List<String> entries;
            List<String> dirs = backend.getChildrenNodes(directory);
            if (dirs.size() != 0) {
                for (String currentDir : dirs) {
                    this.postorderRemove(currentDir);
                }
            }
            if ((entries = backend.getKeys(directory)).size() != 0) {
                for (String key : entries) {
                    this.removeSpi(key);
                }
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    protected void putSpi(String key, String value) {
        backend.setString(this.getGConfKey(key), value);
    }

    protected void removeNodeSpi() throws BackingStoreException {
        this.postorderRemove(this.node);
        this.flush();
    }

    protected void removeSpi(String key) {
        backend.unset(this.getGConfKey(key));
    }

    public void sync() throws BackingStoreException {
        this.flush();
    }

    protected void syncSpi() throws BackingStoreException {
        this.sync();
    }

    protected String getSpi(String key) {
        return backend.getKey(this.getGConfKey(key));
    }

    public boolean isUserNode() {
        return this.isUser;
    }

    private String getGConfKey(String key) {
        String nodeName = "";
        key = GConfNativePeer.escapeString(key);
        nodeName = this.node.endsWith("/") ? String.valueOf(this.node) + key : String.valueOf(this.node) + "/" + key;
        return nodeName;
    }

    private String getRealRoot(boolean isUser) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(PERMISSION);
        }
        String root = null;
        root = isUser ? System.getProperty("gnu.java.util.prefs.gconf.user_root", DEFAULT_USER_ROOT) : System.getProperty("gnu.java.util.prefs.gconf.system_root", DEFAULT_SYSTEM_ROOT);
        return root;
    }
}

