/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RSAKeyPairX509Codec
implements IKeyPairCodec {
    private static final Logger log = Logger.getLogger(RSAKeyPairX509Codec.class.getName());
    private static final OID RSA_ALG_OID = new OID("1.2.840.113549.1.1.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey key) {
        byte[] result;
        if (!(key instanceof GnuRSAPublicKey)) {
            throw new InvalidParameterException("key");
        }
        DERValue derOID = new DERValue(6, RSA_ALG_OID);
        GnuRSAPublicKey rsaKey = (GnuRSAPublicKey)key;
        BigInteger n = rsaKey.getN();
        BigInteger e = rsaKey.getE();
        DERValue derN = new DERValue(2, n);
        DERValue derE = new DERValue(2, e);
        ArrayList<DERValue> algorithmID = new ArrayList<DERValue>(2);
        algorithmID.add(derOID);
        algorithmID.add(new DERValue(5, null));
        DERValue derAlgorithmID = new DERValue(48, algorithmID);
        ArrayList<DERValue> publicKey = new ArrayList<DERValue>(2);
        publicKey.add(derN);
        publicKey.add(derE);
        DERValue derPublicKey = new DERValue(48, publicKey);
        byte[] spkBytes = derPublicKey.getEncoded();
        DERValue derSPK = new DERValue(3, new BitString(spkBytes));
        ArrayList<DERValue> spki = new ArrayList<DERValue>(2);
        spki.add(derAlgorithmID);
        spki.add(derSPK);
        DERValue derSPKI = new DERValue(48, spki);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derSPKI);
            result = baos.toByteArray();
        }
        catch (IOException x) {
            InvalidParameterException y = new InvalidParameterException(x.getMessage());
            y.initCause(x);
            throw y;
        }
        return result;
    }

    public byte[] encodePrivateKey(PrivateKey key) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] input) {
        BigInteger e;
        BigInteger n;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader der = new DERReader(input);
        try {
            DERValue derSPKI = der.read();
            DerUtil.checkIsConstructed(derSPKI, "Wrong SubjectPublicKeyInfo field");
            DERValue derAlgorithmID = der.read();
            DerUtil.checkIsConstructed(derAlgorithmID, "Wrong AlgorithmIdentifier field");
            DERValue derOID = der.read();
            if (!(derOID.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID algOID = (OID)derOID.getValue();
            if (!algOID.equals(RSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + algOID);
            }
            DERValue val = der.read();
            if (val.getTag() == 5) {
                val = der.read();
            }
            if (!(val.getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] spkBytes = ((BitString)val.getValue()).toByteArray();
            der = new DERReader(spkBytes);
            val = der.read();
            DerUtil.checkIsConstructed(derAlgorithmID, "Wrong subjectPublicKey field");
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong modulus field");
            n = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong publicExponent field");
            e = (BigInteger)val.getValue();
        }
        catch (IOException x) {
            InvalidParameterException y = new InvalidParameterException(x.getMessage());
            y.initCause(x);
            throw y;
        }
        GnuRSAPublicKey result = new GnuRSAPublicKey(2, n, e);
        return result;
    }

    public PrivateKey decodePrivateKey(byte[] input) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

