/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key;

import gnu.java.security.key.IKeyPairGenerator;
import gnu.java.security.key.dss.DSSKeyPairGenerator;
import gnu.java.security.key.rsa.RSAKeyPairGenerator;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class KeyPairGeneratorFactory {
    private KeyPairGeneratorFactory() {
    }

    public static IKeyPairGenerator getInstance(String name) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        IKeyPairGenerator result = null;
        if (name.equalsIgnoreCase("dsa") || name.equalsIgnoreCase("dss")) {
            result = new DSSKeyPairGenerator();
        } else if (name.equalsIgnoreCase("rsa")) {
            result = new RSAKeyPairGenerator();
        } else if (name.equalsIgnoreCase("dh")) {
            result = KeyPairGeneratorFactory.makeInstance("gnu.javax.crypto.key.dh.GnuDHKeyPairGenerator");
        } else if (name.equalsIgnoreCase("srp")) {
            result = KeyPairGeneratorFactory.makeInstance("gnu.javax.crypto.key.srp6.SRPKeyPairGenerator");
        }
        return result;
    }

    public static final Set getNames() {
        HashSet<String> hs = new HashSet<String>();
        hs.add("dss");
        hs.add("dsa");
        hs.add("rsa");
        hs.add("dh");
        hs.add("srp");
        return Collections.unmodifiableSet(hs);
    }

    private static IKeyPairGenerator makeInstance(String clazz) {
        try {
            Class<?> c = Class.forName(clazz);
            Constructor<?> ctor = c.getConstructor(new Class[0]);
            return (IKeyPairGenerator)ctor.newInstance(new Object[0]);
        }
        catch (Exception x) {
            throw new IllegalArgumentException("strong crypto key pair generator not available: " + clazz, x);
        }
    }
}

