/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.jce.sig;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.ArrayList;

public class DSSParameters
extends AlgorithmParametersSpi {
    private BigInteger p;
    private BigInteger q;
    private BigInteger g;

    protected void engineInit(AlgorithmParameterSpec spec) throws InvalidParameterSpecException {
        if (!(spec instanceof DSAParameterSpec)) {
            throw new InvalidParameterSpecException("Wrong AlgorithmParameterSpec type: " + spec.getClass().getName());
        }
        DSAParameterSpec dsaSpec = (DSAParameterSpec)spec;
        this.p = dsaSpec.getP();
        this.q = dsaSpec.getQ();
        this.g = dsaSpec.getG();
    }

    protected void engineInit(byte[] params) throws IOException {
        DERReader der = new DERReader(params);
        DERValue derParams = der.read();
        DerUtil.checkIsConstructed(derParams, "Wrong DSS Parameters field");
        DERValue val = der.read();
        DerUtil.checkIsBigInteger(val, "Wrong P field");
        this.p = (BigInteger)val.getValue();
        val = der.read();
        DerUtil.checkIsBigInteger(val, "Wrong Q field");
        this.q = (BigInteger)val.getValue();
        val = der.read();
        DerUtil.checkIsBigInteger(val, "Wrong G field");
        this.g = (BigInteger)val.getValue();
    }

    protected void engineInit(byte[] params, String format) throws IOException {
        if (format != null) {
            if ((format = format.trim()).length() == 0) {
                throw new IOException("Format MUST NOT be an empty string");
            }
            if (!format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown or unsupported format: " + format);
            }
        }
        this.engineInit(params);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (!paramSpec.isAssignableFrom(DSAParameterSpec.class)) {
            throw new InvalidParameterSpecException("Wrong AlgorithmParameterSpec type: " + paramSpec.getName());
        }
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    protected byte[] engineGetEncoded() throws IOException {
        DERValue derP = new DERValue(2, this.p);
        DERValue derQ = new DERValue(2, this.q);
        DERValue derG = new DERValue(2, this.g);
        ArrayList<DERValue> params = new ArrayList<DERValue>(3);
        params.add(derP);
        params.add(derQ);
        params.add(derG);
        DERValue derParams = new DERValue(48, params);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DERWriter.write(baos, derParams);
        byte[] result = baos.toByteArray();
        return result;
    }

    protected byte[] engineGetEncoded(String format) throws IOException {
        if (format != null) {
            if ((format = format.trim()).length() == 0) {
                throw new IOException("Format MUST NOT be an empty string");
            }
            if (!format.equalsIgnoreCase("ASN.1")) {
                throw new IOException("Unknown or unsupported format: " + format);
            }
        }
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        StringBuffer sb = new StringBuffer("p=");
        if (this.p == null) {
            sb.append("???");
        } else {
            sb.append("0x").append(this.p.toString(16));
        }
        sb.append(", q=");
        if (this.q == null) {
            sb.append("???");
        } else {
            sb.append("0x").append(this.q.toString(16));
        }
        sb.append(", g=");
        if (this.g == null) {
            sb.append("???");
        } else {
            sb.append("0x").append(this.g.toString(16));
        }
        return sb.toString();
    }
}

