/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import gnu.java.nio.charset.US_ASCII;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class ISO_8859_1
extends Charset {
    ISO_8859_1() {
        super("ISO-8859-1", new String[]{"iso-ir-100", "ISO_8859-1", "latin1", "l1", "IBM819", "CP819", "csISOLatin1", "8859_1", "ISO8859_1", "ISO_8859_1", "ibm-819", "ISO_8859-1:1987", "819", "ISO8859-1"});
    }

    public boolean contains(Charset cs) {
        return cs instanceof US_ASCII || cs instanceof ISO_8859_1;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Decoder
    extends CharsetDecoder {
        Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                byte b = in.get();
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                out.put((char)(b & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        Encoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
        }

        public boolean canEncode(char c) {
            return c <= '\u00ff';
        }

        public boolean canEncode(CharSequence cs) {
            int i = 0;
            while (i < cs.length()) {
                if (!this.canEncode(cs.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                char c = in.get();
                if (c > '\u00ff') {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                if (!out.hasRemaining()) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)c);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

