/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.local;

import gnu.java.net.local.LocalSocket;
import gnu.java.net.local.LocalSocketImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;

public final class LocalServerSocket
extends ServerSocket {
    private LocalSocketImpl myImpl = new LocalSocketImpl();
    private boolean closed;

    public LocalServerSocket() throws IOException {
    }

    public LocalServerSocket(SocketAddress bindPoint) throws IOException {
        this();
        this.bind(bindPoint);
    }

    public void bind(SocketAddress bindPoint) throws IOException {
        this.bind(bindPoint, 0);
    }

    public void bind(SocketAddress bindPoint, int backlog) throws IOException {
        this.myImpl.doCreate();
        this.myImpl.bind(bindPoint);
        this.myImpl.listen(backlog);
    }

    public InetAddress getInetAddress() {
        return null;
    }

    public int getLocalPort() {
        return -1;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.myImpl.getLocalAddress();
    }

    public Socket accept() throws IOException {
        LocalSocket s = new LocalSocket(true);
        this.myImpl.accept(s.getLocalImpl());
        s.localConnected = true;
        return s;
    }

    public void close() throws IOException {
        this.myImpl.close();
        this.myImpl.unlink();
        this.closed = true;
    }

    public boolean isBound() {
        return this.myImpl.getLocalAddress() != null;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setSoTimeout(int timeout) {
        throw new UnsupportedOperationException("local sockets do not support timeouts");
    }

    public int getSoTimeout() {
        throw new UnsupportedOperationException("local sockets do not support timeouts");
    }

    public void setReuseAddress(boolean b) {
        throw new UnsupportedOperationException("local sockets do not support reuse address");
    }

    public boolean getReuseAddress() {
        throw new UnsupportedOperationException("local sockets do not support reuse address");
    }

    public String toString() {
        return String.valueOf(LocalServerSocket.class.getName()) + " [ address=" + this.myImpl.getLocalAddress() + " ]";
    }

    public void setReceiveBufferSize(int size) {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }

    public int getReceiveBufferSize() {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }

    public void setSendBufferSize(int size) {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }

    public int getSendBufferSize() {
        throw new UnsupportedOperationException("local sockets do not support buffer size");
    }
}

