/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.NativeWrapper;
import gnu.java.awt.peer.qt.QtCanvasPeer;
import gnu.java.awt.peer.qt.QtContainerPeer;
import gnu.java.awt.peer.qt.QtFontMetrics;
import gnu.java.awt.peer.qt.QtFontPeer;
import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtScrollPanePeer;
import gnu.java.awt.peer.qt.QtToolkit;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;
import java.awt.event.WindowEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import sun.awt.CausedFocusEvent;

public class QtComponentPeer
extends NativeWrapper
implements ComponentPeer {
    protected static final int POPUP_TRIGGER = 3;
    protected QtToolkit toolkit;
    Component owner;
    private long eventMask;
    private boolean hasMotionListeners;
    protected QtImage backBuffer;
    protected long qtApp;
    private boolean settingUp;
    private boolean ignoreResize = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    QtComponentPeer(QtToolkit kit, Component owner) {
        this.owner = owner;
        this.toolkit = kit;
        this.qtApp = QtToolkit.guiThread.QApplicationPointer;
        this.nativeObject = 0L;
        QtComponentPeer qtComponentPeer = this;
        synchronized (qtComponentPeer) {
            this.callInit();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setup();
        this.hasMotionListeners = false;
    }

    protected native void callInit();

    protected void init() {
    }

    protected void setup() {
        this.settingUp = true;
        if (this.owner != null) {
            if (this.owner instanceof JComponent) {
                this.setBackground(this.owner.getBackground());
            } else {
                this.owner.setBackground(this.getNativeBackground());
            }
            if (this.owner.getForeground() != null) {
                this.setForeground(this.owner.getForeground());
            } else {
                this.setForeground(Color.black);
            }
            if (this.owner.getCursor() != null && this.owner.getCursor().getType() != 0) {
                this.setCursor(this.owner.getCursor());
            }
            if (this.owner.getFont() != null) {
                this.setFont(this.owner.getFont());
            }
            this.setEnabled(this.owner.isEnabled());
            this.backBuffer = null;
            this.updateBounds();
            this.setVisible(this.owner.isVisible());
            QtToolkit.repaintThread.queueComponent(this);
        }
        this.settingUp = false;
    }

    native void QtUpdate();

    native void QtUpdateArea(int var1, int var2, int var3, int var4);

    private synchronized native void disposeNative();

    private native void setGround(int var1, int var2, int var3, boolean var4);

    private native void setBoundsNative(int var1, int var2, int var3, int var4);

    private native void setCursor(int var1);

    private native Color getNativeBackground();

    private native void setFontNative(QtFontPeer var1);

    private native int whichScreen();

    private native void reparentNative(QtContainerPeer var1);

    private native void getLocationOnScreenNative(Point var1);

    private boolean drawableComponent() {
        return this instanceof QtContainerPeer && !(this instanceof QtScrollPanePeer) || this instanceof QtCanvasPeer;
    }

    void updateBounds() {
        Rectangle r = this.owner.getBounds();
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    synchronized void updateBackBuffer(int width, int height) {
        if (width <= 0 || height <= 0) {
            return;
        }
        if (!this.drawableComponent() && this.backBuffer == null) {
            return;
        }
        if (this.backBuffer != null) {
            if (width < this.backBuffer.width && height < this.backBuffer.height) {
                return;
            }
            this.backBuffer.dispose();
        }
        this.backBuffer = new QtImage(width, height);
    }

    protected void closeEvent() {
        if (this.owner instanceof Window) {
            WindowEvent e = new WindowEvent((Window)this.owner, 201);
            QtToolkit.eventQueue.postEvent(e);
        }
    }

    protected void enterEvent(int modifiers, int x, int y, int dummy) {
        MouseEvent e = new MouseEvent(this.owner, 504, System.currentTimeMillis(), modifiers & 0x2FF, x, y, 0, false);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void focusInEvent() {
        FocusEvent e = new FocusEvent(this.owner, 1004);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void focusOutEvent() {
        FocusEvent e = new FocusEvent(this.owner, 1005);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void keyPressEvent(int modifiers, int code, int unicode, int dummy) {
        KeyEvent e;
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (!manager.dispatchEvent(e = new KeyEvent(this.owner, 401, System.currentTimeMillis(), modifiers, code, (char)(unicode & 0xFFFF), 0))) {
            QtToolkit.eventQueue.postEvent(e);
        }
    }

    protected void keyReleaseEvent(int modifiers, int code, int unicode, int dummy) {
        KeyEvent e = new KeyEvent(this.owner, 402, System.currentTimeMillis(), modifiers, code, (char)(unicode & 0xFFFF), 0);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void leaveEvent(int modifiers, int x, int y, int dummy) {
        MouseEvent e = new MouseEvent(this.owner, 505, System.currentTimeMillis(), modifiers & 0x2FF, x, y, 0, false);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void mouseDoubleClickEvent(int modifiers, int x, int y, int clickCount) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int button = 0;
        if ((modifiers & 0x400) == 1024) {
            button = 1;
        }
        if ((modifiers & 0x800) == 2048) {
            button = 2;
        }
        if ((modifiers & 0x1000) == 4096) {
            button = 3;
        }
        MouseEvent e = new MouseEvent(this.owner, 500, System.currentTimeMillis(), modifiers & 0x2FF, x, y, clickCount, false, button);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void mouseMoveEvent(int modifiers, int x, int y, int clickCount) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int button = 0;
        if ((modifiers & 0x400) == 1024) {
            button = 1;
        }
        if ((modifiers & 0x800) == 2048) {
            button = 2;
        }
        if ((modifiers & 0x1000) == 4096) {
            button = 3;
        }
        int type = button != 0 ? 506 : 503;
        MouseEvent e = new MouseEvent(this.owner, type, System.currentTimeMillis(), modifiers & 0x2FF, x, y, clickCount, false, button);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void mousePressEvent(int modifiers, int x, int y, int clickCount) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int button = 0;
        if ((modifiers & 0x400) == 1024) {
            button = 1;
        }
        if ((modifiers & 0x800) == 2048) {
            button = 2;
        }
        if ((modifiers & 0x1000) == 4096) {
            button = 3;
        }
        MouseEvent e = new MouseEvent(this.owner, 501, System.currentTimeMillis(), modifiers & 0x2FF, x, y, clickCount, button == 3, button);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void mouseReleaseEvent(int modifiers, int x, int y, int clickCount) {
        if ((this.eventMask & 0x10L) == 0L) {
            return;
        }
        int button = 0;
        if ((modifiers & 0x400) == 1024) {
            button = 1;
        }
        if ((modifiers & 0x800) == 2048) {
            button = 2;
        }
        if ((modifiers & 0x1000) == 4096) {
            button = 3;
        }
        MouseEvent e = new MouseEvent(this.owner, 502, System.currentTimeMillis(), modifiers & 0x2FF, x, y, clickCount, false, button);
        QtToolkit.eventQueue.postEvent(e);
    }

    protected void moveEvent(int x, int y, int oldx, int oldy) {
        if (!this.ignoreResize) {
            this.ignoreResize = true;
            this.owner.setLocation(x, y);
            this.ignoreResize = false;
        }
    }

    protected void resizeEvent(int oldWidth, int oldHeight, int width, int height) {
        if (!(this.owner instanceof Window)) {
            return;
        }
        this.updateBackBuffer(width, height);
        this.ignoreResize = true;
        this.owner.setSize(width, height);
        this.ignoreResize = false;
        ComponentEvent e = new ComponentEvent(this.owner, 101);
        QtToolkit.eventQueue.postEvent(e);
        QtToolkit.repaintThread.queueComponent(this);
    }

    protected void showEvent() {
        if (this.owner instanceof Window) {
            WindowEvent e = new WindowEvent((Window)this.owner, 200);
            QtToolkit.eventQueue.postEvent(e);
        } else {
            ComponentEvent e = new ComponentEvent(this.owner, 102);
            QtToolkit.eventQueue.postEvent(e);
        }
    }

    protected void hideEvent() {
        ComponentEvent e = new ComponentEvent(this.owner, 103);
        QtToolkit.eventQueue.postEvent(e);
    }

    public void setEventMask(long x) {
        this.eventMask = x;
    }

    public boolean canDetermineObscurity() {
        return true;
    }

    public int checkImage(Image img, int w, int h, ImageObserver o) {
        return this.toolkit.checkImage(img, w, h, o);
    }

    public void createBuffers(int numBuffers, BufferCapabilities caps) throws AWTException {
    }

    public Image createImage(ImageProducer producer) {
        return this.toolkit.createImage(producer);
    }

    public Image createImage(int width, int height) {
        return new QtImage(width, height);
    }

    public void coalescePaintEvent(PaintEvent e) {
    }

    public VolatileImage createVolatileImage(int w, int h) {
        return new QtVolatileImage(w, h);
    }

    public void destroyBuffers() {
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void dispose() {
        this.disposeNative();
        if (this.backBuffer != null) {
            this.backBuffer.dispose();
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void finalize() {
        this.dispose();
    }

    public void flip(BufferCapabilities.FlipContents contents) {
    }

    public Image getBackBuffer() {
        return this.backBuffer;
    }

    public ColorModel getColorModel() {
        return this.toolkit.getColorModel();
    }

    public FontMetrics getFontMetrics(Font font) {
        return new QtFontMetrics(font, this.getGraphics());
    }

    public Graphics getGraphics() {
        if (this.backBuffer == null) {
            Rectangle r = this.owner.getBounds();
            this.backBuffer = new QtImage(r.width, r.height);
        }
        return this.backBuffer.getDirectGraphics(this);
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        int id = this.whichScreen();
        GraphicsDevice[] devs = QtToolkit.graphicsEnv.getScreenDevices();
        return devs[id].getDefaultConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Point p;
        Point point = p = new Point();
        synchronized (point) {
            this.getLocationOnScreenNative(p);
            try {
                p.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return p;
    }

    private native void getSizeNative(Dimension var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getSize(boolean preferred) {
        Dimension d;
        Dimension dimension = d = new Dimension();
        synchronized (dimension) {
            this.getSizeNative(d, preferred);
            try {
                d.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return d;
    }

    public Dimension getMinimumSize() {
        return this.getSize(false);
    }

    public Dimension getPreferredSize() {
        return this.getSize(true);
    }

    public Toolkit getToolkit() {
        return this.toolkit;
    }

    public native boolean handlesWheelScrolling();

    public void hide() {
        this.setVisible(false);
    }

    public native boolean isFocusable();

    public boolean isFocusTraversable() {
        return false;
    }

    public native boolean isObscured();

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public native void requestFocus();

    public boolean requestFocus(Component source, boolean bool1, boolean bool2, long x) {
        return true;
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void setBackground(Color c) {
        if (c == null && !this.settingUp) {
            return;
        }
        this.setGround(c.getRed(), c.getGreen(), c.getBlue(), false);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.ignoreResize) {
            return;
        }
        this.updateBackBuffer(width, height);
        QtToolkit.repaintThread.queueComponent(this);
        this.setBoundsNative(x, y, width, height);
    }

    public void setCursor(Cursor cursor) {
        if (cursor != null) {
            this.setCursor(cursor.getType());
        }
    }

    public native void setEnabled(boolean var1);

    public void setFont(Font f) {
        if (f == null || f.getPeer() == null) {
            throw new IllegalArgumentException("Null font.");
        }
        this.setFontNative((QtFontPeer)f.getPeer());
    }

    public void setForeground(Color c) {
        if (c == null && !this.settingUp) {
            return;
        }
        this.setGround(c.getRed(), c.getGreen(), c.getBlue(), true);
    }

    public native void setVisible(boolean var1);

    public void show() {
        this.setVisible(true);
    }

    public void handleEvent(AWTEvent e) {
        int eventID = e.getID();
        switch (eventID) {
            case 102: {
                QtToolkit.repaintThread.queueComponent(this);
                break;
            }
            case 800: 
            case 801: {
                Rectangle r = ((PaintEvent)e).getUpdateRect();
                QtToolkit.repaintThread.queueComponent(this, r.x, r.y, r.width, r.height);
                break;
            }
            case 401: {
                break;
            }
        }
    }

    public void paint(Graphics g) {
        Rectangle r = g.getClipBounds();
        if (this.backBuffer != null) {
            this.backBuffer.drawPixelsScaledFlipped((QtGraphics)g, 0, 0, 0, false, false, r.x, r.y, r.width, r.height, r.x, r.y, r.width, r.height, false);
        }
    }

    public void paintBackBuffer() throws InterruptedException {
        if (this.backBuffer != null) {
            this.backBuffer.clear();
            Graphics2D bbg = (Graphics2D)this.backBuffer.getGraphics();
            this.owner.paint(bbg);
            bbg.dispose();
        }
    }

    public void paintBackBuffer(int x, int y, int w, int h) throws InterruptedException {
        if (this.backBuffer != null) {
            Graphics2D bbg = (Graphics2D)this.backBuffer.getGraphics();
            bbg.setBackground(this.getNativeBackground());
            bbg.clearRect(x, y, w, h);
            bbg.setClip(x, y, w, h);
            this.owner.paint(bbg);
            bbg.dispose();
        }
    }

    public boolean prepareImage(Image img, int w, int h, ImageObserver o) {
        return this.toolkit.prepareImage(img, w, h, o);
    }

    public void print(Graphics g) {
    }

    public void repaint(long tm, int x, int y, int w, int h) {
        if (tm <= 0L) {
            QtToolkit.repaintThread.queueComponent(this, x, y, w, h);
            return;
        }
        Timer t = new Timer();
        t.schedule((TimerTask)new RepaintTimerTask(this, x, y, w, h), tm);
    }

    public void updateCursorImmediately() {
        if (this.owner.getCursor() != null) {
            this.setCursor(this.owner.getCursor().getType());
        }
    }

    public native Rectangle getBounds();

    public void reparent(ContainerPeer parent) {
        if (!(parent instanceof QtContainerPeer)) {
            throw new IllegalArgumentException("Illegal peer.");
        }
        this.reparentNative((QtContainerPeer)parent);
    }

    public void setBounds(int x, int y, int width, int height, int z) {
    }

    public boolean isReparentSupported() {
        return true;
    }

    public void layout() {
    }

    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        return true;
    }

    private class RepaintTimerTask
    extends TimerTask {
        private int x;
        private int y;
        private int w;
        private int h;
        private QtComponentPeer peer;

        RepaintTimerTask(QtComponentPeer peer, int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.peer = peer;
        }

        public void run() {
            QtToolkit.repaintThread.queueComponent(this.peer, this.x, this.y, this.w, this.h);
        }
    }
}

