/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.ClasspathGraphicsEnvironment;
import gnu.java.awt.peer.gtk.BufferedImageGraphics;
import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.peer.gtk.GdkScreenGraphicsDevice;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Locale;

public class GdkGraphicsEnvironment
extends ClasspathGraphicsEnvironment {
    private final int native_state = GtkGenericPeer.getUniqueInteger();
    private GdkScreenGraphicsDevice defaultDevice;
    private GdkScreenGraphicsDevice[] devices;
    private Pointer display;

    static {
        System.loadLibrary("gtkpeer");
        GtkToolkit.initializeGlobalIDs();
        GdkGraphicsEnvironment.initIDs();
    }

    private static native void initIDs();

    public GdkGraphicsEnvironment() {
        this.nativeInitState();
    }

    native void nativeInitState();

    public GraphicsDevice[] getScreenDevices() {
        if (this.devices == null) {
            this.devices = this.nativeGetScreenDevices();
        }
        return (GraphicsDevice[])this.devices.clone();
    }

    private native GdkScreenGraphicsDevice[] nativeGetScreenDevices();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GraphicsDevice getDefaultScreenDevice() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        Class<GdkGraphicsEnvironment> clazz = GdkGraphicsEnvironment.class;
        synchronized (GdkGraphicsEnvironment.class) {
            if (this.defaultDevice == null) {
                this.defaultDevice = this.nativeGetDefaultScreenDevice();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.defaultDevice;
        }
    }

    private native GdkScreenGraphicsDevice nativeGetDefaultScreenDevice();

    public Graphics2D createGraphics(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        if (raster instanceof CairoSurface) {
            return ((CairoSurface)raster).getGraphics();
        }
        return new BufferedImageGraphics(image);
    }

    private native int nativeGetNumFontFamilies();

    private native void nativeGetFontFamilies(String[] var1);

    public Font[] getAllFonts() {
        throw new UnsupportedOperationException();
    }

    public String[] getAvailableFontFamilyNames() {
        int array_size = this.nativeGetNumFontFamilies();
        String[] family_names = new String[array_size];
        this.nativeGetFontFamilies(family_names);
        return family_names;
    }

    public String[] getAvailableFontFamilyNames(Locale l) {
        throw new UnsupportedOperationException();
    }

    native int[] getMouseCoordinates();

    native boolean isWindowUnderMouse(GtkWindowPeer var1);

    public WritableRaster createRaster(ColorModel cm, SampleModel sm) {
        if (CairoSurface.isCompatibleSampleModel(sm) && CairoSurface.isCompatibleColorModel(cm)) {
            return new CairoSurface(sm.getWidth(), sm.getHeight());
        }
        return null;
    }
}

