/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer;

import gnu.java.awt.ClasspathToolkit;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public abstract class ClasspathFontPeer
implements FontPeer {
    protected String logicalName;
    protected String familyName;
    protected String faceName;
    protected int style;
    protected float size;
    protected AffineTransform transform;
    private static LRUCache<AffineTransform, TransformAttribute> transCache = new LRUCache(50);

    protected static ClasspathToolkit tk() {
        return (ClasspathToolkit)Toolkit.getDefaultToolkit();
    }

    protected static boolean isLogicalFontName(String name) {
        String uname = name.toUpperCase();
        return uname.equals("SANSSERIF") || uname.equals("SERIF") || uname.equals("MONOSPACED") || uname.equals("DIALOG") || uname.equals("DIALOGINPUT") || uname.equals("DEFAULT");
    }

    protected static String logicalFontNameToFaceName(String name) {
        String uname = name.toUpperCase();
        if (uname.equals("SANSSERIF")) {
            return "Helvetica";
        }
        if (uname.equals("SERIF")) {
            return "Times";
        }
        if (uname.equals("MONOSPACED")) {
            return "Courier";
        }
        if (uname.equals("DIALOG")) {
            return "Helvetica";
        }
        if (uname.equals("DIALOGINPUT")) {
            return "Helvetica";
        }
        if (uname.equals("DEFAULT")) {
            return "Dialog.plain";
        }
        return "Helvetica";
    }

    protected static String faceNameToFamilyName(String name) {
        return name;
    }

    public static void copyStyleToAttrs(int style, Map attrs) {
        if ((style & 1) == 1) {
            attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            attrs.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR);
        }
        if ((style & 2) == 2) {
            attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            attrs.put(TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR);
        }
    }

    protected static void copyFamilyToAttrs(String fam, Map attrs) {
        if (fam != null) {
            attrs.put(TextAttribute.FAMILY, fam);
        }
    }

    public static void copySizeToAttrs(float size, Map attrs) {
        attrs.put(TextAttribute.SIZE, new Float(size));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copyTransformToAttrs(AffineTransform trans, Map attrs) {
        if (trans != null) {
            TransformAttribute ta;
            LRUCache<AffineTransform, TransformAttribute> lRUCache = transCache;
            synchronized (lRUCache) {
                ta = (TransformAttribute)transCache.get(trans);
                if (ta == null) {
                    ta = new TransformAttribute(trans);
                    transCache.put(trans, ta);
                }
            }
            attrs.put(TextAttribute.TRANSFORM, ta);
        }
    }

    protected void setStandardAttributes(String name, String family, int style, float size, AffineTransform trans) {
        this.logicalName = name;
        this.faceName = ClasspathFontPeer.isLogicalFontName(name) ? ClasspathFontPeer.logicalFontNameToFaceName(name) : name;
        this.familyName = family != null ? family : ClasspathFontPeer.faceNameToFamilyName(this.faceName);
        this.style = style;
        this.size = size;
        this.transform = trans;
    }

    protected void setStandardAttributes(String name, Map attribs) {
        Float posture;
        Float weight;
        String family = this.familyName;
        AffineTransform trans = this.transform;
        float size = this.size;
        int style = this.style;
        if (attribs.containsKey(TextAttribute.FAMILY)) {
            family = (String)attribs.get(TextAttribute.FAMILY);
        }
        if (name == null) {
            name = "Default";
        }
        if (attribs.containsKey(TextAttribute.WEIGHT) && (weight = (Float)attribs.get(TextAttribute.WEIGHT)).floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
            ++style;
        }
        if (attribs.containsKey(TextAttribute.POSTURE) && (posture = (Float)attribs.get(TextAttribute.POSTURE)).floatValue() >= TextAttribute.POSTURE_OBLIQUE.floatValue()) {
            style += 2;
        }
        if (attribs.containsKey(TextAttribute.SIZE)) {
            Float sz = (Float)attribs.get(TextAttribute.SIZE);
            size = sz.floatValue();
            if (size < 1.0f) {
                size = 1.0f;
            }
        } else {
            size = 12.0f;
        }
        if (attribs.containsKey(TextAttribute.TRANSFORM)) {
            TransformAttribute ta = (TransformAttribute)attribs.get(TextAttribute.TRANSFORM);
            trans = ta.getTransform();
        }
        this.setStandardAttributes(name, family, style, size, trans);
    }

    protected void getStandardAttributes(Map attrs) {
        ClasspathFontPeer.copyFamilyToAttrs(this.familyName, attrs);
        ClasspathFontPeer.copySizeToAttrs(this.size, attrs);
        ClasspathFontPeer.copyStyleToAttrs(this.style, attrs);
        ClasspathFontPeer.copyTransformToAttrs(this.transform, attrs);
    }

    public ClasspathFontPeer(String name, Map attrs) {
        this.setStandardAttributes(name, attrs);
    }

    public ClasspathFontPeer(String name, int style, int size) {
        this.setStandardAttributes(name, null, style, size, null);
    }

    public String getName(Font font) {
        return this.logicalName;
    }

    public String getFamily(Font font) {
        return this.familyName;
    }

    public String getFamily(Font font, Locale lc) {
        return this.familyName;
    }

    public String getFontName(Font font) {
        return this.faceName;
    }

    public String getFontName(Font font, Locale lc) {
        return this.faceName;
    }

    public float getSize(Font font) {
        return this.size;
    }

    public boolean isPlain(Font font) {
        return this.style == 0;
    }

    public boolean isBold(Font font) {
        return (this.style & 1) == 1;
    }

    public boolean isItalic(Font font) {
        return (this.style & 2) == 2;
    }

    public Font deriveFont(Font font, int style, float size) {
        HashMap attrs = new HashMap();
        this.getStandardAttributes(attrs);
        ClasspathFontPeer.copyStyleToAttrs(style, attrs);
        ClasspathFontPeer.copySizeToAttrs(size, attrs);
        return ClasspathFontPeer.tk().getFont(this.logicalName, attrs);
    }

    public Font deriveFont(Font font, float size) {
        HashMap attrs = new HashMap();
        this.getStandardAttributes(attrs);
        ClasspathFontPeer.copySizeToAttrs(size, attrs);
        return ClasspathFontPeer.tk().getFont(this.logicalName, attrs);
    }

    public Font deriveFont(Font font, int style) {
        HashMap attrs = new HashMap();
        this.getStandardAttributes(attrs);
        ClasspathFontPeer.copyStyleToAttrs(style, attrs);
        return ClasspathFontPeer.tk().getFont(this.logicalName, attrs);
    }

    public Font deriveFont(Font font, int style, AffineTransform t) {
        HashMap attrs = new HashMap();
        this.getStandardAttributes(attrs);
        ClasspathFontPeer.copyStyleToAttrs(style, attrs);
        ClasspathFontPeer.copyTransformToAttrs(t, attrs);
        return ClasspathFontPeer.tk().getFont(this.logicalName, attrs);
    }

    public Font deriveFont(Font font, AffineTransform t) {
        HashMap attrs = new HashMap();
        this.getStandardAttributes(attrs);
        ClasspathFontPeer.copyTransformToAttrs(t, attrs);
        return ClasspathFontPeer.tk().getFont(this.logicalName, attrs);
    }

    public Font deriveFont(Font font, Map attrs) {
        return ClasspathFontPeer.tk().getFont(this.logicalName, attrs);
    }

    public Map getAttributes(Font font) {
        HashMap h = new HashMap();
        this.getStandardAttributes(h);
        return h;
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes(Font font) {
        AttributedCharacterIterator.Attribute[] a = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.SIZE, TextAttribute.POSTURE, TextAttribute.WEIGHT, TextAttribute.TRANSFORM};
        return a;
    }

    public AffineTransform getTransform(Font font) {
        if (this.transform == null) {
            this.transform = new AffineTransform();
        }
        return this.transform;
    }

    public boolean isTransformed(Font font) {
        return !this.transform.isIdentity();
    }

    public float getItalicAngle(Font font) {
        if ((this.style & 2) == 2) {
            return TextAttribute.POSTURE_OBLIQUE.floatValue();
        }
        return TextAttribute.POSTURE_REGULAR.floatValue();
    }

    public int getStyle(Font font) {
        return this.style;
    }

    public abstract boolean canDisplay(Font var1, int var2);

    public abstract int canDisplayUpTo(Font var1, CharacterIterator var2, int var3, int var4);

    public abstract String getSubFamilyName(Font var1, Locale var2);

    public abstract String getPostScriptName(Font var1);

    public abstract int getNumGlyphs(Font var1);

    public abstract int getMissingGlyphCode(Font var1);

    public abstract byte getBaselineFor(Font var1, char var2);

    public abstract String getGlyphName(Font var1, int var2);

    public abstract GlyphVector createGlyphVector(Font var1, FontRenderContext var2, CharacterIterator var3);

    public abstract GlyphVector createGlyphVector(Font var1, FontRenderContext var2, int[] var3);

    public abstract GlyphVector layoutGlyphVector(Font var1, FontRenderContext var2, char[] var3, int var4, int var5, int var6);

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract boolean hasUniformLineMetrics(Font var1);

    public abstract LineMetrics getLineMetrics(Font var1, CharacterIterator var2, int var3, int var4, FontRenderContext var5);

    public abstract Rectangle2D getMaxCharBounds(Font var1, FontRenderContext var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        int max_entries;

        public LRUCache(int max) {
            super(max, 0.75f, true);
            this.max_entries = max;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.max_entries;
        }
    }
}

