/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.AWTError;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class TexturePaintContext
implements PaintContext {
    private BufferedImage image;
    private WritableRaster paintRaster;
    private AffineTransform transform;

    public TexturePaintContext(TexturePaint t, Rectangle db, Rectangle2D ub, AffineTransform xform) {
        this.image = t.getImage();
        try {
            Rectangle2D anchor = t.getAnchorRect();
            BufferedImage image = t.getImage();
            double scaleX = anchor.getWidth() / (double)image.getWidth();
            double scaleY = anchor.getHeight() / (double)image.getHeight();
            this.transform = (AffineTransform)xform.clone();
            this.transform.scale(scaleX, scaleY);
            this.transform.translate(-anchor.getMinX(), -anchor.getMinY());
            this.transform = this.transform.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            AWTError err = new AWTError("Unexpected NoninvertibleTransformException");
            err.initCause(ex);
            throw err;
        }
    }

    public void dispose() {
    }

    public ColorModel getColorModel() {
        return this.image.getColorModel();
    }

    public Raster getRaster(int x1, int y1, int w, int h) {
        this.ensureRasterSize(w, h);
        int x2 = x1 + w;
        int y2 = y1 + h;
        float[] src = new float[2];
        float[] dest = new float[2];
        Raster source = this.image.getData();
        int minX = source.getMinX();
        int width = source.getWidth();
        int minY = source.getMinY();
        int height = source.getHeight();
        Object pixel = null;
        int y = y1;
        while (y < y2) {
            int x = x1;
            while (x < x2) {
                src[0] = x;
                src[1] = y;
                this.transform.transform(src, 0, dest, 0, 1);
                int dx = (int)dest[0];
                int dy = (int)dest[1];
                dx = (dx - minX) % width + minX;
                dy = (dy - minY) % height + minY;
                if (dx < 0) {
                    dx += width;
                }
                if (dy < 0) {
                    dy += height;
                }
                pixel = source.getDataElements(dx, dy, pixel);
                this.paintRaster.setDataElements(x - x1, y - y1, pixel);
                ++x;
            }
            ++y;
        }
        return this.paintRaster;
    }

    private void ensureRasterSize(int w, int h) {
        if (this.paintRaster == null || this.paintRaster.getWidth() < w || this.paintRaster.getHeight() < h) {
            Raster s = this.image.getData();
            this.paintRaster = s.createCompatibleWritableRaster(w, h);
        }
    }
}

