/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.awt.xlib.XFontMetrics;
import gnu.gcj.xlib.Colormap;
import gnu.gcj.xlib.Display;
import gnu.gcj.xlib.Visual;
import gnu.gcj.xlib.XColor;
import gnu.gcj.xlib.XException;
import gnu.gcj.xlib.XImage;
import gnu.java.awt.Buffers;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.util.Enumeration;
import java.util.Hashtable;

public class XGraphicsConfiguration
extends GraphicsConfiguration {
    Visual visual;
    int format;
    Colormap colormap;
    ColorModel imageCM;
    ColorModel pixelCM;
    private static final int CACHE_SIZE_PER_DISPLAY = 10;
    static FontMetricsCache fontMetricsCache = new FontMetricsCache();

    public XGraphicsConfiguration(Visual visual) {
        this.visual = visual;
    }

    public BufferedImage createCompatibleImage(int width, int height) {
        XImage ximg = new XImage(this.visual, width, height, false);
        Point origin = new Point(0, 0);
        WritableRaster raster = this.createRasterForXImage(ximg, origin);
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        props.put("gnu.gcj.xlib.XImage", ximg);
        props.put("java.awt.GraphicsConfiguration", this);
        BufferedImage bimg = new BufferedImage(this.imageCM, raster, false, props);
        DataBuffer dataB = raster.getDataBuffer();
        XGraphicsConfiguration.attachData(ximg, dataB, 0);
        return bimg;
    }

    WritableRaster createRasterForXImage(XImage ximage, Point origin) {
        if (this.imageCM == null) {
            this.prepareColorModel(ximage);
        }
        SampleModel imageSM = null;
        int width = ximage.getWidth();
        int height = ximage.getHeight();
        int bitsPerPixel = ximage.getBitsPerPixel();
        int dataType = Buffers.smallestAppropriateTransferType(bitsPerPixel);
        int bitsPerDataElement = DataBuffer.getDataTypeSize(dataType);
        int scanlineStride = ximage.getBytesPerLine() * 8 / bitsPerDataElement;
        if (this.imageCM instanceof IndexColorModel) {
            int[] bandOffsets = new int[1];
            imageSM = new ComponentSampleModel(dataType, width, height, 1, scanlineStride, bandOffsets);
        } else if (this.imageCM instanceof PackedColorModel) {
            PackedColorModel pcm = (PackedColorModel)this.imageCM;
            int[] masks = pcm.getMasks();
            imageSM = new SinglePixelPackedSampleModel(dataType, width, height, scanlineStride, masks);
        }
        if (imageSM == null) {
            throw new UnsupportedOperationException("creating sample model for " + this.imageCM + " not implemented");
        }
        WritableRaster raster = Raster.createWritableRaster(imageSM, origin);
        return raster;
    }

    static void attachData(XImage ximage, DataBuffer dataB, int offset) {
        offset += dataB.getOffset();
        switch (dataB.getDataType()) {
            case 0: {
                ximage.setData(((DataBufferByte)dataB).getData(), offset);
                break;
            }
            case 1: {
                ximage.setData(((DataBufferUShort)dataB).getData(), offset);
                break;
            }
            case 3: {
                ximage.setData(((DataBufferInt)dataB).getData(), offset);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Do not know how to set data for data type " + dataB.getDataType());
            }
        }
    }

    void prepareColorModel(XImage ximage) {
        this.format = ximage.getFormat();
        int bitsPerPixel = ximage.getBitsPerPixel();
        switch (this.format) {
            case 2: {
                this.calcZPixmapModels(bitsPerPixel);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unimplemented format");
            }
        }
    }

    void calcZPixmapModels(int bitsPerPixel) {
        switch (this.visual.getVisualClass()) {
            case 4: {
                this.calcDecomposedRGBModels(bitsPerPixel);
                break;
            }
            case 3: {
                this.calcPseudoColorModels(bitsPerPixel);
                break;
            }
            default: {
                String msg = "unimplemented visual class";
                throw new UnsupportedOperationException(msg);
            }
        }
    }

    void calcDecomposedRGBModels(int bitsPerPixel) {
        int dataType = Buffers.smallestAppropriateTransferType(bitsPerPixel);
        if (DataBuffer.getDataTypeSize(dataType) != bitsPerPixel) {
            throw new UnsupportedOperationException("unimplemented bits per pixel");
        }
        ColorSpace cs = ColorSpace.getInstance(1000);
        this.imageCM = new DirectColorModel(cs, this.visual.getDepth(), this.visual.getRedMask(), this.visual.getGreenMask(), this.visual.getBlueMask(), 0, false, dataType);
    }

    void calcPseudoColorModels(int bitsPerPixel) {
        if (this.colormap == null) {
            this.colormap = this.visual.getScreen().getDefaultColormap();
        }
        XColor[] colArray = this.colormap.getXColors();
        int numCol = colArray.length;
        byte[] rmap = new byte[numCol];
        byte[] gmap = new byte[numCol];
        byte[] bmap = new byte[numCol];
        byte[] amap = new byte[numCol];
        int i = 0;
        while (i < numCol) {
            XColor color = colArray[i];
            if (color.getFlags() == 1) {
                rmap[i] = (byte)(color.getRed() >> 8);
                gmap[i] = (byte)(color.getGreen() >> 8);
                bmap[i] = (byte)(color.getBlue() >> 8);
                amap[i] = -1;
            }
            ++i;
        }
        this.imageCM = new IndexColorModel(this.visual.getDepth(), numCol, rmap, gmap, bmap, amap);
    }

    public GraphicsDevice getDevice() {
        throw new UnsupportedOperationException("not implemented");
    }

    public BufferedImage createCompatibleImage(int width, int height, int transparency) {
        throw new UnsupportedOperationException("not implemented");
    }

    public VolatileImage createCompatibleVolatileImage(int w, int h) {
        throw new UnsupportedOperationException("not implemented");
    }

    public ColorModel getColorModel() {
        if (this.pixelCM == null) {
            this.preparePixelCM();
        }
        return this.pixelCM;
    }

    void preparePixelCM() {
        switch (this.visual.getVisualClass()) {
            case 4: {
                this.pixelCM = new DirectColorModel(this.visual.getDepth(), this.visual.getRedMask(), this.visual.getGreenMask(), this.visual.getBlueMask());
                break;
            }
            case 3: {
                if (this.colormap == null) {
                    this.colormap = this.visual.getScreen().getDefaultColormap();
                }
                XColor[] colArray = this.colormap.getXColors();
                int numCol = colArray.length;
                byte[] rmap = new byte[numCol];
                byte[] gmap = new byte[numCol];
                byte[] bmap = new byte[numCol];
                byte[] amap = new byte[numCol];
                int i = 0;
                while (i < numCol) {
                    XColor color = colArray[i];
                    if (color.getFlags() == 1) {
                        rmap[i] = (byte)(color.getRed() >> 8);
                        gmap[i] = (byte)(color.getGreen() >> 8);
                        bmap[i] = (byte)(color.getBlue() >> 8);
                        amap[i] = -1;
                    }
                    ++i;
                }
                this.pixelCM = new IndexColorModel(this.visual.getDepth(), numCol, rmap, gmap, bmap, amap);
                break;
            }
            default: {
                throw new UnsupportedOperationException("not implemented");
            }
        }
    }

    public ColorModel getColorModel(int transparency) {
        throw new UnsupportedOperationException("not implemented");
    }

    public AffineTransform getDefaultTransform() {
        throw new UnsupportedOperationException("not implemented");
    }

    public AffineTransform getNormalizingTransform() {
        throw new UnsupportedOperationException("not implemented");
    }

    public Rectangle getBounds() {
        throw new UnsupportedOperationException("not implemented");
    }

    Visual getVisual() {
        return this.visual;
    }

    XFontMetrics getXFontMetrics(Font awtFont) {
        Display display = this.visual.getScreen().getDisplay();
        XFontMetrics fm = fontMetricsCache.get(awtFont, display);
        if (fm == null) {
            String foundry = "*";
            String family = awtFont.getName();
            String weight = awtFont.isBold() ? "bold" : "medium";
            String slant = awtFont.isItalic() ? "i" : "r";
            String sWidth = "*";
            String addStyle = "";
            String pixelSize = "*";
            String pointSize = String.valueOf(awtFont.getSize()) + "0";
            String xres = "*";
            String yres = "*";
            String spacing = "*";
            String averageWidth = "*";
            String charset = "iso10646-1";
            String logicalFontDescription = "-" + foundry + "-" + family + "-" + weight + "-" + slant + "-" + sWidth + "-" + addStyle + "-" + pixelSize + "-" + pointSize + "-" + xres + "-" + yres + "-" + spacing + "-" + averageWidth + "-";
            try {
                gnu.gcj.xlib.Font xfont = new gnu.gcj.xlib.Font(display, String.valueOf(logicalFontDescription) + charset);
                fm = new XFontMetrics(xfont, awtFont);
            }
            catch (XException xException) {
                gnu.gcj.xlib.Font xfont = new gnu.gcj.xlib.Font(display, String.valueOf(logicalFontDescription) + "*-*");
                fm = new XFontMetrics(xfont, awtFont);
            }
            fontMetricsCache.put(awtFont, display, fm);
        }
        return fm;
    }

    int getPixel(Color color) {
        int[] nArray = new int[4];
        nArray[3] = 255;
        int[] unnormalizedComponents = nArray;
        ColorModel cm = this.getColorModel();
        if (color != null) {
            float[] normalizedComponents = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f};
            cm.getUnnormalizedComponents(normalizedComponents, 0, unnormalizedComponents, 0);
        }
        return cm.getDataElement(unnormalizedComponents, 0);
    }

    public VolatileImage createCompatibleVolatileImage(int width, int height, int transparency) {
        return null;
    }

    static class FontMetricsCache {
        private Hashtable displays = new Hashtable();

        FontMetricsCache() {
        }

        XFontMetrics get(Font font, Display display) {
            PerDisplayCache cache = (PerDisplayCache)this.displays.get(display);
            return cache == null ? null : cache.get(font);
        }

        void put(Font font, Display display, XFontMetrics fontMetrics) {
            PerDisplayCache cache = (PerDisplayCache)this.displays.get(display);
            if (cache == null) {
                cache = new PerDisplayCache();
                this.displays.put(display, cache);
            }
            cache.put(font, fontMetrics);
        }

        class PerDisplayCache {
            private int lruCount = 0;
            private Hashtable entries = new Hashtable();

            PerDisplayCache() {
            }

            XFontMetrics get(Font font) {
                CacheEntry entry = (CacheEntry)this.entries.get(font);
                if (entry != null) {
                    entry.lruOrder = this.lruCount++;
                }
                return entry == null ? null : entry.fm;
            }

            void put(Font font, XFontMetrics fontMetrics) {
                if (this.entries.size() >= 10) {
                    int maxAge = 0;
                    CacheEntry oldestEntry = null;
                    int referenceCount = this.lruCount;
                    Enumeration e = this.entries.elements();
                    while (e.hasMoreElements()) {
                        CacheEntry entry = (CacheEntry)e.nextElement();
                        if (referenceCount - entry.lruOrder <= maxAge) continue;
                        maxAge = referenceCount - entry.lruOrder;
                        oldestEntry = entry;
                    }
                    if (oldestEntry != null) {
                        this.entries.remove(oldestEntry.font);
                    }
                }
                CacheEntry newEntry = new CacheEntry();
                newEntry.lruOrder = this.lruCount++;
                newEntry.fm = fontMetrics;
                newEntry.font = font;
                this.entries.put(font, newEntry);
            }

            class CacheEntry {
                int lruOrder;
                XFontMetrics fm;
                Font font;

                CacheEntry() {
                }
            }
        }
    }
}

