/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.gcj.xlib.Display;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;

public class XEventQueue
extends EventQueue {
    Display display;

    public XEventQueue(Display display) {
        this.display = display;
    }

    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent event;
        if (this.peekEvent() == null && this.display != null) {
            this.display.flush();
        }
        if ((event = super.getNextEvent()) != null) {
            switch (event.getID()) {
                case 300: {
                    ContainerEvent ce = (ContainerEvent)event;
                    ce.getChild().invalidate();
                    ce.getContainer().validate();
                    break;
                }
                case 101: {
                    ComponentEvent ce = (ComponentEvent)event;
                    ce.getComponent().validate();
                    break;
                }
                case 102: {
                    ComponentEvent ce = (ComponentEvent)event;
                    Component comp = ce.getComponent();
                    if (!comp.isValid()) {
                        Container parent = comp.getParent();
                        while (parent != null) {
                            Container next = parent.getParent();
                            if (next == null || next.isValid()) {
                                parent.validate();
                                break;
                            }
                            parent = next;
                        }
                        if (comp instanceof Container) {
                            comp.validate();
                        }
                    }
                    comp.repaint();
                    break;
                }
            }
        }
        return event;
    }
}

