/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MemberNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassNode
extends MemberNode
implements ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List interfaces = new ArrayList();
    public String sourceFile;
    public String sourceDebug;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List innerClasses = new ArrayList();
    public List fields = new ArrayList();
    public List methods = new ArrayList();

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.version = version;
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.superName = superName;
        if (interfaces != null) {
            this.interfaces.addAll((Collection)Arrays.asList(interfaces));
        }
    }

    public void visitSource(String file, String debug) {
        this.sourceFile = file;
        this.sourceDebug = debug;
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.outerClass = owner;
        this.outerMethod = name;
        this.outerMethodDesc = desc;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        InnerClassNode icn = new InnerClassNode(name, outerName, innerName, access);
        this.innerClasses.add(icn);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldNode fn = new FieldNode(access, name, desc, signature, value);
        this.fields.add(fn);
        return fn;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodNode mn = new MethodNode(access, name, desc, signature, exceptions);
        this.methods.add(mn);
        return mn;
    }

    public void visitEnd() {
    }

    public void accept(ClassVisitor cv) {
        AnnotationNode an;
        String[] interfaces = new String[this.interfaces.size()];
        this.interfaces.toArray(interfaces);
        cv.visit(this.version, this.access, this.name, this.signature, this.superName, interfaces);
        if (this.sourceFile != null || this.sourceDebug != null) {
            cv.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.outerClass != null) {
            cv.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        int n = this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size();
        int i = 0;
        while (i < n) {
            an = (AnnotationNode)this.visibleAnnotations.get(i);
            an.accept(cv.visitAnnotation(an.desc, true));
            ++i;
        }
        n = this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size();
        i = 0;
        while (i < n) {
            an = (AnnotationNode)this.invisibleAnnotations.get(i);
            an.accept(cv.visitAnnotation(an.desc, false));
            ++i;
        }
        n = this.attrs == null ? 0 : this.attrs.size();
        i = 0;
        while (i < n) {
            cv.visitAttribute((Attribute)this.attrs.get(i));
            ++i;
        }
        i = 0;
        while (i < this.innerClasses.size()) {
            ((InnerClassNode)this.innerClasses.get(i)).accept(cv);
            ++i;
        }
        i = 0;
        while (i < this.fields.size()) {
            ((FieldNode)this.fields.get(i)).accept(cv);
            ++i;
        }
        i = 0;
        while (i < this.methods.size()) {
            ((MethodNode)this.methods.get(i)).accept(cv);
            ++i;
        }
        cv.visitEnd();
    }
}

