/*
 * Decompiled with CFR 0.152.
 */
package gnu.gcj.tools.gc_analyze;

import gnu.gcj.tools.gc_analyze.MemoryMap;
import gnu.gcj.tools.gc_analyze.ToolPrefix;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SymbolTable {
    private HashMap<Long, String> map = new HashMap();
    private HashMap<String, Long> reverse = new HashMap();
    long loadAddr;
    long relocation;
    static Matcher interestingSymbol = Pattern.compile("^([0-9a-fA-F]+)\\s+\\S+\\s+(_Z\\S+)").matcher("");
    static Matcher readelfLoadMatcher = Pattern.compile("^\\s+LOAD\\s+(\\S+)\\s+(\\S+)\\s.*").matcher("");

    public SymbolTable(String filename) throws IOException {
        String line;
        Process p = Runtime.getRuntime().exec(String.valueOf(ToolPrefix.toolPrefix) + "nm " + filename);
        InputStream es = p.getErrorStream();
        InputStream is = p.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        int count = 0;
        while ((line = reader.readLine()) != null) {
            interestingSymbol.reset(line);
            if (!interestingSymbol.matches()) continue;
            try {
                String name = interestingSymbol.group(2);
                String addr = interestingSymbol.group(1);
                if (!name.startsWith("_ZTVN") && !name.endsWith("6class$E")) continue;
                long address = MemoryMap.parseHexLong(addr);
                Long l = new Long(address);
                this.map.put(l, name);
                ++count;
                this.reverse.put(name, l);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        es.close();
        is.close();
        p.destroy();
        if (count > 0) {
            p = Runtime.getRuntime().exec(String.valueOf(ToolPrefix.toolPrefix) + "readelf -l " + filename);
            es = p.getErrorStream();
            is = p.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                readelfLoadMatcher.reset(line);
                if (!readelfLoadMatcher.matches()) continue;
                this.loadAddr = Long.decode(readelfLoadMatcher.group(2));
                break;
            }
            es.close();
            is.close();
            p.destroy();
        }
        System.out.println(String.valueOf(ToolPrefix.toolPrefix) + "nm " + filename + " -> " + count + " symbols");
    }

    public static void main(String[] args) {
        try {
            SymbolTable st = new SymbolTable(args[0]);
            st.dump();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String demangleVTName(String n) {
        if (n.startsWith("_ZTVN") && n.endsWith("E")) {
            return SymbolTable.demangle(n.substring(5, n.length() - 1));
        }
        return null;
    }

    public void dump() {
        for (Map.Entry<Long, String> me : this.map.entrySet()) {
            long address = me.getKey();
            String symbol = me.getValue();
            System.out.println(String.valueOf(Long.toHexString(address)) + " -> " + symbol);
            if (symbol.startsWith("_ZN") && symbol.endsWith("6class$E")) {
                System.out.println("  Class: " + SymbolTable.demangle(symbol.substring(3, symbol.length() - 8)));
                continue;
            }
            if (!symbol.startsWith("_ZTVN") || !symbol.endsWith("E")) continue;
            System.out.println("  VT: " + SymbolTable.demangle(symbol.substring(5, symbol.length() - 1)));
        }
    }

    private static String demangle(String symbol) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < symbol.length()) {
            int l = 0;
            while (i < symbol.length()) {
                char d = symbol.charAt(i);
                if (d < '0' || d > '9') break;
                l = 10 * l + (d - 48);
                ++i;
            }
            if (l == 0) break;
            if (sb.length() > 0) {
                sb.append('.');
            }
            while (l > 0 && i < symbol.length()) {
                sb.append(symbol.charAt(i));
                --l;
                ++i;
            }
        }
        return sb.toString();
    }

    public String getSymbol(long address) {
        String symbol = this.map.get(address);
        if (symbol == null) {
            return null;
        }
        if (symbol.startsWith("_ZN") && symbol.endsWith("6class$E")) {
            symbol = SymbolTable.demangle(symbol.substring(3, symbol.length() - 8));
        }
        return symbol;
    }

    public long getAddress(String symbol) {
        Long address = this.reverse.get(symbol);
        if (address == null) {
            return -1L;
        }
        return address;
    }
}

