/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmiregistry;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.rmiregistry.Messages;
import gnu.classpath.tools.rmiregistry.PersistentHashTable;
import gnu.classpath.tools.rmiregistry.RegistryImpl;
import gnu.java.rmi.server.UnicastServerRef;
import java.io.File;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Hashtable;
import java.util.Map;

public class Main {
    public static String STOP = "gnu.classpath.tools.rmi.registry.command.STOP";
    public static boolean verbose = false;
    private String directory = ".";
    private boolean cold = false;
    private boolean persistent = false;
    private boolean stop = false;
    private int port = 1099;
    private RMIServerSocketFactory ssf = null;

    private Parser initializeParser() {
        ClasspathToolParser parser = new ClasspathToolParser("rmiregistry", true);
        parser.setHeader(Messages.getString("Main.Usage"));
        OptionGroup controlGroup = new OptionGroup(Messages.getString("Main.ControlGroup"));
        controlGroup.add(new Option("restart", Messages.getString("Main.Restart")){

            public void parsed(String argument) throws OptionException {
                Main.this.cold = true;
            }
        });
        controlGroup.add(new Option("stop", Messages.getString("Main.Stop")){

            public void parsed(String argument) throws OptionException {
                Main.this.stop = true;
            }
        });
        parser.add(controlGroup);
        OptionGroup persistenceGroup = new OptionGroup(Messages.getString("Main.PersistenceGroup"));
        persistenceGroup.add(new Option("persistent", Messages.getString("Main.Persistent")){

            public void parsed(String argument) throws OptionException {
                Main.this.persistent = true;
            }
        });
        persistenceGroup.add(new Option("directory", Messages.getString("Main.Directory"), Messages.getString("Main.DirectoryArgument")){

            public void parsed(String argument) throws OptionException {
                Main.this.directory = argument;
            }
        });
        parser.add(persistenceGroup);
        OptionGroup debuggingGroup = new OptionGroup(Messages.getString("Main.DebugGroup"));
        debuggingGroup.add(new Option("verbose", Messages.getString("Main.Verbose")){

            public void parsed(String argument) throws OptionException {
                verbose = true;
            }
        });
        parser.add(debuggingGroup);
        return parser;
    }

    private void run(String[] args) {
        Parser p = this.initializeParser();
        p.parse(args, new FileArgumentCallback(){

            public void notifyFile(String portArgument) {
                Main.this.port = Integer.parseInt(portArgument);
            }
        });
        if (!this.stop) {
            Map table;
            if (!this.persistent) {
                table = new Hashtable();
            } else {
                File dataDirectory = new File(this.directory);
                if (!dataDirectory.exists()) {
                    dataDirectory.mkdirs();
                }
                table = PersistentHashTable.createInstance(new File(dataDirectory, "rmiregistry.data"), this.cold);
            }
            RegistryImpl system = new RegistryImpl(table);
            try {
                UnicastServerRef sref = new UnicastServerRef(new ObjID(0), this.port, this.ssf);
                sref.exportObject((Remote)system);
                System.out.println("The RMI naming service is listening at " + this.port);
            }
            catch (Exception exception) {
                System.out.println("Failed to start RMI naming service at " + this.port);
            }
        } else {
            try {
                Registry r = LocateRegistry.getRegistry(this.port);
                r.unbind(STOP);
            }
            catch (RemoteException remoteException) {
                System.out.println("Failed to stop RMI naming service at " + this.port);
            }
            catch (NotBoundException notBoundException) {
                System.out.println("The naming service at port " + this.port + " is not a " + Main.class.getName());
            }
        }
    }

    public static void main(String[] args) {
        Main rmiregistryprogram = new Main();
        try {
            rmiregistryprogram.run(args);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Main.InternalError"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

