/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.keytool;

import gnu.classpath.Configuration;
import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.getopt.Parser;
import gnu.classpath.tools.keytool.Command;
import gnu.classpath.tools.keytool.Messages;
import gnu.java.util.Base64;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.logging.Logger;

class ExportCmd
extends Command {
    private static final Logger log = Logger.getLogger(ExportCmd.class.getName());
    protected String _alias;
    protected String _certFileName;
    protected String _ksType;
    protected String _ksURL;
    protected String _ksPassword;
    protected String _providerClassName;
    protected boolean rfc;

    ExportCmd() {
    }

    public void setAlias(String alias) {
        this._alias = alias;
    }

    public void setFile(String pathName) {
        this._certFileName = pathName;
    }

    public void setStoretype(String type) {
        this._ksType = type;
    }

    public void setKeystore(String url) {
        this._ksURL = url;
    }

    public void setStorepass(String password) {
        this._ksPassword = password;
    }

    public void setProvider(String className) {
        this._providerClassName = className;
    }

    public void setRfc(String flag) {
        this.rfc = Boolean.valueOf(flag);
    }

    void setup() throws Exception {
        this.setOutputStreamParam(this._certFileName);
        this.setKeyStoreParams(this._providerClassName, this._ksType, this._ksPassword, this._ksURL);
        this.setAliasParam(this._alias);
        if (Configuration.DEBUG) {
            log.fine("-export handler will use the following options:");
            log.fine("  -alias=" + this.alias);
            log.fine("  -file=" + this._certFileName);
            log.fine("  -storetype=" + this.storeType);
            log.fine("  -keystore=" + this.storeURL);
            log.fine("  -provider=" + this.provider);
            log.fine("  -rfc=" + this.rfc);
            log.fine("  -v=" + this.verbose);
        }
    }

    void start() throws KeyStoreException, CertificateEncodingException, IOException {
        Certificate certificate;
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "start");
        }
        this.ensureStoreContainsAlias();
        if (this.store.isCertificateEntry(this.alias)) {
            if (Configuration.DEBUG) {
                log.fine("Alias [" + this.alias + "] is a trusted certificate");
            }
            certificate = this.store.getCertificate(this.alias);
        } else {
            if (Configuration.DEBUG) {
                log.fine("Alias [" + this.alias + "] is a key entry");
            }
            Certificate[] chain = this.store.getCertificateChain(this.alias);
            certificate = chain[0];
        }
        byte[] derBytes = certificate.getEncoded();
        if (this.rfc) {
            String encoded = Base64.encode((byte[])derBytes, (int)72);
            PrintWriter pw = new PrintWriter(this.outStream, true);
            pw.println("-----BEGIN CERTIFICATE-----");
            pw.println(encoded);
            pw.println("-----END CERTIFICATE-----");
        } else {
            this.outStream.write(derBytes);
        }
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "start");
        }
    }

    Parser getParser() {
        if (Configuration.DEBUG) {
            log.entering(this.getClass().getName(), "getParser");
        }
        ClasspathToolParser result = new ClasspathToolParser("export", true);
        result.setHeader(Messages.getString("ExportCmd.17"));
        result.setFooter(Messages.getString("ExportCmd.18"));
        OptionGroup options = new OptionGroup(Messages.getString("ExportCmd.19"));
        options.add(new Option("alias", Messages.getString("ExportCmd.20"), Messages.getString("ExportCmd.21")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this._alias = argument;
            }
        });
        options.add(new Option("file", Messages.getString("ExportCmd.22"), Messages.getString("ExportCmd.23")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this._certFileName = argument;
            }
        });
        options.add(new Option("storetype", Messages.getString("ExportCmd.24"), Messages.getString("ExportCmd.25")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this._ksType = argument;
            }
        });
        options.add(new Option("keystore", Messages.getString("ExportCmd.26"), Messages.getString("ExportCmd.27")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this._ksURL = argument;
            }
        });
        options.add(new Option("storepass", Messages.getString("ExportCmd.28"), Messages.getString("ExportCmd.29")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this._ksPassword = argument;
            }
        });
        options.add(new Option("provider", Messages.getString("ExportCmd.30"), Messages.getString("ExportCmd.31")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this._providerClassName = argument;
            }
        });
        options.add(new Option("rfc", Messages.getString("ExportCmd.32")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this.rfc = true;
            }
        });
        options.add(new Option("v", Messages.getString("ExportCmd.33")){

            public void parsed(String argument) throws OptionException {
                ExportCmd.this.verbose = true;
            }
        });
        result.add(options);
        if (Configuration.DEBUG) {
            log.exiting(this.getClass().getName(), "getParser", result);
        }
        return result;
    }
}

