/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.appletviewer;

import gnu.classpath.tools.appletviewer.AppletTag;
import gnu.classpath.tools.appletviewer.Main;
import gnu.classpath.tools.appletviewer.Messages;
import gnu.classpath.tools.appletviewer.StandaloneAppletWindow;
import gnu.classpath.tools.appletviewer.TagParser;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

class StandaloneAppletViewer
extends Main {
    static ArrayList appletTags = new ArrayList();
    static ArrayList appletWindows = new ArrayList();

    StandaloneAppletViewer(String[] urls) throws MalformedURLException, IOException {
        int i = 0;
        while (i < urls.length) {
            TagParser parser = new TagParser(urls[i]);
            appletTags.addAll(parser.parseAppletTags());
            ++i;
        }
        this.printTags();
        this.createWindows();
    }

    StandaloneAppletViewer(String code, String codebase, String archives, List parameters, Dimension dimensions) throws IOException {
        if (!code.equals("") && !code.endsWith(".class")) {
            System.err.println(Messages.getString("StandaloneAppletViewer.CodeOptionError"));
            System.exit(1);
        }
        String tagString = "<EMBED CODE=\"" + code + "\"" + " WIDTH=" + dimensions.width + " HEIGHT=" + dimensions.height + " CODEBASE=\"" + codebase + "\"" + " ARCHIVE=\"" + archives + "\">";
        Iterator pairs = parameters.iterator();
        while (pairs.hasNext()) {
            StringTokenizer paramTokenizer = new StringTokenizer((String)pairs.next(), ",");
            tagString = String.valueOf(tagString) + "<PARAM NAME=" + paramTokenizer.nextToken().trim() + " VALUE=" + paramTokenizer.nextToken().trim() + ">";
        }
        tagString = String.valueOf(tagString) + "</EMBED>";
        StringReader reader = new StringReader(tagString);
        String path = String.valueOf(System.getProperty("user.dir")) + File.separator;
        TagParser parser = new TagParser(reader, new URL("file", "", path));
        appletTags.addAll(parser.parseAppletTags());
        this.printTags();
        this.createWindows();
    }

    void printTags() {
        if (verbose) {
            System.out.println(Messages.getString("StandaloneAppletViewer.ParsedAppletTags"));
            int i = 0;
            while (i < appletTags.size()) {
                AppletTag tag = (AppletTag)appletTags.get(i);
                System.out.println(" " + Messages.getString("StandaloneAppletViewer.Tag") + " " + i + ":");
                System.out.println(tag);
                ++i;
            }
        }
    }

    void createWindows() {
        int i = 0;
        while (i < appletTags.size()) {
            AppletTag tag = (AppletTag)appletTags.get(i);
            new StandaloneAppletWindow(tag, appletWindows);
            ++i;
        }
    }
}

