;;; -*- mode: lisp; coding: utf-8 -*-
;;; 
;;; Copyright (c) 2008 Masayuki Onjo <onjo@lispuser.net>
;;; 
;;; Redistribution and use in source and binary forms, with or without
;;; modification, are permitted provided that the following conditions
;;; are met:
;;; 
;;;   * Redistributions of source code must retain the above copyright
;;;     notice, this list of conditions and the following disclaimer.
;;; 
;;;   * Redistributions in binary form must reproduce the above
;;;     copyright notice, this list of conditions and the following
;;;     disclaimer in the documentation and/or other materials
;;;     provided with the distribution.
;;; 
;;; THIS SOFTWARE IS PROVIDED BY THE AUTHOR 'AS IS' AND ANY EXPRESSED
;;; OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
;;; WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
;;; ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
;;; DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
;;; DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
;;; GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
;;; INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
;;; WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
;;; NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
;;; SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

(in-package :jp)

;;; Use Compiler-Macro

(define-compiler-macro encode (string external-format &key (start 0) end (null-terminate nil))
  (let ((param-constant-p (every #'constantp (list string start end null-terminate)))
	(encoding-constant-p (and (consp external-format)
				  (eq (first external-format) 'make-encoding)
				  (every #'constantp (cdr external-format)))))
    (cond ((and param-constant-p (constantp external-format))
	   (raw-encode string external-format start end null-terminate))
	  ((and param-constant-p encoding-constant-p)
	   (raw-encode string (apply #'make-encoding (cdr external-format)) start end null-terminate))
	  (t
	   `(raw-encode ,string ,external-format ,start ,end ,null-terminate)))))

(define-compiler-macro decode (vector external-format &key (start 0) end)
  (let* ((vector (if (and (vectorp vector) (not (typep vector '(vector (unsigned-byte 8)))))
		     (coerce vector '(vector (unsigned-byte 8)))
		     vector))
	 (param-constant-p (every #'constantp (list vector start end)))
	 (encoding-constant-p (and (consp external-format)
				   (eq (first external-format) 'make-encoding)
				   (every #'constantp (cdr external-format)))))
    (cond ((and param-constant-p (eql external-format :guess))
	   (raw-decode vector (make-encoding (guess vector)) start end))
	  ((and param-constant-p (constantp external-format))
	   (raw-decode vector external-format start end))
	  ((and param-constant-p encoding-constant-p)
	   (raw-decode vector (apply #'make-encoding (cdr external-format)) start end))
	  ((eql external-format :guess)
	   (let (($vec (gensym))
		 ($ef  (gensym)))
	     `(let* ((,$vec (coerce ,vector '(vector (unsigned-byte 8))))
		     (,$ef (guess ,$vec)))
		(raw-decode ,$vec (make-encoding ,$ef) ,start ,end))))
	  (t
	   `(raw-decode (coerce ,vector '(vector (unsigned-byte 8))) ,external-format ,start ,end)))))

#+allegro
(define-compiler-macro raw-encode (string external-format start end null-terminate)
  `(excl:string-to-octets ,string :external-format ,external-format :start ,start :end ,end :null-terminate ,null-terminate))

#+allegro
(define-compiler-macro raw-decode (string external-format start end)
  `(excl:octets-to-string ,string :external-format ,external-format :start ,start :end ,end))
