/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.LookaheadIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sort.GroupIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;

public class GroupStartingIterator
implements LookaheadIterator,
GroupIterator {
    private SequenceIterator population;
    private Pattern startPattern;
    private XPathContext baseContext;
    private XPathContext runningContext;
    private List currentMembers;
    private Item next;
    private Item current = null;
    private int position = 0;

    public GroupStartingIterator(SequenceIterator population, Pattern startPattern, XPathContext context) throws XPathException {
        this.population = population;
        this.startPattern = startPattern;
        this.baseContext = context;
        this.runningContext = context.newMinorContext();
        this.runningContext.setCurrentIterator(population);
        this.next = population.next();
    }

    private void advance() throws XPathException {
        NodeInfo nextCandidate;
        this.currentMembers = new ArrayList(10);
        this.currentMembers.add(this.current);
        while ((nextCandidate = (NodeInfo)this.population.next()) != null) {
            if (this.startPattern.matches(nextCandidate, this.runningContext)) {
                this.next = nextCandidate;
                return;
            }
            this.currentMembers.add(nextCandidate);
        }
        this.next = null;
    }

    public AtomicValue getCurrentGroupingKey() {
        return null;
    }

    public SequenceIterator iterateCurrentGroup() {
        return new ListIterator(this.currentMembers);
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public Item next() throws XPathException {
        if (this.next != null) {
            this.current = this.next;
            ++this.position;
            this.advance();
            return this.current;
        }
        this.current = null;
        this.position = -1;
        return null;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new GroupStartingIterator(this.population.getAnother(), this.startPattern, this.baseContext);
    }

    public int getProperties() {
        return 4;
    }
}

