/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.db.BlindtextCreator;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;

public class FieldColumn {
    public Object DefaultValue;
    public String m_sFieldName;
    private String m_sDisplayFieldName;
    private String FieldTitle;
    public int ColIndex;
    private String m_sCommandName;
    public int FieldWidth;
    public int DBFormatKey;
    public int FieldType;
    public int StandardFormatKey;
    public boolean bIsNumberFormat;
    public XPropertySet m_xColPropertySet;
    public int iType;
    protected int iDateFormatKey;
    protected int iDateTimeFormatKey;
    protected int iNumberFormatKey;
    protected int iTextFormatKey;
    protected int iTimeFormatKey;
    protected int iLogicalFormatKey;

    public FieldColumn(CommandMetaData commandMetaData, String string) {
        this.m_sDisplayFieldName = string;
        this.m_sCommandName = commandMetaData.getCommandName();
        this.m_sFieldName = this.getOnlyFieldName(this.m_sDisplayFieldName, this.m_sCommandName);
        this.FieldTitle = string;
        this.FieldTitle = this.m_sFieldName;
        DBMetaData.CommandObject commandObject = commandMetaData.getTableByName(this.m_sCommandName);
        this.setFormatKeys(commandMetaData, commandObject.xColumns);
    }

    public FieldColumn(CommandMetaData commandMetaData, String string, String string2, boolean bl) {
        this.m_sCommandName = string2;
        if (bl) {
            this.m_sDisplayFieldName = string;
            this.m_sFieldName = this.getOnlyFieldName(string, string2);
        } else {
            this.m_sFieldName = string;
            this.m_sDisplayFieldName = FieldColumn.composeDisplayFieldName(string2, this.m_sFieldName);
        }
        this.FieldTitle = this.m_sFieldName;
        DBMetaData.CommandObject commandObject = commandMetaData.getTableByName(this.m_sCommandName);
        this.setFormatKeys(commandMetaData, commandObject.xColumns);
    }

    public FieldColumn(CommandMetaData commandMetaData, XNameAccess xNameAccess, String string) {
        this.FieldTitle = this.m_sFieldName = string;
        this.m_sDisplayFieldName = this.m_sFieldName;
        this.ColIndex = JavaTools.FieldInList(xNameAccess.getElementNames(), this.m_sFieldName) + 1;
        this.setFormatKeys(commandMetaData, xNameAccess);
    }

    private String getOnlyFieldName(String string, String string2) {
        String string3 = string.substring(string2.length() + 1, string.length());
        return string3;
    }

    public static String composeDisplayFieldName(String string, String string2) {
        return string + "." + string2;
    }

    private void setFormatKeys(CommandMetaData commandMetaData, XNameAccess xNameAccess) {
        try {
            this.m_xColPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess.getByName(this.m_sFieldName));
            this.ColIndex = JavaTools.FieldInList(xNameAccess.getElementNames(), this.m_sFieldName) + 1;
            this.iType = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Type"));
            NumberFormatter numberFormatter = commandMetaData.getNumberFormatter();
            this.iDateFormatKey = numberFormatter.getDateFormatKey();
            this.iDateTimeFormatKey = numberFormatter.getDateTimeFormatKey();
            this.iNumberFormatKey = numberFormatter.getNumberFormatKey();
            this.iTextFormatKey = numberFormatter.getTextFormatKey();
            this.iTimeFormatKey = numberFormatter.getTimeFormatKey();
            this.iLogicalFormatKey = numberFormatter.getLogicalFormatKey();
            this.DefaultValue = this.getTyperelatedFieldData();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public XPropertySet getXColumnPropertySet() {
        return this.m_xColPropertySet;
    }

    public void setCommandName(String string) {
        this.m_sCommandName = string;
    }

    public String getDisplayFieldName() {
        return this.m_sDisplayFieldName;
    }

    public String getCommandName() {
        return this.m_sCommandName;
    }

    public String getFieldName() {
        return this.m_sFieldName;
    }

    public String getFieldTitle() {
        return this.FieldTitle;
    }

    public void setFieldTitle(String string) {
        this.FieldTitle = string;
    }

    public static String getCommandName(String string) {
        String string2 = null;
        String[] stringArray = JavaTools.ArrayoutofString(string, ".");
        if (stringArray.length >= 2) {
            String string3 = stringArray[stringArray.length - 1];
            string2 = string.substring(0, string.length() - string3.length() - 1);
        }
        return string2;
    }

    public int getFormatKey() {
        try {
            Object object = this.m_xColPropertySet.getPropertyValue("FormatKey");
            int n = AnyConverter.isVoid((Object)object) ? this.StandardFormatKey : AnyConverter.toInt((Object)object);
            return n;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return this.StandardFormatKey;
        }
    }

    public boolean isBoolean() {
        boolean bl = false;
        try {
            this.FieldType = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Type"));
            switch (this.FieldType) {
                case -7: 
                case 16: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return bl;
    }

    private Object getTyperelatedFieldData() {
        try {
            this.FieldType = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Type"));
            switch (this.FieldType) {
                case -7: 
                case 16: {
                    this.StandardFormatKey = this.iLogicalFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case -6: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 5: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 4: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case -5: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 15;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 1: {
                    this.StandardFormatKey = this.iTextFormatKey;
                    this.getTextFieldWidth(10);
                    this.bIsNumberFormat = false;
                    break;
                }
                case 12: {
                    this.StandardFormatKey = this.iTextFormatKey;
                    this.getTextFieldWidth(30);
                    this.bIsNumberFormat = false;
                    break;
                }
                case -1: {
                    this.StandardFormatKey = this.iTextFormatKey;
                    this.getTextFieldWidth(60);
                    this.bIsNumberFormat = false;
                    break;
                }
                case 2: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 20;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 3: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 10 + AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Scale")) + 1;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 6: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 10 + AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Scale")) + 1;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 7: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 10 + AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Scale")) + 1;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 8: {
                    this.StandardFormatKey = this.iNumberFormatKey;
                    this.FieldWidth = 10 + AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Scale")) + 1;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 91: {
                    this.StandardFormatKey = this.iDateFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 92: {
                    this.StandardFormatKey = this.iTimeFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 93: {
                    this.StandardFormatKey = this.iDateTimeFormatKey;
                    this.FieldWidth = 20;
                    this.bIsNumberFormat = true;
                }
            }
            this.DBFormatKey = this.getFormatKey();
            return this.DefaultValue;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    private void getTextFieldWidth(int n) {
        try {
            this.FieldWidth = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Precision"));
            if (this.FieldWidth > 0) {
                if (this.FieldWidth > 2 * n) {
                    this.FieldWidth = 2 * n;
                } else if (this.FieldWidth == 0) {
                    this.FieldWidth = n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public Object getDefaultValue() {
        switch (this.FieldType) {
            case -7: 
            case 16: {
                this.DefaultValue = Integer.valueOf("1");
                break;
            }
            case -6: {
                this.DefaultValue = Integer.valueOf("98");
                break;
            }
            case 5: {
                this.DefaultValue = Integer.valueOf("987");
                break;
            }
            case 4: {
                this.DefaultValue = Integer.valueOf("9876");
                break;
            }
            case -5: {
                this.DefaultValue = Integer.valueOf("98765");
                break;
            }
            case 1: {
                this.DefaultValue = String.valueOf('x');
                break;
            }
            case 12: {
                this.DefaultValue = BlindtextCreator.getBlindTextString(this.FieldTitle, this.FieldWidth, this.FieldWidth);
                break;
            }
            case -1: {
                this.DefaultValue = BlindtextCreator.getBlindTextString(this.FieldTitle, this.FieldWidth, this.FieldWidth);
                break;
            }
            case 2: {
                this.DefaultValue = Double.valueOf("9876.5");
                break;
            }
            case 3: {
                this.DefaultValue = Double.valueOf("9876.5");
                break;
            }
            case 6: {
                this.DefaultValue = Double.valueOf("9876.5");
                break;
            }
            case 7: {
                this.DefaultValue = Double.valueOf("9876.5");
                break;
            }
            case 8: {
                this.DefaultValue = Double.valueOf("9876.54");
                break;
            }
            case 91: {
                this.DefaultValue = Double.valueOf("42510");
                break;
            }
            case 92: {
                this.DefaultValue = Double.valueOf("10");
                break;
            }
            case 93: {
                this.DefaultValue = Double.valueOf("5454110");
                break;
            }
        }
        return this.DefaultValue;
    }
}

