/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.form;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.container.XNameContainer;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.task.XStatusIndicator;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.Control;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.Shape;
import com.sun.star.wizards.document.TimeStampControl;

public class FormControlArranger {
    XNameContainer xFormName;
    XMultiServiceFactory xMSF;
    public DatabaseControl[] DBControlList = null;
    public Control[] LabelControlList = null;
    private XStatusIndicator xProgressBar;
    private FieldColumn[] FieldColumns;
    DatabaseControl curDBControl;
    Control curLabelControl;
    int icurArrangement;
    boolean bIsFirstRun;
    boolean bIsVeryFirstRun;
    boolean bControlsareCreated;
    int cXOffset;
    int cYOffset;
    final int cVertDistance = 200;
    final int cHoriDistance = 300;
    final int cLabelGap = 100;
    final double CMAXREDUCTION = 0.7;
    FormHandler oFormHandler;
    int iReduceWidth;
    int nXTCPos;
    int nYTCPos;
    int nXDBPos;
    int nYDBPos;
    int nTCHeight;
    int nTCWidth;
    int nDBHeight;
    int nDBWidth;
    int nMaxTCWidth;
    int nFormWidth;
    int nFormHeight;
    int nMaxRowY;
    int nSecMaxRowY;
    int nMaxColRightX;
    int a;
    int StartA;
    int nMaxDBYPos = 0;
    Short NBorderType = new Short(1);

    public FormControlArranger(FormHandler formHandler, XNameContainer xNameContainer, CommandMetaData commandMetaData, XStatusIndicator xStatusIndicator, Point point, Size size) {
        this.FieldColumns = commandMetaData.FieldColumns;
        this.xMSF = commandMetaData.xMSF;
        this.xFormName = xNameContainer;
        this.xProgressBar = xStatusIndicator;
        this.LabelControlList = new Control[this.FieldColumns.length];
        this.DBControlList = new DatabaseControl[this.FieldColumns.length];
        this.oFormHandler = formHandler;
        this.cXOffset = point.X;
        this.cYOffset = point.Y;
        this.setFormSize(size);
    }

    private int getLabelDiffHeight(int n) {
        if (this.curDBControl != null && this.curDBControl.getControlType() == 2) {
            return this.getCheckBoxDiffHeight(n);
        }
        return this.oFormHandler.getBasicLabelDiffHeight();
    }

    public void setBorderType(short s) {
        this.NBorderType = new Short(s);
    }

    private int getCheckBoxDiffHeight(int n) {
        if (n < this.DBControlList.length && this.DBControlList[n].getControlType() == 2) {
            return (this.oFormHandler.getDBRefHeight() - this.DBControlList[n].getDBHeight()) / 2;
        }
        return 0;
    }

    private boolean isReducable(int n) {
        boolean bl = false;
        int n2 = this.FieldColumns[n].FieldType;
        switch (n2) {
            case -7: 
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 16: 
            case 91: 
            case 92: 
            case 93: {
                bl = false;
                break;
            }
            case 12: {
                try {
                    short s = AnyConverter.toShort((Object)this.DBControlList[n].xPropertySet.getPropertyValue("MaxTextLen"));
                    if (s != 0 && s <= 20) break;
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
                break;
            }
            case -5: {
                bl = true;
                break;
            }
            default: {
                bl = true;
            }
        }
        if ((double)this.nTCWidth > 0.63 * (double)this.nDBWidth) {
            bl = false;
        }
        return bl;
    }

    private int getControlGroupWidth() {
        if (this.nDBWidth > this.nTCWidth) {
            return this.nDBWidth;
        }
        return this.nTCWidth;
    }

    private void checkJustifiedPosition(int n) {
        int n2 = this.nFormWidth + this.cXOffset;
        int n3 = this.nMaxColRightX - n2;
        int n4 = n2 - (this.DBControlList[n].getPosition().X - this.cHoriDistance);
        if ((double)n3 < 0.5 * (double)n4) {
            this.adjustLineWidth(this.StartA, n, n3, -1);
            this.nYTCPos = this.nMaxRowY + 200;
            this.nYDBPos = this.nYTCPos + this.nTCHeight;
            this.nXTCPos = this.cXOffset;
            this.nXDBPos = this.cXOffset;
            this.bIsFirstRun = true;
            this.StartA = n + 1;
        } else {
            this.nYTCPos = this.nYDBPos + this.nDBHeight == this.nMaxRowY ? this.nSecMaxRowY + 200 : this.nMaxRowY + 200;
            this.nYDBPos = this.nYTCPos + this.nTCHeight;
            this.nXDBPos = this.cXOffset;
            this.nXTCPos = this.cXOffset;
            this.LabelControlList[n].setPosition(new Point(this.cXOffset, this.nYTCPos));
            this.DBControlList[n].setPosition(new Point(this.cXOffset, this.nYDBPos));
            this.bIsFirstRun = true;
            if (this.nDBWidth > this.nTCWidth) {
                this.checkOuterPoints(this.nXDBPos, this.nDBWidth, this.nYDBPos, this.nDBHeight, true);
            } else {
                this.checkOuterPoints(this.nXDBPos, this.nTCWidth, this.nYDBPos, this.nDBHeight, true);
            }
            this.nXDBPos = this.nXTCPos = this.nMaxColRightX + 300;
            this.adjustLineWidth(this.StartA, n - 1, n4, 1);
            this.StartA = n;
        }
    }

    private int getCorrWidth(int n, int n2, int n3, int n4) {
        int n5 = n4 > 0 ? n2 - n + 1 : this.iReduceWidth;
        return n3 / n5;
    }

    private void adjustLineWidth(int n, int n2, int n3, int n4) {
        int n5 = this.getCorrWidth(n, n2, n3, n4);
        int n6 = this.cXOffset;
        for (int i = n; i <= n2; ++i) {
            int n7 = 0;
            this.curDBControl = this.DBControlList[i];
            this.curLabelControl = this.LabelControlList[i];
            if (i != n) {
                this.curLabelControl.setPosition(new Point(n6, this.curLabelControl.getPosition().Y));
                this.curDBControl.setPosition(new Point(n6, this.curLabelControl.getPosition().Y + this.nTCHeight));
            }
            n7 = this.curLabelControl.getSize().Width > this.curDBControl.getSize().Width && n4 > 0 ? this.curLabelControl.getSize().Width : this.curDBControl.getSize().Width;
            if (this.FieldColumns[i].FieldType == 93) {
                TimeStampControl timeStampControl = (TimeStampControl)this.curDBControl;
                n7 = timeStampControl.getSize().Width;
                if (this.isReducable(i) || n4 > 0) {
                    timeStampControl.setSize(new Size(n7 + n4 * n5, timeStampControl.getSize().Height));
                }
            } else if (this.isReducable(i) || n4 > 0) {
                this.curDBControl.setSize(new Size(n7 + n4 * n5, this.curDBControl.getSize().Height));
            }
            n6 = this.curDBControl.getPosition().X + this.curDBControl.getSize().Width + 300;
            if (this.curLabelControl.getSize().Width <= this.curDBControl.getSize().Width) continue;
            n6 = this.curLabelControl.getPosition().X + this.curLabelControl.getSize().Width + 300;
        }
        this.iReduceWidth = n4 > 0 ? 1 : 0;
    }

    private void checkOuterPoints(int n, int n2, int n3, int n4, boolean bl) {
        if (this.icurArrangement == 4 && bl) {
            if (this.bIsFirstRun) {
                this.nSecMaxRowY = this.nMaxRowY = n3 + n4;
            } else {
                int n5 = n3 + n4;
                if (n5 >= this.nMaxRowY) {
                    int n6;
                    this.nSecMaxRowY = n6 = this.nMaxRowY;
                    this.nMaxRowY = n5;
                }
            }
        }
        if (this.bIsFirstRun) {
            this.nMaxColRightX = n + n2;
            this.bIsFirstRun = false;
        } else {
            int n7 = n + n2;
            if (n7 > this.nMaxColRightX) {
                this.nMaxColRightX = n7;
            }
        }
    }

    public void positionControls(int n, Point point, Size size, short s, Short s2) {
        try {
            this.NBorderType = s2;
            this.setStartPoint(point);
            this.icurArrangement = n;
            this.initializePosSizes();
            this.initializeControlColumn(-1);
            this.bIsVeryFirstRun = true;
            this.nMaxRowY = 0;
            this.nSecMaxRowY = 0;
            this.nMaxColRightX = 0;
            this.xProgressBar.start("", this.FieldColumns.length);
            for (int i = 0; i < this.FieldColumns.length; ++i) {
                this.insertLabel(i, s);
                this.insertDBControl(i);
                this.bIsVeryFirstRun = false;
                this.DBControlList[i].setPropertyValue("LabelControl", this.curLabelControl.xPropertySet);
                this.resetPosSizes(i);
                this.xProgressBar.setValue(i + 1);
            }
            this.xProgressBar.end();
            this.bControlsareCreated = true;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public boolean areControlsexisting() {
        if (this.DBControlList != null && this.DBControlList.length > 0) {
            return this.DBControlList[0] != null;
        }
        return false;
    }

    private void initializeControlColumn(int n) {
        this.bIsFirstRun = true;
        this.StartA = n + 1;
        this.a = 0;
    }

    private void resetPosSizes(int n) {
        int n2 = this.nYDBPos;
        switch (this.icurArrangement) {
            case 1: {
                n2 = this.nYDBPos = this.nYDBPos + this.nDBHeight + 200 + this.getCheckBoxDiffHeight(n);
                if (this.nYDBPos > this.cYOffset + this.nFormHeight || n == this.FieldColumns.length - 1) {
                    this.repositionColumnarLeftControls(n);
                    this.nXTCPos = this.nMaxColRightX + 600;
                    this.nXDBPos = this.nXTCPos + this.cLabelGap + this.nMaxTCWidth;
                    n2 = this.nYDBPos = this.cYOffset;
                    this.initializeControlColumn(n);
                } else {
                    ++this.a;
                }
                this.nYTCPos = this.nYDBPos + this.getLabelDiffHeight(n);
                if (n2 + this.nDBHeight <= this.nMaxDBYPos) break;
                this.nMaxDBYPos = n2 + this.nDBHeight;
                break;
            }
            case 2: {
                this.nYTCPos = this.nYDBPos + this.nDBHeight + 200 + this.getCheckBoxDiffHeight(n);
                if (this.nYTCPos > this.cYOffset + this.nFormHeight || n == this.FieldColumns.length - 1) {
                    this.nXTCPos = this.nXDBPos = this.nMaxColRightX + 300;
                    n2 = this.nYDBPos;
                    this.nYDBPos = this.cYOffset + this.nTCHeight + 200;
                    this.nYTCPos = this.cYOffset;
                    this.initializeControlColumn(n);
                } else {
                    ++this.a;
                }
                if (n2 + this.nDBHeight + 200 <= this.nMaxDBYPos) break;
                this.nMaxDBYPos = n2 + this.nDBHeight + 200;
                break;
            }
            case 4: {
                if (this.isReducable(this.a)) {
                    ++this.iReduceWidth;
                }
                if (this.nMaxColRightX > this.cXOffset + this.nFormWidth) {
                    int n3 = this.nYTCPos;
                    this.checkJustifiedPosition(this.a);
                    n2 = this.nYDBPos;
                } else {
                    this.nXTCPos = this.nMaxColRightX + 300;
                }
                ++this.a;
                if (n2 + this.nDBHeight <= this.nMaxDBYPos) break;
                this.nMaxDBYPos = n2 + this.nDBHeight;
            }
        }
    }

    private void repositionColumnarLeftControls(int n) {
        this.bIsFirstRun = true;
        for (int i = this.StartA; i <= n; ++i) {
            if (i == this.StartA) {
                this.nXTCPos = this.LabelControlList[i].getPosition().X;
                this.nXDBPos = this.nXTCPos + this.nMaxTCWidth + 300;
            }
            this.LabelControlList[i].setSize(new Size(this.nMaxTCWidth, this.nTCHeight));
            this.resetDBShape(this.DBControlList[i], this.nXDBPos);
            this.checkOuterPoints(this.nXDBPos, this.nDBWidth, this.nYDBPos, this.nDBHeight, true);
        }
    }

    private void resetDBShape(Shape shape, int n) {
        int n2 = shape.getPosition().Y;
        this.nDBWidth = shape.getSize().Width;
        this.nDBHeight = shape.getSize().Height;
        shape.setPosition(new Point(n, n2));
    }

    private void initializePosSizes() {
        this.nMaxDBYPos = 0;
        this.nXTCPos = this.cXOffset;
        this.nTCWidth = 2000;
        this.nDBWidth = 2000;
        this.nDBHeight = this.oFormHandler.getDBRefHeight();
        this.nTCHeight = this.oFormHandler.getLabelHeight();
        this.iReduceWidth = 0;
        if (this.icurArrangement == 1) {
            this.nYTCPos = this.cYOffset + this.getLabelDiffHeight(0);
            this.nXDBPos = this.cXOffset + 3050;
            this.nYDBPos = this.cYOffset;
        } else {
            this.nXDBPos = this.cXOffset;
            this.nYTCPos = this.cYOffset;
        }
    }

    private void insertLabel(int n, int n2) {
        try {
            if (this.bControlsareCreated) {
                this.LabelControlList[n].setPosition(new Point(this.nXTCPos, this.nYTCPos));
                if (this.icurArrangement != 1) {
                    this.nTCWidth = this.LabelControlList[n].getPreferredWidth(this.FieldColumns[n].getFieldTitle());
                    this.LabelControlList[n].setSize(new Size(this.nTCWidth, this.nTCHeight));
                } else {
                    this.nTCWidth = this.LabelControlList[n].getSize().Width;
                }
            } else {
                Point point = new Point(this.nXTCPos, this.nYTCPos);
                Size size = new Size(this.nTCWidth, this.nTCHeight);
                this.LabelControlList[n] = new Control(this.oFormHandler, this.xFormName, 0, this.FieldColumns[n].m_sFieldName, point, size);
                if (this.bIsVeryFirstRun && this.icurArrangement == 2) {
                    this.nYDBPos = this.nYTCPos + this.nTCHeight;
                }
                this.nTCWidth = this.LabelControlList[n].getPreferredWidth(this.FieldColumns[n].getFieldTitle());
            }
            this.curLabelControl = this.LabelControlList[n];
            if (this.icurArrangement == 1) {
                if (this.bIsFirstRun) {
                    this.nMaxTCWidth = this.nTCWidth;
                    this.bIsFirstRun = false;
                } else if (this.nTCWidth > this.nMaxTCWidth) {
                    this.nMaxTCWidth = this.nTCWidth;
                }
            }
            this.checkOuterPoints(this.nXTCPos, this.nTCWidth, this.nYTCPos, this.nTCHeight, false);
            if (this.icurArrangement == 2 || this.icurArrangement == 4) {
                this.nXDBPos = this.nXTCPos;
                this.nYDBPos = this.nYTCPos + this.nTCHeight;
                this.curLabelControl.xPropertySet.setPropertyValue("Align", (Object)new Short(0));
            } else {
                this.curLabelControl.xPropertySet.setPropertyValue("Align", (Object)new Short((short)n2));
            }
            if (!this.bControlsareCreated) {
                this.curLabelControl.setSize(new Size(this.nTCWidth, this.nTCHeight));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private void insertDBControl(int n) {
        try {
            Point point = new Point(this.nXDBPos, this.nYDBPos);
            if (this.bControlsareCreated) {
                this.DBControlList[n].setPosition(point);
            } else if (this.FieldColumns[n].FieldType == 93) {
                this.DBControlList[n] = new TimeStampControl(new Resource(this.xMSF, "FormWizard", "dbw"), this.oFormHandler, this.xFormName, this.FieldColumns[n].m_sFieldName, point);
            } else {
                this.DBControlList[n] = new DatabaseControl(this.oFormHandler, this.xFormName, this.FieldColumns[n].m_sFieldName, this.FieldColumns[n].FieldType, point);
                if (this.DBControlList[n].getControlType() == 2) {
                    this.DBControlList[n].setPropertyValue("Label", "");
                }
            }
            this.curDBControl = this.DBControlList[n];
            this.nDBHeight = this.curDBControl.getDBHeight();
            this.nDBWidth = this.curDBControl.getDBWidth();
            if (this.FieldColumns[n].FieldType != 93) {
                this.curDBControl.setSize(new Size(this.nDBWidth, this.nDBHeight));
            }
            if (this.curDBControl.getControlType() == 2) {
                this.nYDBPos += (this.oFormHandler.getDBRefHeight() - this.nDBHeight) / 2;
                point = new Point(this.nXDBPos, this.nYDBPos);
                this.curDBControl.setPosition(point);
            }
            this.checkOuterPoints(this.nXDBPos, this.nDBWidth, this.nYDBPos, this.nDBHeight, true);
            this.curDBControl.setPropertyValue("Border", this.NBorderType);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private int assignFieldLength(int n) {
        if (n >= 65535) {
            return -1;
        }
        return n;
    }

    public int getFormHeight() {
        return this.nMaxDBYPos - this.cYOffset;
    }

    public int getEntryPointY() {
        if (this.icurArrangement == 2) {
            Control control = this.LabelControlList[0];
            return control.getPosition().Y;
        }
        DatabaseControl databaseControl = this.DBControlList[0];
        return databaseControl.getPosition().Y;
    }

    public void setStartPoint(Point point) {
        this.cXOffset = point.X;
        this.cYOffset = point.Y;
    }

    public void adjustYPositions(int n) {
        for (int i = 0; i < this.DBControlList.length; ++i) {
            Point point = this.DBControlList[i].getPosition();
            this.DBControlList[i].setPosition(new Point(point.X, point.Y - n));
            point = this.LabelControlList[i].getPosition();
            this.LabelControlList[i].setPosition(new Point(point.X, point.Y - n));
        }
        this.nMaxDBYPos = -n;
        this.cYOffset = -n;
    }

    public void setFormSize(Size size) {
        this.nFormHeight = size.Height;
        this.nFormWidth = size.Width;
    }
}

