/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.File;
import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.SimpleLog;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.ZipUnzipFile;
import org.hsqldb.persist.Cache;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileBlockManager;
import org.hsqldb.persist.DataFileDefrag;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.BitMap;

public class DataFileCache {
    protected FileAccess fa;
    public static final int FLAG_ISSAVED = 2;
    public static final int FLAG_ROWINFO = 3;
    static final int LONG_EMPTY_SIZE = 4;
    static final int LONG_FREE_POS_POS = 12;
    static final int LONG_EMPTY_INDEX_POS = 20;
    static final int FLAGS_POS = 28;
    static final int INITIAL_FREE_POS = 32;
    DataFileBlockManager freeBlocks;
    private static final int initIOBufferSize = 256;
    protected String fileName;
    protected String backupFileName;
    protected Database database;
    protected boolean fileModified;
    protected int cacheFileScale;
    protected boolean cacheReadonly;
    protected boolean storeOnInsert;
    protected int cachedRowPadding = 8;
    protected boolean hasRowInfo = false;
    protected RowInputInterface rowIn;
    protected RowOutputInterface rowOut;
    public long maxDataFileSize;
    protected Storage dataFile;
    protected long fileFreePosition;
    protected int maxCacheSize;
    protected long maxCacheBytes;
    protected int maxFreeBlocks;
    protected Cache cache;

    public DataFileCache(Database database, String string) throws HsqlException {
        this.initParams(database, string);
        this.cache = new Cache(this);
    }

    protected void initParams(Database database, String string) throws HsqlException {
        HsqlDatabaseProperties hsqlDatabaseProperties = database.getProperties();
        this.fileName = string + ".data";
        this.backupFileName = string + ".backup";
        this.database = database;
        this.fa = database.getFileAccess();
        int n = hsqlDatabaseProperties.getIntegerProperty("hsqldb.cache_scale", 14, 8, 18);
        int n2 = hsqlDatabaseProperties.getIntegerProperty("hsqldb.cache_size_scale", 10, 6, 20);
        int n3 = hsqlDatabaseProperties.getIntegerProperty("hsqldb.cache_free_count_scale", 9, 6, 12);
        this.cacheFileScale = database.getProperties().getIntegerProperty("hsqldb.cache_file_scale", 1);
        if (this.cacheFileScale != 1) {
            this.cacheFileScale = 8;
        }
        this.cacheReadonly = database.isFilesReadOnly();
        int n4 = 1 << n;
        int n5 = 1 << n2;
        this.maxCacheSize = n4 * 3;
        this.maxCacheBytes = this.maxCacheSize * n5;
        this.maxDataFileSize = this.cacheFileScale == 1 ? Integer.MAX_VALUE : 0x1FFFFFFFCL;
        this.maxFreeBlocks = 1 << n3;
        this.dataFile = null;
    }

    public void open(boolean bl) throws HsqlException {
        this.fileFreePosition = 0L;
        this.database.logger.appLog.logContext(SimpleLog.LOG_NORMAL, "start");
        try {
            boolean bl2;
            int n;
            Object object;
            boolean bl3 = this.database.isFilesInJar();
            long l = 0L;
            if (!bl3 && this.fa.isStreamElement(this.fileName)) {
                if (this.database.isStoredFileAccess()) {
                    bl3 = true;
                } else {
                    object = new File(this.fileName);
                    boolean bl4 = bl3 = ((File)object).length() > 32L;
                }
            }
            if (bl3) {
                object = this.database.getProperties().getProperty("hsqldb.cache_version");
                n = "1.7.0".equals(object);
                boolean bl5 = "1.8.0".equals(object);
                if (n == 0) {
                    throw Trace.error(30);
                }
            }
            int n2 = n = (bl2 = this.database.getProperties().isPropertyTrue("hsqldb.nio_data_file")) ? 1 : 0;
            if (this.database.isFilesInJar()) {
                n = 2;
            }
            String string = this.database.getURLProperties().getProperty("storage_class_name");
            String string2 = this.database.getURLProperties().getProperty("storage_key");
            this.dataFile = ScaledRAFile.newScaledRAFile(this.database, this.fileName, bl, n, string, string2);
            if (bl3) {
                this.dataFile.seek(28L);
                int n3 = this.dataFile.readInt();
                this.hasRowInfo = BitMap.isSet(n3, 3);
                this.dataFile.seek(4L);
                l = this.dataFile.readLong();
                this.dataFile.seek(12L);
                this.fileFreePosition = this.dataFile.readLong();
                if (this.fileFreePosition < 32L) {
                    this.fileFreePosition = 32L;
                }
            } else {
                this.fileFreePosition = 32L;
                if (!bl) {
                    this.dataFile.seek(12L);
                    this.dataFile.writeLong(32L);
                    this.dataFile.seek(28L);
                    this.dataFile.writeInt(0);
                }
            }
            this.initBuffers();
            this.fileModified = false;
            this.freeBlocks = new DataFileBlockManager(this.maxFreeBlocks, this.cacheFileScale, l);
            this.database.logger.appLog.logContext(SimpleLog.LOG_NORMAL, "end");
        }
        catch (Throwable throwable) {
            this.database.logger.appLog.logContext(throwable, "failed");
            this.close(false);
            throw Trace.error(29, 210, new Object[]{throwable, this.fileName});
        }
    }

    public void close(boolean bl) throws HsqlException {
        SimpleLog simpleLog = this.database.logger.appLog;
        try {
            int n;
            if (this.cacheReadonly) {
                if (this.dataFile != null) {
                    this.dataFile.close();
                }
                return;
            }
            StopWatch stopWatch = new StopWatch();
            simpleLog.sendLine(SimpleLog.LOG_NORMAL, "DataFileCache.close(" + bl + ") : start");
            if (bl) {
                this.cache.saveAll();
                Trace.printSystemOut("saveAll: " + stopWatch.elapsedTime());
                simpleLog.sendLine(SimpleLog.LOG_NORMAL, "DataFileCache.close() : save data");
                if (this.fileModified || this.freeBlocks.isModified()) {
                    this.dataFile.seek(4L);
                    this.dataFile.writeLong(this.freeBlocks.getLostBlocksSize());
                    this.dataFile.seek(12L);
                    this.dataFile.writeLong(this.fileFreePosition);
                    this.dataFile.seek(28L);
                    n = BitMap.set(0, 2);
                    if (this.hasRowInfo) {
                        n = BitMap.set(n, 3);
                    }
                    this.dataFile.writeInt(n);
                    simpleLog.sendLine(SimpleLog.LOG_NORMAL, "DataFileCache.close() : flags");
                    if (this.dataFile.length() != this.fileFreePosition) {
                        this.dataFile.seek(this.fileFreePosition);
                    }
                    simpleLog.sendLine(SimpleLog.LOG_NORMAL, "DataFileCache.close() : seek end");
                    Trace.printSystemOut("pos and flags: " + stopWatch.elapsedTime());
                }
            }
            if (this.dataFile != null) {
                this.dataFile.close();
                simpleLog.sendLine(SimpleLog.LOG_NORMAL, "DataFileCache.close() : close");
                this.dataFile = null;
                Trace.printSystemOut("close: " + stopWatch.elapsedTime());
            }
            int n2 = n = this.fileFreePosition == 32L ? 1 : 0;
            if (n != 0) {
                this.fa.removeElement(this.fileName);
                this.fa.removeElement(this.backupFileName);
            }
        }
        catch (Throwable throwable) {
            simpleLog.logContext(throwable, null);
            throw Trace.error(29, 211, new Object[]{throwable, this.fileName});
        }
    }

    protected void initBuffers() {
        if (this.rowOut == null || ((RowOutputBinary)this.rowOut).getBuffer().length > 256) {
            this.rowOut = new RowOutputBinary(256);
        }
        if (this.rowIn == null || ((RowInputBinary)this.rowIn).getBuffer().length > 256) {
            this.rowIn = new RowInputBinary(new byte[256]);
        }
    }

    public void defrag() throws HsqlException {
        if (this.cacheReadonly) {
            return;
        }
        if (this.fileFreePosition == 32L) {
            return;
        }
        this.database.logger.appLog.logContext(SimpleLog.LOG_NORMAL, "start");
        try {
            boolean bl = this.dataFile.wasNio();
            this.cache.saveAll();
            DataFileDefrag dataFileDefrag = new DataFileDefrag(this.database, this, this.fileName);
            dataFileDefrag.process();
            this.close(false);
            this.deleteFile(bl);
            this.renameDataFile();
            this.backupFile();
            this.database.getProperties().setProperty("hsqldb.cache_version", "1.7.0");
            this.database.getProperties().save();
            this.cache.clear();
            this.cache = new Cache(this);
            this.open(this.cacheReadonly);
            dataFileDefrag.updateTableIndexRoots();
            dataFileDefrag.updateTransactionRowIDs();
        }
        catch (Throwable throwable) {
            this.database.logger.appLog.logContext(throwable, null);
            throw new HsqlException(throwable, Trace.getMessage(98), 98);
        }
        this.database.logger.appLog.logContext(SimpleLog.LOG_NORMAL, "end");
    }

    public synchronized void remove(int n, PersistentStore persistentStore) throws IOException {
        CachedObject cachedObject = this.release(n);
        int n2 = cachedObject == null ? this.getStorageSize(n) : cachedObject.getStorageSize();
        this.freeBlocks.add(n, n2);
    }

    public synchronized void removePersistence(int n, PersistentStore persistentStore) throws IOException {
    }

    private int setFilePos(CachedObject cachedObject) throws IOException {
        int n;
        int n2 = cachedObject.getStorageSize();
        int n3 = n = this.freeBlocks == null ? -1 : this.freeBlocks.get(n2);
        if (n == -1) {
            n = (int)(this.fileFreePosition / (long)this.cacheFileScale);
            long l = this.fileFreePosition + (long)n2;
            if (l > this.maxDataFileSize) {
                throw new IOException(Trace.getMessage(225));
            }
            this.fileFreePosition = l;
        }
        cachedObject.setPos(n);
        return n;
    }

    public synchronized void add(CachedObject cachedObject) throws IOException {
        int n = cachedObject.getRealSize(this.rowOut);
        n = (n + this.cachedRowPadding - 1) / this.cachedRowPadding * this.cachedRowPadding;
        cachedObject.setStorageSize(n);
        int n2 = this.setFilePos(cachedObject);
        this.cache.put(n2, cachedObject);
        if (this.storeOnInsert) {
            this.saveRow(cachedObject);
        }
    }

    public synchronized void restore(CachedObject cachedObject) throws IOException {
        int n = cachedObject.getPos();
        this.cache.put(n, cachedObject);
        if (this.storeOnInsert) {
            this.saveRow(cachedObject);
        }
    }

    public synchronized int getStorageSize(int n) throws IOException {
        CachedObject cachedObject = this.cache.get(n);
        if (cachedObject != null) {
            return cachedObject.getStorageSize();
        }
        return this.readSize(n);
    }

    public synchronized CachedObject get(int n, PersistentStore persistentStore, boolean bl) throws HsqlException {
        if (n < 0) {
            return null;
        }
        try {
            CachedObject cachedObject = this.cache.get(n);
            if (cachedObject == null) {
                RowInputInterface rowInputInterface = this.readObject(n);
                if (rowInputInterface == null) {
                    return null;
                }
                cachedObject = persistentStore.get(rowInputInterface);
                n = cachedObject.getPos();
                this.cache.put(n, cachedObject);
            }
            if (bl) {
                cachedObject.keepInMemory(true);
            }
            return cachedObject;
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException, this.fileName + " get pos: " + n);
            throw Trace.error(129, 209, new Object[]{iOException, this.fileName});
        }
    }

    synchronized RowInputInterface getRaw(int n) throws IOException {
        return this.readObject(n);
    }

    protected synchronized int readSize(int n) throws IOException {
        this.dataFile.seek((long)n * (long)this.cacheFileScale);
        return this.dataFile.readInt();
    }

    protected synchronized RowInputInterface readObject(int n) throws IOException {
        this.dataFile.seek((long)n * (long)this.cacheFileScale);
        int n2 = this.dataFile.readInt();
        this.rowIn.resetRow(n, n2);
        this.dataFile.read(this.rowIn.getBuffer(), 4, n2 - 4);
        return this.rowIn;
    }

    public synchronized CachedObject release(int n) {
        return this.cache.release(n);
    }

    protected synchronized void saveRows(CachedObject[] cachedObjectArray, int n, int n2) throws IOException {
        try {
            for (int i = n; i < n + n2; ++i) {
                CachedObject cachedObject = cachedObjectArray[i];
                this.saveRow(cachedObject);
                cachedObjectArray[i] = null;
            }
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException, null);
            throw iOException;
        }
        catch (Throwable throwable) {
            this.database.logger.appLog.logContext(throwable, null);
            throw new IOException(throwable.toString());
        }
        finally {
            this.initBuffers();
        }
    }

    public synchronized void saveRow(CachedObject cachedObject) throws IOException {
        this.setFileModified();
        this.rowOut.reset();
        cachedObject.write(this.rowOut);
        this.dataFile.seek((long)cachedObject.getPos() * (long)this.cacheFileScale);
        this.dataFile.write(this.rowOut.getOutputStream().getBuffer(), 0, this.rowOut.getOutputStream().size());
    }

    void backupFile() throws IOException {
        try {
            if (this.fa.isStreamElement(this.fileName)) {
                ZipUnzipFile.compressFile(this.fileName, this.backupFileName + ".new", this.database.getFileAccess());
            }
        }
        catch (IOException iOException) {
            this.database.logger.appLog.logContext(iOException, null);
            throw iOException;
        }
    }

    void renameBackupFile() {
        if (this.fa.isStreamElement(this.backupFileName + ".new")) {
            this.fa.removeElement(this.backupFileName);
            this.fa.renameElement(this.backupFileName + ".new", this.backupFileName);
        }
    }

    void renameDataFile() {
        if (this.fa.isStreamElement(this.fileName + ".new")) {
            this.fa.removeElement(this.fileName);
            this.fa.renameElement(this.fileName + ".new", this.fileName);
        }
    }

    void deleteFile(boolean bl) {
        this.fa.removeElement(this.fileName);
        if (!this.database.isStoredFileAccess() && this.fa.isStreamElement(this.fileName)) {
            if (bl) {
                System.gc();
                this.fa.removeElement(this.fileName);
            }
            if (this.fa.isStreamElement(this.fileName)) {
                this.fa.renameElement(this.fileName, this.fileName + ".old");
                File file = new File(this.fileName + ".old");
                FileUtil.getDefaultInstance().deleteOnExit(file);
            }
        }
    }

    void deleteBackup() {
        this.fa.removeElement(this.backupFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteOrResetFreePos(Database database, String string) {
        ScaledRAFile scaledRAFile = null;
        database.getFileAccess().removeElement(string);
        if (database.isStoredFileAccess()) {
            return;
        }
        if (!database.getFileAccess().isStreamElement(string)) {
            return;
        }
        try {
            scaledRAFile = new ScaledRAFile(database, string, false);
            scaledRAFile.seek(12L);
            scaledRAFile.writeLong(32L);
        }
        catch (IOException iOException) {
            database.logger.appLog.logContext(iOException, null);
        }
        finally {
            if (scaledRAFile != null) {
                try {
                    scaledRAFile.close();
                }
                catch (IOException iOException) {
                    database.logger.appLog.logContext(iOException, null);
                }
            }
        }
    }

    public int capacity() {
        return this.maxCacheSize;
    }

    public long bytesCapacity() {
        return this.maxCacheBytes;
    }

    public long getTotalCachedBlockSize() {
        return this.cache.getTotalCachedBlockSize();
    }

    public int getFreeBlockCount() {
        return this.freeBlocks.size();
    }

    public int getTotalFreeBlockSize() {
        return 0;
    }

    public long getFileFreePos() {
        return this.fileFreePosition;
    }

    public int getCachedObjectCount() {
        return this.cache.size();
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean hasRowInfo() {
        return this.hasRowInfo;
    }

    public boolean isFileModified() {
        return this.fileModified;
    }

    protected synchronized void setFileModified() throws IOException {
        if (!this.fileModified) {
            this.dataFile.seek(28L);
            int n = BitMap.set(0, 2);
            if (this.hasRowInfo) {
                n = BitMap.set(n, 3);
            }
            this.dataFile.writeInt(n);
            this.fileModified = true;
        }
    }
}

