/***************************************************************************
      qgsprovidercountcalcevent.h  -  Notification that the exact count
                                      of a layer has been calculated.
                             -------------------
    begin                : Feb 1, 2005
    copyright            : (C) 2005 by Brendan Morley
    email                : morb at ozemail dot com dot au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/* $Id: qgsprovidercountcalcevent.h 6415 2007-01-09 02:39:15Z wonder $ */

#ifndef QGSPROVIDERCOUNTCALCEVENT_H
#define QGSPROVIDERCOUNTCALCEVENT_H

#include <qevent.h>

#include "qgis.h"
//Added by qt3to4:
#include <QCustomEvent>

/*!
 * \brief   A custom event that is designed to be fired when a layer count has been fully calculated.
   \author  Brendan Morley
   \date    March 2005

   
   This QCustomEvent is designed to be fired when the full item count of a layer has been calculated.
   It was initially included in QGIS to help the QgsPostgresProvider provide the asynchronous
   calculation of PostgreSQL layer counts.
   
   Events are used instead of Qt signals/slots as events can be received asynchronously,
   which makes for better mutlithreading behaviour and less opportunity for programmer mishap.
  
 */ 

// TODO: Add the pg table this is a count OF.

class CORE_EXPORT QgsProviderCountCalcEvent : public QCustomEvent
{

public:

  QgsProviderCountCalcEvent( long numberFeatures );

  long numberFeatures() const;

  
private:

  long n;
    
};

#endif
