#!/bin/bash
# GDAL
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-11-08
# require:
#	PROJ
#	GEOS
#	GRASS
#	PostGIS
#	fftw
#
SRC_URI=http://download.osgeo.org/gdal/gdal-1.5.3.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P2
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/gis
PAC_DIR=$PLAMO/Packages/4.5/10_gis
BUILD_DIR=$PLAMO/gdal
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
 ./configure --prefix=/usr \
  --with-grass=/usr/grass \
  --with-pg=/opt/pgsql/bin/pg_config

 make
 make install DESTDIR=$WORK
 make docs
 make install-docs DESTDIR=$WORK

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
    COMMITERS Doxyfile HOWTO-RELEASE LICENSE.TXT NEWS PROVENANCE.TXT \
    VERSION \
	$WORK/$DOC_DIR
mv $WORK/usr/doc/{gdal,ogr} $WORK/$DOC_DIR/
rmdir $WORK/usr/doc/
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX $WORK/$DOC_DIR


# make package
cd $WORK
echo "y
1" | makepkg ${PAC_NAME}.tgz
mv ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
echo "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz ... done"
cd $CWD
